/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow;

import android.app.Activity;
import android.graphics.Bitmap;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebBackForwardList;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.NavigationUtils;
import com.yy.webservice.IJsTitleBarAction;
import com.yy.webservice.IWebUICallBack;
import com.yy.webservice.R;
import com.yy.webservice.WebConfigure;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.event.parqam.JsReturn;
import com.yy.webservice.webwindow.IWebUi;
import com.yy.webservice.webwindow.IWebViewWindow;
import com.yy.webservice.webwindow.StatusLayout;
import com.yy.webservice.webwindow.TitleBar;
import com.yy.webservice.webwindow.WebWindow;
import com.yy.webservice.webwindow.titlebar.WebTitleButton;
import com.yy.webservice.webwindow.webview.ICallBack;
import com.yy.webservice.webwindow.webview.IWebIntentFilter;
import com.yy.webservice.webwindow.webview.IWebViewEventListener;
import com.yy.webservice.webwindow.webview.IWebViewPermissionCallback;
import com.yy.webservice.webwindow.webview.Utils;
import com.yy.webservice.webwindow.webview.WebViewController;
import com.yy.webservice.webwindow.webview.base.WebViewSettings;
import org.json.JSONException;
import org.json.JSONObject;

public class WebUIController {
    private static String TAG = "Web_WebUIController";
    public static final int INTERCEPT_LEFT_BACK = 1;
    public static final int INTERCEPT_ANDROID_BACK = 2;
    private TitleBar mTitleBar;
    private IWebViewWindow mWebViewWindow;
    private WebViewController mWebViewController;
    private WebEnvSettings mWebEnvSettings;
    private StatusLayout mStatusLayout;
    private IWebUICallBack mUICallBack;
    private IWebUi mAbsWebWindow;
    private boolean mEnableAndroidBackBtn = true;
    private int mAndroidBackBtnId = 0;
    private String mAndroidBackBtnCallBackName;
    private boolean mSinglePageGoBack = false;
    private boolean mHasRetryed = false;
    private int mInterceptBack = 0;
    private WebViewController.AbsAppearanceCallback mCallback = new WebViewController.AbsAppearanceCallback(){

        @Override
        public void onReceivedTitle(WebView view, String title) {
            if (WebUIController.this.mTitleBar != null && ((WebUIController)WebUIController.this).mWebEnvSettings.usePageTitle) {
                WebUIController.this.mTitleBar.setTitle(title);
            }
        }

        @Override
        public void onPermissionRequested(String permission, IWebViewPermissionCallback callback) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onPermissionRequested(permission, callback);
            }
        }

        @Override
        protected void handleBackAction(Object data) {
        }

        @Override
        public void changeHeight(int height) {
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            if (WebUIController.this.mTitleBar != null) {
                WebUIController.this.mTitleBar.setBackBtnEnableState(true);
                WebUIController.this.mTitleBar.setBackListener(WebUIController.this.finishActivityListener);
                WebUIController.this.mTitleBar.showBackBtn();
                WebUIController.this.mEnableAndroidBackBtn = true;
                WebUIController.this.mAndroidBackBtnId = 0;
            }
            super.onPageStarted(view, url, favIcon);
        }
    };
    private View.OnClickListener mCloseBtnListener = new View.OnClickListener(){

        public void onClick(View view) {
            WebUIController.this.finish();
        }
    };
    private View.OnClickListener finishActivityListener = new View.OnClickListener(){

        public void onClick(View view) {
            MLog.info((Object)TAG, (String)"finishActivityListener clicked", (Object[])new Object[0]);
            if (WebUIController.this.needInterceptBack(1) && WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onInterceptBack(1);
                return;
            }
            WebUIController.this.onBackBtnBack();
        }
    };
    private WebWindow.IWebWindowCallBack mWebWindowCallBack = new WebWindow.IWebWindowCallBack(){

        @Override
        public void onPullDownToRefresh() {
            if (WebUIController.this.mWebViewController != null) {
                WebUIController.this.mWebViewController.setDownloadListenerToNull();
                WebUIController.this.mWebViewController.loadUrl(WebUIController.this.mWebViewController.getWebCurrentUrl(), true);
            }
        }

        @Override
        public void refresh() {
            if (WebUIController.this.mWebViewController != null && !StringUtils.isEmpty((String)WebUIController.this.mWebViewController.getWebCurrentUrl())) {
                WebUIController.this.mWebViewController.loadUrl(WebUIController.this.mWebViewController.getWebCurrentUrl(), true);
            }
        }
    };
    private IJsTitleBarAction mWebActivityJsSupportWebApi = new IJsTitleBarAction(){

        @Override
        public void showBackBtn(boolean isShow) {
            if (WebUIController.this.mTitleBar != null) {
                WebUIController.this.mTitleBar.showBack(isShow);
            }
        }

        @Override
        public void setNavigationBarTitle(String title) {
            if (WebUIController.this.mTitleBar != null && ((WebUIController)WebUIController.this).mWebEnvSettings.usePageTitle) {
                WebUIController.this.mTitleBar.setTitleText(title);
            }
        }

        @Override
        public void showTitleBar(boolean isShow) {
            if (WebUIController.this.mWebEnvSettings != null) {
                ((WebUIController)WebUIController.this).mWebEnvSettings.usePageTitle = isShow;
            }
            if (WebUIController.this.mWebViewWindow != null) {
                WebUIController.this.mWebViewWindow.updateLayout(!isShow);
            }
            if (WebUIController.this.mTitleBar != null) {
                WebUIController.this.mTitleBar.showTitleBar(isShow);
                WebUIController.this.mTitleBar.hideTitle(!isShow);
                if (isShow) {
                    WebUIController.this.mTitleBar.setBackIcon(R.drawable.nav_back_black);
                } else if (WebUIController.this.mWebEnvSettings != null && ((WebUIController)WebUIController.this).mWebEnvSettings.backBtnResId > 0) {
                    WebUIController.this.mTitleBar.setBackIcon(((WebUIController)WebUIController.this).mWebEnvSettings.backBtnResId);
                }
            }
        }

        @Override
        public void addRightBtn(WebTitleButton btn) {
            if (WebUIController.this.mTitleBar != null) {
                WebUIController.this.mTitleBar.addRightBtn(btn);
            }
        }

        @Override
        public void removeRightBtn() {
            if (WebUIController.this.mTitleBar != null) {
                WebUIController.this.mTitleBar.removeRightBtn();
            }
        }
    };
    private IWebViewEventListener mWebViewEventListener = new IWebViewEventListener(){

        @Override
        public void onProgressChanged(WebView view, int newProgress) {
        }

        @Override
        public void onReceivedTitle(WebView view, String title) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onReceivedTitle(view, title);
            }
        }

        @Override
        public void onReceivedIcon(WebView view, Bitmap icon) {
        }

        @Override
        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
        }

        @Override
        public void onRequestFocus(WebView view) {
        }

        @Override
        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            return false;
        }

        @Override
        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            return false;
        }

        @Override
        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            return false;
        }

        @Override
        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            return false;
        }

        @Override
        public boolean onJsTimeout() {
            return false;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.shouldOverrideUrlLoading(view, url);
            }
            return true;
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onPageStarted(view, url, favicon);
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onPageFinished(view, url);
            }
        }

        @Override
        public void onLoadResource(WebView view, String url) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onLoadResource(view, url);
            }
        }

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onReceivedError(view, errorCode, description, failingUrl);
            }
        }

        @Override
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            if (WebUIController.this.mUICallBack != null) {
                return WebUIController.this.mUICallBack.shouldInterceptRequest(view, request);
            }
            return null;
        }

        @Override
        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            if (WebUIController.this.mUICallBack != null) {
                WebUIController.this.mUICallBack.onReceivedHttpError(view, request, errorResponse);
            }
        }
    };

    public WebUIController(IWebUi webWindow, WebEnvSettings webEnvSettings, WebConfigure webConfigure, IWebUICallBack iuiCallBack) {
        this.mAbsWebWindow = webWindow;
        this.mTitleBar = this.mAbsWebWindow.getTitleBar();
        this.mWebViewWindow = this.mAbsWebWindow.getWebViewWindow();
        this.mStatusLayout = webWindow.getStatusLayout();
        this.mWebEnvSettings = webEnvSettings;
        webWindow.setWebWindowCallBack(this.mWebWindowCallBack);
        this.mUICallBack = iuiCallBack;
        this.mAbsWebWindow.setBackListener(this.finishActivityListener);
        WebViewSettings settings = new WebViewSettings();
        settings.webviewFeature = this.mWebEnvSettings.webviewFeature;
        settings.useYYJsInterface = this.mWebEnvSettings.useYYJsInterface;
        settings.renderMode = this.mWebEnvSettings.renderMode;
        settings.forceEnableSwLayer = this.mWebEnvSettings.forceEnableSwLayer;
        this.mWebViewController = new WebViewController(settings, this.mAbsWebWindow.getWebView(), webConfigure, new ICallBack(){

            @Override
            public String getDefaultUA() {
                if (WebUIController.this.mWebEnvSettings != null && ((WebUIController)WebUIController.this).mWebEnvSettings.defaultUa != null) {
                    return ((WebUIController)WebUIController.this).mWebEnvSettings.defaultUa;
                }
                return "";
            }

            @Override
            public Activity getActivity() {
                if (WebUIController.this.mAbsWebWindow.getContext() instanceof Activity) {
                    return (Activity)WebUIController.this.mAbsWebWindow.getContext();
                }
                return null;
            }

            @Override
            public IWebIntentFilter getIntentFilter(String url) {
                return WebUIController.this.mUICallBack != null ? WebUIController.this.mUICallBack.getIntentFilter(url) : null;
            }

            @Override
            public boolean enabledWebContentsDebugging() {
                return RuntimeContext.sIsDebuggable;
            }

            @Override
            public void onRefreshComplete(String originUrl, String url) {
                if (WebUIController.this.mWebViewWindow != null) {
                    WebUIController.this.mWebViewWindow.onRefreshComplete();
                }
            }

            @Override
            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                if (WebUIController.this.mWebViewWindow != null && WebUIController.this.mAbsWebWindow.getContext() instanceof Activity) {
                    NavigationUtils.startDownload((Activity)((Activity)WebUIController.this.mAbsWebWindow.getContext()), (String)url);
                }
            }

            @Override
            public void showNetError(String originUrl, int errorCode, String description, String url) {
                if (WebUIController.this.mHasRetryed) {
                    if (WebUIController.this.mStatusLayout != null) {
                        WebUIController.this.mStatusLayout.showNetError();
                    }
                } else {
                    WebUIController.this.mHasRetryed = true;
                    if (WebUIController.this.mStatusLayout != null) {
                        WebUIController.this.mStatusLayout.refresh();
                    }
                    MLog.info((Object)"WebUiController", (String)"error refresh!", (Object[])new Object[0]);
                }
            }

            @Override
            public void showLoading() {
                if (WebUIController.this.mStatusLayout != null) {
                    WebUIController.this.mStatusLayout.showLoading();
                }
            }

            @Override
            public void hideStatusView() {
                if (WebUIController.this.mStatusLayout != null) {
                    WebUIController.this.mStatusLayout.hideStatusView();
                }
            }

            @Override
            public boolean nativeGetGameIsInstall(String gameId) {
                if (WebUIController.this.mUICallBack != null) {
                    return WebUIController.this.mUICallBack.nativeGetGameIsInstall(gameId);
                }
                return false;
            }

            @Override
            public IJsParam callAppMethod(String module, String methodName, String context, String paramJson, String callback) {
                IJsParam result;
                if (WebUIController.this.mUICallBack != null && (result = WebUIController.this.mUICallBack.callAppMethod(module, methodName, context, paramJson, callback)) != null) {
                    return result;
                }
                return JsReturn.DEFAULT_ERROR;
            }

            @Override
            public String appInfo() {
                if (WebUIController.this.mUICallBack != null) {
                    return WebUIController.this.mUICallBack.appInfo();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String allSupportMethod() {
                if (WebUIController.this.mUICallBack != null) {
                    return WebUIController.this.mUICallBack.allSupportMethod();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String userToken() {
                if (WebUIController.this.mUICallBack != null) {
                    return WebUIController.this.mUICallBack.userToken();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String myselfUserInfo() {
                if (WebUIController.this.mUICallBack != null) {
                    return WebUIController.this.mUICallBack.myselfUserInfo();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String getCurrentWebviewStyle() {
                JSONObject json = new JSONObject();
                try {
                    json.put("style", ((WebUIController)WebUIController.this).mWebEnvSettings.webViewStyle.getStyle());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return json.toString();
            }
        });
        this.mWebViewController.setAppearanceCallback(this.mCallback);
        this.mWebViewController.setWebViewEventListener(this.mWebViewEventListener);
    }

    public void updateWebViewHeight(int height) {
        if (this.mCallback != null) {
            this.mCallback.changeHeight(height);
        }
    }

    public void onBackBtnBack() {
        this.backWebView();
    }

    private void backWebView() {
        WebBackForwardList backList;
        if (this.mWebEnvSettings != null && this.mWebEnvSettings.backStyle == 2 && this.mWebViewController != null && this.mWebViewController.canGoBack() && ((backList = this.mWebViewController.copyBackForwardList()) != null && backList.getCurrentIndex() >= 1 || this.mSinglePageGoBack)) {
            this.mWebViewController.goBack();
            return;
        }
        this.finish();
    }

    public boolean canGoBack() {
        if (this.mWebViewController != null) {
            return this.mWebViewController.canGoBack();
        }
        return false;
    }

    private void finish() {
        if (this.mUICallBack != null) {
            this.mUICallBack.requestExit();
        }
    }

    public boolean onKeyEvent(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0 && event.getAction() == 1) {
            if (this.needInterceptBack(2) && this.mUICallBack != null) {
                this.mUICallBack.onInterceptBack(2);
                MLog.info((Object)TAG, (String)"mUICallBack InterceptBack", (Object[])new Object[0]);
                return true;
            }
            if (this.onKeyBack()) {
                MLog.error((Object)TAG, (String)"onKeyBack", (Object[])new Object[0]);
                return true;
            }
        }
        MLog.info((Object)TAG, (String)"on intercept back", (Object[])new Object[0]);
        return false;
    }

    public boolean onKeyBack() {
        this.backWebView();
        return true;
    }

    public void loadOriginUrl(String url) {
        MLog.info((Object)TAG, (String)"loadOriginUrl : %s", (Object[])new Object[]{url});
        if (!StringUtils.isEmpty((String)url)) {
            this.mWebViewController.loadOriginUrl(url, true);
        }
        if (this.mWebViewWindow != null) {
            this.mWebViewWindow.initBottomAction(url);
        }
    }

    public void loadUrl(String url) {
        MLog.info((Object)TAG, (String)"loadUrl : %s", (Object[])new Object[]{url});
        if (!StringUtils.isEmpty((String)url)) {
            this.mWebViewController.loadUrl(url, true);
        }
    }

    public void setTitleImage(int imageResId) {
        if (imageResId > 0 && this.mTitleBar != null) {
            this.mTitleBar.setTitleImage(imageResId);
        }
    }

    public void updateTitleMsgStatus(int id2, String badge) {
        if (this.mTitleBar != null) {
            this.mTitleBar.updateMsgStatus(id2, badge);
        }
    }

    public void refreshWebView() {
        if (this.mWebViewController != null) {
            this.mWebViewController.refresh();
        }
    }

    public void showProgressDialog(String label, boolean cancelable, int timeOut) {
        if (this.mWebViewWindow != null) {
            if (timeOut <= 0) {
                timeOut = 5000;
            }
            this.mWebViewWindow.showProgressDialog(label, cancelable, timeOut);
        }
    }

    public void hideProgress() {
        if (this.mWebViewWindow != null) {
            this.mWebViewWindow.hideProgress();
        }
    }

    public boolean addWebViweClientFilterList(String jsonData) {
        if (this.mWebViewController != null) {
            return this.mWebViewController.addWebViweClientFilterList(jsonData);
        }
        return false;
    }

    public void webViewSafeLoadJs(String jsStr) {
        if (this.mWebViewController != null) {
            this.mWebViewController.safetyLoadJs(jsStr);
        }
    }

    public void showAlertDialog(String title, String message, String positiveButton, String neutralButton, String negativeButton, boolean cancelable, Utils.IAlertDialogCallBack callBack) {
        if (this.mAbsWebWindow.getContext() instanceof Activity) {
            Utils.showAlertDialog((Activity)this.mAbsWebWindow.getContext(), title, message, positiveButton, neutralButton, negativeButton, cancelable, callBack);
        }
    }

    public void onSetPageBackMode(String backMode, String lastLayerUrl) {
        if (this.mWebViewController != null && this.mTitleBar != null) {
            this.mTitleBar.onSetPageBackMode(backMode, lastLayerUrl, this.mWebViewController.getWebCurrentUrl());
            if (StringUtils.equals((String)this.mWebViewController.getWebCurrentUrl(), (String)lastLayerUrl) && StringUtils.equals((String)backMode, (String)"goback")) {
                this.mSinglePageGoBack = true;
            }
        }
    }

    public void enableCloseBtn(boolean enable) {
        if (this.mTitleBar != null) {
            this.mTitleBar.enableCloseBtn(enable, enable ? this.mCloseBtnListener : null);
        }
    }

    public void appendUserAgentString(String ua) {
        if (!StringUtils.isEmpty((String)ua) && this.mWebViewController != null) {
            this.mWebViewController.appendUserAgentString(ua);
        }
    }

    public void updateUserAgentString(String ua) {
        if (!StringUtils.isEmpty((String)ua) && this.mWebViewController != null) {
            this.mWebViewController.setUserAgentString(ua);
        }
    }

    public void updateRenderMode(int mode) {
        if (this.mWebViewController != null) {
            this.mWebViewController.updateRenderMode(mode);
        }
    }

    public void checkExit(boolean checkAutoFinish) {
        boolean finish = false;
        if (checkAutoFinish) {
            if (this.mWebEnvSettings != null && this.mWebEnvSettings.autoFinish) {
                finish = true;
            }
        } else {
            finish = true;
        }
        if (finish && this.mUICallBack != null) {
            this.mUICallBack.requestExit();
        }
    }

    public IJsTitleBarAction getJsChangeTitleBarAction() {
        return this.mWebActivityJsSupportWebApi;
    }

    public void onDestroy() {
        if (this.mWebViewWindow != null) {
            this.mWebViewWindow.setPllOnRefreshListener(null);
            this.mWebViewWindow = null;
        }
        if (this.mWebViewController != null) {
            this.mWebViewController.destroy();
            this.mWebViewController = null;
        }
        this.mInterceptBack = 0;
    }

    public void interceptBack(int intercept) {
        this.mInterceptBack = intercept;
    }

    public boolean enablePushRefresh(boolean enable) {
        if (this.mWebViewWindow != null) {
            return this.mWebViewWindow.setPullRefreshEnable(enable);
        }
        return false;
    }

    private boolean needInterceptBack(int type) {
        return (this.mInterceptBack & type) == type || type == 2 && this.mWebEnvSettings != null && this.mWebEnvSettings.dialogStyle != null && !this.mWebEnvSettings.dialogStyle.getCloseByBack();
    }

    private void setWebTitle(boolean isTransparent, int titleColor, int backRes) {
        if (this.mWebViewWindow != null) {
            this.mWebViewWindow.updateLayout(isTransparent);
        }
        if (this.mTitleBar != null) {
            this.mTitleBar.setTitle(isTransparent, titleColor, backRes);
        }
    }
}

