/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.webservice.R;
import com.yy.webservice.webwindow.titlebar.CommonTitle;
import com.yy.webservice.webwindow.titlebar.WebTitleButton;
import java.util.HashMap;
import java.util.Map;

public class TitleBar
extends YYFrameLayout {
    private Map<String, WebPageBackEntity> mPageBackModeRecord = new HashMap<String, WebPageBackEntity>();
    private CommonTitle mCommonTitle;
    private Context mContext;

    public TitleBar(Context context) {
        super(context);
        this.mContext = context;
    }

    public void initWebTitle(boolean showBackBtn, boolean isTransparent, String title, int titleColor, int backRes) {
        this.mCommonTitle = new CommonTitle(this.mContext, showBackBtn);
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View view = this.mCommonTitle.onCreateView(inflater, (ViewGroup)this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView(view);
        this.showTitleBar(!isTransparent);
        this.mCommonTitle.setTitleTextColor(titleColor);
        if (backRes > 0) {
            this.mCommonTitle.addLeftButtonWithImageRes(backRes);
        }
        this.mCommonTitle.setTitleText(title);
    }

    public void setCloseIcon() {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setCloseIcon();
        }
    }

    public void setBackListener(View.OnClickListener listener) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setBackListener(listener);
        }
    }

    public void enableCloseBtn(boolean enableClose, View.OnClickListener listener) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.enableClose(enableClose, listener);
        }
    }

    public void hideBackBtn() {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setBackBtnState(8);
        }
    }

    public void showBackBtn() {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setBackBtnState(0);
        }
    }

    public void showBack(boolean show) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.showBack(show);
        }
    }

    public void addRightBtn(WebTitleButton btn) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.addRightBtn(btn);
        }
    }

    public void removeRightBtn() {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.removeRightBtn();
        }
    }

    public void setTitle(String title) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setTitleText(title);
        }
    }

    public void setTitleText(String title) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setTitleText(title);
        }
    }

    public void clearTitle() {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.clearTitle();
        }
    }

    public void clearRightContainer() {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.clearTitle();
        }
    }

    public void setTitleTextColor(int color2) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setTitleTextColor(color2);
        }
    }

    public void setTitleImage(int resId) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setTitleImage(resId);
        }
    }

    public void updateMsgStatus(int id2, String badge) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.updateMsgStatus(id2, badge);
        }
    }

    public void setBackBtnEnableState(boolean state) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setBackBtnEnableState(true);
        }
    }

    public void setMyBackground(int color2) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setMyBackground(color2);
        }
    }

    public void setMyBackgroundWithDivider(int color2) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setMyBackgroundWithDivider(color2);
        }
    }

    public void hideTitle(boolean hideTitle) {
        if (this.mCommonTitle != null) {
            if (hideTitle) {
                this.mCommonTitle.hideTitleText();
            } else {
                this.mCommonTitle.showTitleText();
            }
        }
    }

    public void setTitle(boolean isTransparent, int titleColor, int backRes) {
        if (this.mCommonTitle != null) {
            this.showTitleBar(!isTransparent);
            this.mCommonTitle.setTitleTextColor(titleColor);
            if (backRes > 0) {
                this.mCommonTitle.addLeftButtonWithImageRes(backRes);
            }
        }
    }

    public void setBackIcon(int res) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.addLeftButtonWithImageRes(res);
        }
    }

    public void showTitleBar(boolean isShow) {
        if (this.mCommonTitle != null) {
            this.mCommonTitle.setDividerVisibility(isShow);
            if (!isShow) {
                this.mCommonTitle.setMyBackground(0);
            } else {
                this.mCommonTitle.setDeviderColor(this.mContext.getResources().getColor(R.color.wa_simple_title_divider_color));
                this.mCommonTitle.setMyBackground(this.mContext.getResources().getColor(R.color.wa_simple_title_bg_default_color));
            }
        }
    }

    public void onSetPageBackMode(String backMode, String lastLayerUrl, String currentWebUrl) {
        String curUrl = currentWebUrl;
        WebPageBackEntity pageEntity = new WebPageBackEntity();
        pageEntity.currentPageUrl = curUrl;
        pageEntity.backMode = backMode;
        pageEntity.lastLayerUrl = lastLayerUrl;
        this.mPageBackModeRecord.put(curUrl, pageEntity);
    }

    public WebPageBackEntity getPageBackMode(String url) {
        return this.mPageBackModeRecord.get(url);
    }

    public static class WebPageBackEntity {
        public String currentPageUrl;
        public String backMode;
        public String lastLayerUrl;
        public static final String WEB_PAGE_BACK_STYLE = "web_page_back_style";
        public static final String BACK_STYLE_EXIT = "exit";
        public static final String BACK_STYLE_HISTORY = "history";
        public static final String BACK_STYLE_LAYER = "layer";
        public static final String BACK_STYLE_SELF = "self";
        public static final String BACK_STYLE_GOBACK = "goback";
    }
}

