/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.base.logger.MLog;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.webservice.R;

public class StatusLayout {
    private ViewGroup mContainer;
    private View mNetErrorView;
    private View mLoadingView;
    private SVGAImageView mProgress;
    private View.OnClickListener mRefreshListener;

    public StatusLayout(ViewGroup container) {
        this.mContainer = container;
    }

    public void setRefreshListener(View.OnClickListener listener) {
        this.mRefreshListener = listener;
    }

    public void showLoading() {
        if (this.mLoadingView != null) {
            this.mContainer.removeView(this.mLoadingView);
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContainer.getContext());
        View view = inflater.inflate(R.layout.wa_webview_loading, this.mContainer, false);
        this.mProgress = (SVGAImageView)view.findViewById(R.id.svga_loading_progress);
        this.mContainer.addView(view);
        this.mLoadingView = view;
        SvgaLoader.load((SVGAImageView)this.mProgress, (String)"loading.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (StatusLayout.this.mProgress != null) {
                    StatusLayout.this.mProgress.startAnimation();
                }
            }

            public void onFailed(Exception e) {
                MLog.error((Object)"StatusLayout", (String)"load svga failed ", (Throwable)e, (Object[])new Object[0]);
            }
        });
    }

    public void refresh() {
        if (this.mRefreshListener != null) {
            this.mRefreshListener.onClick((View)this.mContainer);
        }
    }

    public void showNetError() {
        if (this.mNetErrorView != null) {
            this.mContainer.removeView(this.mNetErrorView);
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContainer.getContext());
        View view = inflater.inflate(R.layout.wa_network_error, this.mContainer, false);
        view.setOnClickListener(this.mRefreshListener);
        this.mContainer.addView(view);
        this.mNetErrorView = view;
    }

    public void hideStatusView() {
        if (this.mNetErrorView != null) {
            this.mContainer.removeView(this.mNetErrorView);
            this.mNetErrorView = null;
        }
        if (this.mLoadingView != null) {
            this.mContainer.removeView(this.mLoadingView);
            this.mLoadingView = null;
        }
    }
}

