/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.event.parqam;

import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.event.parqam.IJsParam;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseJsParam
implements IJsParam {
    private static final String TAG = "BaseJsParam";
    public static final int SUCCESS = 1;
    public int code = 1;
    public String msg = "";
    public String data = "";
    private JSONObject jsonObject;
    private String jsonString;

    public static BaseJsParam errorParam(int code, String errMsg) {
        BaseJsParam result = new BaseJsParam();
        result.code = code;
        result.msg = errMsg;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "code");
        return result;
    }

    public static BaseJsParam codeParam(int code, String data) {
        BaseJsParam result = new BaseJsParam();
        result.code = code;
        result.data = data;
        return result;
    }

    public static BaseJsParam successParam(String msg) {
        BaseJsParam result = new BaseJsParam();
        result.code = 1;
        result.msg = msg;
        return result;
    }

    public static BaseJsParam dataParam(String data) {
        BaseJsParam result = new BaseJsParam();
        result.data = data;
        return result;
    }

    public static DataBuilder builder() {
        return new DataBuilder();
    }

    @Override
    public synchronized String toJson() {
        if (this.jsonString != null) {
            return this.jsonString;
        }
        if (this.jsonObject == null) {
            this.jsonObject = JsonParser.obtainJSONObject();
            try {
                this.jsonObject.put("code", this.code);
                this.jsonObject.put("msg", (Object)this.msg);
                this.jsonObject.put("data", (Object)this.data);
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
            this.jsonString = this.jsonObject.toString();
        }
        return this.jsonString;
    }

    public static BaseJsParam parse(String jsonString) {
        BaseJsParam param = new BaseJsParam();
        if (!TextUtils.isEmpty((CharSequence)jsonString)) {
            param.jsonString = jsonString;
            try {
                param.jsonObject = JsonParser.obtainJSONObject((String)jsonString);
                param.code = param.jsonObject.optInt("code", 0);
                param.msg = param.jsonObject.optString("msg", "");
                param.data = param.jsonObject.optString("data", "");
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return param;
    }

    public String toString() {
        return this.toJson();
    }

    public static class DataBuilder {
        private JSONObject jsonObject;

        DataBuilder() {
        }

        public synchronized DataBuilder put(String key, Object value) {
            if (TextUtils.isEmpty((CharSequence)key) || value == null) {
                return this;
            }
            if (this.jsonObject == null) {
                this.jsonObject = JsonParser.obtainJSONObject();
            }
            try {
                this.jsonObject.put(key, value);
            }
            catch (JSONException e) {
                MLog.error((Object)BaseJsParam.TAG, (String)"put json error key: %s, value: %s", (Throwable)e, (Object[])new Object[]{key, value});
            }
            return this;
        }

        public synchronized String jsonData() {
            if (this.jsonObject != null) {
                return this.jsonObject.toString();
            }
            return "";
        }

        public BaseJsParam build() {
            BaseJsParam param = new BaseJsParam();
            param.data = this.jsonData();
            return param;
        }
    }
}

