/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.event;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsEventCallback;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.event.parqam.JsReturn;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsEventDispatch {
    private static final String TAG = "JsEventDispatch";
    private final Map<JsMethod, JsEvent> mJsEvents = new ConcurrentHashMap<JsMethod, JsEvent>();

    public IJsParam dispatchEvent(final @NonNull IWebBusinessHandler handler, String module, String methodName, String context, final String paramJson, String callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"dispatchEvent module: %s, methodName: %s, context: %s, callback: %s, paramJson: %s", (Object[])new Object[]{module, methodName, context, callback, paramJson});
        }
        if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)methodName)) {
            return JsReturn.DEFAULT_ERROR;
        }
        JsMethod jm = JsMethod.jsMethod(module, methodName);
        final JsEvent je = this.mJsEvents.get(jm);
        if (je == null) {
            return JsReturn.DEFAULT_ERROR;
        }
        JsEventCallback cb = null;
        if (!TextUtils.isEmpty((CharSequence)callback)) {
            cb = new JsEventCallback(handler, context, callback);
        }
        final JsEventCallback fcb = cb;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                je.jsCall(handler, paramJson, fcb);
            }
        });
        return JsReturn.DEFAULT;
    }

    public void addJsEvent(@NonNull JsEvent event) {
        JsMethod jm;
        if (this.mJsEvents.containsValue(event)) {
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"addJsEvent method: %s", (Object[])new Object[]{event.method()});
        }
        if (RuntimeContext.sIsDebuggable && this.mJsEvents.containsKey(jm = event.method())) {
            throw new IllegalStateException("js call can only be handle by one, you may add two different handle event with the same method: " + jm.toString());
        }
        this.mJsEvents.put(event.method(), event);
    }

    public void removeJsEvent(@NonNull JsEvent event) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"removeJsEvent method: %s", (Object[])new Object[]{event.method()});
        }
        this.mJsEvents.remove(event.method());
    }

    public String allSupportMethod() {
        HashMap<String, JSONArray> module = new HashMap<String, JSONArray>();
        for (Map.Entry<JsMethod, JsEvent> entry : this.mJsEvents.entrySet()) {
            JsMethod jsMethod = entry.getKey();
            String moduleId = jsMethod.getModule();
            JSONArray ja = (JSONArray)module.get(moduleId);
            if (ja == null) {
                ja = new JSONArray();
                module.put(moduleId, ja);
            }
            ja.put((Object)jsMethod.getMethod());
        }
        JSONObject jsonObject = JsonParser.obtainJSONObject();
        for (Map.Entry entry : module.entrySet()) {
            try {
                jsonObject.put((String)entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return jsonObject.toString();
    }
}

