/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.event;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEventUtils;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONException;
import org.json.JSONObject;

public class JsEventCallback
implements IJsEventCallback {
    private static final String TAG = "JsEventCallback";
    private final IWebBusinessHandler mWebHandler;
    private String mContext;
    private final String mCallbackName;

    JsEventCallback(@NonNull IWebBusinessHandler handler, @Nullable String context, @NonNull String callback) {
        this.mWebHandler = handler;
        this.mContext = context;
        this.mCallbackName = callback;
    }

    @Override
    public void callJs(final IJsParam param) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    JsEventCallback.this.callJsAsync(param);
                }
            });
        } else {
            this.callJsAsync(param);
        }
    }

    private void callJsAsync(IJsParam param) {
        String json = param == null ? "" : param.toJson();
        String string2 = json = json == null ? "" : json;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"callJsAsync context: %s, callback: %s, param: %s", (Object[])new Object[]{this.mContext, this.mCallbackName, json});
        }
        if ("oldMethodContext".equals(this.mContext)) {
            if ("onLoadPrivateUserData".equals(this.mCallbackName)) {
                this.onLoadPrivateUserData(json);
            } else if ("onShareSuccess".equals(this.mCallbackName)) {
                this.mWebHandler.loadPureJs("callWebviewMethod('onShareSuccess')");
            } else if ("onActivityShareSuccess".equals(this.mCallbackName)) {
                this.mWebHandler.loadNotifyJs(this.mCallbackName, "");
            }
        } else if ("yy_js_interface_context".equals(this.mContext)) {
            this.mWebHandler.loadPureJs(JsEventUtils.formatYYJs(this.mCallbackName, json));
        } else {
            this.mWebHandler.loadCallbackJs(this.mCallbackName, this.mContext, json);
        }
    }

    private void onLoadPrivateUserData(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return;
        }
        try {
            BaseJsParam param = BaseJsParam.parse(json);
            if (param == null || TextUtils.isEmpty((CharSequence)param.data)) {
                MLog.error((Object)TAG, (String)"onLoadPrivateUserData data is empty", (Object[])new Object[0]);
                return;
            }
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)param.data);
            String key = jsonObject.optString("key");
            String value = jsonObject.optString("value");
            this.mWebHandler.loadPureJs(StringUtils.formatWitUSLocal((String)"onLoadPrivateUserData('%s', '%s')", (Object[])new Object[]{key, value}));
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"onLoadPrivateUserData", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

