/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.PerfOptDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.webservice.IJsTitleBarAction;
import com.yy.webservice.IWebUICallBack;
import com.yy.webservice.WebConfigure;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsEventDispatch;
import com.yy.webservice.event.JsEventUtils;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.event.parqam.JsReturn;
import com.yy.webservice.webwindow.IWebUi;
import com.yy.webservice.webwindow.IWebWindowCallback;
import com.yy.webservice.webwindow.WebDialogStyleWindow;
import com.yy.webservice.webwindow.WebUIController;
import com.yy.webservice.webwindow.WebWindow;
import com.yy.webservice.webwindow.webview.IWebIntentFilter;
import com.yy.webservice.webwindow.webview.IWebViewPermissionCallback;
import com.yy.webservice.webwindow.webview.Utils;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import com.yy.webservice.webwindow.webview.base.WebViewReuse;
import com.yy.webservice.webwindow.webview.base.YYWebView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WebDisplayController
extends AbstractController {
    private static final String TAG = "Web_WebDisplayController";
    private WebEnvSettings mWebEnvSettings;
    private WebConfigure mWebConfigure;
    private IWebUi mWebWindow;
    private WebUIController mWebUiController;
    private IWebUICallBack mWebUICallBack;
    private ICallBack mCallBack;
    private IWebBusinessHandler mWebBusinessHandler;
    private final List<WebBusinessHandlerCallback> mWebBusinessHandlerCallbacks = new CopyOnWriteArrayList<WebBusinessHandlerCallback>();
    private JsEventDispatch mJsEventDispatch;
    private int mIndex;
    private long mOBeginLoadTime;
    private long mFinishLoadTime;
    private boolean isShowWeb;
    public boolean isDelayShowWindow = false;
    public boolean loadUrlAfterWindowShown = true;
    private String mWebId;
    private final List<String> mNotifyList = new CopyOnWriteArrayList<String>();
    private boolean windowDettach = false;

    public WebDisplayController(Environment baseEnv, WebEnvSettings webEnvSettings, WebConfigure webConfigure, ICallBack callBack, int index) {
        super(baseEnv);
        this.mWebEnvSettings = webEnvSettings;
        this.mCallBack = callBack;
        this.mIndex = index;
        this.mWebConfigure = webConfigure;
        this.loadUrlAfterWindowShown = !WebViewReuse.loadUrlBeforeWindowShownSwitchOn();
    }

    private boolean canCacheWeb() {
        if (PerfOptDef.webWindowReuse != 1 && PerfOptDef.webWindowReuse != 2) {
            return false;
        }
        if (this.mWebEnvSettings == null) {
            return false;
        }
        if (PerfOptDef.webWindowReuse == 1) {
            return this.mWebEnvSettings != null ? this.mWebEnvSettings.webWindowReuse == 1 : false;
        }
        return true;
    }

    public void releaseCache() {
        if (this.windowDettach) {
            this.releaseWeb();
        }
    }

    public WebEnvSettings getWebEnvSettings() {
        return this.mWebEnvSettings;
    }

    public void closeWindow(boolean animation) {
        if (this.mWebWindow == null) {
            return;
        }
        if (this.mWindowMgr.getCurrentWindow() == this.getWebWindow()) {
            this.mWindowMgr.popWindow(animation, this.getWebWindow());
        } else {
            this.mWindowMgr.removeWindow(this.getWebWindow(), true);
        }
    }

    private void fillStartLoadTime() {
        if (this.mWebEnvSettings != null) {
            if (this.mWebEnvSettings.statParams.startLoadPageTime > 0L) {
                this.mOBeginLoadTime = this.mWebEnvSettings.statParams.startLoadPageTime;
            } else {
                this.mWebEnvSettings.statParams.startLoadPageTime = this.mOBeginLoadTime = System.currentTimeMillis();
            }
        } else {
            this.mOBeginLoadTime = System.currentTimeMillis();
        }
    }

    public void showWebWindow(boolean aniWhenBringToFront) {
        this.isDelayShowWindow = false;
        this.fillStartLoadTime();
        if (this.mWebWindow == null) {
            this.mWebWindow = this.createWindow();
            this.checkHideNavBar();
            this.mWindowMgr.pushWindow(this.getWebWindow(), this.webWindowAnimator());
        } else {
            this.checkHideNavBar();
            this.mWindowMgr.pushWindow(this.getWebWindow(), aniWhenBringToFront);
            if (this.mWebEnvSettings != null) {
                this.mWebWindow.showTitleBar(!this.mWebEnvSettings.isFullScreen);
            }
        }
        if (!this.loadUrlAfterWindowShown) {
            this.loadOriginUrl();
        }
    }

    private void checkHideNavBar() {
        AbstractWindow currentWin = this.mWindowMgr.getCurrentWindow();
        if (currentWin != null && TextUtils.equals((CharSequence)currentWin.getName(), (CharSequence)"ChannelWindow")) {
            this.mWebWindow.checkHideNavBar();
        }
    }

    public void delayShowWebWindow() {
        this.isDelayShowWindow = true;
        this.fillStartLoadTime();
        if (this.mWebWindow == null) {
            this.mWebWindow = this.createWindow();
        }
        this.loadOriginUrl();
    }

    private IWebUi createWindow() {
        if (this.mWebEnvSettings.dialogStyle != null) {
            return new WebDialogStyleWindow(this.mContext, (UICallBacks)this, this.mWebEnvSettings, new IWebWindowCallback(){

                @Override
                public void onRealExit() {
                    WebDisplayController.this.realExit();
                }
            });
        }
        return new WebWindow(this.mContext, (UICallBacks)this, this.mWebEnvSettings);
    }

    public void handleRefresh(boolean retruenRefresh, boolean retruenRefreshPazrt) {
        if (retruenRefresh) {
            if (this.mWebUiController != null) {
                this.mWebUiController.refreshWebView();
            }
        } else if (retruenRefreshPazrt && this.mWebUiController != null) {
            this.mWebUiController.webViewSafeLoadJs("javascript:reshPart()");
        }
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        if (AbstractWindow.isHaveKeyDownEvent() && this.mWebUiController != null && this.mWebUiController.onKeyEvent(keyCode, event)) {
            return true;
        }
        return super.onWindowKeyEvent(keyCode, event);
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        if (!this.isDelayShowWindow && this.loadUrlAfterWindowShown) {
            this.loadOriginUrl();
        }
        if (this.canCacheWeb() && this.mWebWindow != null && this.mWebEnvSettings != null) {
            this.mWebWindow.showTitleBar(!this.mWebEnvSettings.isFullScreen);
        }
        if (this.mCallBack != null) {
            this.mCallBack.onWebShown(this.getWebBussinessHandler(), this.windowDettach);
        }
        this.windowDettach = false;
    }

    private void loadOriginUrl() {
        if (this.mWebUiController == null) {
            MLog.info((Object)TAG, (String)"init mWebViewBussiness", (Object[])new Object[0]);
            this.initWebUICallBack();
            this.mWebUiController = new WebUIController(this.mWebWindow, this.mWebEnvSettings, this.mWebConfigure, this.mWebUICallBack);
            this.mJsEventDispatch = new JsEventDispatch();
            if (this.mCallBack != null) {
                this.mCallBack.onWebBusinessCreated(this.getWebBussinessHandler());
            }
            if (this.mWebBusinessHandlerCallbacks != null && this.mWebBusinessHandlerCallbacks.size() > 0) {
                for (WebBusinessHandlerCallback callback : this.mWebBusinessHandlerCallbacks) {
                    callback.beforeLoadUrl(this.mWebEnvSettings.url);
                }
            }
            this.mWebUiController.loadOriginUrl(this.mWebEnvSettings.url);
        }
        if (!this.mWebEnvSettings.isShowStatusBar) {
            this.mDeviceMgr.hideSysStatusBar();
        } else {
            this.mDeviceMgr.showSysStatusBar();
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        if (this.mCallBack != null) {
            this.mCallBack.onWebHidden(this.getWebBussinessHandler());
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        if (abstractWindow != this.mWebWindow) {
            return;
        }
        if (this.canCacheWeb() && !RuntimeContext.sHappenLowMemWarn) {
            Notification notification = Notification.obtain((int)NotificationDef.N_WEB_VIEW_WINDOW_CLOSED);
            notification.extObj = this.mWebEnvSettings;
            NotificationCenter.getGlobalInstance().notify(notification);
            if (this.mCallBack != null) {
                this.mCallBack.cachedWhenWindowDettach(this);
            }
            this.windowDettach = true;
            MLog.info((Object)TAG, (String)"cache mWebViewBussiness", (Object[])new Object[0]);
            return;
        }
        this.releaseWeb();
    }

    private void releaseWeb() {
        if (this.mWebWindow != null && this.mWebUiController != null) {
            for (WebBusinessHandlerCallback callback : this.mWebBusinessHandlerCallbacks) {
                callback.onWebViewDestroy();
            }
            if (this.mCallBack != null) {
                this.mCallBack.onWebBusinessDestroyed(this.mWebBusinessHandler);
            }
            boolean refresh = false;
            boolean refreshPart = false;
            if (this.mWebEnvSettings != null) {
                refresh = this.mWebEnvSettings.retruenRefresh;
                refreshPart = this.mWebEnvSettings.retruenRefreshPart;
                this.mWebEnvSettings.webWindowReuse = -1;
            }
            this.mWebUiController.onDestroy();
            this.mWebUiController = null;
            if (this.mCallBack != null) {
                this.mCallBack.exited(this, refresh, refreshPart);
            }
            Notification notification = Notification.obtain((int)NotificationDef.N_WEB_VIEW_WINDOW_CLOSED);
            notification.extObj = this.mWebEnvSettings;
            NotificationCenter.getGlobalInstance().notify(notification);
        }
        MLog.info((Object)TAG, (String)"release mWebViewBussiness", (Object[])new Object[0]);
        this.mWebWindow = null;
        this.windowDettach = false;
    }

    private boolean webWindowAnimator() {
        return this.mWebEnvSettings == null ? true : this.mWebEnvSettings.webWindowAnimator;
    }

    private void initWebUICallBack() {
        if (this.mWebUICallBack == null) {
            this.mWebUICallBack = new IWebUICallBack(){

                @Override
                public String getDefaultUA() {
                    return "";
                }

                @Override
                @Nullable
                public IWebIntentFilter getIntentFilter(String url) {
                    return WebDisplayController.this.mCallBack != null ? WebDisplayController.this.mCallBack.getIntentFilter(url) : null;
                }

                @Override
                public void requestExit() {
                    WebDisplayController.this.exitWebView();
                }

                @Override
                public void onReceivedTitle(WebView view, String title) {
                }

                @Override
                public void shouldOverrideUrlLoading(WebView view, String url) {
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    WebDisplayController.this.isShowWeb = false;
                    for (WebBusinessHandlerCallback callback : WebDisplayController.this.mWebBusinessHandlerCallbacks) {
                        callback.onPageStarted(view, url, favicon);
                    }
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    WebDisplayController.this.mFinishLoadTime = System.currentTimeMillis();
                    if (!WebDisplayController.this.isShowWeb && WebDisplayController.this.isDelayShowWindow) {
                        WebDisplayController.this.isShowWeb = true;
                        WebDisplayController.this.mWindowMgr.pushWindow(WebDisplayController.this.getWebWindow(), WebDisplayController.this.webWindowAnimator());
                    }
                    for (WebBusinessHandlerCallback callback : WebDisplayController.this.mWebBusinessHandlerCallbacks) {
                        callback.onPageFinished(view, url);
                    }
                }

                @Override
                public void onLoadResource(WebView view, String url) {
                }

                @Override
                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    for (WebBusinessHandlerCallback callback : WebDisplayController.this.mWebBusinessHandlerCallbacks) {
                        callback.onReceivedError(view, errorCode, description, failingUrl);
                    }
                }

                @Override
                public void onInterceptBack(int type) {
                    for (WebBusinessHandlerCallback callback : WebDisplayController.this.mWebBusinessHandlerCallbacks) {
                        callback.onInterceptBack(type);
                    }
                }

                @Override
                public boolean nativeGetGameIsInstall(String gameId) {
                    if (WebDisplayController.this.mCallBack != null) {
                        return WebDisplayController.this.mCallBack.nativeGetGameIsInstall(gameId);
                    }
                    return false;
                }

                @Override
                public IJsParam callAppMethod(String module, String methodName, String context, String paramJson, String callback) {
                    if (WebDisplayController.this.mJsEventDispatch != null) {
                        return WebDisplayController.this.mJsEventDispatch.dispatchEvent(WebDisplayController.this.getWebBussinessHandler(), module, methodName, context, paramJson, callback);
                    }
                    return JsReturn.DEFAULT_ERROR;
                }

                @Override
                public String appInfo() {
                    if (WebDisplayController.this.mCallBack != null) {
                        return WebDisplayController.this.mCallBack.appInfo();
                    }
                    return null;
                }

                @Override
                public String allSupportMethod() {
                    if (WebDisplayController.this.mJsEventDispatch != null) {
                        return WebDisplayController.this.mJsEventDispatch.allSupportMethod();
                    }
                    return null;
                }

                @Override
                public String userToken() {
                    if (WebDisplayController.this.mCallBack != null) {
                        return WebDisplayController.this.mCallBack.userToken();
                    }
                    return null;
                }

                @Override
                public String myselfUserInfo() {
                    if (WebDisplayController.this.mCallBack != null) {
                        return WebDisplayController.this.mCallBack.myselfUserInfo();
                    }
                    return null;
                }

                @Override
                public void onPermissionRequested(String permission, IWebViewPermissionCallback callback) {
                    if (WebDisplayController.this.mCallBack != null) {
                        WebDisplayController.this.mCallBack.onPermissionRequested(permission, callback);
                    }
                }

                @Override
                public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                    WebResourceResponse resourceResponse = null;
                    for (WebBusinessHandlerCallback callback : WebDisplayController.this.mWebBusinessHandlerCallbacks) {
                        resourceResponse = callback.shouldInterceptRequest(view, request);
                        if (resourceResponse == null) continue;
                        return resourceResponse;
                    }
                    return null;
                }

                @Override
                public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                    for (WebBusinessHandlerCallback callback : WebDisplayController.this.mWebBusinessHandlerCallbacks) {
                        callback.onReceivedHttpError(view, request, errorResponse);
                    }
                }
            };
        }
    }

    public void exitWebView() {
        if (YYTaskExecutor.isMainThread()) {
            this.exitInMain();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebDisplayController.this.exitInMain();
                }
            });
        }
    }

    private void exitInMain() {
        if (this.mWebWindow != null && !this.mWebWindow.interceptorClose()) {
            this.realExit();
        }
    }

    private void realExit() {
        if (this.webViewWindowAboveChannelWindow()) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_WEB_WINDOW_INSTANT_CLOSE));
        }
        if (this.mWindowMgr.getCurrentWindow() == this.mWebWindow) {
            this.mWindowMgr.popWindow(this.webWindowAnimator(), this.getWebWindow());
        } else {
            this.mWindowMgr.removeWindow(this.getWebWindow(), this.webWindowAnimator());
        }
    }

    private boolean webViewWindowAboveChannelWindow() {
        AbstractWindow window = this.getEnvironment().getWindowManager().getWindowBehind(this.getWebWindow());
        if (window == null) {
            return false;
        }
        return window.getName().equals("ChannelWindow");
    }

    private synchronized IWebBusinessHandler getWebBussinessHandler() {
        if (this.mWebBusinessHandler == null) {
            this.mWebBusinessHandler = new IWebBusinessHandler(){

                @Override
                public int getWebIndex() {
                    return WebDisplayController.this.mIndex;
                }

                @Override
                public void addJsEvent(@NonNull JsEvent event) {
                    if (WebDisplayController.this.mJsEventDispatch != null) {
                        WebDisplayController.this.mJsEventDispatch.addJsEvent(event);
                    }
                }

                @Override
                public void removeJsEvent(@NonNull JsEvent event) {
                    if (WebDisplayController.this.mJsEventDispatch != null) {
                        WebDisplayController.this.mJsEventDispatch.removeJsEvent(event);
                    }
                }

                @Override
                public void loadPureJs(String js) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)WebDisplayController.TAG, (String)"loadPureJs js: %s", (Object[])new Object[]{js});
                    }
                    WebDisplayController.this.loadPureJs(js);
                }

                @Override
                public void loadCallbackJs(String callbackName, String context, String param) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)WebDisplayController.TAG, (String)"loadCallbackJs callbackName: %s, context: %s, param: %s", (Object[])new Object[]{callbackName, context, param});
                    }
                    WebDisplayController.this.loadCallbackJs(callbackName, context, param);
                }

                @Override
                public void loadNotifyJs(String notifyName, String param) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)WebDisplayController.TAG, (String)"loadNotifyJs notifyName: %s, param: %s", (Object[])new Object[]{notifyName, param});
                    }
                    WebDisplayController.this.loadNotifyJs(notifyName, param);
                }

                @Override
                public WebEnvSettings getWebEnvSettings() {
                    return WebDisplayController.this.mWebEnvSettings;
                }

                @Override
                public void exit() {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.checkExit(false);
                    }
                }

                @Override
                public void setTitleImage(int imageResId) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.setTitleImage(imageResId);
                    }
                }

                @Override
                public void updateTitleMsgStatus(int id2, String badge) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.updateTitleMsgStatus(id2, badge);
                    }
                }

                @Override
                public void refreshWebView() {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.refreshWebView();
                    }
                }

                @Override
                public void showProgressDialog(String label, boolean cancelable, int timeOut) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.showProgressDialog(label, cancelable, timeOut);
                    }
                }

                @Override
                public void hideProgress() {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.hideProgress();
                    }
                }

                @Override
                public boolean addWebViweClientFilterList(String jsonData) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        return WebDisplayController.this.mWebUiController.addWebViweClientFilterList(jsonData);
                    }
                    return false;
                }

                @Override
                public void showAlertDialog(String title, String message, String positiveButton, String neutralButton, String negativeButton, boolean cancelable, Utils.IAlertDialogCallBack callBack) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.showAlertDialog(title, message, positiveButton, neutralButton, negativeButton, cancelable, callBack);
                    }
                }

                @Override
                public void onSetPageBackMode(String backMode, String lastLayerUrl) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.onSetPageBackMode(backMode, lastLayerUrl);
                    }
                }

                @Override
                public void appendUserAgentString(String ua) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.appendUserAgentString(ua);
                    }
                }

                @Override
                public void updateUserAgentString(String ua) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.updateUserAgentString(ua);
                    }
                }

                @Override
                public void setTouchAreas(List<Rect> touchArea, boolean showDebugAreaView) {
                }

                @Override
                public List<Rect> getTouchAreas() {
                    return null;
                }

                @Override
                public void loadUrl(String url) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.loadUrl(url);
                    }
                }

                @Override
                public IJsTitleBarAction getJsChangeTitleBarAction() {
                    if (WebDisplayController.this.mWebUiController != null) {
                        return WebDisplayController.this.mWebUiController.getJsChangeTitleBarAction();
                    }
                    return null;
                }

                @Override
                public void showStatusBar(boolean isShow) {
                    if (!isShow) {
                        WebDisplayController.this.mDeviceMgr.hideSysStatusBar();
                    } else {
                        WebDisplayController.this.mDeviceMgr.showSysStatusBar();
                    }
                    if (WebDisplayController.this.mWebEnvSettings != null) {
                        ((WebDisplayController)WebDisplayController.this).mWebEnvSettings.isShowStatusBar = isShow;
                    }
                }

                @Override
                public boolean enablePushRefresh(boolean enable) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        return WebDisplayController.this.mWebUiController.enablePushRefresh(enable);
                    }
                    return false;
                }

                @Override
                public void addWebViewListener(@Nullable WebBusinessHandlerCallback callback) {
                    if (callback == null) {
                        return;
                    }
                    if (!WebDisplayController.this.mWebBusinessHandlerCallbacks.contains(callback)) {
                        WebDisplayController.this.mWebBusinessHandlerCallbacks.add(callback);
                    }
                }

                @Override
                public void removeWebViewListener(@Nullable WebBusinessHandlerCallback callback) {
                    if (callback == null) {
                        return;
                    }
                    if (WebDisplayController.this.mWebBusinessHandlerCallbacks.contains(callback)) {
                        WebDisplayController.this.mWebBusinessHandlerCallbacks.remove(callback);
                    }
                }

                @Override
                public void interceptBack(int intercept) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.interceptBack(intercept);
                    }
                }

                @Override
                public void simulateAppBack(int type) {
                    if (WebDisplayController.this.mWebUiController == null) {
                        return;
                    }
                    if (type == 1) {
                        WebDisplayController.this.mWebUiController.onBackBtnBack();
                    } else if (type == 2) {
                        WebDisplayController.this.mWebUiController.onKeyBack();
                    }
                }

                @Override
                public long getWebViewBeginTime() {
                    return WebDisplayController.this.mOBeginLoadTime;
                }

                @Override
                public long getWebViewFinishTime() {
                    return WebDisplayController.this.mFinishLoadTime;
                }

                @Override
                @Nullable
                public Context getContext() {
                    if (WebDisplayController.this.mWebWindow != null) {
                        return ((AbstractWindow)WebDisplayController.this.mWebWindow).getContext();
                    }
                    return WebDisplayController.this.mContext;
                }

                @Override
                public void setWebId(String webId) {
                    MLog.info((Object)WebDisplayController.TAG, (String)"setWebId webId: %s", (Object[])new Object[]{webId});
                    WebDisplayController.this.mWebId = webId;
                }

                @Override
                public String getWeId() {
                    return WebDisplayController.this.mWebId;
                }

                @Override
                public boolean isUseCacheWeb() {
                    WebView webView2;
                    if (WebDisplayController.this.mWebWindow != null && (webView2 = WebDisplayController.this.mWebWindow.getWebView()) instanceof YYWebView) {
                        return ((YYWebView)webView2).isReused();
                    }
                    return false;
                }

                @Override
                public boolean registerNotify(String notify) {
                    MLog.debug((Object)WebDisplayController.TAG, (String)"registerNotify webId: %s, notify: %s", (Object[])new Object[]{WebDisplayController.this.mWebId, notify});
                    if (TextUtils.isEmpty((CharSequence)notify)) {
                        MLog.error((Object)WebDisplayController.TAG, (String)"registerNotify webId: %s, notify: %s", (Object[])new Object[]{WebDisplayController.this.mWebId, notify});
                        return false;
                    }
                    return WebDisplayController.this.mNotifyList.add(notify);
                }

                @Override
                public boolean unregisterNotify(String notify) {
                    MLog.debug((Object)WebDisplayController.TAG, (String)"unregisterNotify webId: %s, notify: %s", (Object[])new Object[]{WebDisplayController.this.mWebId, notify});
                    if (TextUtils.isEmpty((CharSequence)notify)) {
                        MLog.error((Object)WebDisplayController.TAG, (String)"unregisterNotify webId: %s, notify: %s", (Object[])new Object[]{WebDisplayController.this.mWebId, notify});
                        return false;
                    }
                    return WebDisplayController.this.mNotifyList.add(notify);
                }

                @Override
                public void updateRenderMode(int mode) {
                    if (WebDisplayController.this.mWebUiController != null) {
                        WebDisplayController.this.mWebUiController.updateRenderMode(mode);
                    }
                }
            };
        }
        return this.mWebBusinessHandler;
    }

    private void loadPureJs(String js) {
        if (TextUtils.isEmpty((CharSequence)js)) {
            return;
        }
        this.loadJsString(JsEventUtils.formatPureLoadJs(js));
    }

    private void loadCallbackJs(String methodName, String context, String param) {
        if (TextUtils.isEmpty((CharSequence)methodName)) {
            return;
        }
        this.loadJsString(JsEventUtils.formatLoadJs(methodName, context, param));
    }

    private void loadNotifyJs(String methodName, String param) {
        if (TextUtils.isEmpty((CharSequence)methodName)) {
            return;
        }
        this.loadJsString(JsEventUtils.formatLoadJs(methodName, "notify", param));
    }

    private void loadJsString(String jsStr) {
        if (TextUtils.isEmpty((CharSequence)jsStr)) {
            return;
        }
        if (this.mWebUiController != null) {
            this.mWebUiController.webViewSafeLoadJs(jsStr);
        }
    }

    private AbstractWindow getWebWindow() {
        return (AbstractWindow)this.mWebWindow;
    }

    static interface ICallBack {
        public void exited(WebDisplayController var1, boolean var2, boolean var3);

        public void cachedWhenWindowDettach(WebDisplayController var1);

        public void onWebBusinessCreated(IWebBusinessHandler var1);

        public void onWebBusinessDestroyed(IWebBusinessHandler var1);

        @Nullable
        public IWebIntentFilter getIntentFilter(String var1);

        public boolean nativeGetGameIsInstall(String var1);

        public String appInfo();

        public String userToken();

        public String myselfUserInfo();

        public void onPermissionRequested(String var1, IWebViewPermissionCallback var2);

        public void onWebShown(IWebBusinessHandler var1, boolean var2);

        public void onWebHidden(IWebBusinessHandler var1);
    }
}

