/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice;

import android.os.Message;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.webservice.WebConfigure;
import com.yy.webservice.WebDisplayController;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.client.IWebServiceCallBack;
import com.yy.webservice.webwindow.webview.IWebIntentFilter;
import com.yy.webservice.webwindow.webview.IWebViewPermissionCallback;
import java.util.ArrayList;

public class WebController
extends AbstractController
implements WebDisplayController.ICallBack {
    private static final String TAG = "Web_WebController";
    private final ArrayList<WebDisplayController> mDisplayers = new ArrayList(5);
    private final ArrayList<WebDisplayController> mCachedDisplayers = new ArrayList(2);
    private String mDefaultUa;
    private WebConfigure mWebConfigure;
    private IWebServiceCallBack mCallBack;

    public WebController(Environment baseEnv, String defaultUa, WebConfigure webConfigure, IWebServiceCallBack callBack) {
        super(baseEnv);
        this.mDefaultUa = defaultUa;
        this.mCallBack = callBack;
        this.mWebConfigure = webConfigure;
    }

    public void setDefaultUa(String ua) {
        this.mDefaultUa = ua;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUrl(WebEnvSettings webEnvSettings) {
        if (webEnvSettings == null) {
            return;
        }
        WebDisplayController controller = null;
        if (this.mCachedDisplayers.size() > 0) {
            for (WebDisplayController item : this.mCachedDisplayers) {
                if (StringUtils.isNotEmpty((String)item.getWebEnvSettings().originUrl) && StringUtils.equal((String)item.getWebEnvSettings().originUrl, (String)webEnvSettings.originUrl)) {
                    controller = item;
                    break;
                }
                if (!StringUtils.isNotEmpty((String)item.getWebEnvSettings().url) || !StringUtils.equal((String)item.getWebEnvSettings().url, (String)webEnvSettings.url)) continue;
                controller = item;
                break;
            }
            if (controller != null) {
                this.mCachedDisplayers.remove((Object)controller);
            }
        }
        if (controller == null) {
            webEnvSettings.defaultUa = StringUtils.isEmpty((String)webEnvSettings.defaultUa) ? this.mDefaultUa : webEnvSettings.defaultUa + this.mDefaultUa;
            controller = new WebDisplayController(this.getEnvironment(), webEnvSettings, this.mWebConfigure, this, this.mDisplayers.size());
            if (webEnvSettings.isDelayShow) {
                controller.delayShowWebWindow();
            } else {
                controller.showWebWindow(false);
            }
            ArrayList<WebDisplayController> arrayList = this.mDisplayers;
            synchronized (arrayList) {
                this.mDisplayers.add(controller);
                MLog.info((Object)TAG, (String)"on webView added, current size:%d", (Object[])new Object[]{this.mDisplayers.size()});
            }
        } else {
            if (webEnvSettings.isDelayShow) {
                controller.delayShowWebWindow();
            } else {
                controller.showWebWindow(controller.getWebEnvSettings().webWindowAnimator);
            }
            MLog.info((Object)TAG, (String)"use cached webView, originUrl:%s, url:%s", (Object[])new Object[]{controller.getWebEnvSettings().originUrl, controller.getWebEnvSettings().url});
        }
    }

    public void releaseCacheByTrimMemory() {
        int size = this.mCachedDisplayers.size();
        if (size <= 0) {
            return;
        }
        WebDisplayController keep = null;
        if (!RuntimeContext.sHappenLowMemWarn) {
            keep = this.mCachedDisplayers.get(size - 1);
        }
        ArrayList<WebDisplayController> cachedDisplayersCopy = new ArrayList<WebDisplayController>(this.mCachedDisplayers.size());
        cachedDisplayersCopy.addAll(this.mCachedDisplayers);
        for (WebDisplayController item : cachedDisplayersCopy) {
            if (item == null || item == keep) continue;
            item.releaseCache();
        }
        this.mCachedDisplayers.clear();
        if (keep != null) {
            this.mCachedDisplayers.add(keep);
        }
        MLog.info((Object)TAG, (String)"releaseCacheByTrimMemory:%d, %d, %s", (Object[])new Object[]{size, this.mCachedDisplayers.size(), keep != null && keep.getWebEnvSettings() != null ? keep.getWebEnvSettings().url : ""});
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (this.mDisplayers == null || this.mDisplayers.size() < 1) {
            return;
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exited(WebDisplayController controller, boolean retruenRefresh, boolean retruenRefreshPazrt) {
        WebDisplayController topController = null;
        ArrayList<WebDisplayController> arrayList = this.mDisplayers;
        synchronized (arrayList) {
            this.mDisplayers.remove((Object)controller);
            if (this.mDisplayers.size() > 0) {
                topController = this.mDisplayers.get(this.mDisplayers.size() - 1);
            }
            this.mCachedDisplayers.remove((Object)controller);
            MLog.info((Object)TAG, (String)"on webView destory, current size:%d, %s", (Object[])new Object[]{this.mDisplayers.size(), controller.getWebEnvSettings() != null ? controller.getWebEnvSettings().originUrl : ""});
            MLog.info((Object)TAG, (String)"remove webView, current size:%d", (Object[])new Object[]{this.mCachedDisplayers.size()});
        }
        if (topController != null) {
            topController.handleRefresh(retruenRefresh, retruenRefreshPazrt);
        }
    }

    @Override
    public void cachedWhenWindowDettach(WebDisplayController controller) {
        if (this.mCachedDisplayers.contains((Object)controller)) {
            return;
        }
        this.mCachedDisplayers.add(controller);
        boolean shouldRemove = false;
        if (RuntimeContext.getPhoneType() == 3 && this.mCachedDisplayers.size() > 3) {
            shouldRemove = true;
        } else if (RuntimeContext.isPhoneSuperLow() && this.mCachedDisplayers.size() > 1) {
            shouldRemove = true;
        } else if (this.mCachedDisplayers.size() > 2) {
            shouldRemove = true;
        }
        if (shouldRemove) {
            WebDisplayController item = this.mCachedDisplayers.get(0);
            item.releaseCache();
            this.mCachedDisplayers.remove((Object)item);
        }
        MLog.info((Object)TAG, (String)"on webView cached, current size:%d, url:%s", (Object[])new Object[]{this.mCachedDisplayers.size(), controller.getWebEnvSettings().originUrl});
    }

    @Override
    public void onWebBusinessCreated(IWebBusinessHandler businessHandler) {
        if (this.mCallBack != null) {
            this.mCallBack.onWebBusinessCreated(businessHandler);
        }
    }

    @Override
    public void onWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
        if (this.mCallBack != null) {
            this.mCallBack.onWebBusinessDestroyed(businessHandler);
        }
    }

    @Override
    @Nullable
    public IWebIntentFilter getIntentFilter(String url) {
        return this.mCallBack != null ? this.mCallBack.getIntentFilter(url) : null;
    }

    @Override
    public void onWebShown(IWebBusinessHandler bussinessHandler, boolean webWindowFromCache) {
        MLog.info((Object)TAG, (String)"onWebShown webWindowFromCache:%d", (Object[])new Object[]{webWindowFromCache ? 1 : 0});
        if (this.mCallBack != null) {
            this.mCallBack.onWebShown(bussinessHandler, webWindowFromCache);
        }
    }

    @Override
    public void onWebHidden(IWebBusinessHandler bussinessHandler) {
        if (this.mCallBack != null) {
            this.mCallBack.onWebHidden(bussinessHandler);
        }
    }

    @Override
    public boolean nativeGetGameIsInstall(String gameId) {
        if (this.mCallBack != null) {
            return this.mCallBack.nativeGetGameIsInstall(gameId);
        }
        return false;
    }

    @Override
    public String appInfo() {
        if (this.mCallBack != null) {
            return this.mCallBack.appInfo();
        }
        return null;
    }

    @Override
    public String userToken() {
        if (this.mCallBack != null) {
            return this.mCallBack.userToken();
        }
        return null;
    }

    @Override
    public String myselfUserInfo() {
        if (this.mCallBack != null) {
            return this.mCallBack.myselfUserInfo();
        }
        return null;
    }

    @Override
    public void onPermissionRequested(String permission, IWebViewPermissionCallback callback) {
        if (this.mCallBack != null) {
            this.mCallBack.onPermissionRequested(permission, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllWindow() {
        ArrayList<WebDisplayController> arrayList = this.mDisplayers;
        synchronized (arrayList) {
            int i = 0;
            for (WebDisplayController displayController : this.mDisplayers) {
                if (this.mDisplayers.size() == 1 && i == 0) {
                    displayController.closeWindow(true);
                } else {
                    displayController.closeWindow(false);
                }
                ++i;
            }
            MLog.info((Object)TAG, (String)"on webView added, current size:%d", (Object[])new Object[]{this.mDisplayers.size()});
        }
    }
}

