/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.send.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.utils.FontUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ISendPacketListener;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ui.SendPacketAdapter;
import java.util.List;
import net.ihago.money.api.redpacket.SendGear;

public class SendPacketPanel
extends BasePanel {
    private ISendPacketListener mPacketListener;
    private RecyclerView mRecyclerView;
    private SendPacketAdapter mAdapter;

    public SendPacketPanel(Context context, ISendPacketListener listener) {
        super(context);
        this.mPacketListener = listener;
        this.setCanHideOutside(false);
        this.setCanKeyback(false);
        this.createView(context);
        this.setHideAnim((Animation)new AnimationSet(false));
    }

    private void createView(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_red_packet_send, (ViewGroup)this, false);
        this.setContent(view);
        TextView title = (TextView)view.findViewById(R.id.packet_title);
        title.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if ("ae".equalsIgnoreCase(AccountUtil.registerCountry()) || "id".equalsIgnoreCase(AccountUtil.registerCountry())) {
            title.setBackgroundResource(R.drawable.green_send_title_bg);
        } else {
            title.setBackgroundResource(R.drawable.packet_send_title_bg);
        }
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.diamond_list);
        GridLayoutManager manager = new GridLayoutManager(context, 3);
        manager.setOrientation(1);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.mAdapter = new SendPacketAdapter(this.mPacketListener);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        view.findViewById(R.id.packet_quest).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SendPacketPanel.this.mPacketListener != null) {
                    SendPacketPanel.this.mPacketListener.onQuestClick();
                }
            }
        });
        view.findViewById(R.id.packet_send).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendPacketPanel.this.hide(false);
                if (SendPacketPanel.this.mPacketListener != null) {
                    SendPacketPanel.this.mPacketListener.onClick();
                }
            }
        });
        view.findViewById(R.id.packet_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SendPacketPanel.this.hide(false);
                if (SendPacketPanel.this.mPacketListener != null) {
                    SendPacketPanel.this.mPacketListener.onClose();
                }
            }
        });
    }

    public void setGearList(List<SendGear> list) {
        if (this.mAdapter != null) {
            this.mAdapter.setData(list);
        }
    }
}

