/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.result.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.IRedPacketResultAdapterCallback;
import java.util.List;
import net.ihago.money.api.redpacket.WinnerInfo;

public class RedPackageResultAdapter
extends RecyclerView.Adapter<NormalHolder> {
    private IRedPacketResultAdapterCallback mCallback;
    Context mContext;
    List<WinnerInfo> mList;

    public RedPackageResultAdapter(Context context, List<WinnerInfo> list, IRedPacketResultAdapterCallback callback2) {
        this.mContext = context;
        this.mList = list;
        this.mCallback = callback2;
    }

    @NonNull
    public NormalHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new NormalHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_redpackagelist, parent, false));
    }

    public void onBindViewHolder(@NonNull NormalHolder holder, int position) {
        WinnerInfo bean = this.mList.get(position);
        if (bean == null) {
            return;
        }
        holder.nameTv.setText((CharSequence)bean.nick);
        holder.countTv.setText((CharSequence)String.valueOf(bean.diamonds));
        long tamp = bean.timestamp * 1000L;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"RedPacket", (String)" result  getTimestamp: %d, tamp: %d", (Object[])new Object[]{bean.timestamp, tamp});
        }
        tamp = tamp <= 0L ? System.currentTimeMillis() : tamp;
        String date = DateUtils.dateToString((long)tamp, (String)"MM-dd HH:mm:ss");
        holder.timeTv.setText((CharSequence)date);
        ImageLoader.loadImage((ImageView)holder.avatarIv.getCircleImageView(), (String)(bean.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)1));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public int getItemCount() {
        return this.mList.size();
    }

    protected class NormalHolder
    extends RecyclerView.ViewHolder {
        public View itemView;
        public YYTextView nameTv;
        public HeadFrameImageView avatarIv;
        public YYTextView timeTv;
        public YYTextView countTv;

        public NormalHolder(View itemView) {
            super(itemView);
            this.itemView = itemView;
            this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_nickname);
            this.avatarIv = (HeadFrameImageView)itemView.findViewById(R.id.img_avtor);
            this.timeTv = (YYTextView)itemView.findViewById(R.id.tv_time);
            this.countTv = (YYTextView)itemView.findViewById(R.id.tv_diamond_count);
        }
    }
}

