/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.result.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.redpacket.PacketUtils;
import com.yy.hiyo.wallet.redpacket.room.presenter.PacketResult;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.IRedPacketResultAdapterCallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.IRedPacketResultUICallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.RedPackageResultAdapter;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.RedPacketFailedHeadView;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.RedPacketSuccessHeadView;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.redpacket.PacketInfo;
import net.ihago.money.api.redpacket.WinnerInfo;

public class PacketResultPanel
extends BasePanel
implements View.OnClickListener,
IRedPacketResultAdapterCallback {
    private static final String TAG = "FTRedPacketResultPanel";
    public static final int STATE_FAIL_BY_ME = 10;
    public static final int STATE_FAIL_BY_OTHER = 11;
    public static final int STATE_SUCCESS = 0;
    View view;
    YYTextView countPersentTv;
    YYFrameLayout mHeadLayout;
    RedPacketFailedHeadView mRedPacketFailedHeadView;
    RedPacketSuccessHeadView mRedPacketSuccessHeadView;
    RecyclerView mRecyclerView;
    RecycleImageView closeIv;
    YYButton shareBtn;
    private RedPackageResultAdapter mAdapter;
    private List<WinnerInfo> mList = new ArrayList<WinnerInfo>();
    int status;
    private String roomId;
    IRedPacketResultUICallback iRedPacketResultUICallback;

    public PacketResultPanel(Context context, IRedPacketResultUICallback iRedPackageResultUICallback, String roomId) {
        super(context);
        this.createView(context);
        this.setCanHideOutside(false);
        this.iRedPacketResultUICallback = iRedPackageResultUICallback;
        this.roomId = roomId;
    }

    private void createView(Context context) {
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.layout_red_packet_result, (ViewGroup)this, false);
        this.mHeadLayout = (YYFrameLayout)this.view.findViewById(R.id.layout_head_continer);
        this.mRecyclerView = (RecyclerView)this.view.findViewById(R.id.result_list);
        this.closeIv = (RecycleImageView)this.view.findViewById(R.id.img_close);
        this.countPersentTv = (YYTextView)this.view.findViewById(R.id.red_package_count);
        this.shareBtn = (YYButton)this.view.findViewById(R.id.btn_share);
        this.shareBtn.setOnClickListener(this::onClick);
        this.closeIv.setOnClickListener((View.OnClickListener)this);
        this.setContent(this.view);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.mContext, 1);
        itemDecoration.setDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_redresultlist_divider));
        this.mAdapter = new RedPackageResultAdapter(this.mContext, this.mList, this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    public RedPacketFailedHeadView getFailHead() {
        if (this.mRedPacketFailedHeadView == null) {
            this.mRedPacketFailedHeadView = new RedPacketFailedHeadView(this.getContext());
        }
        return this.mRedPacketFailedHeadView;
    }

    public RedPacketSuccessHeadView getSuccessHead() {
        if (this.mRedPacketSuccessHeadView == null) {
            this.mRedPacketSuccessHeadView = new RedPacketSuccessHeadView(this.getContext());
        }
        return this.mRedPacketSuccessHeadView;
    }

    public void updateWinnerList(List<WinnerInfo> list) {
        if (list == null) {
            return;
        }
        this.mList.clear();
        this.mList.addAll(list);
        this.mAdapter.notifyDataSetChanged();
    }

    protected void onShown() {
        super.onShown();
        MLog.info((Object)TAG, (String)"result panel onShown", (Object[])new Object[0]);
    }

    protected void onHidden() {
        super.onHidden();
        MLog.info((Object)TAG, (String)"result panel onHidden", (Object[])new Object[0]);
    }

    public void seCount0fRedPackage(int hasGet, int total) {
    }

    public void updatePanelView(int status, PacketResult packetResult) {
        if (packetResult == null || packetResult.getPacketInfo() == null) {
            MLog.error((Object)TAG, (String)"updatePanelView packetResult is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"updatePanelView packetId: %s", (Object[])new Object[]{packetResult.getPacketId()});
        this.status = status;
        this.updateHeadViewBystatus(status, packetResult);
        this.updatePanelCommonView(packetResult.getPacketInfo());
        this.showDebugPacketId(packetResult.getPacketInfo());
    }

    private void showDebugPacketId(PacketInfo packetInfo) {
        TextView packetId;
        if (RuntimeContext.sIsDebuggable && packetInfo != null && this.view != null && (packetId = (TextView)this.view.findViewById(R.id.test_packet_id)) != null) {
            packetId.setVisibility(0);
            packetId.setText((CharSequence)packetInfo.id);
        }
    }

    private void updatePanelCommonView(PacketInfo packetInfo) {
        String amount = String.format(ResourceUtils.getString((int)R.string.persent_in_persent, (Object[])new Object[]{packetInfo.current, packetInfo.total}), new Object[0]);
        String total = ResourceUtils.getString((int)R.string.short_tips_total);
        String diamondNum = amount + "  " + total + " " + packetInfo.current_diamonds + "/" + packetInfo.diamonds;
        this.countPersentTv.setText((CharSequence)diamondNum);
    }

    public void updateLsitView(List<WinnerInfo> listData) {
    }

    private void updateHeadViewBystatus(int status, PacketResult packetResult) {
        if (status == 10 || status == 11) {
            this.updateFailView(status, packetResult.getPacketInfo());
        } else if (status == 0) {
            this.updateSuccessView(packetResult.getPacketInfo(), this.winDiamond(packetResult.getWinnerInfos(), AccountUtil.getUid()));
        }
    }

    private void updateFailView(int status, PacketInfo packetInfo) {
        this.mHeadLayout.removeAllViews();
        this.mHeadLayout.addView((View)this.getFailHead());
        this.shareBtn.setVisibility(8);
        if (status == 10) {
            this.getFailHead().setContent(ResourceUtils.getString((int)R.string.lucky_porket_has_been_issued));
        } else if (status == 11) {
            if (PacketUtils.isPacketExpired(packetInfo)) {
                this.getFailHead().setContent(ResourceUtils.getString((int)R.string.short_lucky_pocket));
                GiftHiidoReport.redPacketOver(this.roomId);
            } else {
                this.getFailHead().setContent(ResourceUtils.getString((int)R.string.lucky_pocket_is_finished));
                GiftHiidoReport.redPacketFail(this.roomId);
            }
        }
    }

    private void updateSuccessView(PacketInfo packetInfo, int winDiamond) {
        if (packetInfo == null) {
            MLog.error((Object)TAG, (String)"updateSuccessView packetInfo == null", (Object[])new Object[0]);
            return;
        }
        this.shareBtn.setVisibility(0);
        this.mHeadLayout.removeAllViews();
        this.mHeadLayout.addView((View)this.getSuccessHead());
        if (this.status == 0) {
            String name = ShortNameUtils.getShortNameWithoutColon((String)packetInfo.sender_nick, (int)8);
            this.getSuccessHead().setTitle(String.format(ResourceUtils.getString((int)R.string.lucky_pocket_result_title), name));
            this.getSuccessHead().updateAvator(packetInfo.sender_avatar);
            this.getSuccessHead().updatCount(winDiamond);
            GiftHiidoReport.redPacketSuccess(winDiamond, this.roomId);
        }
    }

    private int winDiamond(List<WinnerInfo> winnerInfos, long uid) {
        if (FP.empty(winnerInfos)) {
            return 0;
        }
        for (WinnerInfo info : winnerInfos) {
            if (info.uid != uid) continue;
            return info.diamonds;
        }
        return 0;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.img_close) {
            this.hide(false);
        } else if (v.getId() == R.id.btn_share && this.iRedPacketResultUICallback != null) {
            this.iRedPacketResultUICallback.onBtnShareClick();
            GiftHiidoReport.redPacketSuccessShare(this.roomId);
        }
    }
}

