/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.foreshow;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.foreshow.ui.ForeShowView;
import net.ihago.money.api.redpacket.PacketInfo;
import net.ihago.money.api.redpacket.RainNotify;

public class ForeshowPresenter
implements IPacketPresenter,
ForeShowView.ICountdownFinishCallback {
    private static final String TAG = "FTRedPacketForeshowPresenter";
    ForeShowView foreshowView;
    private RainNotify mNotify;
    private ICountdownFinishCallback iCountdownFinishCallback;
    private boolean isResume = false;
    private long overtime = 0L;
    private Runnable mOvertimeTask = new Runnable(){

        @Override
        public void run() {
            if (ForeshowPresenter.this.mNotify != null && ForeshowPresenter.this.iCountdownFinishCallback != null) {
                MLog.info((Object)ForeshowPresenter.TAG, (String)"over time packetId: %s", (Object[])new Object[]{((ForeshowPresenter)ForeshowPresenter.this).mNotify.packet_info.id});
                ForeshowPresenter.this.iCountdownFinishCallback.onOvertime(((ForeshowPresenter)ForeshowPresenter.this).mNotify.packet_info);
                ForeshowPresenter.this.mNotify = null;
                ForeshowPresenter.this.overtime = 0L;
            }
        }
    };

    @Override
    public void onCreate(RedPacketParam createParam) {
    }

    @Override
    public void onStart(ViewGroup parent) {
        this.isResume = true;
        this.initView(parent);
        MLog.info((Object)TAG, (String)"onStart packetId: %s, overtime: %d, current: %d", (Object[])new Object[]{this.mNotify == null ? "" : this.mNotify.packet_info.id, this.overtime, System.currentTimeMillis()});
        if (this.mNotify != null && this.overtime > System.currentTimeMillis()) {
            this.tryShowFore(this.mNotify);
        }
    }

    @Override
    public void onPause() {
        this.isResume = false;
    }

    @Override
    public void onDestroy() {
        YYTaskExecutor.removeTask((Runnable)this.mOvertimeTask);
        this.iCountdownFinishCallback = null;
        if (this.foreshowView != null) {
            if (this.foreshowView.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.foreshowView.getParent()).removeView((View)this.foreshowView);
            }
            this.foreshowView.destroy();
            this.foreshowView = null;
        }
    }

    @Override
    public void onReceiveBro(Object notify) {
        if (notify instanceof RainNotify) {
            this.mNotify = (RainNotify)notify;
            if (this.isResume) {
                MLog.info((Object)TAG, (String)"onReceiveBro mNotify resume packetId: %s, overtime: %d", (Object[])new Object[]{this.mNotify.packet_info.id, this.overtime});
                this.tryShowFore(this.mNotify);
            } else {
                long remain = this.mNotify.rain_second.intValue();
                YYTaskExecutor.postToMainThread((Runnable)this.mOvertimeTask, (long)(remain * 1000L));
                this.overtime = System.currentTimeMillis() + remain * 1000L;
                MLog.info((Object)TAG, (String)"onReceiveBro mNotify un resume packetId: %s, overtime: %d, remainTime: %d", (Object[])new Object[]{this.mNotify.packet_info.id, this.overtime, remain});
            }
        }
    }

    void initView(ViewGroup parent) {
        if (this.foreshowView == null) {
            this.foreshowView = new ForeShowView(parent.getContext());
        }
        if (this.foreshowView.getParent() != null) {
            ((ViewGroup)this.foreshowView.getParent()).removeView((View)this.foreshowView);
        }
        this.foreshowView.setCountdownFinishCallback(this::onCountDownFinish);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(14);
        parent.addView((View)this.foreshowView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void tryShowFore(RainNotify notify) {
        YYTaskExecutor.removeTask((Runnable)this.mOvertimeTask);
        if (notify == null || notify.packet_info == null) {
            return;
        }
        this.doShowFore(notify);
    }

    public void doShowFore(RainNotify notify) {
        if (notify == null || notify.packet_info == null) {
            return;
        }
        this.foreshowView.showView();
        this.foreshowView.updateUserHeadInfo(notify.packet_info.sender_avatar, notify.packet_info.sender_nick);
    }

    public void setCountdownFinishCallback(ICountdownFinishCallback iCountdownFinishCallback) {
        this.iCountdownFinishCallback = iCountdownFinishCallback;
    }

    @Override
    public void onCountDownFinish() {
        if (this.iCountdownFinishCallback != null) {
            this.iCountdownFinishCallback.onCountdownFinish(this.mNotify);
        }
        this.mNotify = null;
        this.overtime = 0L;
    }

    public static interface ICountdownFinishCallback {
        public void onCountdownFinish(RainNotify var1);

        public void onOvertime(PacketInfo var1);
    }
}

