/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.prop.monitor;

import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.gift.data.bean.ReceiverUserInfo;
import com.yy.hiyo.wallet.gift.data.param.SendGiftArgv;
import com.yy.hiyo.wallet.monitor.RequestTask;
import com.yy.hiyo.wallet.monitor.RequestTaskCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.prop.monitor.PropHandlerMonitor;
import com.yy.hiyo.wallet.prop.proto.param.BuyPropParam;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BuyPropRequestMonitor {
    public static final int SUCCESS = 1;
    public static final int FAIL = 2;
    public static final int TIMEOUT = 3;
    private final Map<String, RequestTask> mRequestList = new ConcurrentHashMap<String, RequestTask>();

    public void request(String seq, int cmd, int type, BuyPropParam param) {
        RequestTask task = new RequestTask(seq, cmd, new RequestTaskCallback(){

            @Override
            public void onTimeout(RequestTask task) {
                BuyPropRequestMonitor.this.timeout(task.seqId);
            }

            @Override
            public void onRelease(RequestTask task) {
                BuyPropRequestMonitor.this.mRequestList.remove(task.seqId);
            }
        });
        task.putExtend("type", type);
        task.putExtend("propInfo", this.propInfo(param));
        task.putExtend("userInfo", this.userInfo(param));
        task.putExtend("chargeInfo", this.chargeInfo(param));
        this.mRequestList.put(seq, task);
    }

    public void success(String seq) {
        RequestTask task = this.mRequestList.remove(seq);
        if (task == null) {
            return;
        }
        BuyPropRequestMonitor.reportReqResultMetri(task.cmd, task.duration(), 1);
        this.report(task, 1, "success", 1);
    }

    public void fail(String seq, int code, String reason) {
        RequestTask task = this.mRequestList.remove(seq);
        if (task == null) {
            return;
        }
        BuyPropRequestMonitor.reportReqResultMetri(task.cmd, task.duration(), code);
        this.report(task, 2, reason, code);
    }

    public void reportMetr(String seq, String code) {
        RequestTask task = this.mRequestList.get(seq);
        if (task == null) {
            return;
        }
        StringBuilder builder = new StringBuilder("revenue/cmd/");
        if (PayUtils.isHuaweiPayChannel()) {
            builder.append("huawei/");
        }
        builder.append(task.cmd);
        HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)task.duration(), (String)code);
    }

    public static void reportReqResultMetri(int cmd, long duration, int code) {
        if (code == 1) {
            code = 0;
        }
        StringBuilder builder = new StringBuilder("revenue/result/cmd/");
        if (PayUtils.isHuaweiPayChannel()) {
            builder.append("huawei/");
        }
        builder.append(cmd);
        HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)duration, (String)("" + code));
    }

    public void timeout(String seq) {
        RequestTask task = this.mRequestList.remove(seq);
        if (task == null) {
            return;
        }
        this.report(task, 3, "timeout", -1);
    }

    private String propInfo(BuyPropParam param) {
        if (param == null) {
            return "";
        }
        String info = "" + param.getUsedChannel();
        SendGiftArgv gift = param.getGift();
        if (gift != null) {
            info = info + "_" + gift.getPropsId() + "_" + gift.getCount();
        }
        return info;
    }

    private String userInfo(BuyPropParam param) {
        if (param == null || param.getGift() == null) {
            return "";
        }
        SendGiftArgv gift = param.getGift();
        StringBuilder receiverUids = new StringBuilder();
        if (gift != null && gift.getReceiverUserInfos() != null) {
            for (ReceiverUserInfo receiverUserInfo : gift.getReceiverUserInfos()) {
                receiverUids.append(receiverUserInfo.getUid() + "_");
            }
        }
        return receiverUids.toString() + gift.getRoomId() + "_" + gift.getAnchorUid();
    }

    private String chargeInfo(BuyPropParam param) {
        if (param == null || param.getRecharge() == null) {
            return "";
        }
        String info = "";
        RechargeParam charge = param.getRecharge();
        if (charge != null) {
            info = charge.getFrom() + "_" + charge.getProductId();
        }
        if (param.getGift() != null) {
            info = info + "_" + param.getGift().isUseDiamond();
        }
        return info;
    }

    private void report(RequestTask task, int result, String reason, int code) {
        if (task == null) {
            return;
        }
        StatisContent content = PropHandlerMonitor.createContent();
        content.put("ifield", task.cmd);
        content.put("ifieldtwo", task.getInt("type"));
        content.put("ifieldthree", task.duration());
        content.put("ifieldfour", result);
        content.put("ifieldfive", code);
        content.put("sfield", "request");
        content.put("sfieldtwo", reason);
        content.put("sfieldthree", task.getString("propInfo"));
        content.put("sfieldfour", task.getString("userInfo"));
        content.put("sfieldfive", task.getString("chargeInfo"));
        HiidoStatis.reportContent((StatisContent)content);
    }
}

