/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.sku;

import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemUtils;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.ProductType;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.sku.SkuDetailManager;
import com.yy.hiyo.wallet.pay.sku.strategy.AdvanceStrategy;
import com.yy.hiyo.wallet.pay.sku.strategy.ISkuStrategy;
import com.yy.hiyo.wallet.pay.sku.strategy.IStrategyListener;
import com.yy.hiyo.wallet.pay.sku.strategy.InTimeStrategy;
import com.yy.hiyo.wallet.pay.sku.strategy.PersistStrategy;
import com.yy.socialplatformbase.platform.google.billing.IGooglePay;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0010H\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010'\u001a\u00020(H\u0016J\u001c\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0-J\u001c\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001d0&J\u0018\u00102\u001a\u00020#2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u00103\u001a\u00020#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\b\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\b\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/yy/hiyo/wallet/pay/sku/SkuDetailManager;", "Lcom/yy/hiyo/wallet/pay/sku/strategy/IStrategyListener;", "()V", "hadInit", "", "isOpen", "()Z", "isOpen$delegate", "Lkotlin/Lazy;", "pay", "Lcom/yy/hiyo/wallet/base/IPlatformPay;", "kotlin.jvm.PlatformType", "getPay", "()Lcom/yy/hiyo/wallet/base/IPlatformPay;", "pay$delegate", "queryStrategy", "", "getQueryStrategy", "()I", "queryStrategy$delegate", "reportStrategy", "getReportStrategy", "reportStrategy$delegate", "strategyMap", "", "Lcom/yy/hiyo/wallet/pay/sku/strategy/ISkuStrategy;", "getSkuDetails", "Lcom/yy/billing/base/SkuDetailsInfo;", "productId", "", "isBillingV2", "isStrategyValid", "id", "landAndCountry", "onQuerySuccess", "", "strategyId", "list", "", "duration", "", "queryDetail", "info", "Lcom/yy/hiyo/wallet/base/pay/bean/RechargeParam;", "callback", "Lcom/yy/hiyo/wallet/base/pay/callback/IPayCallback;", "queryDetails", "type", "Lcom/yy/hiyo/wallet/base/ProductType;", "skus", "report", "startup", "Companion", "wallet_billDebug"})
public final class SkuDetailManager
implements IStrategyListener {
    private volatile boolean hadInit;
    private final Lazy pay$delegate = LazyKt.lazy((Function0)pay.2.INSTANCE);
    private final Map<Integer, ISkuStrategy> strategyMap;
    private final Lazy isOpen$delegate;
    private final Lazy queryStrategy$delegate;
    private final Lazy reportStrategy$delegate;
    private static final String TAG = "FTPaySkuDetail";
    public static final Companion Companion = new Companion(null);

    private final IPlatformPay getPay() {
        Lazy lazy = this.pay$delegate;
        SkuDetailManager skuDetailManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IPlatformPay)lazy.getValue();
    }

    private final boolean isOpen() {
        Lazy lazy = this.isOpen$delegate;
        SkuDetailManager skuDetailManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    private final int getQueryStrategy() {
        Lazy lazy = this.queryStrategy$delegate;
        SkuDetailManager skuDetailManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int getReportStrategy() {
        Lazy lazy = this.reportStrategy$delegate;
        SkuDetailManager skuDetailManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    public final void startup() {
        if (this.hadInit) {
            return;
        }
        MLog.info((Object)TAG, (String)"startup isOpen: %b, queryStrategy: 0b%s, reportStrategy: 0b%s", (Object[])new Object[]{this.isOpen(), Integer.toBinaryString(this.getQueryStrategy()), Integer.toBinaryString(this.getReportStrategy())});
        if (this.isStrategyValid(1)) {
            this.strategyMap.put(1, new InTimeStrategy(1, this));
        }
        if (this.isStrategyValid(2)) {
            this.strategyMap.put(2, new AdvanceStrategy(2, this));
        }
        if (this.isStrategyValid(4)) {
            this.strategyMap.put(4, new PersistStrategy(4, this));
        }
        this.hadInit = true;
    }

    public final void queryDetails(@NotNull ProductType type, @NotNull List<String> skus) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(skus, (String)"skus");
            this.startup();
            ISkuStrategy iSkuStrategy = this.strategyMap.get(2);
            if (iSkuStrategy == null) break block0;
            IPlatformPay iPlatformPay = this.getPay();
            Intrinsics.checkExpressionValueIsNotNull((Object)iPlatformPay, (String)"pay");
            iSkuStrategy.queryDetail(iPlatformPay, type, skus);
        }
    }

    public final void queryDetail(@NotNull RechargeParam info, @NotNull IPayCallback<SkuDetailsInfo> callback2) {
        ISkuStrategy it;
        boolean bl;
        boolean bl2;
        ISkuStrategy iSkuStrategy;
        int id2;
        boolean $i$f$forEach;
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        this.startup();
        ProductType type = PayUtils.getProductType(info.getProductType());
        String sku = info.getProductId();
        boolean bl3 = false;
        List list = new ArrayList();
        list.add(1);
        list.add(2);
        list.add(4);
        if (!info.isCurrencyCodeEnable() && !this.isBillingV2()) {
            PayUtils.callbackFailed(callback2, 60003, "\u5145\u503c\u5217\u8868\u67e5\u8be2\u5f00\u5173\u4e3a\u5173\u95ed\uff0c\u5373\u4e0d\u9700\u8981\u67e5\u8be2");
        } else {
            Iterable $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                id2 = ((Number)element$iv).intValue();
                boolean bl4 = false;
                ISkuStrategy iSkuStrategy2 = this.strategyMap.get(id2);
                if (iSkuStrategy2 == null) continue;
                iSkuStrategy = iSkuStrategy2;
                bl2 = false;
                bl = false;
                it = iSkuStrategy;
                boolean bl5 = false;
                iSkuStrategy2 = it.isValid(this.getQueryStrategy()) ? iSkuStrategy : null;
                if (iSkuStrategy2 == null) continue;
                iSkuStrategy = iSkuStrategy2;
                bl2 = false;
                bl = false;
                it = iSkuStrategy;
                boolean bl6 = false;
                IPlatformPay iPlatformPay = this.getPay();
                Intrinsics.checkExpressionValueIsNotNull((Object)iPlatformPay, (String)"pay");
                String string2 = sku;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sku");
                it.queryDetails(iPlatformPay, type, string2, callback2);
                return;
            }
            PayUtils.callbackFailed(callback2, 60003, "boss\u67e5\u8be2\u5f00\u5173\u4e3a\u5173\u95ed\uff0c\u5373\u4e0d\u9700\u8981\u67e5\u8be2");
        }
        if (this.getReportStrategy() > 0) {
            Iterable $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                id2 = ((Number)element$iv).intValue();
                boolean bl7 = false;
                ISkuStrategy iSkuStrategy3 = this.strategyMap.get(id2);
                if (iSkuStrategy3 == null) continue;
                iSkuStrategy = iSkuStrategy3;
                bl2 = false;
                bl = false;
                it = iSkuStrategy;
                boolean bl8 = false;
                iSkuStrategy3 = it.isValid(this.getReportStrategy()) ? iSkuStrategy : null;
                if (iSkuStrategy3 == null) continue;
                iSkuStrategy = iSkuStrategy3;
                bl2 = false;
                bl = false;
                it = iSkuStrategy;
                boolean bl9 = false;
                IPlatformPay iPlatformPay = this.getPay();
                Intrinsics.checkExpressionValueIsNotNull((Object)iPlatformPay, (String)"pay");
                String string3 = sku;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sku");
                it.queryDetails(iPlatformPay, type, string3, null);
                return;
            }
        }
    }

    @Nullable
    public final SkuDetailsInfo getSkuDetails(@NotNull String productId) {
        SkuDetailsInfo detail;
        Intrinsics.checkParameterIsNotNull((Object)productId, (String)"productId");
        this.startup();
        ISkuStrategy iSkuStrategy = this.strategyMap.get(1);
        Object object = detail = iSkuStrategy != null ? iSkuStrategy.getDetail(productId) : null;
        if (detail == null) {
            ISkuStrategy iSkuStrategy2 = this.strategyMap.get(2);
            Object object2 = detail = iSkuStrategy2 != null ? iSkuStrategy2.getDetail(productId) : null;
        }
        if (detail == null) {
            ISkuStrategy iSkuStrategy3 = this.strategyMap.get(4);
            detail = iSkuStrategy3 != null ? iSkuStrategy3.getDetail(productId) : null;
        }
        return detail;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onQuerySuccess(int strategyId, @NotNull List<SkuDetailsInfo> list, long duration) {
        void $this$filterTo$iv$iv;
        Object object;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        ISkuStrategy iSkuStrategy = this.strategyMap.get(strategyId);
        if (iSkuStrategy != null) {
            iSkuStrategy.updateDetails(list);
        }
        if ((strategyId & this.getReportStrategy()) == strategyId) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                SkuDetailsInfo it = (SkuDetailsInfo)element$iv;
                boolean bl = false;
                this.report(it, duration);
            }
        }
        Map<Integer, ISkuStrategy> $this$filter$iv = this.strategyMap;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void bl = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = bl.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl3 = false;
            if (!(((Number)it.getKey()).intValue() != strategyId)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$forEach$iv = destination$iv$iv;
        $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl5 = false;
            ((ISkuStrategy)it.getValue()).updateDetails(list);
        }
    }

    private final boolean isStrategyValid(int id2) {
        return (id2 & this.getReportStrategy()) == id2 || (id2 & this.getQueryStrategy()) == id2;
    }

    private final void report(SkuDetailsInfo info, long duration) {
        ISkuStrategy iSkuStrategy;
        ISkuStrategy iSkuStrategy2;
        Object it;
        String sku = info.getProductId();
        Object object = new StatisContent();
        boolean bl = false;
        boolean bl2 = false;
        StatisContent $this$apply = object;
        boolean bl3 = false;
        $this$apply.put("act", "hagoperf");
        $this$apply.put("perftype", "pay");
        StatisContent content = object;
        ISkuStrategy iSkuStrategy3 = this.strategyMap.get(1);
        if (iSkuStrategy3 != null && (iSkuStrategy3 = iSkuStrategy3.getOldDetail(sku)) != null) {
            object = iSkuStrategy3;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            content.put("sfield", it.getPriceCurrencyCode());
            content.put("ifield", (int)(it.getTimestamp() / (long)1000));
        }
        if ((iSkuStrategy2 = this.strategyMap.get(2)) != null && (iSkuStrategy2 = iSkuStrategy2.getOldDetail(sku)) != null) {
            object = iSkuStrategy2;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl5 = false;
            content.put("sfieldtwo", it.getPriceCurrencyCode());
            content.put("ifieldtwo", (int)(it.getTimestamp() / (long)1000));
        }
        if ((iSkuStrategy = this.strategyMap.get(4)) != null && (iSkuStrategy = iSkuStrategy.getOldDetail(sku)) != null) {
            object = iSkuStrategy;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl6 = false;
            content.put("sfieldthree", it.getPriceCurrencyCode());
            content.put("ifieldthree", (int)(it.getTimestamp() / (long)1000));
        }
        content.put("sfieldfour", sku);
        content.put("ifieldfour", (int)duration);
        content.put("sfieldfive", "bizhong-" + this.landAndCountry());
        HiidoStatis.reportContent((StatisContent)content);
    }

    private final String landAndCountry() {
        StringBuilder stringBuilder = new StringBuilder();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        return stringBuilder.append(locale.getCountry()).append("_").append(SystemUtils.getLang()).toString();
    }

    private final boolean isBillingV2() {
        return PayUtils.getBillingVersion() == IGooglePay.VERSION.V2_0_3;
    }

    public SkuDetailManager() {
        Map map;
        SkuDetailManager skuDetailManager = this;
        boolean bl = false;
        skuDetailManager.strategyMap = map = (Map)new LinkedHashMap();
        this.isOpen$delegate = LazyKt.lazy((Function0)isOpen.2.INSTANCE);
        this.queryStrategy$delegate = LazyKt.lazy((Function0)queryStrategy.2.INSTANCE);
        this.reportStrategy$delegate = LazyKt.lazy((Function0)reportStrategy.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/wallet/pay/sku/SkuDetailManager$Companion;", "", "()V", "TAG", "", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

