/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.handler;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.RechargeDbBean;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.RechargeRiskTipsConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.billing.base.PurchaseInfo;
import com.yy.billing.base.RechargeResult;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyUri;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.IPlatformRechargeCallback;
import com.yy.hiyo.wallet.base.pay.PayPlatform;
import com.yy.hiyo.wallet.base.pay.bean.BalanceResponse;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.pay.callback.SimpleRechargeCallback;
import com.yy.hiyo.wallet.base.revenue.internal.IPayHandler;
import com.yy.hiyo.wallet.base.revenue.internal.IRechargeService;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.pay.IRechargeRistkCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.RechargeRiskDialog;
import com.yy.hiyo.wallet.pay.RiskChallengeWrapper;
import com.yy.hiyo.wallet.pay.handler.IHandlerCallback;
import com.yy.hiyo.wallet.pay.handler.RechargeRetryHandler;
import com.yy.hiyo.wallet.pay.monitor.PayHandlerMonitor;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.hiyo.wallet.pay.proto.bean.OrderResult;
import com.yy.hiyo.wallet.pay.proto.bean.ReportRechargeResult;
import com.yy.hiyo.wallet.pay.question.QuestionPresent;
import com.yy.hiyo.wallet.pay.request.ReportPayResult;
import com.yy.hiyo.wallet.pay.request.RequestOrder;
import com.yy.hiyo.wallet.pay.sku.SkuDetailManager;
import com.yy.hiyo.wallet.recharge.internal.common.GpFailIMViewModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RechargeHandler
implements IRechargeHandler,
IPayHandler,
IThirdNotify<RechargeInfo> {
    private static final String TAG = "FTPayRechargeHandler";
    private static final long NOTIFY_TIME_OUT = 20000L;
    private RequestOrder mRequestOrder;
    private ReportPayResult mReportPayResult;
    private IPlatformPay mPay;
    private PayPlatform mPlatform;
    private String mPayPayload;
    private IHandlerCallback mHandlerCallback;
    private RechargeFinishListener mFinishListener;
    private RechargeRetryHandler mRetryHandler;
    private QuestionPresent mQuestionPresenter;
    private long mLastBalance = 0L;
    @Nullable
    private SkuDetailManager mSkuDetailManager;
    private final PayHandlerMonitor mPayHandlerMonitor = new PayHandlerMonitor();
    private RequestBalanceTask mRequestBalanceTask;
    private String mProductId;
    private IRechargeService rechargeService;
    private String mPayType = "gp";

    public RechargeHandler(IRechargeService rechargeService, @NonNull PayPlatform platform, SkuDetailManager skuDetailManager, IHandlerCallback handlerCallback) {
        this.rechargeService = rechargeService;
        this.mPlatform = platform;
        this.mPay = ((IPayService)ServiceManagerProxy.getService(IPayService.class)).getPay(platform);
        this.mPayType = this.mPay.getPayType();
        this.mHandlerCallback = handlerCallback;
        this.mSkuDetailManager = skuDetailManager;
        ProtoManager.getInstance().registerThirdNotify(RechargeInfo.class, (IThirdNotify)this);
    }

    public ThirdNotifyUri.Uri uri() {
        return ThirdNotifyUri.RECHARGE_SUCCESS;
    }

    public void onNotify(@NonNull RechargeInfo notify) {
        MLog.info((Object)TAG, (String)"recharge success notify: %s", (Object[])new Object[]{notify});
        this.notifySuccess(notify);
    }

    public void rechargeWithOrder(final @NonNull Activity activity, final @NonNull RechargeParam info, final IRechargeCallback callback2) {
        if (GuestLoginUtils.checkAndShowGuide((int)10)) {
            PayUtils.callbackFailed(callback2, 10015, "guest can not recharge");
            return;
        }
        if (this.mPay == null) {
            String msg = "can not found pay with platform ";
            MLog.error((Object)TAG, (String)"rechargeWithOrder msg: %s", (Object[])new Object[]{msg});
            PayUtils.callbackFailed(callback2, 10005, msg);
            this.onFinish();
        } else {
            this.mSkuDetailManager.queryDetail(info, new IPayCallback<SkuDetailsInfo>(){

                public void onSucceed(@Nullable SkuDetailsInfo data) {
                    MLog.info((Object)RechargeHandler.TAG, (String)"querySkuDetails data.size: %s", (Object[])new Object[]{data});
                    String code = data == null ? "" : data.getPriceCurrencyCode();
                    RechargeHandler.this.requestOrder(RechargeHandler.this.mPlatform, activity, info, code, (IRechargeCallback)(callback2 == null ? new SimpleRechargeCallback() : callback2), RechargeHandler.this.mPay);
                }

                public void onFailed(int code, String msg) {
                    MLog.error((Object)RechargeHandler.TAG, (String)"querySkuDetails code: %d, msg: %s", (Object[])new Object[]{code, msg});
                    RechargeHandler.this.requestOrder(RechargeHandler.this.mPlatform, activity, info, "", (IRechargeCallback)(callback2 == null ? new SimpleRechargeCallback() : callback2), RechargeHandler.this.mPay);
                }
            });
        }
    }

    public void rechargeDirect(final String orderId, final String payload, final @NonNull Activity activity, final @NonNull RechargeParam info, final IRechargeCallback callback2) {
        if (GuestLoginUtils.checkAndShowGuide((int)10)) {
            PayUtils.callbackFailed(callback2, 10015, "guest can not recharge");
            return;
        }
        if (this.mPay == null) {
            String msg = "can not found pay with platform ";
            MLog.error((Object)TAG, (String)"recharge msg: %s", (Object[])new Object[]{msg});
            PayUtils.callbackFailed(callback2, 10005, msg);
            this.onFinish();
        } else {
            this.mSkuDetailManager.queryDetail(info, new IPayCallback<SkuDetailsInfo>(){

                public void onSucceed(@Nullable SkuDetailsInfo data) {
                    MLog.info((Object)RechargeHandler.TAG, (String)"querySkuDetails data.size: %s", (Object[])new Object[]{data});
                    String code = data == null ? "" : data.getPriceCurrencyCode();
                    RechargeHandler.this.rechargeReal(orderId, payload, RechargeHandler.this.mPay, activity, info, callback2);
                }

                public void onFailed(int code, String msg) {
                    MLog.error((Object)RechargeHandler.TAG, (String)"querySkuDetails code: %d, msg: %s", (Object[])new Object[]{code, msg});
                    RechargeHandler.this.rechargeReal(orderId, payload, RechargeHandler.this.mPay, activity, info, callback2);
                }
            });
        }
    }

    public void cancelRecharge() {
        MLog.info((Object)TAG, (String)"cancelRecharge", (Object[])new Object[0]);
        if (this.mPay != null) {
            this.mPay.cancelRecharge(this.mPayPayload);
        }
        this.mPayHandlerMonitor.stopMonitor();
        this.onFinish();
    }

    public void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        this.removeRequestBalanceTask();
        if (this.mFinishListener != null) {
            this.mFinishListener.release();
            this.mFinishListener = null;
        }
        if (this.mRequestOrder != null) {
            this.mRequestOrder.cancel();
            this.mRequestOrder = null;
        }
        if (this.mReportPayResult != null) {
            this.mReportPayResult.cancel();
            this.mReportPayResult = null;
        }
        if (this.mRetryHandler != null) {
            this.mRetryHandler.destroy();
            this.mRetryHandler = null;
        }
        this.finishQuestionPresent();
        ProtoManager.getInstance().unregisterThirdNotify((IThirdNotify)this);
    }

    private void notifySuccess(RechargeInfo info) {
        if (this.mFinishListener != null && this.mFinishListener.orderId.equals(info.getOrderId())) {
            this.mPayHandlerMonitor.monitorNotify(this.mFinishListener.productId, info, this.mFinishListener.duration());
            this.mFinishListener.release();
            PayUtils.callbackSucceed(this.mFinishListener.callback, info);
            this.mFinishListener = null;
            this.onFinish();
            this.removeRequestBalanceTask();
        }
        String toast = ResourceUtils.getString((int)R.string.short_tips_recharge_success);
        if (info.getCurrencyAmount() > 0L) {
            toast = ResourceUtils.getString((int)R.string.short_tips_recharge_success_with_amount, (Object[])new Object[]{String.valueOf(info.getCurrencyAmount())});
        }
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)toast, (int)1);
        Map<String, Long> extend = Collections.singletonMap("diamond", info.getCurrencyAmount());
        PayUtils.updateDbState(info.getOrderId(), 2, extend, null);
    }

    private void requestOrder(final @NonNull PayPlatform platform, final @NonNull Activity activity, final @NonNull RechargeParam info, final String gpCurCode, final @NonNull IRechargeCallback callback2, final IPlatformPay pay2) {
        final String seq = RevenueProto.uniqueSeq();
        this.mPayHandlerMonitor.monitorRequest(info.getFrom(), seq, 1022, info.getProductId(), String.valueOf(info.getUnitPrice()), String.valueOf(platform));
        this.mRequestOrder = new RequestOrder((IRechargeService<OrderResult>)this.rechargeService, platform, info, seq, gpCurCode, this.mPayHandlerMonitor, new IPayCallback<OrderResult>(){

            public void onSucceed(@Nullable OrderResult data) {
                if (data == null) {
                    String msg = "request order happen some error!";
                    MLog.error((Object)RechargeHandler.TAG, (String)"recharge requestOrder onSucceed msg: %s", (Object[])new Object[]{msg});
                    RechargeHandler.this.mPayHandlerMonitor.monitorRequestFailed(seq, 41001, msg);
                    PayUtils.callbackFailed(callback2, 41001, msg);
                    RechargeHandler.this.onFinish();
                } else {
                    RechargeHandler.this.mPayHandlerMonitor.monitorResponse(data.response.seq, data.result, data.response.result, info.getProductId(), String.valueOf(info.getUnitPrice()), data.getOrderId());
                    PayUtils.sendOrderToIm(data.getOrderId(), "", info, 1);
                    MLog.info((Object)RechargeHandler.TAG, (String)"recharge requestOrder onSucceed payload = %s", (Object[])new Object[]{data.getPayload()});
                    RechargeHandler.this.rechargeReal(data.getOrderId(), data.getPayload(), data.getRevenueOrderId(), pay2, activity, info, callback2);
                }
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)RechargeHandler.TAG, (String)"requestOrder onFailed code: %s, msg: %s", (Object[])new Object[]{code, msg});
                RechargeHandler.this.mPayHandlerMonitor.monitorRequestFailed(seq, code, msg);
                if (code == 40929) {
                    RechargeHandler.this.riskChallenge(msg, platform, activity, info, gpCurCode, callback2, pay2, code);
                } else {
                    PayUtils.callbackFailed(callback2, code, msg);
                    RechargeHandler.this.onFinish();
                    RechargeHandler.this.handleFailedCode(code, activity);
                }
            }
        });
    }

    private void riskChallenge(final String msg, final @NonNull PayPlatform platform, final @NonNull Activity activity, final @NonNull RechargeParam info, final String gpCurCode, final @NonNull IRechargeCallback callback2, final IPlatformPay pay2, final int orderCode) {
        final long cur = System.currentTimeMillis();
        RiskChallengeWrapper.INSTANCE.challenge(msg, new RiskChallengeWrapper.IRiskCallback(){

            @Override
            public void onResult(@Nullable String result, int code) {
                MLog.info((Object)RechargeHandler.TAG, (String)"riskChallenge code: %d, result: %s", (Object[])new Object[]{code, result});
                PayMonitor.reportRiskChallenge(code, System.currentTimeMillis() - cur);
                if (code == 0) {
                    RechargeHandler.this.requestOrder(platform, activity, info, gpCurCode, callback2, pay2);
                } else {
                    PayUtils.callbackFailed(callback2, orderCode, msg);
                    RechargeHandler.this.onFinish();
                    RiskChallengeWrapper.INSTANCE.challengeErrorTips(code);
                }
            }
        });
    }

    private void handleFailedCode(int code, Activity activity) {
        if (40982 == code) {
            return;
        }
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.RECHARGE_RISK_TIPS);
        if (config instanceof RechargeRiskTipsConfig) {
            String text = ((RechargeRiskTipsConfig)config).getText(code);
            String warning = ((RechargeRiskTipsConfig)config).getWarning(code);
            if (!TextUtils.isEmpty((CharSequence)text) && !TextUtils.isEmpty((CharSequence)warning)) {
                RechargeRiskDialog dialog2 = new RechargeRiskDialog((Context)activity, text, warning, new IRechargeRistkCallback(){

                    @Override
                    public void onFeedbackClick() {
                        MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.HIDE_RECHARGE_DIALOG);
                        RechargeHandler.this.openFeedback();
                    }
                });
                dialog2.show();
            }
        }
    }

    private void openFeedback() {
        Message msg = Message.obtain();
        msg.what = MixBaseMsgDef.SHOW_FEEDBACK_WRAP_WINDOW;
        msg.arg1 = 7;
        msg.arg2 = 8;
        Bundle bundle = new Bundle();
        bundle.putString("feedback_content", "");
        msg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    private void addRechargeToDb(String orderId, long revenueOrderId, String payload, RechargeParam info) {
        if (ServiceManagerProxy.getServiceManager() == null || ServiceManagerProxy.getServiceManager().getService(IDBService.class) == null) {
            return;
        }
        Object value = info.getExpand("gameId");
        String gameId = value instanceof String ? (String)value : "";
        RechargeDbBean dbBean = new RechargeDbBean(orderId, info.getProductId(), info.getUnitPrice(), info.getDiamond(), info.getSrcCurrencySymbol(), info.getChargeConfigId(), info.getUseChannel(), gameId, info.getProductType(), payload, info.isCurrencyCodeEnable(), info.msgIntercept());
        dbBean.setRevenueOrderId(revenueOrderId);
        MyBox box = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(RechargeDbBean.class);
        if (box == null) {
            return;
        }
        box.addItem((BaseDBBean)dbBean);
    }

    private void rechargeReal(String orderId, String payload, IPlatformPay pay2, @NonNull Activity activity, @NonNull RechargeParam info, IRechargeCallback callback2) {
        this.rechargeReal(orderId, payload, 0L, pay2, activity, info, callback2);
    }

    private void rechargeReal(final String orderId, final String payload, final long revenueOrderId, final IPlatformPay pay2, final @NonNull Activity activity, final @NonNull RechargeParam info, final IRechargeCallback callback2) {
        SkuDetailsInfo detailInfo;
        this.mPayHandlerMonitor.startRecharge(info.getProductId(), orderId);
        this.addRechargeToDb(orderId, revenueOrderId, payload, info);
        this.mPayPayload = payload;
        this.mProductId = info.getProductId();
        final long startTime = System.currentTimeMillis();
        String details = "";
        if (this.mSkuDetailManager != null && (detailInfo = this.mSkuDetailManager.getSkuDetails(info.getProductId())) != null) {
            details = detailInfo.getOriginalJson();
        }
        pay2.recharge(activity, info.getProductId(), PayUtils.getProductType(info.getProductType()), payload, PayUtils.getAccountId(), details, (IPlatformRechargeCallback)new IPlatformRechargeCallback<RechargeResult>(){

            public void onSucceed(@Nullable RechargeResult data) {
                RechargeHandler.this.reportPayResult(activity, data, info, orderId, payload, false, true, 0, (IPayCallback<RechargeInfo>)callback2);
                RechargeHandler.this.mPayHandlerMonitor.reportMetriGpRecharge("0");
                RechargeHandler.this.mPayHandlerMonitor.rechargeSuccess(info.getProductId(), orderId, data.orderId, callback2.rechargeSource(), RechargeHandler.this.mPayType);
                PayUtils.rechargeSuccess(orderId, data);
                PayUtils.callbackRechargeSuccess(callback2, data);
            }

            public void onUnConsume(List<PurchaseInfo> list) {
                RechargeHandler.this.handleUnConsume(list);
            }

            public void onConsumeFail(int code) {
                MLog.error((Object)RechargeHandler.TAG, (String)"rechargeReal onConsumeFail code: %s", (Object[])new Object[]{code});
                RechargeHandler.this.mPayHandlerMonitor.reportMetriGpRecharge(String.valueOf(code));
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)RechargeHandler.TAG, (String)"rechargeReal onFailed code: %s, msg: %s", (Object[])new Object[]{code, msg});
                RechargeHandler.this.mPayHandlerMonitor.reportMetriGpRecharge(String.valueOf(code));
                RechargeHandler.this.onRechargeFail(code, msg, activity, info, payload, orderId, revenueOrderId, callback2, pay2, startTime);
            }
        });
    }

    private void onRechargeFail(final int code, final String msg, final @NonNull Activity activity, final @NonNull RechargeParam info, final String payload, final String orderId, final long revenueOrderId, final IRechargeCallback callback2, final IPlatformPay pay2, long startTime) {
        boolean intercept2 = this.getRetryHandler(activity).interceptRechargeFail(info, orderId, code, msg, new RechargeRetryHandler.IHandleResult(){

            @Override
            public void onHandle(boolean needRetry) {
                MLog.info((Object)RechargeHandler.TAG, (String)"rechargeReal onFailed intercept needRetry: %b", (Object[])new Object[]{needRetry});
                if (!needRetry) {
                    RechargeHandler.this.finishRetryHandler();
                    RechargeHandler.this.handleRechargeFail(code, msg, info, orderId, true, callback2);
                } else {
                    RechargeHandler.this.rechargeReal(orderId, payload, revenueOrderId, pay2, activity, info, callback2);
                }
            }
        });
        MLog.info((Object)TAG, (String)"rechargeReal onFailed intercept: %b", (Object[])new Object[]{intercept2});
        if (!intercept2) {
            this.finishRetryHandler();
            if (code == 20001 && System.currentTimeMillis() - startTime > 5000L) {
                this.handleRechargeFail(20101, msg, info, orderId, false, callback2);
                Message m = Message.obtain();
                m.what = AppbaseMsgDef.HIDE_RECHARGE_DIALOG;
                m.arg1 = code;
                m.obj = msg;
                MsgDispatcher.getInstance().sendMessage(m);
                this.getQuestionPresenter().showQuestions((Context)activity, new IHandlerCallback(){

                    @Override
                    public void onHandlerFinished(IPayHandler handler) {
                        RechargeHandler.this.finishQuestionPresent();
                        RechargeHandler.this.onFinish();
                    }
                });
            } else {
                this.handleRechargeFail(code, msg, info, orderId, true, callback2);
            }
        }
        if (code != 20001) {
            new GpFailIMViewModel().onGpPayFail("" + orderId);
        }
    }

    private void handleRechargeFail(int code, String msg, @NonNull RechargeParam info, String orderId, boolean finish, IRechargeCallback callback2) {
        PayUtils.callbackFailed(callback2, code, msg);
        if (finish) {
            this.onFinish();
        }
        this.mPayHandlerMonitor.rechargeFail(info.getProductId(), orderId, code, msg, callback2.rechargeSource(), this.mPayType);
        if (code == 20001 || code == 20101) {
            PayUtils.updateDbState(orderId, 10, null, info);
        } else if (code != 10012) {
            PayUtils.updateDbState(orderId, 12, null, info);
        }
    }

    public void reportPayResult(final @Nullable Activity activity, final @Nullable RechargeResult rechargeResult, final @NonNull RechargeParam info, final String orderId, final String payload, final boolean finishAfter, boolean consume2, int reportType, final IPayCallback<RechargeInfo> callback2) {
        if (info.getProductType() != 1) {
            this.getBalance();
        }
        final String seq = RevenueProto.uniqueSeq();
        if (rechargeResult != null) {
            this.mPayHandlerMonitor.monitorRequest(info.getFrom(), seq, 1045, info.getProductId(), String.valueOf(info.getUnitPrice()), rechargeResult.orderId, rechargeResult.payload);
            if (info.isNeedRechargeSuccessBro()) {
                this.mFinishListener = new RechargeFinishListener(info.getProductId(), orderId, rechargeResult.payload, callback2);
            }
        }
        this.mReportPayResult = new ReportPayResult(info, rechargeResult, seq, consume2, this.mPayHandlerMonitor, reportType, new IPayCallback<ReportRechargeResult>(){

            public void onSucceed(@Nullable ReportRechargeResult data) {
                if (data == null) {
                    int code = 51100;
                    String msg = "reportPayResult happen some error!";
                    MLog.error((Object)RechargeHandler.TAG, (String)"rechargeReal reportPayResult onSucceed msg: %s", (Object[])new Object[]{msg});
                    RechargeHandler.this.interceptReportFail(code, msg, activity, rechargeResult, info, orderId, payload, seq, finishAfter, (IPayCallback<RechargeInfo>)callback2);
                } else {
                    MLog.info((Object)RechargeHandler.TAG, (String)"reportPayResult onSucceed orderId: %s", (Object[])new Object[]{orderId});
                    RechargeHandler.this.handleReportSuccess(data, rechargeResult, seq, info, orderId, payload, finishAfter, false, (IPayCallback<RechargeInfo>)callback2);
                }
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)RechargeHandler.TAG, (String)"reportPayResult onFailed code: %d, msg: %s, orderId: %s", (Object[])new Object[]{code, msg, orderId});
                if (code == 50980) {
                    RechargeHandler.this.handleReportSuccess(null, rechargeResult, seq, info, orderId, payload, finishAfter, true, (IPayCallback<RechargeInfo>)callback2);
                    RechargeHandler.this.mPayHandlerMonitor.monitorRequestFailed(seq, code, msg);
                } else {
                    RechargeHandler.this.interceptReportFail(code, msg, activity, rechargeResult, info, orderId, payload, seq, finishAfter, (IPayCallback<RechargeInfo>)callback2);
                }
            }
        });
    }

    private void handleReportSuccess(@Nullable ReportRechargeResult data, @Nullable RechargeResult rechargeResult, String seq, @NonNull RechargeParam info, String orderId, String payload, boolean finishAfter, boolean hadGive, IPayCallback<RechargeInfo> callback2) {
        if (rechargeResult != null && data != null) {
            this.mPayHandlerMonitor.monitorResponse(seq, data.result, data.response.result, info.getProductId(), String.valueOf(info.getUnitPrice()), rechargeResult.orderId, orderId);
        }
        PayUtils.updateDbState(orderId, 20, null, info);
        if (info.isNeedRechargeSuccessBro() && this.mFinishListener != null && !hadGive) {
            if (info.getProductType() != 1) {
                YYTaskExecutor.postToMainThread((Runnable)this.getRequestBalanceTask(info, payload), (long)2000L);
            }
            this.mFinishListener.startTimer();
        } else {
            RechargeInfo rechargeInfo = this.rechargeParamToInfo(info, orderId, 0L);
            PayUtils.callbackSucceed(callback2, rechargeInfo);
            if (finishAfter) {
                this.onFinish();
            }
            Map<String, Long> extend = Collections.singletonMap("diamond", rechargeInfo.getCurrencyAmount());
            PayUtils.updateDbState(orderId, 2, extend, info);
        }
    }

    @NonNull
    private RechargeInfo rechargeParamToInfo(@NonNull RechargeParam info, String orderId, long difAmount) {
        long diamond = info.getDiamond() > 0L ? info.getDiamond() : difAmount;
        return RechargeInfo.newBuilder().appid(1802).orderId(orderId).currencyType(1805).amount(info.getUnitPrice()).usedChannel(info.getUseChannel()).currencyAmount(diamond).productType(info.getProductType()).payChannel(this.mPlatform.getChannel()).payMethod(this.mPlatform.getMethod()).msgIntercept(Boolean.valueOf(info.msgIntercept())).build();
    }

    private void interceptReportFail(final int code, final String msg, @Nullable Activity activity, final @Nullable RechargeResult rechargeResult, final @NonNull RechargeParam info, final String orderId, final String payload, final String seq, final boolean finishAfter, final IPayCallback<RechargeInfo> callback2) {
        if (activity != null) {
            boolean intercept2 = this.getRetryHandler(activity).interceptReportFail(code, payload, msg, new RechargeRetryHandler.IHandleResult(){

                @Override
                public void onHandle(boolean needRetry) {
                    MLog.info((Object)RechargeHandler.TAG, (String)"reportPayResult intercept needRetry: %b", (Object[])new Object[]{needRetry});
                    RechargeHandler.this.finishRetryHandler();
                    if (needRetry) {
                        RechargeHandler.this.reportPayResult(null, rechargeResult, info, orderId, payload, false, true, 0, null);
                    }
                    RechargeHandler.this.handleReportFail(payload, orderId, code, msg, seq, finishAfter, (IPayCallback<RechargeInfo>)callback2, info);
                }
            });
            MLog.info((Object)TAG, (String)"reportPayResult onFailed intercept: %b", (Object[])new Object[]{intercept2});
            if (!intercept2) {
                this.finishRetryHandler();
                this.handleReportFail(payload, orderId, code, msg, seq, finishAfter, callback2, info);
            }
        } else {
            this.finishRetryHandler();
            this.handleReportFail(payload, orderId, code, msg, seq, finishAfter, callback2, info);
        }
    }

    private void handleReportFail(String payload, String orderId, int code, String msg, String seq, boolean finishAfter, IPayCallback<RechargeInfo> callback2, RechargeParam info) {
        this.mPayHandlerMonitor.monitorRequestFailed(seq, code, msg);
        PayUtils.callbackFailed(callback2, code, msg);
        if (finishAfter) {
            this.onFinish();
        }
        if (code == 50980) {
            MLog.info((Object)TAG, (String)"return -20 order had finish", (Object[])new Object[0]);
            PayUtils.updateDbState(orderId, 2, null, info);
        } else {
            PayUtils.updateDbState(orderId, 21, null, info);
        }
    }

    private void handleUnConsume(List<PurchaseInfo> list) {
        MLog.info((Object)TAG, (String)"handleUnConsume list.size: %d", (Object[])new Object[]{FP.size(list)});
        for (PurchaseInfo info : list) {
            String productId = info.getProductId();
            ProductItemInfo itemInfo = this.getRechargeItemInfo(productId);
            if (itemInfo == null) {
                MLog.error((Object)TAG, (String)"handleUnConsume ProductItemInfo is null with productId: %s", (Object[])new Object[]{productId});
            }
            RechargeResult result = new RechargeResult(info);
            PayUtils.rechargeSuccess(PayUtils.getOrderFromPayload(result.payload), result);
            RechargeParam param = this.getRechargeParam(itemInfo, productId);
            param.setNeedRechargeSuccessBro(true);
            this.reportPayResult(null, result, param, PayUtils.getOrderFromPayload(info.getPayload()), info.getPayload(), true, false, 0, null);
        }
    }

    private RechargeParam getRechargeParam(ProductItemInfo info, String productId) {
        RechargeParam param = RechargeParam.newBuilder().productId(productId).chargeConfigId(info == null ? 0 : info.cid).quantity(1).unitPrice(info == null ? 0.0 : info.getSrcAmount()).srcCurrencySymbol(info == null ? "" : info.getSrcCurrencySymbol()).useChannel(PayUtils.getPayUseChannel()).diamond(info == null ? 0L : info.destAmount).userCouponId(info == null ? 0L : (info.couponBean == null ? 0L : info.couponBean.id)).productType(info == null ? 0 : info.productType).isCurrencyCodeEnable(info == null || info.isCurrencyCodeEnable()).build();
        param.setFrom(103);
        return param;
    }

    private ProductItemInfo getRechargeItemInfo(String productId) {
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IPayService.class) != null) {
            return ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).getRechargeItemInfo(productId);
        }
        return null;
    }

    private void getBalance() {
        this.getBalance(null, "");
    }

    private void getBalance(final RechargeParam info, final String orderId) {
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IPayService.class) != null) {
            ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).queryBalance(-1, (IPayCallback)new IPayCallback<BalanceResponse>(){

                public void onSucceed(@Nullable BalanceResponse response) {
                    if (response != null) {
                        long balance = PayUtils.getBalance(response.accountList);
                        MLog.info((Object)RechargeHandler.TAG, (String)"compare balance mLastBalance: %d, balance: %d", (Object[])new Object[]{RechargeHandler.this.mLastBalance, balance});
                        if (RechargeHandler.this.mLastBalance > 0L && info != null && !TextUtils.isEmpty((CharSequence)orderId) && balance > RechargeHandler.this.mLastBalance) {
                            RechargeInfo rechargeInfo = RechargeHandler.this.rechargeParamToInfo(info, orderId, balance - RechargeHandler.this.mLastBalance);
                            RechargeHandler.this.notifySuccess(rechargeInfo);
                        } else if (balance <= RechargeHandler.this.mLastBalance && info != null && !TextUtils.isEmpty((CharSequence)orderId) && RechargeHandler.this.mFinishListener != null) {
                            YYTaskExecutor.postToMainThread((Runnable)RechargeHandler.this.getRequestBalanceTask(info, orderId), (long)2000L);
                        }
                        RechargeHandler.this.mLastBalance = balance;
                    }
                }

                public void onFailed(int code, String msg) {
                }
            });
        }
    }

    private RequestBalanceTask getRequestBalanceTask(RechargeParam info, String orderId) {
        this.removeRequestBalanceTask();
        this.mRequestBalanceTask = new RequestBalanceTask(info, orderId);
        return this.mRequestBalanceTask;
    }

    private void removeRequestBalanceTask() {
        if (this.mRequestBalanceTask != null) {
            YYTaskExecutor.removeTask((Runnable)this.mRequestBalanceTask);
            this.mRequestBalanceTask = null;
        }
    }

    private void waitNotifyTimeout(RechargeFinishListener listener) {
        MLog.info((Object)TAG, (String)"waitNotifyTimeout listener: %s", (Object[])new Object[]{listener});
        if (listener == null) {
            return;
        }
        if (listener == this.mFinishListener) {
            this.mFinishListener = null;
        }
        PayUtils.callbackFailed(listener.callback, 10004, "recharge success, but time out when wait for notify from server");
        this.onFinish();
        this.mPayHandlerMonitor.monitorNotifyTimeout(listener.productId, listener.orderId, listener.duration());
        PayUtils.updateDbState(listener.orderId, 30, null, null);
    }

    private void onFinish() {
        MLog.info((Object)TAG, (String)"onFinish", (Object[])new Object[0]);
        this.removeRequestBalanceTask();
        if (this.mHandlerCallback != null) {
            this.mHandlerCallback.onHandlerFinished(this);
            this.mHandlerCallback = null;
        }
    }

    private RechargeRetryHandler getRetryHandler(Activity activity) {
        if (this.mRetryHandler == null) {
            this.mRetryHandler = new RechargeRetryHandler(activity);
        }
        return this.mRetryHandler;
    }

    private void finishRetryHandler() {
        if (this.mRetryHandler != null) {
            this.mRetryHandler.destroy();
            this.mRetryHandler = null;
        }
    }

    private QuestionPresent getQuestionPresenter() {
        if (this.mQuestionPresenter == null) {
            this.mQuestionPresenter = new QuestionPresent();
        }
        return this.mQuestionPresenter;
    }

    private void finishQuestionPresent() {
        if (this.mQuestionPresenter != null) {
            this.mQuestionPresenter.destroy();
            this.mQuestionPresenter = null;
        }
    }

    private class RequestBalanceTask
    implements Runnable {
        RechargeParam info;
        String orderId;

        public RequestBalanceTask(RechargeParam info, String orderId) {
            this.info = info;
            this.orderId = orderId;
        }

        @Override
        public void run() {
            RechargeHandler.this.getBalance(this.info, this.orderId);
        }
    }

    private class RechargeFinishListener {
        String productId;
        String orderId;
        String payload;
        long startTime;
        IPayCallback<RechargeInfo> callback;
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                RechargeHandler.this.waitNotifyTimeout(RechargeFinishListener.this);
            }
        };

        public RechargeFinishListener(String productId, String orderId, String payload, IPayCallback<RechargeInfo> callback2) {
            this.productId = productId;
            this.orderId = orderId;
            this.payload = payload;
            this.callback = callback2;
        }

        void startTimer() {
            this.startTime = SystemClock.elapsedRealtime();
            YYTaskExecutor.postToMainThread((Runnable)this.timeoutTask, (long)20000L);
        }

        long duration() {
            return Math.abs(SystemClock.elapsedRealtime() - this.startTime);
        }

        void release() {
            YYTaskExecutor.removeTask((Runnable)this.timeoutTask);
        }

        public String toString() {
            return "RechargeFinishListener{productId='" + this.productId + '\'' + ", payload='" + this.payload + '\'' + '}';
        }
    }
}

