/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.RechargeDbBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.login.base.LoginGuideCallbackSimple;
import com.yy.hiyo.login.base.LoginGuideDialogCallback;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.IPayLevelService;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.CouponDiscountBean;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeSuccessListener;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.RevenueSdkReport;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.money.api.paylevel.RechargeScene;

public abstract class BaseRechargeController
extends DefaultController {
    private static final String TAG = "FTPayBaseRechargeController";
    private static final long LOADING_TIMEOUT = 10000L;
    private DialogLinkManager mLoadingDialogManager;
    private DialogLinkManager mTipsDialogManager;
    protected int fromType = 0;
    protected String mGid = "";
    protected String mRoomId = "";
    protected String mActId = "";
    protected String mPageId = "";
    protected boolean isLogining = false;
    protected boolean isOnlyNative = false;
    private ActivityAction mActivityAction;
    private boolean isSelectActivity = false;
    protected IRechargeHandler mRechargeHandler;
    protected String mRechargeSuccessOrderId;
    protected CouponBean mCurrCouponBean;
    public RechargeDbBean bean;
    private IRechargeSuccessListener mRechargeSuccessListener = new IRechargeSuccessListener(){

        public void onSuccess(RechargeInfo info) {
            BaseRechargeController.this.onRechargeSuccess(info);
        }
    };
    private Runnable mRequestBalanceTimeoutTask = new Runnable(){

        @Override
        public void run() {
            BaseRechargeController.this.showToast(R.string.tips_unknown_error);
            BaseRechargeController.this.hideLoading();
        }
    };
    LoginGuideDialogCallback loginGuideDialogCallback = new LoginGuideCallbackSimple(){

        public void onSelectOther() {
            BaseRechargeController.this.onSelectedOther();
        }

        public void onLoginFinished() {
            BaseRechargeController.this.onLoginFinish();
        }

        public void onLoadingChange(boolean isoading) {
            BaseRechargeController.this.isLogining = isoading;
        }
    };

    public BaseRechargeController(Environment env) {
        super(env);
        ((IPayService)this.getServiceManager().getService(IPayService.class)).addPayListener(this.mRechargeSuccessListener);
    }

    protected abstract int getLoginDialogType();

    protected abstract int getLoginDialogFrom();

    protected void handleBundle(Bundle bundle) {
        if (bundle != null) {
            this.fromType = bundle.getInt("fromType", 0);
            this.mGid = bundle.getString("gid", "");
            this.mRoomId = bundle.getString("roomId", "");
            this.isOnlyNative = bundle.getBoolean("onlyNativeRecharge", false);
            this.mActId = bundle.getString("actId", "");
            int activityType = bundle.getInt("recharge_dialog_act_type", 0);
            this.mPageId = bundle.getString("pageId", "");
            if (StringUtils.isEmpty((String)this.mPageId)) {
                this.mPageId = RevenueSdkReport.INSTANCE.generatePageId();
            }
            switch (activityType) {
                case 1: {
                    this.handleNoBalanceActivity();
                    break;
                }
                case 2: {
                    this.mActivityAction = (ActivityAction)bundle.getSerializable("activity_action");
                    this.isSelectActivity = bundle.getBoolean("is_select_activity");
                    break;
                }
                default: {
                    this.mActivityAction = null;
                    this.isSelectActivity = false;
                }
            }
        }
    }

    private void handleNoBalanceActivity() {
        ActivityActionList activityActionList = ((IActivityService)ServiceManagerProxy.getService(IActivityService.class)).getActivityBannerInfoFromCache("", null, 6);
        MLog.info((Object)TAG, (String)("getActivityBannerInfoFromCache:" + activityActionList), (Object[])new Object[0]);
        if (activityActionList != null && !FP.empty((Collection)activityActionList.list)) {
            this.mActivityAction = (ActivityAction)activityActionList.list.get(0);
            this.mActivityAction.spliceLinkUrl("from", String.valueOf(this.fromType));
            this.mActivityAction.title = ResourceUtils.getString((int)R.string.title_recharge_activity);
            this.isSelectActivity = true;
        } else {
            this.isSelectActivity = false;
            this.mActivityAction = null;
        }
    }

    protected Map<String, Object> addCommonExpandParam(Map<String, Object> expand) {
        if (expand == null) {
            expand = new HashMap<String, Object>();
        }
        expand.put("native", 1);
        return expand;
    }

    protected void showLoginGuide() {
        Bundle bundle = new Bundle();
        bundle.putInt("type_from_key", this.getLoginDialogType());
        bundle.putString("gid", this.mGid);
        GuestLoginUtils.showLoginGuide((Bundle)bundle, (LoginGuideDialogCallback)this.loginGuideDialogCallback);
    }

    protected void hideLoginGuide() {
        this.sendMessage(BaseMsgDef.MSG_HIDE_LOGIN_GUIDE_DIALOG);
    }

    protected void onSelectedOther() {
    }

    protected RechargeParam getRechargeParam(ProductItemInfo info) {
        RechargeParam param = RechargeParam.newBuilder().productId(info.getProductId()).chargeConfigId(info.cid).quantity(1).unitPrice(info.getSrcAmount()).srcCurrencySymbol(info.getSrcCurrencySymbol()).useChannel(PayUtils.getPayUseChannel()).diamond(info.destAmount).userCouponId(info.couponBean == null ? 0L : info.couponBean.id).productType(info.productType).pageId(this.mPageId).isCurrencyCodeEnable(info.isCurrencyCodeEnable()).build();
        param.setFrom(this.fromType);
        if (!TextUtils.isEmpty((CharSequence)this.mGid)) {
            param.addExpand("gameId", (Object)this.mGid);
        }
        this.addCommonExpandParam(param.getExpand());
        return param;
    }

    @CallSuper
    protected void onLoginFinish() {
        this.isLogining = false;
    }

    protected void showLoading() {
        if (this.mLoadingDialogManager == null) {
            this.mLoadingDialogManager = new DialogLinkManager(this.mContext);
        }
        ProgressDialog dialog2 = new ProgressDialog();
        dialog2.setCheckDeadLoop(false);
        this.mLoadingDialogManager.showDialog((BaseDialog)dialog2);
    }

    protected boolean checkItemClick() {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return false;
        }
        if (AccountUtil.isLoginByGuest()) {
            this.showLoginGuide();
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_login_first), (int)0);
            return false;
        }
        return true;
    }

    protected void onRechargeSuccess(RechargeInfo info) {
        YYTaskExecutor.execute(() -> ((IPayLevelService)this.getServiceManager().getService(IPayLevelService.class)).updateRechargeUrl(RechargeScene.RechargeScenePage), (long)30000L);
    }

    protected void handleOnSucceed(ProductItemInfo productItemInfo, RechargeInfo data, int promptType) {
        RechargeHiidoReport.rechargeResult(this.mGid, this.fromType, this.mRoomId, productItemInfo, 1, promptType, data != null ? data.getOrderId() : "");
    }

    protected void handleOnFailed(ProductItemInfo productItemInfo, int code, String msg, int promptType) {
        RechargeHiidoReport.rechargeResult(this.mGid, this.fromType, this.mRoomId, productItemInfo, code, promptType, "");
        this.hideLoading();
    }

    protected List<ProductItemInfo> sortRechargeList(List<ProductItemInfo> productItemInfoList) {
        Collections.sort(productItemInfoList, (o1, o2) -> o1.getLevel() - o2.getLevel());
        return productItemInfoList;
    }

    private void showToast(@StringRes int res) {
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)res), (int)0);
    }

    protected void hideLoading() {
        if (this.mLoadingDialogManager != null) {
            this.mLoadingDialogManager.dismissDialog();
            this.mLoadingDialogManager = null;
        }
    }

    private void hideTips() {
        if (this.mTipsDialogManager != null) {
            this.mTipsDialogManager.dismissDialog();
            this.mTipsDialogManager = null;
        }
    }

    protected void startBalanceTimeoutTask() {
        YYTaskExecutor.postToMainThread((Runnable)this.mRequestBalanceTimeoutTask, (long)10000L);
    }

    protected void endBalanceTimeoutTask() {
        YYTaskExecutor.removeTask((Runnable)this.mRequestBalanceTimeoutTask);
    }

    protected void onDestroy() {
        this.cancelRecharge();
        this.hideLoading();
        this.hideLoginGuide();
        this.hideTips();
        this.isLogining = false;
    }

    protected void onFinish() {
        this.mRechargeHandler = null;
    }

    protected void cancelRecharge() {
        if (this.mRechargeHandler != null) {
            this.mRechargeHandler.cancelRecharge();
            this.mRechargeHandler = null;
        }
    }

    public ActivityAction getActivityAction() {
        return this.mActivityAction;
    }

    public boolean isSelectActivity() {
        return this.isSelectActivity;
    }

    protected void checkAbnormal() {
        ((IPayService)this.getServiceManager().getService(IPayService.class)).checkAbnormalOrder();
    }

    protected void requestCouponDiscount(final List<ProductItemInfo> productData) {
        if (this.mCurrCouponBean == null || this.mCurrCouponBean.id == 0L) {
            return;
        }
        if (productData == null || productData.isEmpty()) {
            return;
        }
        ArrayList<Integer> chargeConfigIds = new ArrayList<Integer>();
        for (ProductItemInfo productDatum : productData) {
            chargeConfigIds.add(productDatum.cid);
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryCouponDiscountAsync(this.mCurrCouponBean.id, chargeConfigIds, (IPayCallback)new IPayCallback<List<CouponDiscountBean>>(){

            public void onSucceed(@Nullable List<CouponDiscountBean> data) {
                if (!FP.empty(data)) {
                    block0: for (CouponDiscountBean datum : data) {
                        if (datum.couponEnabled && TextUtils.isEmpty((CharSequence)datum.discountProductId)) {
                            String msg = datum.cid + " \u4f18\u60e0\u5238\u5546\u54c1id \u4e3a\u7a7a";
                            if (SystemUtils.isShowEnvSetting()) {
                                throw new IllegalStateException(msg);
                            }
                            MLog.error((Object)BaseRechargeController.TAG, (String)msg, (Object[])new Object[0]);
                            continue;
                        }
                        for (ProductItemInfo productDatum : productData) {
                            if (productDatum.cid != datum.cid) continue;
                            productDatum.couponDiscountBean = datum;
                            productDatum.couponBean = datum.couponEnabled ? BaseRechargeController.this.mCurrCouponBean : null;
                            continue block0;
                        }
                    }
                    BaseRechargeController.this.updataRechargeListForCoupon();
                }
            }

            public void onFailed(int code, String msg) {
                if (code == -400) {
                    ToastUtils.showToast((Context)BaseRechargeController.this.mContext, (int)R.string.tips_coupon_overdue);
                }
                BaseRechargeController.this.onRequestCouponDiscountFailed();
            }
        });
    }

    protected abstract void updataRechargeListForCoupon();

    protected abstract void onRequestCouponDiscountFailed();
}

