/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gold;

import com.yy.base.logger.MLog;
import com.yy.hiyo.game.base.GameGoldChangeBean;
import com.yy.hiyo.wallet.base.gold.GameGoldBusiness;
import com.yy.hiyo.wallet.base.gold.IGameGoldBehavior;
import com.yy.hiyo.wallet.base.gold.IGameGoldHandler;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentationPresenter;
import com.yy.hiyo.wallet.gold.notify.IGameGoldNotify;
import com.yy.hiyo.wallet.gold.notify.IGameGoldNotifyListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.gamecoin.ChangeCoinNotify;
import net.ihago.money.api.gamecoin.GiveCoinNotify;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/yy/hiyo/wallet/gold/GameGoldHandler;", "Lcom/yy/hiyo/wallet/base/gold/IGameGoldHandler;", "Lcom/yy/hiyo/wallet/gold/notify/IGameGoldNotifyListener;", "business", "Lcom/yy/hiyo/wallet/base/gold/GameGoldBusiness;", "behavior", "Lcom/yy/hiyo/wallet/base/gold/IGameGoldBehavior;", "notify", "Lcom/yy/hiyo/wallet/gold/notify/IGameGoldNotify;", "(Lcom/yy/hiyo/wallet/base/gold/GameGoldBusiness;Lcom/yy/hiyo/wallet/base/gold/IGameGoldBehavior;Lcom/yy/hiyo/wallet/gold/notify/IGameGoldNotify;)V", "getNotify", "()Lcom/yy/hiyo/wallet/gold/notify/IGameGoldNotify;", "presenter", "Lcom/yy/hiyo/wallet/gold/goldpresent/GoldPresentationPresenter;", "destroy", "", "onChangeCoin", "Lnet/ihago/money/api/gamecoin/ChangeCoinNotify;", "onGiveCoin", "Lnet/ihago/money/api/gamecoin/GiveCoinNotify;", "queryJoinCoin", "Companion", "wallet_billDebug"})
public final class GameGoldHandler
implements IGameGoldHandler,
IGameGoldNotifyListener {
    private final GoldPresentationPresenter presenter;
    private final GameGoldBusiness business;
    private final IGameGoldBehavior behavior;
    @NotNull
    private final IGameGoldNotify notify;
    @NotNull
    public static final String TAG = "GameGoldHandler";
    public static final Companion Companion = new Companion(null);

    public void queryJoinCoin() {
        this.presenter.queryJoinCoin();
    }

    @Override
    public void onGiveCoin(@NotNull GiveCoinNotify notify) {
        Intrinsics.checkParameterIsNotNull((Object)notify, (String)"notify");
        MLog.info((Object)TAG, (String)"give coin count:%d,times:%d", (Object[])new Object[]{notify.coin, notify.times});
        if (notify.coin > 0L) {
            Long l = notify.id;
            if (l == null || l != 0L) {
                Long l2 = notify.coin;
                Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"notify.coin");
                long l3 = l2;
                Long l4 = notify.id;
                Intrinsics.checkExpressionValueIsNotNull((Object)l4, (String)"notify.id");
                this.presenter.showDialog(l3, 1, l4);
            }
        }
    }

    @Override
    public void onChangeCoin(@NotNull ChangeCoinNotify notify) {
        Intrinsics.checkParameterIsNotNull((Object)notify, (String)"notify");
        MLog.info((Object)TAG, (String)"onChangeCoin coin: %d, gameCoin: %d", (Object[])new Object[]{notify.coin, notify.game_coin});
        GameGoldChangeBean bean = new GameGoldChangeBean();
        Long l = notify.coin;
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"notify.coin");
        bean.setCoinChange(l.longValue());
        Long l2 = notify.game_coin;
        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"notify.game_coin");
        bean.setCoinCount(l2.longValue());
        this.behavior.notifyGoldChange(bean);
    }

    public final void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        this.notify.removeListener(this);
        this.presenter.destroy();
    }

    @NotNull
    public final IGameGoldNotify getNotify() {
        return this.notify;
    }

    public GameGoldHandler(@NotNull GameGoldBusiness business, @NotNull IGameGoldBehavior behavior, @NotNull IGameGoldNotify notify) {
        Intrinsics.checkParameterIsNotNull((Object)business, (String)"business");
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        Intrinsics.checkParameterIsNotNull((Object)notify, (String)"notify");
        this.business = business;
        this.behavior = behavior;
        this.notify = notify;
        this.presenter = new GoldPresentationPresenter(this.behavior);
        this.notify.addListener(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/wallet/gold/GameGoldHandler$Companion;", "", "()V", "TAG", "", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

