/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.giftpackage;

import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftPackage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.PackageGiftInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelHandlerCallback;
import com.yy.hiyo.wallet.gift.ui.pannel.giftpackage.IGiftPackageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.active.api.activity.PropOneLimit;
import net.ihago.money.api.pay.FreeGiftConversionNotify;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J,\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00032\u0010\u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\fJ\u0018\u0010)\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010*\u001a\u00020\u0010J\b\u0010+\u001a\u00020\u0014H\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/yy/hiyo/wallet/gift/ui/pannel/giftpackage/GiftPackageManager;", "Lcom/yy/hiyo/wallet/gift/ui/pannel/giftpackage/IGiftPackageManager;", "callback", "Lcom/yy/hiyo/wallet/gift/ui/pannel/IGiftPanelHandlerCallback;", "(Lcom/yy/hiyo/wallet/gift/ui/pannel/IGiftPanelHandlerCallback;)V", "getCallback", "()Lcom/yy/hiyo/wallet/gift/ui/pannel/IGiftPanelHandlerCallback;", "diamondBalanceCache", "", "isInitFinish", "", "listeners", "", "Lcom/yy/hiyo/wallet/base/revenue/gift/IGiftPackage$IGiftPackageListener;", "mPackMap", "", "", "Lcom/yy/hiyo/wallet/base/revenue/gift/bean/PackageGiftInfo;", "packageCount", "addListener", "", "listener", "clearCountCache", "convertPackListToMap", "packList", "", "Lcom/yy/hiyo/wallet/base/revenue/gift/bean/GiftItemInfo;", "createPackageByGiftInfo", "giftInfo", "createPackageGiftById", "propId", "getBalanceCache", "getPackageGiftByCache", "getPackagesCount", "notifyNewPackageGift", "notifyPackageInitFinish", "notifyReceivedGift", "notify", "Lnet/ihago/money/api/pay/FreeGiftConversionNotify;", "mCallback", "mGiftList", "onConsumeGift", "gitNumber", "onDestroy", "removeListener", "updateBalanceCache", "balance", "Companion", "wallet_billDebug"})
public final class GiftPackageManager
implements IGiftPackageManager {
    private final Map<Integer, PackageGiftInfo> mPackMap;
    private final List<IGiftPackage.IGiftPackageListener> listeners;
    private boolean isInitFinish;
    private int packageCount;
    private long diamondBalanceCache;
    @NotNull
    private final IGiftPanelHandlerCallback callback;
    @NotNull
    public static final String TAG = "GiftPackageManager";
    public static final Companion Companion = new Companion(null);

    @Override
    public void convertPackListToMap(@NotNull List<? extends GiftItemInfo> packList) {
        Intrinsics.checkParameterIsNotNull(packList, (String)"packList");
        boolean hasNewPacket = false;
        this.packageCount = 0;
        if (!FP.empty((Collection)packList)) {
            this.clearCountCache();
            for (GiftItemInfo giftItemInfo : packList) {
                PackageGiftInfo pack;
                if (giftItemInfo == null) continue;
                boolean hasPackageGiftInfo = this.getPackageGiftByCache(giftItemInfo.getPropsId()) != null;
                PackageGiftInfo packageGiftInfo = pack = this.createPackageByGiftInfo(giftItemInfo);
                if (packageGiftInfo != null) {
                    packageGiftInfo.setGiftItemInfo(giftItemInfo);
                }
                PackageGiftInfo packageGiftInfo2 = pack;
                if (packageGiftInfo2 != null) {
                    packageGiftInfo2.setCount(giftItemInfo.getCount());
                }
                if (giftItemInfo.getCount() > 0) {
                    int n = this.packageCount;
                    this.packageCount = n + 1;
                }
                if (pack != null && !hasPackageGiftInfo) {
                    hasNewPacket = true;
                }
                MLog.debug((Object)TAG, (String)("convertPackListToMap " + giftItemInfo.getCount() + " propsId " + ':' + giftItemInfo.getPropsId() + " hasNewPacket" + hasNewPacket), (Object[])new Object[0]);
            }
        } else {
            this.clearCountCache();
        }
        if (!this.isInitFinish) {
            this.notifyPackageInitFinish();
        }
        if (hasNewPacket) {
            this.notifyNewPackageGift();
        }
    }

    @Override
    public void updateBalanceCache(long balance) {
    }

    private final void clearCountCache() {
        Map<Integer, PackageGiftInfo> $this$forEach$iv = this.mPackMap;
        boolean $i$f$forEach = false;
        Map<Integer, PackageGiftInfo> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<Integer, PackageGiftInfo>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PackageGiftInfo> element$iv;
            Map.Entry<Integer, PackageGiftInfo> it = element$iv = iterator.next();
            boolean bl2 = false;
            it.getValue().setCount(0);
        }
    }

    private final PackageGiftInfo createPackageByGiftInfo(GiftItemInfo giftInfo) {
        if (this.mPackMap.containsKey(giftInfo.getPropsId())) {
            return this.mPackMap.get(giftInfo.getPropsId());
        }
        PackageGiftInfo packageGiftInfo = new PackageGiftInfo(giftInfo.getPropsId());
        packageGiftInfo.setGiftItemInfo(giftInfo);
        this.mPackMap.put(giftInfo.getPropsId(), packageGiftInfo);
        return this.mPackMap.get(giftInfo.getPropsId());
    }

    public int getPackagesCount() {
        return this.packageCount;
    }

    public long getBalanceCache() {
        return this.diamondBalanceCache;
    }

    @Nullable
    public PackageGiftInfo createPackageGiftById(int propId) {
        block4: {
            Object v2;
            boolean bl;
            Iterable iterable;
            GiftItemInfo giftItemInfo;
            block3: {
                if (this.mPackMap.containsKey(propId)) {
                    return this.mPackMap.get(propId);
                }
                giftItemInfo = this.callback.getAllGift();
                if (giftItemInfo == null) break block4;
                iterable = (Iterable)giftItemInfo;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    GiftItemInfo it = (GiftItemInfo)t;
                    boolean bl3 = false;
                    GiftItemInfo giftItemInfo2 = it;
                    if (!(giftItemInfo2 != null && giftItemInfo2.getPropsId() == propId)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            if ((giftItemInfo = (GiftItemInfo)v2) != null) {
                iterable = giftItemInfo;
                bl = false;
                boolean bl4 = false;
                Iterable it = iterable;
                boolean bl5 = false;
                PackageGiftInfo packageGiftInfo = new PackageGiftInfo(propId);
                packageGiftInfo.setGiftItemInfo((GiftItemInfo)it);
                this.mPackMap.put(propId, packageGiftInfo);
            }
        }
        return this.mPackMap.get(propId);
    }

    @Nullable
    public PackageGiftInfo getPackageGiftByCache(int propId) {
        return this.mPackMap.get(propId);
    }

    public void addListener(@NotNull IGiftPackage.IGiftPackageListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (!this.listeners.contains(listener)) {
            if (this.isInitFinish) {
                listener.onPackageInitFinish();
            }
            this.listeners.add(listener);
        }
    }

    public void removeListener(@NotNull IGiftPackage.IGiftPackageListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public final void onConsumeGift(@Nullable GiftItemInfo giftInfo, int gitNumber) {
        if (giftInfo != null && gitNumber > 0) {
            PackageGiftInfo pack;
            PackageGiftInfo packageGiftInfo = pack = this.getPackageGiftByCache(giftInfo.getPropsId());
            if ((packageGiftInfo != null ? packageGiftInfo.getGiftItemInfo() : null) != null) {
                if (gitNumber <= pack.getCount()) {
                    pack.setCount(pack.getCount() - gitNumber);
                    MLog.debug((Object)TAG, (String)("onConsumeGift " + pack.getCount() + "  propsId :" + giftInfo.getPropsId()), (Object[])new Object[0]);
                } else {
                    pack.setCount(0);
                }
            }
        }
    }

    public final void notifyReceivedGift(@NotNull FreeGiftConversionNotify notify, @Nullable IGiftPanelHandlerCallback mCallback, @Nullable List<GiftItemInfo> mGiftList) {
        Intrinsics.checkParameterIsNotNull((Object)notify, (String)"notify");
        if (mGiftList == null) {
            MLog.error((Object)TAG, (String)"notifyReceivedGift return gift list is null", (Object[])new Object[0]);
        }
        List<GiftItemInfo> list = mGiftList;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (GiftItemInfo info : list) {
            PackageGiftInfo packageGiftInfo;
            boolean bl;
            if (info == null) continue;
            Long l = notify.prop_id;
            if (l == null || (long)info.getPropsId() != l) continue;
            if (Intrinsics.compare((int)notify.conversion_count, (int)0) > 0) {
                if (this.createPackageByGiftInfo(info) != null) {
                    PackageGiftInfo packageGiftInfo2;
                    boolean bl2 = false;
                    bl = false;
                    PackageGiftInfo it = packageGiftInfo2;
                    boolean bl3 = false;
                    PackageGiftInfo packageGiftInfo3 = it;
                    int n = packageGiftInfo3.getCount();
                    Integer n2 = notify.conversion_count;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"notify.conversion_count");
                    packageGiftInfo3.setCount(n + n2);
                }
                continue;
            }
            Boolean bl4 = notify.reach_limit;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"notify.reach_limit");
            if (!bl4.booleanValue()) continue;
            IGiftPanelHandlerCallback iGiftPanelHandlerCallback = mCallback;
            PropOneLimit limit = iGiftPanelHandlerCallback != null ? iGiftPanelHandlerCallback.getGiftLimit(info.getPropsId()) : null;
            if (limit == null) continue;
            if (this.createPackageByGiftInfo(info) == null) continue;
            bl = false;
            boolean bl5 = false;
            PackageGiftInfo it = packageGiftInfo;
            boolean bl6 = false;
            it.setCount((int)limit.max_cnt_limit.longValue());
        }
    }

    public static /* synthetic */ void notifyReceivedGift$default(GiftPackageManager giftPackageManager, FreeGiftConversionNotify freeGiftConversionNotify, IGiftPanelHandlerCallback iGiftPanelHandlerCallback, List list, int n, Object object) {
        if ((n & 2) != 0) {
            iGiftPanelHandlerCallback = null;
        }
        giftPackageManager.notifyReceivedGift(freeGiftConversionNotify, iGiftPanelHandlerCallback, list);
    }

    private final void notifyNewPackageGift() {
        for (IGiftPackage.IGiftPackageListener listener : this.listeners) {
            listener.onAddNewPackageGift();
        }
    }

    private final void notifyPackageInitFinish() {
        this.isInitFinish = true;
        for (IGiftPackage.IGiftPackageListener listener : this.listeners) {
            listener.onPackageInitFinish();
        }
    }

    @Override
    public void onDestroy() {
        MLog.error((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        this.isInitFinish = false;
        this.mPackMap.clear();
        this.listeners.clear();
        this.diamondBalanceCache = -1L;
        this.packageCount = -1;
    }

    @NotNull
    public final IGiftPanelHandlerCallback getCallback() {
        return this.callback;
    }

    public GiftPackageManager(@NotNull IGiftPanelHandlerCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.callback = callback2;
        GiftPackageManager giftPackageManager = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        giftPackageManager.mPackMap = object;
        giftPackageManager = this;
        bl = false;
        giftPackageManager.listeners = object = (List)new ArrayList();
        this.packageCount = -1;
        this.diamondBalanceCache = -1L;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/wallet/gift/ui/pannel/giftpackage/GiftPackageManager$Companion;", "", "()V", "TAG", "", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

