/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.adapter;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Color;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import biz.SourceEntry;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.account.AccountRelatedSetting;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.wallet.DR;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IRedPacketService;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketHandler;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelContract;
import com.yy.hiyo.wallet.gift.ui.pannel.act.GiftItemActExpandInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.GiftItemViewType;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.IGiftItemAdapter;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.ActBannerGiftInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.GiftPanelItemInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.holder.BannerHolder;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.holder.BaseGiftVH;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.holder.MyViewHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GiftItemAdapter
extends RecyclerView.Adapter<BaseGiftVH>
implements IGiftItemAdapter {
    public static final String TAG = "GiftItemAdapter";
    private static final int FREE_GIFT_HEART_ID = 18020011;
    public static long FIVE_DAY = 432000L;
    private Context mContext;
    private List<GiftPanelItemInfo> mGiftList;
    private OnGiftItemCallback mGiftItemCallback;
    private BubblePopupWindow mRedPocketGuide;
    private BubblePopupWindow mCoinGiftGuide;
    private GiftPanelContract.View mView;
    private MyViewHolder mRedPocketHolder;
    private MyViewHolder mAppearViewHolder;
    private boolean isVideo = false;
    private String mRoomId;
    private int roomMode;
    private int mSelectedIndex = -1;
    private int mAnimateGiftId = 0;
    private int mRedPocketIndex;
    private boolean mIsShow;
    private boolean mCanShowGuide;
    private boolean mHasGuideShown;
    private long lastRefreshTime = 0L;
    private boolean checkGift = false;
    private String tabType = "0";
    private boolean mIsAppearAnimated = false;
    private boolean isHasBanner = false;
    private boolean isFirstShow = false;

    public GiftItemAdapter(Context context, GiftPanelContract.View view, String tabType) {
        this.mView = view;
        this.tabType = tabType;
        this.mContext = context;
        this.initCoinsGiftGuide();
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void setData(List<GiftPanelItemInfo> list) {
        if (this.mGiftList == null) {
            this.mGiftList = new ArrayList<GiftPanelItemInfo>();
        }
        this.mGiftList.clear();
        if (list != null) {
            this.mGiftList.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        if (!FP.empty(this.mGiftList)) {
            return this.mGiftList.size();
        }
        return 0;
    }

    public int getItemViewType(int position) {
        return this.mGiftList.get(position).getViewType().getType();
    }

    public void setOnClickListener(OnGiftItemCallback listener) {
        this.mGiftItemCallback = listener;
    }

    @NonNull
    public BaseGiftVH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == GiftItemViewType.BANNER_ITEM.getType()) {
            this.isHasBanner = true;
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_gift_banner_view, parent, false);
            return new BannerHolder(view);
        }
        int layoutId = R.layout.item_gift;
        if (this.tabType.equals("packet")) {
            layoutId = R.layout.item_packet_gift;
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
        return new MyViewHolder(view);
    }

    public void onShow(List<GiftPanelItemInfo> list) {
        if (this.mIsShow) {
            MLog.debug((Object)TAG, (String)"onShow return mIsShow already is true tabType %s", (Object[])new Object[]{this.tabType});
            return;
        }
        if (this.isHasBanner) {
            this.bannerShow(this.tabType, this.roomMode);
        }
        this.setData(list);
        MLog.debug((Object)TAG, (String)"onShow tabType %s", (Object[])new Object[]{this.tabType});
        if ("packet".equals(this.tabType) && this.mGiftList != null) {
            for (GiftPanelItemInfo giftPanelItemInfo : this.mGiftList) {
                long expireTime = giftPanelItemInfo.getGiftInfo().getExpireDate();
                if (giftPanelItemInfo.getGiftInfo().getExpireCount() <= 0 || expireTime <= 0L || expireTime >= this.getExpireShowMinTime()) continue;
                GiftHiidoReport.giftExpireShow(String.valueOf(giftPanelItemInfo.getPropsId()), String.valueOf(expireTime));
                MLog.debug((Object)TAG, (String)"onShow expireTime %s", (Object[])new Object[]{expireTime});
            }
        }
        this.mIsShow = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GiftItemAdapter.this.mIsShow && GiftItemAdapter.this.mCanShowGuide && !GiftItemAdapter.this.mHasGuideShown) {
                    GiftItemAdapter.this.showRedPocketGuide(GiftItemAdapter.this.mRedPocketHolder, GiftItemAdapter.this.mRedPocketIndex);
                }
                GiftItemAdapter.this.showSelectedAppearAnim();
            }
        }, (long)300L);
    }

    private long getExpireShowMinTime() {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig) {
            return ((CommonConfig)config).getData().giftExpireMinTime;
        }
        return FIVE_DAY;
    }

    public void bannerShow(String actId, int roomType) {
        if (this.mGiftItemCallback != null) {
            this.isFirstShow = this.mGiftItemCallback.isFirstBannerShow(actId);
        }
        MLog.debug((Object)TAG, (String)"bannerShow %s, %s , %s", (Object[])new Object[]{actId, roomType, this.isFirstShow});
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60129245").put("function_id", "privilege_center_bubble_show").put("activity_id", actId).put("banner_source", this.isFirstShow ? "0" : "1").put("room_type", roomType + "").put("is_video", this.isVideo ? "1" : "0"));
    }

    public void onHide() {
        this.mIsShow = false;
    }

    public void onViewAttachedToWindow(@NonNull BaseGiftVH holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        if (this.mGiftList != null) {
            GiftPanelItemInfo giftInfo = this.mGiftList.get(holder.getAdapterPosition());
            long time = System.currentTimeMillis();
            if (giftInfo != null && giftInfo.getType() == 1000 && time - this.lastRefreshTime > 1000L) {
                this.lastRefreshTime = time;
                GiftHiidoReport.redPacketShow(this.mRoomId);
            }
        }
    }

    public void onBindViewHolder(@NonNull BaseGiftVH holder, int position) {
        holder.bindView(this.mGiftList.get(position), this.tabType, this.mGiftItemCallback, this.mView, this.mCoinGiftGuide, this.mRoomId, this, position, this.mSelectedIndex, this.checkGift);
    }

    @Override
    public void setRedPocketGuide(final MyViewHolder holder, final int position) {
        this.mCanShowGuide = true;
        this.mRedPocketHolder = holder;
        this.mRedPocketIndex = position;
        if (this.mIsShow && this.mCanShowGuide && !this.mHasGuideShown) {
            YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GiftItemAdapter.this.showRedPocketGuide(holder, position);
                }
            });
        }
    }

    @Override
    public boolean isFirstBannerShow() {
        return this.isFirstShow;
    }

    @Override
    public void updateAppearView(@NotNull MyViewHolder holder, int giftId) {
        this.mAppearViewHolder = holder;
        this.mAnimateGiftId = giftId;
    }

    private void showSelectedAppearAnim() {
        boolean canShow;
        boolean bl = this.mAnimateGiftId == 0 ? false : (canShow = !AccountRelatedSetting.getInstance().getBoolean("key_special_gift_show_animation_show" + this.mAnimateGiftId, false));
        if (this.mView.getFrom() == 13 && this.mAppearViewHolder != null && !this.mIsAppearAnimated && canShow) {
            this.mIsAppearAnimated = true;
            AccountRelatedSetting.getInstance().putBoolean("key_special_gift_show_animation_show" + this.mAnimateGiftId, true);
            ViewGroup container = (ViewGroup)this.mAppearViewHolder.itemView;
            int childCount = container.getChildCount();
            final ArrayList<View> contentViews = new ArrayList<View>();
            for (int i = 0; i < childCount; ++i) {
                View child = container.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                child.setVisibility(8);
                contentViews.add(child);
            }
            ObjectAnimator frameAnimExpandX = ObjectAnimator.ofFloat((Object)this.mAppearViewHolder.itemView, (Property)View.SCALE_X, (float[])new float[]{0.5f, 1.0f});
            ObjectAnimator frameAnimExpandY = ObjectAnimator.ofFloat((Object)this.mAppearViewHolder.itemView, (Property)View.SCALE_Y, (float[])new float[]{0.5f, 1.0f});
            ObjectAnimator frameAnimAlphaInit = ObjectAnimator.ofFloat((Object)this.mAppearViewHolder.itemView, (Property)View.ALPHA, (float[])new float[]{0.2f, 0.5f});
            AnimatorSet frameAnimSet = new AnimatorSet();
            frameAnimSet.setDuration(500L);
            frameAnimSet.play((Animator)frameAnimExpandX).with((Animator)frameAnimExpandY).with((Animator)frameAnimAlphaInit);
            ObjectAnimator frameAnimAlphaFinal = ObjectAnimator.ofFloat((Object)this.mAppearViewHolder.itemView, (Property)View.ALPHA, (float[])new float[]{0.5f, 1.0f});
            frameAnimAlphaFinal.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    for (View view : contentViews) {
                        view.setVisibility(0);
                    }
                }
            });
            frameAnimAlphaFinal.setDuration(500L);
            ObjectAnimator giftIconAnimX = ObjectAnimator.ofFloat((Object)this.mAppearViewHolder.mRivGiftImg, (Property)View.SCALE_X, (float[])new float[]{0.0f, 0.4f, 0.8f, 1.2f, 1.0f});
            giftIconAnimX.setDuration(700L);
            ObjectAnimator giftIconAnimY = ObjectAnimator.ofFloat((Object)this.mAppearViewHolder.mRivGiftImg, (Property)View.SCALE_Y, (float[])new float[]{0.0f, 0.4f, 0.8f, 1.2f, 1.0f});
            giftIconAnimY.setDuration(700L);
            final AnimatorSet giftIconAnimSet = new AnimatorSet();
            giftIconAnimSet.play((Animator)giftIconAnimY).with((Animator)giftIconAnimX).with((Animator)frameAnimAlphaFinal).after((Animator)frameAnimSet);
            if (this.mAppearViewHolder.mSVGAImageView != null) {
                this.mAppearViewHolder.mSVGAImageView.setCallback(new SVGACallback(){

                    public void onPause() {
                    }

                    public void onFinished() {
                        GiftItemAdapter.this.mIsAppearAnimated = false;
                        GiftItemAdapter.this.mAppearViewHolder = null;
                        GiftItemAdapter.this.mAnimateGiftId = 0;
                    }

                    public void onRepeat() {
                    }

                    public void onStep(int i, double v) {
                    }
                });
                this.mAppearViewHolder.mSVGAImageView.setLoops(1);
                DyResLoader.INSTANCE.loadSvga(this.mAppearViewHolder.mSVGAImageView, DR.gift_appear_halo, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        giftIconAnimSet.start();
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((GiftItemAdapter)GiftItemAdapter.this).mAppearViewHolder.mSVGAImageView.startAnimation();
                            }
                        }, (long)500L);
                        ((GiftItemAdapter)GiftItemAdapter.this).mAppearViewHolder.itemView.setVisibility(0);
                        GiftItemAdapter.this.reportForGameExitRecommend();
                    }

                    public void onFailed(Exception e) {
                    }
                });
            }
        } else if (this.mAppearViewHolder != null && this.mAppearViewHolder.itemView != null) {
            this.mAppearViewHolder.itemView.setVisibility(0);
        }
    }

    private void reportForGameExitRecommend() {
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel();
        if (channel != null && channel.getEnterParam() != null && channel.getEnterParam().entry == SourceEntry.SE_GAME_EXIT_POPUP_NEW_USER.getValue()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "get_free_gift_show"));
        }
    }

    private void initRedPocketGuide() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_red_pocket_guide, null);
        BubbleStyle bubbleStyle = (BubbleStyle)view.findViewById(R.id.bfl_root);
        bubbleStyle.setFillColor(Color.parseColor((String)"#f959cb31"));
        bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mRedPocketGuide = new BubblePopupWindow(view, bubbleStyle);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GiftHiidoReport.redPacketExplainClick(GiftItemAdapter.this.mRoomId);
                IRedPacketHandler handler = ((IRedPacketService)ServiceManagerProxy.getServiceManager().getService(IRedPacketService.class)).getHandler(GiftItemAdapter.this.mRoomId);
                if (GiftItemAdapter.this.mRedPocketGuide != null) {
                    GiftItemAdapter.this.mRedPocketGuide.dismiss();
                }
                if (GiftItemAdapter.this.mGiftItemCallback != null) {
                    GiftItemAdapter.this.mGiftItemCallback.hidePanel();
                }
                if (handler != null) {
                    handler.showRedPacket();
                }
            }
        });
    }

    private void initCoinsGiftGuide() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_coins_gift_guide, null);
        BubbleStyle bubbleStyle = (BubbleStyle)view.findViewById(R.id.ll_root);
        bubbleStyle.setFillColor(Color.parseColor((String)"#24bdf9"));
        bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mCoinGiftGuide = new BubblePopupWindow(view, bubbleStyle);
    }

    private void showRedPocketGuide(MyViewHolder holder, int position) {
        if (holder == null) {
            return;
        }
        int[] location = new int[2];
        holder.itemView.getLocationInWindow(location);
        if (location[0] > 0 || location[1] > 0) {
            this.initRedPocketGuide();
            boolean canShow = SettingFlags.getBoolean((String)"key_red_pocket_entrance_guide_show", (boolean)true);
            if (this.mView != null && !this.mView.isShowWithoutAnim()) {
                return;
            }
            int margin = ResolutionUtils.dip2Px((float)7.0f);
            if (canShow && !this.mRedPocketGuide.isShowing() && !this.mCoinGiftGuide.isShowing()) {
                if (position <= 3) {
                    this.mRedPocketGuide.showArrowTo(holder.itemView, BubbleStyle.ArrowDirection.Up, margin);
                } else {
                    this.mRedPocketGuide.showArrowTo(holder.itemView, BubbleStyle.ArrowDirection.Down, margin);
                }
                SettingFlags.setBoolean((String)"key_red_pocket_entrance_guide_show", (boolean)false);
                this.mHasGuideShown = true;
                GiftHiidoReport.redPacketExplainShow(this.mRoomId);
            }
        }
    }

    public void setRoomMode(int roomMode) {
        this.roomMode = roomMode;
    }

    public void isVideo(boolean video) {
        this.isVideo = video;
    }

    public static interface OnGiftItemCallback {
        public GiftItemActExpandInfo getActGiftInfo(GiftPanelItemInfo var1);

        public void hidePanel();

        public void onClickGift(GiftPanelItemInfo var1);

        public void onClickBanner(ActBannerGiftInfo var1, boolean var2);

        public void updateSelectHolder(MyViewHolder var1);

        public boolean isFirstBannerShow(String var1);
    }
}

