/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.luckygift;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.gift.LuckyGiftyNotifyType;
import com.yy.hiyo.wallet.gift.data.bean.LuckyGiftBroadcastInfo;
import com.yy.hiyo.wallet.gift.data.bean.LuckyGiftUnicastInfo;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerCallback;
import com.yy.hiyo.wallet.gift.ui.luckygift.LuckyGiftContract;
import com.yy.hiyo.wallet.gift.ui.luckygift.LuckyGiftOperator;
import com.yy.hiyo.wallet.gift.ui.luckygift.LuckyGiftView;
import java.util.ArrayList;
import java.util.List;

public class LuckyGiftPresenter
implements LuckyGiftContract.Presenter,
LuckyGiftOperator {
    private GiftHandlerParam mHandlerParam;
    private IGiftHandlerCallback mHandlerCallback;
    private ViewGroup mLayer;
    private LuckyGiftContract.View mView;
    private List<LuckyGiftUnicastInfo> mUnicastInfoList;
    private List<LuckyGiftBroadcastInfo> mBroadcastInfoList;

    public LuckyGiftPresenter(@NonNull ViewGroup layer, @NonNull IGiftHandlerCallback handlerCallback, @NonNull GiftHandlerParam handlerParam) {
        this.mLayer = layer;
        this.mHandlerParam = handlerParam;
        this.mHandlerCallback = handlerCallback;
        this.mUnicastInfoList = new ArrayList<LuckyGiftUnicastInfo>();
        this.mBroadcastInfoList = new ArrayList<LuckyGiftBroadcastInfo>();
        if (this.mView == null) {
            this.mView = new LuckyGiftView(this.mLayer);
            this.mView.setPresenter(this);
        }
    }

    public void start() {
    }

    @Override
    public void onPause() {
        FeatureLog.i((String)"FTLuckyGift", (String)"onPause", (Object[])new Object[0]);
        this.clear();
    }

    @Override
    public void onDestroy() {
        FeatureLog.i((String)"FTLuckyGift", (String)"onDestroy", (Object[])new Object[0]);
        this.clear();
    }

    private void clear() {
        this.mUnicastInfoList.clear();
        this.mBroadcastInfoList.clear();
        if (this.mView != null) {
            this.mView.clearView();
            this.mView = null;
        }
    }

    @Override
    public void setLuckyGiftCurrentWinInfo(LuckyGiftUnicastInfo info) {
        FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftCurrentWinInfo : info = %s", (Object[])new Object[]{info});
        if (info != null && this.mView != null) {
            if (info.getType() == LuckyGiftyNotifyType.PERIOD) {
                if (this.mView.isPrizePoolWinShowing()) {
                    this.mUnicastInfoList.add(info);
                    FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftCurrentWinInfo : prize pool win is showing, so cache info", (Object[])new Object[0]);
                } else {
                    this.mView.showCurUserWin(info);
                    FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftCurrentWinInfo : show prize pool win", (Object[])new Object[0]);
                }
            } else if (info.getType() == LuckyGiftyNotifyType.INSTANT) {
                this.mView.showCurUserWin(info);
                FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftCurrentWinInfo : show win toast", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void setLuckyGiftRoomWinInfo(LuckyGiftBroadcastInfo info) {
        FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftRoomWinInfo : info = %s", (Object[])new Object[]{info});
        if (info != null && this.mView != null) {
            if (this.mView.isWinBroadcastShowing()) {
                this.mBroadcastInfoList.add(info);
                FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftRoomWinInfo : win broadcast is showing, so cache info", (Object[])new Object[0]);
            } else {
                this.mView.showWinBroadcast(info);
                FeatureLog.i((String)"FTLuckyGift", (String)"setLuckyGiftRoomWinInfo : show win broadcast", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onPrizePoolWinHide() {
        if (!FP.empty(this.mUnicastInfoList)) {
            FeatureLog.i((String)"FTLuckyGift", (String)"onPrizePoolWinHide : last prize pool win is hidden, show next", (Object[])new Object[0]);
            LuckyGiftUnicastInfo info = this.mUnicastInfoList.remove(0);
            if (info != null) {
                this.setLuckyGiftCurrentWinInfo(info);
            }
        }
    }

    @Override
    public void onWinBroadcastHide() {
        if (!FP.empty(this.mBroadcastInfoList)) {
            FeatureLog.i((String)"FTLuckyGift", (String)"onWinBroadcastHide : last win broadcast is hidden, show next", (Object[])new Object[0]);
            LuckyGiftBroadcastInfo info = this.mBroadcastInfoList.remove(0);
            if (info != null) {
                this.setLuckyGiftRoomWinInfo(info);
            }
        }
    }

    @Override
    public GiftItemInfo getGiftInfo(int propId) {
        return this.mHandlerCallback.findGiftById(propId, this.mHandlerParam.getChannelId());
    }
}

