/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.flash;

import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.hiyo.channel.base.bean.GfConfigItem;
import com.yy.hiyo.channel.base.service.IGfPrivilegeService;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.gift.ui.flash.GiftFlashAnimHelper;
import com.yy.hiyo.wallet.gift.ui.flash.IBaseFlashView;
import com.yy.hiyo.wallet.gift.ui.flash.IFlashPresenterCallback;
import com.yy.hiyo.wallet.gift.ui.flash.IGiftAnimatorPresenter;
import com.yy.hiyo.wallet.gift.ui.flash.IGiftFlashViewCallBack;
import com.yy.hiyo.wallet.gift.ui.flash.MyComboFlashView;
import com.yy.hiyo.wallet.gift.ui.flash.NewGiftFlashView;
import com.yy.hiyo.wallet.gift.ui.flash.combotv.GiftFlashComboView;
import com.yy.hiyo.wallet.gift.utils.GiftComboUtils;
import java.util.ArrayList;
import java.util.List;

public class GiftAnimatorPresent
implements IGiftFlashViewCallBack,
IGiftAnimatorPresenter {
    private static final String TAG = "GiftAnimatorPresent";
    private ViewGroup mRootView;
    private IBaseFlashView mGiftFlashView;
    private IBaseFlashView mComboFlashView;
    private IBaseFlashView mNormalFlashView;
    private IFlashPresenterCallback mPresenterCallback;
    private boolean isAnimShow = false;
    private boolean isCombo = false;
    private boolean isFirst = false;
    private SpannableStringBuilder spannableNum;
    private SpannableStringBuilder spannableCombo;
    private SpannableStringBuilder spannableComboNum;
    private int marginLeft = 0;
    private int marginTop = 0;
    private GiftFlashComboView flashComboView;
    private Runnable mFlashStayRunnable = new Runnable(){

        @Override
        public void run() {
            if (GiftAnimatorPresent.this.mGiftFlashView != null) {
                GiftAnimatorPresent.this.mGiftFlashView.startExitAnim();
            }
        }
    };

    public GiftAnimatorPresent(ViewGroup rootView2, int left, int top, IFlashPresenterCallback callback2, boolean isFirst) {
        this.mRootView = rootView2;
        this.mPresenterCallback = callback2;
        this.isFirst = isFirst;
        this.marginTop = top;
        this.marginLeft = left;
        this.bindView();
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    private void bindView() {
        this.mNormalFlashView = new NewGiftFlashView(this, this.mRootView.getContext(), this.marginLeft, this.marginTop);
        this.mComboFlashView = new MyComboFlashView(this, this.mRootView.getContext(), this.marginLeft, this.marginTop);
    }

    @Override
    public void addGiftEffect(@NonNull GiftBroResult result) {
        this.addGiftEffect(result, null);
    }

    @Override
    public void destroy() {
        this.mRootView.removeAllViews();
        YYTaskExecutor.removeTask((Runnable)this.mFlashStayRunnable);
        this.mNormalFlashView = null;
        this.mComboFlashView = null;
    }

    @Override
    public void addGiftEffect(@NonNull GiftBroResult info, GiftItemInfo randomBoxInfo) {
        MLog.info((Object)TAG, (String)"onGiftComboInfoChanged info: %s", (Object[])new Object[]{info});
        GiftComboInfo combo = info.getGiftComboInfo();
        GiftBroadcastInfo bro = info.getGiftBroInfo();
        if (combo == null || bro == null) {
            return;
        }
        int comboCount = combo.getComboHits();
        if (info.needShow(4) || randomBoxInfo != null) {
            this.spannableCombo = null;
            this.spannableNum = null;
            this.spannableComboNum = null;
            if (combo.getIsFinishCombo()) {
                MLog.info((Object)TAG, (String)"onGiftComboInfoChanged isFinishCombo = true", (Object[])new Object[0]);
                if (!this.isAnimShow) {
                    this.mPresenterCallback.finish(this);
                }
                return;
            }
            if (comboCount > 1) {
                this.spannableCombo = GiftComboUtils.INSTANCE.getGiftNumSpannable(String.valueOf(comboCount), 1);
                this.spannableComboNum = GiftComboUtils.INSTANCE.getGiftNumSpannable(String.valueOf(comboCount), 4);
                this.spannableNum = GiftComboUtils.INSTANCE.getGiftNumSpannable(String.valueOf(bro.getPropsCount()), 3);
            } else if (bro.getPropsCount() != 0) {
                this.spannableCombo = GiftComboUtils.INSTANCE.getGiftNumSpannable(String.valueOf(info.getGiftBroInfo().getPropsCount()), 2);
            }
            this.playGiftAnim(info, randomBoxInfo);
        }
    }

    public boolean isIdle() {
        return !this.isAnimShow;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isCombo() {
        MLog.info((Object)TAG, (String)"isCombo =%s", (Object[])new Object[]{this.isCombo});
        return this.isCombo && this.mGiftFlashView instanceof MyComboFlashView;
    }

    public void onFlashLocationChanged(int left, int top) {
        this.marginLeft = left;
        if (top > 0) {
            this.marginTop = top;
            if (this.mNormalFlashView != null) {
                this.mNormalFlashView.updateLocation(left, this.marginTop);
            }
            if (this.mComboFlashView != null) {
                this.mComboFlashView.updateLocation(left, this.marginTop);
            }
        }
    }

    public void playGiftAnim(GiftBroResult info, GiftItemInfo randomBoxInfo) {
        MLog.info((Object)TAG, (String)"playGiftAnim", (Object[])new Object[0]);
        if (this.isAnimShow && !this.isCombo) {
            MLog.error((Object)TAG, (String)"flashAnimatorShow is true ,return", (Object[])new Object[0]);
            return;
        }
        RecycleImageView sweepImg = new RecycleImageView(this.mRootView.getContext());
        if (LanguageUtils.isRtl()) {
            sweepImg.setRotationY(180.0f);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, DpToPxDef.RESOLUTION_40_DP);
        params.setMarginStart(DpToPxDef.RESOLUTION_180_DP);
        sweepImg.setLayoutParams((ViewGroup.LayoutParams)params);
        if (this.flashComboView != null) {
            this.flashComboView.startAlphaAnim();
        }
        this.flashComboView = new GiftFlashComboView(this.mRootView.getContext(), this.getAnimHelper());
        this.mGiftFlashView = info.isMyself() ? this.mComboFlashView : this.mNormalFlashView;
        this.mGiftFlashView.updateView(this.spannableNum, this.spannableCombo, this.spannableComboNum, info, randomBoxInfo, sweepImg, this.flashComboView);
        this.isAnimShow = true;
        this.mRootView.removeView((View)this.mGiftFlashView);
        this.mRootView.addView((View)this.mGiftFlashView);
        this.mGiftFlashView.startEnterAnim(info, randomBoxInfo, sweepImg, this.flashComboView);
    }

    @Override
    public void removeStayRunnable(long exitDelay) {
        YYTaskExecutor.removeTask((Runnable)this.mFlashStayRunnable);
        YYTaskExecutor.postToMainThread((Runnable)this.mFlashStayRunnable, (long)exitDelay);
    }

    @Override
    public void removeGiftAnim(boolean isCombo) {
        MLog.info((Object)TAG, (String)"removeGiftAnim", (Object[])new Object[0]);
        YYTaskExecutor.removeTask((Runnable)this.mFlashStayRunnable);
        if (this.flashComboView != null) {
            this.flashComboView = null;
        }
        if (this.mGiftFlashView != null) {
            ((View)this.mGiftFlashView).setVisibility(8);
            this.mRootView.removeView((View)this.mGiftFlashView);
            this.isAnimShow = false;
            if (this.mPresenterCallback != null) {
                if (isCombo) {
                    this.mPresenterCallback.finishCombo(this);
                } else {
                    this.mPresenterCallback.finish(this);
                }
            }
        }
    }

    @Override
    public void pauseCombo() {
        this.isCombo = false;
    }

    @Override
    public void nextCombo() {
        this.isCombo = true;
        if (this.mGiftFlashView != null && this.mPresenterCallback != null) {
            this.mPresenterCallback.finish(this);
        }
    }

    @Override
    public void giftSvgaEnd(GiftBroResult giftBroResult) {
        if (this.mPresenterCallback != null && giftBroResult != null) {
            if (giftBroResult.needShow(8)) {
                this.mPresenterCallback.addBigEffectView(giftBroResult);
            } else {
                this.mPresenterCallback.addFlyMicView(giftBroResult, this.getMarginTop());
            }
        }
    }

    @Override
    @NonNull
    public GiftFlashAnimHelper getAnimHelper() {
        return this.mPresenterCallback.getAnimHelper();
    }

    @Override
    public GfConfigItem getGFConfigByUid(List<GiftBroUserInfo> recyUser, long amount) {
        IGfPrivilegeService service = (IGfPrivilegeService)ServiceManagerProxy.getService(IGfPrivilegeService.class);
        if (service != null) {
            ArrayList<GfConfigItem> gfConfigItems = new ArrayList<GfConfigItem>();
            for (GiftBroUserInfo userInfo : recyUser) {
                GfConfigItem item = service.getGFConfigByUid(userInfo.getUid(), amount);
                if (item == null) continue;
                gfConfigItems.add(item);
            }
            return gfConfigItems.size() > 0 ? (GfConfigItem)gfConfigItems.get(0) : null;
        }
        return null;
    }
}

