/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.bigeffect;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.resource.file.ResInfo;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.gift.ui.bigeffect.BigEffectPlayInfo;
import com.yy.hiyo.wallet.gift.ui.bigeffect.IBigEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.bigeffect.IBigEffectView;
import com.yy.hiyo.wallet.gift.ui.bigeffect.ReplaceSvgaInfo;
import com.yy.hiyo.wallet.gift.ui.bigeffect.SvgaLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BigEffectView
extends YYFrameLayout
implements IBigEffectView {
    private static String TAG = "BigEffectView";
    private View containerView;
    private SVGAImageView svgaImageView;
    private CircleImageView senderHeader;
    private CircleImageView receiverHeader;
    private CircleImageView receiverHeader2;
    private CircleImageView receiverHeader3;
    private ViewGroup receiverHeaderLayout;
    private TextView senderNick;
    private TextView receiverNick;
    private TextView count;
    private RecycleImageView giftIcon;
    private SvgaLocation mSmallLocation;
    private SvgaLocation mBigLocation;
    private SvgaLocation mFullScreenLocation;
    private RecycleImageView bannerBgImg;
    private List<CircleImageView> receiverViews = new ArrayList<CircleImageView>();
    private IBigEffectPresenter iPresenter;

    public BigEffectView(Context context) {
        super(context);
        this.createView(context);
    }

    public BigEffectView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public BigEffectView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_big_effect, (ViewGroup)this);
        this.containerView = this.findViewById(R.id.top_container);
        this.svgaImageView = (SVGAImageView)this.findViewById(R.id.big_effect_svga);
        this.senderHeader = (CircleImageView)this.findViewById(R.id.header_sender);
        this.receiverHeader = (CircleImageView)this.findViewById(R.id.header_receiver);
        this.receiverHeader2 = (CircleImageView)this.findViewById(R.id.header_receiver2);
        this.receiverHeader3 = (CircleImageView)this.findViewById(R.id.header_receiver3);
        this.receiverHeaderLayout = (ViewGroup)this.findViewById(R.id.header_receiver_layout);
        this.senderNick = (TextView)this.findViewById(R.id.nick_sender);
        this.receiverNick = (TextView)this.findViewById(R.id.nick_receiver);
        this.count = (TextView)this.findViewById(R.id.count);
        this.bannerBgImg = (RecycleImageView)this.findViewById(R.id.banner_bg);
        this.giftIcon = (RecycleImageView)this.findViewById(R.id.gift_icon);
        this.receiverViews.add(this.receiverHeader);
        this.receiverViews.add(this.receiverHeader2);
        this.receiverViews.add(this.receiverHeader3);
        this.svgaImageView.setLoops(1);
        this.svgaImageView.setCallback(new SVGACallback(){

            public void onPause() {
            }

            public void onFinished() {
                if (BigEffectView.this.iPresenter != null) {
                    BigEffectView.this.iPresenter.onPlayFinish();
                }
            }

            public void onRepeat() {
            }

            public void onStep(int i, double v) {
            }
        });
    }

    @Override
    public void setPresenter(IBigEffectPresenter iPresenter) {
        this.iPresenter = iPresenter;
    }

    private void initFamilyGiftStyle(BigEffectPlayInfo playInfo) {
        if (!FP.empty((CharSequence)playInfo.familyName) && !FP.empty((CharSequence)playInfo.familyLvIcon)) {
            ViewGroup mFamilyLayout = (ViewGroup)this.findViewById(R.id.familyLayout);
            TextView mFamilyNameTv = (TextView)this.findViewById(R.id.familyNameTv);
            RecycleImageView mFamilyLvIv = (RecycleImageView)this.findViewById(R.id.familyLvIv);
            mFamilyLayout.setVisibility(0);
            this.receiverHeaderLayout.setVisibility(8);
            mFamilyNameTv.setText((CharSequence)ShortNameUtils.getShortNameWithoutColon((String)playInfo.familyName, (int)6));
            ImageLoader.loadImage((ImageView)mFamilyLvIv, (String)(playInfo.familyLvIcon + YYImageUtils.getThumbnailPostfix((int)75)));
        }
    }

    @Override
    public void start(BigEffectPlayInfo playInfo) {
        if (playInfo == null || TextUtils.isEmpty((CharSequence)playInfo.svgaUrl)) {
            if (this.iPresenter != null) {
                this.iPresenter.onPlayFinish();
            }
            MLog.error((Object)TAG, (String)"start return", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"start %s", (Object[])new Object[]{playInfo.svgaUrl});
        if (playInfo.type == 11) {
            this.initFamilyGiftStyle(playInfo);
        }
        this.senderNick.setText((CharSequence)playInfo.sendderNick);
        String recvNick = playInfo.receiverNick;
        if (playInfo.mRevUserInfos != null && playInfo.mRevUserInfos.size() > 1) {
            recvNick = ResourceUtils.getString((int)R.string.tips_recv_all);
        }
        this.receiverNick.setText((CharSequence)recvNick);
        this.count.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_gift_combo, (Object[])new Object[]{playInfo.propCount}));
        ImageLoader.loadImage((ImageView)this.giftIcon, (String)playInfo.giftIcon, (int)R.drawable.icon_gift_default);
        this.setHeaderIcon(playInfo.senderHeader, (RecycleImageView)this.senderHeader, playInfo.senderUid);
        if (playInfo.mRevUserInfos != null && playInfo.mRevUserInfos.size() > 0) {
            for (int i = 0; i < playInfo.mRevUserInfos.size(); ++i) {
                GiftBroUserInfo userInfo = playInfo.mRevUserInfos.get(i);
                if (userInfo == null) continue;
                long uid = userInfo.getUid();
                if (i >= this.receiverViews.size()) break;
                this.setHeaderIcon("", (RecycleImageView)this.receiverViews.get(i), uid);
                this.receiverViews.get(i).setVisibility(0);
            }
        }
        this.playSvga(playInfo);
    }

    @Override
    @NotNull
    public ViewGroup getContentView() {
        return this;
    }

    private void initBigLocation() {
        if (this.mBigLocation == null) {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)this.getContext());
            int screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
            this.mBigLocation = new SvgaLocation(this.iPresenter.isVideo() ? screenHeight - screenWidth : screenHeight - screenWidth - DpToPxDef.RESOLUTION_120_DP, screenWidth, screenWidth);
        }
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.svgaImageView.getLayoutParams();
        lp.width = this.mBigLocation.getWidth();
        lp.height = this.mBigLocation.getHeight();
        lp.topMargin = this.mBigLocation.getMarginTop();
        this.svgaImageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        FrameLayout.LayoutParams banner = (FrameLayout.LayoutParams)this.containerView.getLayoutParams();
        banner.topMargin = this.mBigLocation.getMarginTop() - DpToPxDef.RESOLUTION_40_DP;
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)banner);
    }

    private void initFullScreenLocation() {
        if (this.mFullScreenLocation == null) {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)this.getContext());
            int screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
            this.mFullScreenLocation = new SvgaLocation(0, screenWidth, screenHeight);
        }
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.svgaImageView.getLayoutParams();
        lp.width = this.mFullScreenLocation.getWidth();
        lp.height = this.mFullScreenLocation.getHeight();
        lp.topMargin = this.mFullScreenLocation.getMarginTop();
        this.svgaImageView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void initSmallLocation() {
        if (this.mSmallLocation == null) {
            this.mSmallLocation = new SvgaLocation(ResolutionUtils.dip2Px((float)140.0f), ResolutionUtils.dip2Px((float)200.0f), ResolutionUtils.dip2Px((float)130.0f));
        }
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.svgaImageView.getLayoutParams();
        lp.width = this.mSmallLocation.getWidth();
        lp.height = this.mSmallLocation.getHeight();
        lp.topMargin = this.mSmallLocation.getMarginTop();
        this.svgaImageView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void playSvga(final BigEffectPlayInfo playInfo) {
        int vis;
        String svgaUrl = playInfo.svgaUrl;
        int n = vis = playInfo.triggerFullBroadcast ? 8 : 0;
        if (playInfo.showType == 3) {
            this.initFullScreenLocation();
        } else if (playInfo.showType == 2) {
            vis = 8;
            this.initSmallLocation();
        } else if (playInfo.showType == 4) {
            ReplaceSvgaInfo mReplaceSvgaInfo;
            if (this.isReplaceKeySvga(playInfo)) {
                vis = 8;
            }
            if ((mReplaceSvgaInfo = playInfo.mReplaceSvgaInfo) != null && TextUtils.equals((CharSequence)"full", (CharSequence)mReplaceSvgaInfo.getSvgaSize())) {
                this.initFullScreenLocation();
            } else {
                this.initBigLocation();
            }
        } else {
            this.initBigLocation();
        }
        this.containerView.setVisibility(vis);
        if (!TextUtils.isEmpty((CharSequence)playInfo.svgaBannerUrl) && vis == 0) {
            ImageLoader.loadImage((ImageView)this.bannerBgImg, (String)playInfo.svgaBannerUrl);
        }
        ResInfo resInfo = new ResInfo(svgaUrl, "", null, -1L);
        ResPersistUtils.loadSvga((SVGAImageView)this.svgaImageView, (ResPersistUtils.Dir)ResPersistUtils.Dir.GIFT_SVGA, (ResInfo)resInfo, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (BigEffectView.this.isReplaceKeySvga(playInfo) || playInfo.type == 13) {
                    SVGADynamicEntity dynamicEntity = BigEffectView.this.getSvgaDynamicEntity(playInfo);
                    SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
                    BigEffectView.this.svgaImageView.setImageDrawable((Drawable)drawable2);
                }
                if (BigEffectView.this.svgaImageView != null) {
                    BigEffectView.this.svgaImageView.startAnimation();
                }
            }

            public void onFailed(Exception e) {
                MLog.error((Object)"BigEffectView", (Throwable)e);
                if (BigEffectView.this.iPresenter != null) {
                    BigEffectView.this.iPresenter.onPlayFinish();
                }
            }
        });
    }

    private boolean isReplaceKeySvga(BigEffectPlayInfo playInfo) {
        return playInfo.showType == 4 && playInfo.mReplaceSvgaInfo != null && playInfo.mReplaceSvgaInfo.getReplaceType() == 1;
    }

    private SVGADynamicEntity getSvgaDynamicEntity(BigEffectPlayInfo playInfo) {
        SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
        if (playInfo.propid == 18020033 || playInfo.propid == 18020034) {
            CharSequence receiverName = TextUtils.ellipsize((CharSequence)playInfo.receiverNick, (TextPaint)this.getNameTextPaint(), (float)ResolutionUtils.dip2Px((float)35.0f), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            CharSequence senderName = TextUtils.ellipsize((CharSequence)playInfo.sendderNick, (TextPaint)this.getNameTextPaint(), (float)ResolutionUtils.dip2Px((float)35.0f), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            String giftSlogan = playInfo.giftSlogan;
            if (StringUtils.isEmpty((String)giftSlogan)) {
                giftSlogan = ResourceUtils.getString((int)R.string.title_greeting_card_default_slogan);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.createStaticLayout(receiverName);
                dynamicEntity.setDynamicText(this.createStaticLayout(receiverName).build(), "name1");
                dynamicEntity.setDynamicText(this.createStaticLayout(senderName).build(), "name2");
            } else {
                dynamicEntity.setDynamicText(new StaticLayout(receiverName, 0, receiverName.length(), this.getNameTextPaint(), 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false), "name1");
                dynamicEntity.setDynamicText(new StaticLayout(senderName, 0, senderName.length(), this.getNameTextPaint(), 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false), "name2");
            }
            dynamicEntity.setDynamicText(new StaticLayout((CharSequence)giftSlogan, 0, giftSlogan.length(), this.getWishTextPaint(), 0, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false), "wishes");
            this.loadImage(playInfo.senderHeader + YYImageUtils.getCircleThumbnailPostfix((int)40), "head", dynamicEntity);
        } else if (this.isReplaceKeySvga(playInfo)) {
            this.addNormalText(dynamicEntity, ResourceUtils.getString((int)R.string.btn_gift_panel_send), "give", null);
            if (LanguageUtils.isRtl()) {
                this.loadHeaderSvga(Collections.singletonList(playInfo.senderUid), dynamicEntity, "recipient_profile", "recipient_nickname", playInfo.mReplaceSvgaInfo);
                this.loadHeaderSvga(Collections.singletonList(playInfo.receiverUid), dynamicEntity, "giver_profile", "giver_nickname", playInfo.mReplaceSvgaInfo);
            } else {
                this.loadHeaderSvga(Collections.singletonList(playInfo.receiverUid), dynamicEntity, "recipient_profile", "recipient_nickname", playInfo.mReplaceSvgaInfo);
                this.loadHeaderSvga(Collections.singletonList(playInfo.senderUid), dynamicEntity, "giver_profile", "giver_nickname", playInfo.mReplaceSvgaInfo);
            }
        }
        return dynamicEntity;
    }

    @SuppressLint(value={"NewApi"})
    private StaticLayout.Builder createStaticLayout(CharSequence receiverName) {
        return StaticLayout.Builder.obtain((CharSequence)receiverName, (int)0, (int)receiverName.length(), (TextPaint)this.getNameTextPaint(), (int)0).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(false).setMaxLines(1);
    }

    private void loadHeaderSvga(List<Long> uid, final SVGADynamicEntity dynamicEntity, final String key, final String nickKey, final ReplaceSvgaInfo replaceSvgaInfo) {
        if (ServiceManagerProxy.getServiceManager() == null || ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class) == null) {
            return;
        }
        IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class);
        final ArrayList<UserInfoKS> infoList = new ArrayList<UserInfoKS>();
        for (Long aUid : uid) {
            UserInfoKS userInfoKS = userInfoService.getUserInfo(aUid.longValue());
            if (userInfoKS.ver <= 0L) break;
            infoList.add(userInfoKS);
        }
        if (infoList.size() == uid.size()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserInfoKS userInfoBean = (UserInfoKS)infoList.get(0);
                    BigEffectView.this.loadImage(userInfoBean.avatar + YYImageUtils.getCircleThumbnailPostfix((int)40), key, dynamicEntity);
                    BigEffectView.this.addNormalText(dynamicEntity, userInfoBean.nick, nickKey, replaceSvgaInfo);
                }
            });
        } else {
            ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).requestUserInfosFromServer(uid, new OnKSProfileListCallback(){

                public void onUISuccess(@NonNull @NotNull List<UserInfoKS> userInfo) {
                    if (FP.empty(userInfo)) {
                        return;
                    }
                    UserInfoKS userInfoBean = userInfo.get(0);
                    BigEffectView.this.loadImage(userInfoBean.avatar + YYImageUtils.getCircleThumbnailPostfix((int)40), key, dynamicEntity);
                    BigEffectView.this.addNormalText(dynamicEntity, userInfoBean.nick, nickKey, replaceSvgaInfo);
                }

                public void onError(String reason, long code) {
                }
            });
        }
    }

    private void addNormalText(SVGADynamicEntity dynamicEntity, String text, String key, ReplaceSvgaInfo replaceSvgaInfo) {
        CharSequence charSequence = TextUtils.ellipsize((CharSequence)text, (TextPaint)this.getNormalTextPaint(replaceSvgaInfo), (float)ResolutionUtils.dip2Px((float)40.0f), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
        dynamicEntity.setDynamicText(new StaticLayout(charSequence, 0, charSequence.length(), this.getNormalTextPaint(replaceSvgaInfo), 0, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false), key);
    }

    private void loadImage(String url, final String key, final SVGADynamicEntity dynamicEntity) {
        ImageLoader.loadBitmap((Context)this.getContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                dynamicEntity.setDynamicImage(bitmap, key);
            }
        });
    }

    private TextPaint getNormalTextPaint(ReplaceSvgaInfo replaceSvgaInfo) {
        TextPaint textPaint = new TextPaint();
        if (replaceSvgaInfo != null && replaceSvgaInfo.getTextSzie() > 0) {
            textPaint.setTextSize((float)replaceSvgaInfo.getTextSzie());
        } else {
            textPaint.setTextSize(15.0f);
        }
        if (replaceSvgaInfo != null && !TextUtils.isEmpty((CharSequence)replaceSvgaInfo.getTextColor())) {
            textPaint.setColor(Color.parseColor((String)replaceSvgaInfo.getTextColor()));
        } else {
            textPaint.setColor(Color.parseColor((String)"#ffffff"));
        }
        return textPaint;
    }

    private TextPaint getNameTextPaint() {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(Color.parseColor((String)"#ffee93"));
        textPaint.setTextSize(20.0f);
        return textPaint;
    }

    private TextPaint getWishTextPaint() {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(Color.parseColor((String)"#ffee93"));
        textPaint.setTextSize(22.0f);
        Typeface font = Typeface.create((Typeface)Typeface.DEFAULT, (int)1);
        textPaint.setTypeface(font);
        return textPaint;
    }

    private void setHeaderIcon(String url, final RecycleImageView imageView, long uid) {
        if (uid <= 0L || ServiceManagerProxy.getServiceManager() == null || ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class) == null) {
            return;
        }
        final UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid);
        if (userInfoKS.ver > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ImageLoader.loadImage((ImageView)imageView, (String)userInfoKS.avatar, (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex));
                }
            });
        } else {
            ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).requestUserInfoFromServer(uid, new OnKSProfileListCallback(){

                public void onUISuccess(List<UserInfoKS> userInfo) {
                    if (FP.empty(userInfo)) {
                        return;
                    }
                    UserInfoKS use = userInfo.get(0);
                    ImageLoader.loadImage((ImageView)imageView, (String)use.avatar, (int)AvatarUtils.getDefaultAvatar((int)use.sex));
                }

                public void onError(String reason, long code) {
                }
            });
        }
    }
}

