/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.bigeffect;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.alphaplayer.AlphaVideoPlayer;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IComposeQueue;
import com.yy.hiyo.channel.base.service.IComposeTask;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IBigEffectGiftListener;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftBehavior;
import com.yy.hiyo.wallet.gift.effect.IEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.bigeffect.BigEffectPlayInfo;
import com.yy.hiyo.wallet.gift.ui.bigeffect.BigEffectVideoView;
import com.yy.hiyo.wallet.gift.ui.bigeffect.BigEffectView;
import com.yy.hiyo.wallet.gift.ui.bigeffect.GiftVideoInfo;
import com.yy.hiyo.wallet.gift.ui.bigeffect.IBigEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.bigeffect.IBigEffectView;
import com.yy.hiyo.wallet.gift.ui.bigeffect.ReplaceSvgaInfo;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class BigEffectPresenter
implements IEffectPresenter {
    private static final String TAG = "BigEffectPresenter";
    private ViewGroup mGiftLayer;
    private IBigEffectView mBigEffectView;
    private IGiftBehavior behavior;
    private IBigEffectGiftListener listener;
    private final Queue<BigEffectPlayInfo> mEffectQueue = new PriorityBlockingQueue<BigEffectPlayInfo>();
    private boolean pause = false;
    private boolean isDestroy = false;

    public BigEffectPresenter(ViewGroup rootView2, IGiftBehavior behavior, IBigEffectGiftListener bigEffectGiftListener) {
        this.mGiftLayer = rootView2;
        this.behavior = behavior;
        this.listener = bigEffectGiftListener;
    }

    @Override
    public void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        this.isDestroy = true;
        this.mEffectQueue.clear();
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mBigEffectView != null) {
                ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("big_effect");
            }
            this.removeView();
            this.mBigEffectView = null;
            this.mGiftLayer = null;
        });
    }

    @Override
    public void addGiftEffect(@NonNull GiftBroResult result) {
        HashMap map;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"addGiftEffect result: %s", (Object[])new Object[]{result});
        }
        if (result.isFinish()) {
            return;
        }
        GiftItemInfo giftInfo = result.getGiftInfo();
        if (result.needShow(8)) {
            String svga = giftInfo.getSvga();
            String fullScreenSvga = giftInfo.getFullScreenSvga();
            String replaceSvga = giftInfo.getReplaceSvga();
            String videoUrl = giftInfo.getVideo();
            String videoSize = giftInfo.getVideoSize();
            String videoReplaceSvga = giftInfo.getVideoReplaceSvga();
            GiftItemInfo.ReplaceConfig videoReplaceConfig = giftInfo.getVideoReplaceConfig();
            this.updateSvgaSize(result, giftInfo.getSvgaReplaceConfig(), svga, fullScreenSvga, replaceSvga, giftInfo.getTinySvga(), videoUrl, videoSize, videoReplaceSvga, videoReplaceConfig);
        }
        if (result.getGiftComboExpand() != null && !TextUtils.isEmpty((CharSequence)result.getGiftComboExpand().getTriggerEffectLevel()) && (map = giftInfo.getLevelMultipleSvgas()) != null) {
            MLog.debug((Object)TAG, (String)"addGiftEffect combSvga = %s", (Object[])new Object[]{((Object)map).toString()});
            GiftItemInfo.LevelMultipleSvgas levelMultipleSvgas = (GiftItemInfo.LevelMultipleSvgas)map.get(result.getGiftComboExpand().getTriggerEffectLevel());
            if (levelMultipleSvgas != null) {
                String svga = levelMultipleSvgas.getSvga();
                String fullScreenSvga = levelMultipleSvgas.getFullScreenSvga();
                String replaceSvga = levelMultipleSvgas.getReplaceSvga();
                String videoUrl = levelMultipleSvgas.getVideo();
                String videoSize = levelMultipleSvgas.getVideoSize();
                String videoReplaceSvga = giftInfo.getVideoReplaceSvga();
                GiftItemInfo.ReplaceConfig videoReplaceConfig = giftInfo.getVideoReplaceConfig();
                this.updateSvgaSize(result, levelMultipleSvgas.getReplaceConfig(), svga, fullScreenSvga, replaceSvga, "", videoUrl, videoSize, videoReplaceSvga, videoReplaceConfig);
            } else {
                MLog.error((Object)TAG, (String)"levelMultipleSvgas is null", (Object[])new Object[0]);
            }
        }
        this.next();
    }

    public void addLocalGiftEffect(GiftBroResult giftBroResult) {
        if (giftBroResult.getGiftInfo() != null) {
            GiftItemInfo.EffectResourceConfig cp = giftBroResult.getGiftInfo().getCpEffectResource();
            this.updateSvgaSize(giftBroResult, cp.getReplaceConfig(), cp.getSvga(), cp.getFullScreenSvga(), cp.getReplaceSvga(), "", cp.getVideo(), cp.getVideoSize(), cp.getVideoReplaceSvga(), cp.getVideoReplaceConfig());
            this.next();
        }
    }

    private void updateSvgaSize(GiftBroResult result, GiftItemInfo.ReplaceConfig replaceConfig, String svga, String fullScreenSvga, String replaceSvga, String tinySvga, String videoGiftUrl, String videoGiftSize, String videoReplaceSvga, GiftItemInfo.ReplaceConfig videoReplaceConfig) {
        GiftVideoInfo giftVideoInfo = null;
        if (!TextUtils.isEmpty((CharSequence)videoGiftUrl)) {
            giftVideoInfo = new GiftVideoInfo(videoGiftUrl, videoGiftSize, videoReplaceSvga, videoReplaceConfig);
        }
        ReplaceSvgaInfo mReplaceSvgaInfo = null;
        int showType = 1;
        if (!TextUtils.isEmpty((CharSequence)tinySvga)) {
            showType = 2;
            svga = tinySvga;
        }
        if (!TextUtils.isEmpty((CharSequence)fullScreenSvga)) {
            showType = 3;
            svga = fullScreenSvga;
        } else if (!TextUtils.isEmpty((CharSequence)replaceSvga)) {
            mReplaceSvgaInfo = this.parseReplaceSvga(replaceConfig, replaceSvga);
            showType = 4;
            svga = replaceSvga;
        }
        if (!(TextUtils.isEmpty((CharSequence)svga) && TextUtils.isEmpty((CharSequence)videoGiftUrl) || result.getGiftBroInfo().getRevUserInfos() == null)) {
            for (GiftBroUserInfo userInfo : result.getGiftBroInfo().getRevUserInfos()) {
                this.mEffectQueue.offer(new BigEffectPlayInfo(result, svga, showType, mReplaceSvgaInfo, userInfo.getUid(), userInfo.getNickName(), giftVideoInfo));
            }
        }
    }

    public void pauseSvgaQueue() {
        this.pause = true;
        MLog.info((Object)TAG, (String)"pauseSvgaQueue", (Object[])new Object[0]);
    }

    public void resumeSvgaQueue() {
        this.pause = false;
        MLog.info((Object)TAG, (String)"resumeSvgaQueue", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread(this::next);
    }

    private ReplaceSvgaInfo parseReplaceSvga(GiftItemInfo.ReplaceConfig replaceConfig, String replaceSvaga) {
        if (replaceConfig == null) {
            MLog.error((Object)TAG, (String)"parseReplaceSvga parse expand fail, for jo is null", (Object[])new Object[0]);
            return null;
        }
        return new ReplaceSvgaInfo(replaceConfig.getSvgaSize(), replaceConfig.getReplaceType(), replaceConfig.getTextColor(), replaceConfig.getTextSize(), replaceSvaga);
    }

    public boolean isPlayFinish() {
        return this.mEffectQueue.isEmpty() && this.mBigEffectView == null;
    }

    private void play(BigEffectPlayInfo playInfo, final Callback<Boolean> onFinished2) {
        if (this.mGiftLayer == null) {
            onFinished2.onResponse((Object)true);
            return;
        }
        if (playInfo == null) {
            onFinished2.onResponse((Object)true);
            return;
        }
        ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).startHighPerfScene("big_effect");
        this.mBigEffectView = playInfo != null && playInfo.giftVideoInfo != null && AlphaVideoPlayer.isSupport() ? new BigEffectVideoView(this.mGiftLayer.getContext()) : new BigEffectView(this.mGiftLayer.getContext());
        this.mBigEffectView.setPresenter(new IBigEffectPresenter(){

            @Override
            public void onPlayFinish() {
                YYTaskExecutor.postToMainThread(() -> {
                    ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).stopHighPerfScene("big_effect");
                    BigEffectPresenter.this.removeView();
                    onFinished2.onResponse((Object)true);
                });
            }

            @Override
            public boolean isVideo() {
                return BigEffectPresenter.this.behavior.getSubMode() == 2;
            }
        });
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.mGiftLayer.addView((View)this.mBigEffectView.getContentView(), lp);
        if (playInfo != null) {
            this.mBigEffectView.start(playInfo);
        }
        if (this.listener != null) {
            this.listener.onPlay();
        }
    }

    private void next() {
        if (this.isDestroy || FP.empty((CharSequence)RuntimeContext.getChannelId())) {
            MLog.error((Object)TAG, (String)"next isDestroy %s, cid %s", (Object[])new Object[]{this.isDestroy, RuntimeContext.getChannelId()});
            return;
        }
        if (this.mEffectQueue.isEmpty()) {
            if (this.listener != null) {
                this.listener.onFinish();
            }
            return;
        }
        if (this.mBigEffectView != null || this.pause) {
            return;
        }
        BigEffectPlayInfo playInfo = this.mEffectQueue.peek();
        if (playInfo != null && !FP.empty((CharSequence)RuntimeContext.getChannelId())) {
            String cid = RuntimeContext.getChannelId();
            IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(cid);
            if (channel == null) {
                this.next();
                return;
            }
            IComposeQueue queue = channel.getComposeQueue();
            queue.push(new IComposeTask(playInfo.senderUid == AccountUtil.getUid() ? -128 : 0){

                public void onExecute(@NonNull Function0<Unit> next) {
                    BigEffectPlayInfo info = (BigEffectPlayInfo)BigEffectPresenter.this.mEffectQueue.poll();
                    BigEffectPresenter.this.play(info, (Callback<Boolean>)data -> {
                        next.invoke();
                        BigEffectPresenter.this.next();
                    });
                }
            });
        } else {
            this.next();
        }
    }

    private void removeView() {
        if (this.mGiftLayer != null && this.mBigEffectView != null && this.mGiftLayer.indexOfChild((View)this.mBigEffectView.getContentView()) >= 0) {
            this.mGiftLayer.removeView((View)this.mBigEffectView.getContentView());
        }
        this.mBigEffectView = null;
    }
}

