/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.sdk;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftExpandInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftPushBroMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.IGiftListIntercept;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.gift.LoadGiftManager;
import com.yy.hiyo.wallet.gift.data.param.LoadGiftArgv;
import com.yy.hiyo.wallet.gift.data.param.LoadPackageArgv;
import com.yy.hiyo.wallet.gift.data.param.SendGiftArgv;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.gift.pack.PropsItem;
import com.yy.hiyo.wallet.gift.sdk.GiftBroadcast;
import com.yy.hiyo.wallet.gift.sdk.IGiftBroListener;
import com.yy.hiyo.wallet.gift.sdk.IGiftBroadcast;
import com.yy.hiyo.wallet.gift.sdk.IGiftPushBroListener;
import com.yy.hiyo.wallet.gift.sdk.IGiftSdk;
import com.yy.hiyo.wallet.gift.sdk.ISendGift;
import com.yy.hiyo.wallet.gift.sdk.MyLoadPackageGift;
import com.yy.hiyo.wallet.gift.sdk.MySendGiftRequest;
import com.yy.hiyo.wallet.gift.sdk.cache.GiftDiskCache;
import com.yy.hiyo.wallet.gift.statis.GiftMonitor;
import com.yy.hiyo.wallet.revenuesdk.RevenueSdkProxy;
import com.yy.mobile.framework.revenuesdk.gift.IGiftRequestCallback;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftJsonParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GiftSdkWrapper
implements IGiftSdk {
    private static final String TAG = "FTGiftGiftSdkWrapper";
    private ISendGift mSendGif;
    private final RevenueSdkProxy mRevenueProxy;
    private IGiftBroadcast mGiftBroadcast;
    private IGiftListIntercept mGiftListIntercept;
    private final Map<String, List<IGiftCallback<LoadGiftResult>>> mCache = new ConcurrentHashMap<String, List<IGiftCallback<LoadGiftResult>>>();
    private final Map<String, String> mChannelIdLastMd5Map = new ConcurrentHashMap<String, String>();

    public GiftSdkWrapper() {
        this.mRevenueProxy = RevenueSdkProxy.getInstance();
    }

    @Override
    public void loadGiftList(LoadGiftArgv argv, boolean isCacheEmpty, IGiftCallback<LoadGiftResult> callback2) {
        if (argv == null) {
            GiftUtils.callbackFailed(callback2, (int)10001, (String)"param is null");
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute(() -> this.asyncLoadGiftList(argv, isCacheEmpty, callback2));
        } else {
            this.asyncLoadGiftList(argv, isCacheEmpty, callback2);
        }
    }

    private void asyncLoadGiftList(LoadGiftArgv argv, boolean isCacheEmpty, IGiftCallback<LoadGiftResult> callback2) {
        String key = this.makeRequestKey(argv);
        MLog.info((Object)TAG, (String)("loadGiftList key " + key), (Object[])new Object[0]);
        if (this.filterDuplicate(key, callback2)) {
            return;
        }
        String channelId = argv.channelId + "";
        boolean liveCategoryId = false;
        GiftInfo giftInfo = this.findGiftInfoCache(isCacheEmpty, channelId, 0);
        String lastMd5Hash = giftInfo != null ? giftInfo.getMd5Version() : this.mChannelIdLastMd5Map.get(channelId) + "";
        LoadAllGiftJsonParam loadAllGiftParam = this.buildParam(argv, lastMd5Hash, 0);
        boolean isForceUpdate = giftInfo == null && isCacheEmpty;
        this.doLoadAllGiftData(loadAllGiftParam, key, giftInfo, isForceUpdate);
    }

    private String makeRequestKey(LoadGiftArgv argv) {
        if (argv == null) {
            return "";
        }
        return argv.uid + "_" + argv.anchorUid + "_" + argv.channelId + "_" + argv.countryCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filterDuplicate(String key, IGiftCallback<LoadGiftResult> callback2) {
        if (this.mCache.containsKey(key)) {
            List<IGiftCallback<LoadGiftResult>> list = this.mCache.get(key);
            Class<GiftSdkWrapper> clazz = GiftSdkWrapper.class;
            synchronized (GiftSdkWrapper.class) {
                if (list != null) {
                    list.add(callback2);
                    MLog.info((Object)TAG, (String)("gift list request is duplicate key " + key), (Object[])new Object[0]);
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        Class<GiftSdkWrapper> clazz = GiftSdkWrapper.class;
        synchronized (GiftSdkWrapper.class) {
            ArrayList<IGiftCallback<LoadGiftResult>> list = new ArrayList<IGiftCallback<LoadGiftResult>>(2);
            list.add(callback2);
            this.mCache.put(key, list);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return false;
        }
    }

    private GiftInfo findGiftInfoCache(boolean isCacheEmpty, String channelId, int liveCategoryId) {
        GiftInfo giftInfo = null;
        if (isCacheEmpty) {
            giftInfo = GiftDiskCache.getDiskGiftCache(channelId, liveCategoryId);
            MLog.info((Object)TAG, (String)("cache is empty, disk cache is " + giftInfo), (Object[])new Object[0]);
        }
        return giftInfo;
    }

    private LoadAllGiftJsonParam buildParam(LoadGiftArgv argv, String lastMd5Hash, int liveCategoryId) {
        LoadAllGiftJsonParam loadAllGiftParam = new LoadAllGiftJsonParam();
        loadAllGiftParam.appId = 1802;
        loadAllGiftParam.uid = argv.uid;
        loadAllGiftParam.recvUid = argv.anchorUid;
        loadAllGiftParam.channelId = argv.channelId;
        loadAllGiftParam.countryCode = argv.countryCode;
        loadAllGiftParam.filterPropsTypes = "";
        loadAllGiftParam.ssid = 0L;
        loadAllGiftParam.sid = 0L;
        loadAllGiftParam.liveCategoryId = liveCategoryId;
        loadAllGiftParam.clientVersion = "";
        loadAllGiftParam.version = 1;
        loadAllGiftParam.lastMd5Hash = lastMd5Hash;
        loadAllGiftParam.expand = argv.expand;
        return loadAllGiftParam;
    }

    private void doLoadAllGiftData(final LoadAllGiftJsonParam loadAllGiftParam, final String key, final GiftInfo giftInfo, boolean isForceUpdate) {
        final long time = System.currentTimeMillis();
        this.mRevenueProxy.loadAllGiftJsonData(loadAllGiftParam, new IGiftRequestCallback<String>(){

            public void onSuccess(String result) {
                if (result == null) {
                    GiftSdkWrapper.this.onCallbackFail(key, -1, "result is null");
                    GiftMonitor.giftListSdkMetric(false, -1, "result is null", System.currentTimeMillis() - time);
                } else {
                    YYTaskExecutor.execute(() -> GiftSdkWrapper.this.onLoadGiftSuccess(result, key, "" + loadAllGiftParam2.channelId, loadAllGiftParam2.liveCategoryId, giftInfo));
                    GiftMonitor.giftListSdkMetric(true, 0, "success", System.currentTimeMillis() - time);
                }
            }

            public void onFail(int code, String failReason) {
                GiftSdkWrapper.this.onCallbackFail(key, code, failReason);
                GiftMonitor.giftListSdkMetric(false, code, failReason, System.currentTimeMillis() - time);
            }
        }, isForceUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallbackFail(String key, int code, String errMsg) {
        Class<GiftSdkWrapper> clazz = GiftSdkWrapper.class;
        synchronized (GiftSdkWrapper.class) {
            List<IGiftCallback<LoadGiftResult>> list = this.mCache.get(key);
            this.mCache.remove(key);
            if (list != null) {
                for (IGiftCallback<LoadGiftResult> callback2 : list) {
                    GiftUtils.callbackFailed(callback2, (int)code, (String)errMsg);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallbackSuccess(String key, LoadGiftResult loadGiftResult) {
        Class<GiftSdkWrapper> clazz = GiftSdkWrapper.class;
        synchronized (GiftSdkWrapper.class) {
            List<IGiftCallback<LoadGiftResult>> list = this.mCache.get(key);
            this.mCache.remove(key);
            if (list != null) {
                for (IGiftCallback<LoadGiftResult> callback2 : list) {
                    GiftUtils.callbackSucceed(callback2, (Object)loadGiftResult);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void onLoadGiftSuccess(String result, String key, String channelId, int liveCategoryId, GiftInfo giftInfoParam) {
        GiftInfo giftInfo = (GiftInfo)JsonParser.parseJsonObject((String)result, GiftInfo.class);
        if (giftInfo != null) {
            giftInfo.parse();
            ArrayList list = giftInfo.getPropsList();
            if (list.size() == 0) {
                giftInfo = giftInfoParam != null ? giftInfoParam : giftInfo;
                MLog.debug((Object)TAG, (String)("result list size 0 giftInfoParam = " + giftInfoParam), (Object[])new Object[0]);
            } else {
                GiftDiskCache.updateGiftInfoJsonToDiskCache(channelId, liveCategoryId, result);
            }
            if (giftInfo.getPropsList().size() > 0) {
                this.mChannelIdLastMd5Map.remove(channelId);
                this.mChannelIdLastMd5Map.put(channelId, giftInfo.getMd5Version());
            }
            if (this.mGiftListIntercept != null) {
                this.mGiftListIntercept.modifyGiftItemInfoGiftLevel((List)giftInfo.getPropsList());
            }
            this.onCallbackSuccess(key, new LoadGiftResult((List)giftInfo.getPropsList(), new GiftExpandInfo.Builder().expand(giftInfo.getExpendData().getTabInfo()).build()));
            if (!LoadGiftManager.useSdkGiftCache()) {
                this.clearSdkCache();
            }
        } else {
            this.onCallbackFail(key, -1, "parse giftInfo is null");
        }
    }

    @Override
    public void loadPackageList(LoadPackageArgv argv, IGiftCallback<List<PropsItem>> callback2) {
        if (argv == null) {
            GiftUtils.callbackFailed(callback2, (int)10001, (String)"param is null");
            return;
        }
        new MyLoadPackageGift().loadPackageList(argv, callback2);
    }

    @Override
    public void sendGift(SendGiftArgv param, IGiftCallback<SendGiftRes> callback2) {
        if (param == null) {
            GiftUtils.callbackFailed(callback2, (int)10001, (String)"param is null");
            return;
        }
        this.getSendGift().sendGift(param, callback2);
    }

    @Override
    public void registerGiftBroadcast(IGiftBroListener<GiftBroResult> bro) {
        this.getGiftBro().registerBroadcast(bro);
    }

    @Override
    public void unregisterGiftBroadcast(IGiftBroListener<GiftBroResult> bro) {
        if (this.mGiftBroadcast != null) {
            this.mGiftBroadcast.unregisterBroadcast(bro);
        }
    }

    @Override
    public void registerGiftPush(IGiftPushBroListener<GiftPushBroMessage> bro) {
        this.getGiftBro().registerPush(bro);
    }

    @Override
    public void unregisterGiftPush(IGiftPushBroListener<GiftPushBroMessage> bro) {
        if (this.mGiftBroadcast != null) {
            this.mGiftBroadcast.unregisterPush(bro);
        }
    }

    @Override
    public void setGiftListIntercept(IGiftListIntercept intercept2) {
        this.mGiftListIntercept = intercept2;
    }

    private ISendGift getSendGift() {
        if (this.mSendGif == null) {
            this.mSendGif = new MySendGiftRequest();
        }
        return this.mSendGif;
    }

    private IGiftBroadcast getGiftBro() {
        if (this.mGiftBroadcast == null) {
            this.mGiftBroadcast = new GiftBroadcast();
        }
        return this.mGiftBroadcast;
    }

    private void clearSdkCache() {
        this.mRevenueProxy.clearSdkCache();
    }
}

