/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.sdk;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboEffectLevel;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftMulBroadcastMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftPushBroMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;

public class GiftBroadcastParse {
    private static final String TAG = "FTGiftBroadcast";

    public GiftBroResult parseGiftBro(String giftMsg) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"handleGiftBro giftMsg: %s", (Object[])new Object[]{giftMsg});
        }
        if (TextUtils.isEmpty((CharSequence)giftMsg)) {
            MLog.error((Object)TAG, (String)"handleGiftBro giftMsg is empty!!", (Object[])new Object[0]);
            return null;
        }
        try {
            GiftBroadcastMessage info = (GiftBroadcastMessage)JsonParser.parseJsonObject((String)giftMsg, GiftBroadcastMessage.class);
            if (info != null) {
                return this.handleGiftBro(info);
            }
            MLog.error((Object)TAG, (String)"handleGiftBro parse giftMsg is null, %s", (Object[])new Object[]{giftMsg});
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"handleGiftBro parse giftMsg error, %s", (Throwable)e, (Object[])new Object[]{giftMsg});
        }
        return null;
    }

    public void handleParseGiftItemInfo(GiftPushBroMessage notify) {
        GiftItemInfo giftInfo = this.getGiftService().getGift(notify.getUsedChannel(), notify.getPropsId());
        notify.setGiftItemInfo(giftInfo);
    }

    public GiftBroResult handleGiftBro(@NonNull GiftBroadcastMessage notify) {
        GiftItemInfo giftInfo = this.getGiftService().getGift(notify.getUsedChannel(), notify.getPropsId());
        if (giftInfo == null) {
            MLog.error((Object)TAG, (String)"handleGiftBroAsync can not found gift: %s", (Object[])new Object[]{notify.getPropsId()});
        }
        String expandStr = notify.getExpand();
        SendGiftExpand expand = null;
        GiftComboInfo comboInfo = null;
        GiftComboEffectLevel giftComboExpand = null;
        GiftBroUserInfo sendUserInfo = GiftBroUserInfo.newBuilder().uid(notify.getUid()).nickName(notify.getUserNickname()).build();
        GiftBroUserInfo revUserInfo = GiftBroUserInfo.newBuilder().uid(notify.getRecvUid()).nickName(notify.getRecvNickname()).build();
        GiftBroadcastInfo.Builder giftBroadcastInfo = GiftBroadcastInfo.newBuilder().propsCount(notify.getPropsCount()).propsCurrencyAmount(notify.getPropsCurrencyAmount()).propsId(notify.getPropsId()).recvUserInfo(Collections.singletonList(revUserInfo)).sendUserInfo(sendUserInfo).usedChannel(notify.getUsedChannel()).usedTime(notify.getUsedTime());
        String vipInfo = null;
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)expandStr);
            expand = GiftUtils.parseSendGiftExpand((JSONObject)jo);
            comboInfo = this.parseExpandCombo(jo);
            giftComboExpand = this.parseGiftExpand(jo);
            giftBroadcastInfo.giftComboInfo(comboInfo);
            vipInfo = jo.optString("vipInfo");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"handleGiftBro %s", (Throwable)e, (Object[])new Object[]{expandStr});
        }
        GiftBroResult result = GiftBroResult.newBuilder().giftBroInfo(giftBroadcastInfo.build()).expand(expand).giftComboInfo(comboInfo).giftComboExpand(giftComboExpand).giftInfo(giftInfo).vipInfo(vipInfo).build();
        return result;
    }

    public GiftBroResult handleGiftBro(GiftMulBroadcastMessage notify) {
        GiftItemInfo giftInfo = this.getGiftService().getGift(notify.getUsedChannel(), notify.getPropsId());
        if (giftInfo == null) {
            MLog.error((Object)TAG, (String)"handleGiftBroAsync can not found gift: %s", (Object[])new Object[]{notify.getPropsId()});
        }
        String expandStr = notify.getExpand();
        MLog.info((Object)TAG, (String)"handleGiftBro expandStr = %s", (Object[])new Object[]{expandStr});
        SendGiftExpand expand = null;
        GiftComboInfo comboInfo = null;
        GiftComboEffectLevel giftComboExpand = null;
        long sendUid = notify.getSenderUserInfo() == null ? 0L : notify.getSenderUserInfo().getUid();
        String sendNickName = notify.getSenderUserInfo() == null ? "" : notify.getSenderUserInfo().getNickName();
        GiftBroUserInfo sendUserInfo = GiftBroUserInfo.newBuilder().uid(sendUid).nickName(sendNickName).build();
        ArrayList<GiftBroUserInfo> userInfoList = new ArrayList<GiftBroUserInfo>();
        for (GiftMulBroadcastMessage.UserInfo userInfo : notify.getRecverUserInfos()) {
            userInfoList.add(GiftBroUserInfo.newBuilder().uid(userInfo.getUid()).nickName(userInfo.getNickName()).build());
        }
        GiftBroadcastInfo.Builder giftBroadcastInfo = GiftBroadcastInfo.newBuilder().propsCount(notify.getPropsCount()).propsId(notify.getPropsId()).recvUserInfo(userInfoList).sendUserInfo(sendUserInfo).usedChannel(notify.getUsedChannel());
        String vipInfo = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)expandStr)) {
                JSONObject jo = JsonParser.obtainJSONObject((String)expandStr);
                expand = GiftUtils.parseSendGiftExpand((JSONObject)jo);
                comboInfo = this.parseExpandCombo(jo);
                giftComboExpand = this.parseGiftExpand(jo);
                giftBroadcastInfo.giftComboInfo(comboInfo);
                vipInfo = jo.optString("vipInfo");
            }
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"handleGiftBro %s", (Throwable)e, (Object[])new Object[]{expandStr});
        }
        GiftBroResult result = GiftBroResult.newBuilder().giftBroInfo(giftBroadcastInfo.build()).expand(expand).giftComboInfo(comboInfo).giftComboExpand(giftComboExpand).giftInfo(giftInfo).vipInfo(vipInfo).build();
        return result;
    }

    private GiftComboEffectLevel parseGiftExpand(JSONObject jo) {
        if (jo == null) {
            MLog.error((Object)TAG, (String)"parseGiftExpand parse expand fail, for jo is null", (Object[])new Object[0]);
            return null;
        }
        GiftComboEffectLevel giftComboExpand = null;
        try {
            if (jo.has("comboEffectLevel")) {
                JSONObject co = jo.getJSONObject("comboEffectLevel");
                int lackComboCount = co.optInt("lackComboCount", 0);
                String triggerEffectLevel = co.optString("triggerEffectLevel", "");
                String targetEffectLevel = co.optString("targetEffectLevel", "");
                boolean comboProgressNotice = co.optBoolean("comboProgressNotice", false);
                giftComboExpand = new GiftComboEffectLevel(lackComboCount, triggerEffectLevel, targetEffectLevel, comboProgressNotice);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parseGiftExpand parse expand fail", (Throwable)e, (Object[])new Object[0]);
        }
        return giftComboExpand;
    }

    private GiftComboInfo parseExpandCombo(JSONObject jo) {
        if (jo == null) {
            MLog.error((Object)TAG, (String)"parseExpandCombo parse expand fail, for jo is null", (Object[])new Object[0]);
            return null;
        }
        GiftComboInfo comboInfo = null;
        try {
            JSONObject co = jo.getJSONObject("comboInfo");
            int comboHits = co.optInt("comboHits", 0);
            long intervalTime = co.optLong("intervalTime", 0L);
            long firstSendTime = co.optLong("firstSendTime", 0L);
            long useTime = jo.optLong("usedTimeMS", 0L);
            boolean isFinishCombo = co.optBoolean("isFinishCombo", false);
            comboInfo = new GiftComboInfo(comboHits, intervalTime, isFinishCombo, firstSendTime, useTime);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parseExpandCombo parse expand fail", (Throwable)e, (Object[])new Object[0]);
        }
        return comboInfo;
    }

    private IGiftService getGiftService() {
        return (IGiftService)ServiceManagerProxy.getService(IGiftService.class);
    }
}

