/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.handler;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.anchorfansclub.IFansClubService;
import com.yy.hiyo.user.base.freeze.IUserFreezeService;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelOperator;
import java.util.Random;

public class SendGiftFailHandle {
    private static final String TAG = "SendGiftFailHandle";
    private DialogLinkManager mDialogManager;
    private Context mContext;
    private IGiftPanelOperator mPannelOperator;
    private int promptType = 0;
    private int[] prompts = new int[]{R.string.short_tips_no_buy_two, R.string.short_tips_send_gift, R.string.short_tips_no_buy_one};

    public SendGiftFailHandle(@Nullable Context context, IGiftPanelOperator operator) {
        this.mContext = context;
        this.mPannelOperator = operator;
    }

    public void sendGiftFail(String roomId, int from, int code, String msg, String gid, String avatar, int propId) {
        MLog.error((Object)TAG, (String)"sendGift onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
        int tips = R.string.tips_gift_service_error;
        if (code == 20997) {
            this.noEnoughBalance(roomId, from, gid, avatar, propId);
            return;
        }
        if (code == 20994) {
            tips = R.string.tips_enough_gift;
        } else if (code == 20992) {
            tips = R.string.tips_gift_reach_limit;
        } else if (code == 20989) {
            tips = R.string.tips_gift_restricted;
        } else if (code == 20988) {
            tips = R.string.tips_can_not_use_gift;
        } else if (code == 20499) {
            tips = R.string.tips_gift_temp_restricted;
        } else if (code == 20987) {
            tips = R.string.tips_can_not_send_gift;
        } else if (code == 20984) {
            tips = R.string.tips_can_not_send_free_gift;
        } else if (code == 20495) {
            tips = R.string.tips_gift_intercurrent_control;
        } else if (code == 20492) {
            tips = R.string.tips_gift_service_busy;
        } else if (code == 20599) {
            tips = R.string.tips_gift_auth_fail;
        } else if (code == 20995) {
            tips = 0;
            ServiceManagerProxy.getInstance().observeService(IUserFreezeService.class, service -> service.showAccountFreezeDialog(4));
        } else if (code == 20500) {
            tips = R.string.tips_gift_service_error;
        } else if (code == 20978) {
            tips = R.string.tips_room_name_containt_sensitive_word;
        }
        if (tips != 0) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)tips, (int)1);
        }
    }

    void onPayLevelNotReached(int payLevel) {
        int tipRes = R.string.tips_vip_not_reached;
        String tips = String.format(ResourceUtils.getString((int)tipRes), String.valueOf(payLevel));
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)tips, (int)1);
    }

    public void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        if (this.mDialogManager != null) {
            this.mDialogManager.dismissDialog();
            this.mDialogManager = null;
        }
        this.mContext = null;
        this.mPannelOperator = null;
    }

    private void noEnoughBalance(String roomId, int from, String gid, String avatar, int propId) {
        this.showRechargeDialog(gid, roomId, avatar);
        ((IFansClubService)ServiceManagerProxy.getService(IFansClubService.class)).setRechargeDialogState(roomId, propId, true);
    }

    private void showRechargeDialog(String gid, String roomId, String avatar) {
        if (this.mPannelOperator != null) {
            this.mPannelOperator.hideGiftPanel();
        }
        Message msg = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putString("gid", gid);
        bundle.putString("roomId", roomId);
        bundle.putInt("fromType", 4);
        bundle.putInt("recharge_dialog_act_type", 1);
        msg.setData(bundle);
        msg.arg1 = this.promptType;
        msg.what = AppbaseMsgDef.SHOW_RECHARGE_DIALOG;
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    private int randRechargePrompot(int[] prompts) {
        int size = prompts.length;
        int rand = new Random().nextInt(size);
        this.promptType = rand + 1;
        return rand < size ? prompts[rand] : R.string.tips_no_enough_balance;
    }
}

