/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.handler;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftPushBroMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.IGiftListIntercept;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.gift.data.param.SendGiftArgv;
import com.yy.hiyo.wallet.gift.data.result.GiftOperationNotifyResult;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.gift.handler.GiftHandler;
import com.yy.hiyo.wallet.gift.handler.GiftHandlerStack;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerCallback;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerInner;
import com.yy.hiyo.wallet.gift.model.GiftOperationNotify;
import com.yy.hiyo.wallet.gift.model.IGiftOperationNotifyListener;
import com.yy.hiyo.wallet.gift.sdk.IGiftBroListener;
import com.yy.hiyo.wallet.gift.sdk.IGiftPushBroListener;
import com.yy.hiyo.wallet.gift.sdk.IGiftSdk;
import java.util.List;

public class GiftHandlerManager
implements IGiftHandlerCallback,
IGiftBroListener<GiftBroResult>,
IGiftPushBroListener<GiftPushBroMessage>,
IGiftOperationNotifyListener<GiftOperationNotifyResult> {
    private static final String TAG = "FTGiftHandlerManager";
    private final IGiftSdk mGiftSdkWrapper;
    private final IGiftService mGiftService;
    private final GiftOperationNotify mGiftOperationNotify;
    private GiftHandlerStack mHandlerStack;

    public GiftHandlerManager(IGiftSdk giftSdk, IGiftService giftService) {
        this.mGiftSdkWrapper = giftSdk;
        this.mGiftService = giftService;
        this.mGiftOperationNotify = new GiftOperationNotify();
    }

    public IGiftHandler createHandler(@NonNull GiftHandlerParam param) {
        MLog.info((Object)TAG, (String)"createHandler param: %s", (Object[])new Object[]{param});
        String roomId = param.getRoomId();
        IGiftHandler handler = this.findGiftHandler(roomId);
        if (handler == null) {
            GiftHandler inner = new GiftHandler(param, this);
            this.getHandlerStack().push(inner);
            handler = inner;
        } else {
            String msg = StringUtils.formatWitUSLocal((String)"the handler of roomId(%s) had exist, only one handler for one roomId", (Object[])new Object[]{roomId});
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(msg);
            }
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
        }
        return handler;
    }

    @Nullable
    public IGiftHandler findGiftHandler(String roomId) {
        if (this.mHandlerStack != null) {
            return this.mHandlerStack.search(roomId);
        }
        return null;
    }

    public void finishGiftHandler(String roomId) {
        IGiftHandlerInner handler;
        if (this.mHandlerStack != null && (handler = this.mHandlerStack.search(roomId)) != null) {
            handler.finish();
        }
    }

    private void checkDuplication(String roomId) {
        if (this.mHandlerStack != null && this.mHandlerStack.search(roomId) != null) {
            String msg = StringUtils.formatWitUSLocal((String)"the handler of roomId(%s) had exist, only one handler for one roomId", (Object[])new Object[]{roomId});
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            throw new IllegalStateException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GiftHandlerStack getHandlerStack() {
        if (this.mHandlerStack != null) return this.mHandlerStack;
        Class<GiftHandlerManager> clazz = GiftHandlerManager.class;
        synchronized (GiftHandlerManager.class) {
            if (this.mHandlerStack != null) return this.mHandlerStack;
            this.mHandlerStack = new GiftHandlerStack();
            this.mGiftSdkWrapper.registerGiftBroadcast(this);
            this.mGiftSdkWrapper.registerGiftPush(this);
            this.mGiftOperationNotify.registerGiftOperationListener(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mHandlerStack;
        }
    }

    @Override
    public void destroyHandler(IGiftHandler handler) {
        if (this.mHandlerStack != null) {
            this.mHandlerStack.remove(handler.roomId());
        }
    }

    @Override
    public void onBroadcast(@NonNull GiftBroResult result) {
        MLog.info((Object)TAG, (String)"onBroadcast result: %s", (Object[])new Object[]{result});
        if (this.mHandlerStack == null) {
            MLog.info((Object)TAG, (String)"onBroadcast mHandlerStack is null ", (Object[])new Object[0]);
            return;
        }
        String roomId = result.getRoomId();
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            MLog.error((Object)TAG, (String)"onBroadcast result roomId is empty", (Object[])new Object[0]);
            return;
        }
        IGiftHandlerInner handler = this.mHandlerStack.search(roomId);
        if (handler == null) {
            MLog.error((Object)TAG, (String)("onBroadcast handler is null " + roomId), (Object[])new Object[0]);
            return;
        }
        handler.onGiftBroadcast(result);
    }

    @Override
    public void onPushBroadcast(@NonNull GiftPushBroMessage result) {
        MLog.info((Object)TAG, (String)"onPush result: %s", (Object[])new Object[]{result});
        if (this.mHandlerStack == null) {
            MLog.info((Object)TAG, (String)"onBroadcast mHandlerStack is null ", (Object[])new Object[0]);
            return;
        }
        for (int i = 0; i < this.mHandlerStack.size(); ++i) {
            IGiftHandlerInner handler = (IGiftHandlerInner)this.mHandlerStack.get(i);
            if (null == handler) continue;
            handler.onGiftPush(result);
        }
    }

    @Override
    public void onNotify(GiftOperationNotifyResult result) {
        MLog.info((Object)TAG, (String)"onFreeGiftBroadcast result: %s", (Object[])new Object[]{result});
        if (this.mHandlerStack == null) {
            MLog.info((Object)TAG, (String)"onFreeGiftBroadcast mHandlerStack is null ", (Object[])new Object[0]);
            return;
        }
        IGiftHandlerInner handler = this.mHandlerStack.peek();
        MLog.info((Object)TAG, (String)"onFreeGiftBroadcast handler: %s", (Object[])new Object[]{handler});
        if (handler == null) {
            return;
        }
        handler.onGiftOperationNotify(result);
    }

    @Override
    public void loadGiftList(IGiftHandler handler, IGiftCallback<LoadGiftResult> callback2) {
        this.loadGiftList(handler, callback2, false);
    }

    @Override
    public void loadGiftList(IGiftHandler handler, IGiftCallback<LoadGiftResult> callback2, boolean forceUpdate) {
        MLog.info((Object)TAG, (String)"loadGiftList handler: %s", (Object[])new Object[]{handler});
        GiftHandlerParam param = handler.getGiftHandlerParam();
        this.mGiftService.loadGiftList(param.getRoomId(), param.getAnchorUid(), param.getChannelId(), forceUpdate, callback2);
    }

    @Override
    public void loadPackageList(IGiftHandler handler, IGiftCallback<List<GiftItemInfo>> callback2) {
        MLog.info((Object)TAG, (String)"loadPackageList handler: %s", (Object[])new Object[]{handler});
        GiftHandlerParam param = handler.getGiftHandlerParam();
        this.mGiftService.loadPackageList(param.getChannelId(), AccountUtil.getUid(), callback2);
    }

    @Override
    public void sendGift(SendGiftArgv param, IGiftCallback<SendGiftRes> callback2) {
        this.mGiftSdkWrapper.sendGift(param, callback2);
    }

    @Override
    public List<GiftItemInfo> getAllGift(int usedChannel) {
        return this.mGiftService.getGiftList(usedChannel);
    }

    @Override
    public List<GiftItemInfo> getAllPackage(long uid) {
        return this.mGiftService.getPackageList(uid);
    }

    @Override
    public GiftItemInfo findGiftById(int propsId, int usedChannel) {
        return this.mGiftService.getGift(usedChannel, propsId);
    }

    @Override
    public void setGiftListIntercept(IGiftListIntercept intercept2) {
        this.mGiftService.setGiftListIntercept(intercept2);
    }
}

