/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift;

import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.resource.file.ResInfo;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftExpandInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.IGiftListIntercept;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.util.GiftResUrlParse;
import com.yy.hiyo.wallet.gift.GiftListCache;
import com.yy.hiyo.wallet.gift.data.param.LoadGiftArgv;
import com.yy.hiyo.wallet.gift.data.param.LoadPackageArgv;
import com.yy.hiyo.wallet.gift.pack.PropsItem;
import com.yy.hiyo.wallet.gift.sdk.IGiftSdk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class LoadGiftManager {
    private static final String TAG = "LoadGiftManager";
    private static final long INTERVAL = 300000L;
    private static final int RETRY_COUNT = 3;
    private final IGiftSdk mGiftSdkWrapper;
    private GiftListCache mGiftListCache = null;
    private final SparseArray<Long> mRequestGiftListFrequency = new SparseArray();
    private final Map<String, ResInfo> mPreloadSvgaList = new HashMap<String, ResInfo>();
    private final Map<String, ResInfo> mPreloadOfList = new HashMap<String, ResInfo>();
    private final Map<String, ResInfo> mPreloadVideoList = new HashMap<String, ResInfo>();
    private final Map<String, ResInfo> mPreloadVoiceList = new HashMap<String, ResInfo>();
    private final Map<Long, List<GiftItemInfo>> mPackageCache = new ConcurrentHashMap<Long, List<GiftItemInfo>>();
    private GiftExpandInfo giftPanelExpand;
    private GiftResUrlParse mGiftResUrlParse = new GiftResUrlParse();
    private IFrequencyLimitExecutor sFrequencyLimitExecutor;

    public LoadGiftManager(IGiftSdk sdk) {
        this.mGiftSdkWrapper = sdk;
    }

    public void loadGiftList(String roomId, long anchorUid, int channelId, String expand, boolean forceUpdate, IGiftCallback<LoadGiftResult> callback2) {
        LoadGiftArgv argv = this.requestGiftListArgv(roomId, anchorUid, channelId, expand);
        this.checkRequestGiftList(argv, forceUpdate, callback2);
    }

    public void setGiftListIntercept(IGiftListIntercept giftListIntercept) {
        if (this.mGiftSdkWrapper != null) {
            this.mGiftSdkWrapper.setGiftListIntercept(giftListIntercept);
        }
    }

    public List<GiftItemInfo> getGiftList(int channelId) {
        return this.getGiftListCache().getGiftList(channelId);
    }

    public void loadPackageList(int channelId, long uid, IGiftCallback<List<GiftItemInfo>> callback2) {
        LoadPackageArgv argv = this.requestPackageListArgv(channelId, uid);
        this.requestPackageList(argv, 0, callback2);
    }

    public List<GiftItemInfo> getPackageList(long uid) {
        return this.mPackageCache.get(uid);
    }

    @Deprecated
    public GiftItemInfo getGift(int propId) {
        int channel = GiftChannel.USER_ALL_CHANNEL.getChannel();
        return this.getGiftListCache().getGift(channel, propId);
    }

    public GiftItemInfo getGift(int channelId, int propId) {
        return this.getGiftListCache().getGift(channelId, propId);
    }

    private void checkRequestGiftList(LoadGiftArgv argv, boolean forceUpdate, IGiftCallback<LoadGiftResult> callback2) {
        Long last = null;
        long now = System.currentTimeMillis();
        boolean update = forceUpdate;
        if (!(update || (last = (Long)this.mRequestGiftListFrequency.get(argv.channelId)) != null && Math.abs(now - last) <= 300000L)) {
            update = true;
        }
        if (update) {
            this.requestGiftList(argv, 0, callback2);
        } else {
            this.getFromCache(argv, callback2);
        }
    }

    private void getFromCache(LoadGiftArgv argv, IGiftCallback<LoadGiftResult> callback2) {
        List<GiftItemInfo> list = this.getGiftList(argv.channelId);
        MLog.info((Object)TAG, (String)"requestGiftList argv: %s, list.size: %d", (Object[])new Object[]{argv, FP.size(list)});
        if (FP.empty(list)) {
            this.requestGiftList(argv, 0, callback2);
        } else {
            LoadGiftResult result = new LoadGiftResult(list, this.getGiftExpand(argv.channelId));
            GiftUtils.callbackSucceed(callback2, (Object)result);
        }
    }

    private GiftExpandInfo getGiftExpand(int channelId) {
        return this.getGiftListCache().getExpandInfo(channelId);
    }

    private void requestGiftList(final LoadGiftArgv argv, final int retryCount, final IGiftCallback<LoadGiftResult> callback2) {
        boolean isCacheEmpty = FP.empty(this.getGiftList(argv.channelId));
        MLog.info((Object)TAG, (String)"requestGiftList retryCount: %d, isCacheEmpty: %b, argv: %s", (Object[])new Object[]{retryCount, isCacheEmpty, argv});
        this.mGiftSdkWrapper.loadGiftList(argv, isCacheEmpty, new IGiftCallback<LoadGiftResult>(){

            public void onSucceed(LoadGiftResult result) {
                MLog.info((Object)LoadGiftManager.TAG, (String)"requestGiftList onSucceed result\uff1a%d", (Object[])new Object[]{result != null ? result.getGiftList().size() : 0});
                if (result == null) {
                    this.onFailed(-1, "result is null");
                    return;
                }
                long now = System.currentTimeMillis();
                LoadGiftManager.this.mRequestGiftListFrequency.put(argv.channelId, (Object)now);
                if (FP.empty((Collection)result.getGiftList())) {
                    List<GiftItemInfo> cacheList = LoadGiftManager.this.getGiftList(argv.channelId);
                    if (FP.empty(cacheList)) {
                        this.onFailed(-2, "list  and cache is empty");
                    } else {
                        GiftExpandInfo info = LoadGiftManager.this.getGiftExpand(argv.channelId);
                        GiftUtils.callbackSucceed((IGiftCallback)callback2, (Object)new LoadGiftResult(cacheList, info));
                    }
                } else {
                    GiftExpandInfo expandInfo = result.getGiftExpand();
                    MLog.info((Object)LoadGiftManager.TAG, (String)("requestGiftList onSucceed expandInfo " + expandInfo.getGiftTabList().toString()), (Object[])new Object[0]);
                    LoadGiftManager.this.giftPanelExpand = result.getGiftExpand();
                    result.setGiftExpand(LoadGiftManager.this.giftPanelExpand);
                    LoadGiftManager.this.getGiftListCache().updateGiftList(argv.channelId, result.getGiftList(), expandInfo);
                    GiftUtils.callbackSucceed((IGiftCallback)callback2, (Object)result);
                }
                if (result != null) {
                    LoadGiftManager.this.preload(result.getGiftList());
                }
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)LoadGiftManager.TAG, (String)"requestGiftList onFailed code\uff1a %d, msg: %s", (Object[])new Object[]{code, msg});
                if (retryCount < 3 && FP.empty(LoadGiftManager.this.getGiftList(argv.channelId))) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (FP.empty(LoadGiftManager.this.getGiftList(argv.channelId))) {
                                LoadGiftManager.this.requestGiftList(argv, retryCount + 1, (IGiftCallback<LoadGiftResult>)callback2);
                            }
                        }
                    }, (long)LoadGiftManager.this.requestDelay(retryCount));
                } else {
                    GiftUtils.callbackFailed((IGiftCallback)callback2, (int)code, (String)msg);
                }
            }
        });
    }

    private void requestPackageList(final LoadPackageArgv argv, final int retryCount, final IGiftCallback<List<GiftItemInfo>> callback2) {
        MLog.info((Object)TAG, (String)"requestPackageList retryCount: %d, argv: %s", (Object[])new Object[]{retryCount, argv});
        if (argv == null) {
            return;
        }
        this.mGiftSdkWrapper.loadPackageList(argv, new IGiftCallback<List<PropsItem>>(){

            public void onSucceed(List<PropsItem> result) {
                ArrayList<GiftItemInfo> list = new ArrayList<GiftItemInfo>(result.size());
                for (PropsItem item : result) {
                    GiftItemInfo gift = LoadGiftManager.this.getGift(argv.channelId, item.getPropsId());
                    if (gift == null) continue;
                    gift.setCount(item.getCount());
                    gift.setExpireCount(item.getExpireCount());
                    gift.setExpireDate((long)item.getExpireDate());
                    list.add(gift);
                }
                GiftUtils.callbackSucceed((IGiftCallback)callback2, list);
                LoadGiftManager.this.mPackageCache.put(argv.uid, list);
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)LoadGiftManager.TAG, (String)"requestPackageList onFailed code\uff1a %d, msg: %s", (Object[])new Object[]{code, msg});
                if (retryCount < 3 && FP.empty(LoadGiftManager.this.getPackageList(argv.uid))) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (FP.empty(LoadGiftManager.this.getPackageList(argv.uid))) {
                                LoadGiftManager.this.requestPackageList(argv, retryCount + 1, (IGiftCallback<List<GiftItemInfo>>)callback2);
                            }
                        }
                    }, (long)LoadGiftManager.this.requestDelay(retryCount));
                } else {
                    GiftUtils.callbackFailed((IGiftCallback)callback2, (int)code, (String)msg);
                }
            }
        });
    }

    private void preloadArGift(List<GiftItemInfo> giftList) {
        ArrayList<GiftItemInfo> copy = new ArrayList<GiftItemInfo>(giftList);
        int size = this.mPreloadOfList.size();
        for (GiftItemInfo info : copy) {
            if (info == null) continue;
            boolean checkMd5 = info.isCheckResMd5();
            this.addNewRes(checkMd5, this.mPreloadOfList, info.getArOfRescource());
        }
        if (this.mPreloadOfList.size() == size) {
            return;
        }
        HashSet<ResInfo> arGiftSet = new HashSet<ResInfo>(this.mPreloadOfList.values());
        ResPersistUtils.preLoadRes((ResPersistUtils.Dir)ResPersistUtils.Dir.AR_GIFT, arGiftSet);
    }

    private void preload(List<GiftItemInfo> giftList) {
        if (FP.empty(giftList)) {
            return;
        }
        if (this.sFrequencyLimitExecutor == null) {
            this.sFrequencyLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)5000L, (boolean)false);
        }
        this.sFrequencyLimitExecutor.execute(() -> {
            this.preloadSvga(giftList);
            this.preloadArGift(giftList);
            this.preloadGiftVideo(giftList);
        });
    }

    private void preloadGiftVideo(List<GiftItemInfo> giftList) {
        ArrayList<GiftItemInfo> copy = new ArrayList<GiftItemInfo>(giftList);
        int size = this.mPreloadVideoList.size();
        for (GiftItemInfo info : copy) {
            if (info == null) continue;
            boolean checkMd5 = info.isCheckResMd5();
            this.addNewRes(checkMd5, this.mPreloadVideoList, info.getVideo());
        }
        if (this.mPreloadVideoList.size() == size) {
            return;
        }
        HashSet<ResInfo> preloadSet = new HashSet<ResInfo>(this.mPreloadVideoList.values());
        ResPersistUtils.preLoadRes((ResPersistUtils.Dir)ResPersistUtils.Dir.GIFT_VIDEO, preloadSet);
    }

    private void preloadGiftVoice(List<GiftItemInfo> giftList) {
        ArrayList<GiftItemInfo> copy = new ArrayList<GiftItemInfo>(giftList);
        int size = this.mPreloadVoiceList.size();
        for (GiftItemInfo info : copy) {
            if (info == null) continue;
            boolean checkMd5 = info.isCheckResMd5();
            this.addNewRes(checkMd5, this.mPreloadVoiceList, info.getVoice());
        }
        if (this.mPreloadVoiceList.size() == size) {
            return;
        }
        HashSet<ResInfo> preloadSet = new HashSet<ResInfo>(this.mPreloadVoiceList.values());
        ResPersistUtils.preLoadRes((ResPersistUtils.Dir)ResPersistUtils.Dir.GIFT_VOICE, preloadSet);
    }

    private void preloadSvga(List<GiftItemInfo> giftList) {
        ArrayList<GiftItemInfo> copy = new ArrayList<GiftItemInfo>(giftList);
        int size = this.mPreloadSvgaList.size();
        for (GiftItemInfo info : copy) {
            if (info == null) continue;
            boolean checkMd5 = info.isCheckResMd5();
            this.addNewRes(checkMd5, this.mPreloadSvgaList, info.getSvga(), info.getFullScreenSvga(), info.getKtvSvga(), info.getReplaceSvga(), info.getPreviewSvga(), info.getVideoReplaceSvga(), info.getBoxSvga(), info.getMoodSvga(), info.getTinySvga(), info.getMoodBgSvga(), info.getVoiceSvga(), info.getSvgaFlyConfig().getSplitSvga());
            this.addNewRes(checkMd5, this.mPreloadSvgaList, this.getGiftComboSvgaList(info));
        }
        if (this.mPreloadSvgaList.size() == size) {
            return;
        }
        HashSet<ResInfo> preloadSet = new HashSet<ResInfo>(this.mPreloadSvgaList.values());
        ResPersistUtils.preLoadRes((ResPersistUtils.Dir)ResPersistUtils.Dir.GIFT_SVGA, preloadSet);
    }

    private void addNewRes(boolean checkMd5, Map<String, ResInfo> resInfoMap, String ... urls) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url) || resInfoMap.containsKey(url)) continue;
            ResInfo resInfo = this.newResInfo(url, checkMd5);
            resInfoMap.put(url, resInfo);
        }
    }

    private void addNewRes(boolean checkMd5, Map<String, ResInfo> resInfoMap, List<String> urls) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url) || resInfoMap.containsKey(url)) continue;
            ResInfo resInfo = this.newResInfo(url, checkMd5);
            resInfoMap.put(url, resInfo);
        }
    }

    @NotNull
    private ResInfo newResInfo(String resUrl, boolean checkMd5) {
        long speed = 0L;
        return new ResInfo(resUrl, "", checkMd5 && this.isGiftCheckMd5() ? this.mGiftResUrlParse : null, speed);
    }

    @NotNull
    private List<ResInfo> newResInfo(List<String> resUrl, boolean checkMd5) {
        ArrayList<ResInfo> infos = new ArrayList<ResInfo>(resUrl.size());
        for (String url : resUrl) {
            infos.add(this.newResInfo(url, checkMd5));
        }
        return infos;
    }

    private List<String> getGiftComboSvgaList(GiftItemInfo giftInfo) {
        ArrayList<String> svgaList = new ArrayList<String>();
        if (giftInfo != null) {
            try {
                HashMap map = giftInfo.getLevelMultipleSvgas();
                if (map != null) {
                    for (GiftItemInfo.LevelMultipleSvgas value : map.values()) {
                        String svga = value.getSvga();
                        String fullScreenSvga = value.getFullScreenSvga();
                        String replaceSvaga = value.getReplaceSvga();
                        if (!TextUtils.isEmpty((CharSequence)svga) && svga.endsWith(".svga")) {
                            svgaList.add(svga);
                        }
                        if (!TextUtils.isEmpty((CharSequence)fullScreenSvga) && fullScreenSvga.endsWith(".svga")) {
                            svgaList.add(fullScreenSvga);
                        }
                        if (TextUtils.isEmpty((CharSequence)replaceSvaga) || !replaceSvaga.endsWith(".svga")) continue;
                        svgaList.add(replaceSvaga);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return svgaList;
    }

    private boolean isGiftCheckMd5() {
        return SettingFlags.getBoolean((String)"gift_res_check_md5", (boolean)true);
    }

    private long requestDelay(int count) {
        return count * 500;
    }

    @NonNull
    private LoadGiftArgv requestGiftListArgv(String roomId, long anchorUid, int channelId, String expand) {
        LoadGiftArgv.Builder argv = LoadGiftArgv.newBuilder();
        argv.channelId(channelId);
        argv.roomId(roomId);
        argv.uid(AccountUtil.getUid());
        argv.anchorUid(anchorUid);
        argv.countryCode(AccountUtil.realCountry());
        argv.expand(expand);
        return argv.build();
    }

    private LoadPackageArgv requestPackageListArgv(int channelId, long uid) {
        LoadPackageArgv.Builder argv = LoadPackageArgv.newBuilder();
        argv.channelId(channelId);
        argv.uid(uid);
        return argv.build();
    }

    private GiftListCache getGiftListCache() {
        if (this.mGiftListCache == null) {
            MLog.info((Object)TAG, (String)"getGiftListCache", (Object[])new Object[0]);
            this.mGiftListCache = new GiftListCache();
        }
        return this.mGiftListCache;
    }

    public static boolean useSdkGiftCache() {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig) {
            return ((CommonConfig)config).getData().giftSdkCache;
        }
        return false;
    }
}

