/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.floatplay.handler;

import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.common.Callback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.game.service.callback.IRoomGameBridge;
import com.yy.hiyo.wallet.base.floatplay.CreatePlayHandlerParam;
import com.yy.hiyo.wallet.base.floatplay.FromSource;
import com.yy.hiyo.wallet.base.floatplay.IFloatGameLifecycle;
import com.yy.hiyo.wallet.base.floatplay.PlayState;
import com.yy.hiyo.wallet.base.floatplay.StartPlayResult;
import com.yy.hiyo.wallet.base.floatplay.StartPlayResultCode;
import com.yy.hiyo.wallet.floatplay.IControllerCallback;
import com.yy.hiyo.wallet.floatplay.game.GamePlayHandler;
import com.yy.hiyo.wallet.floatplay.handler.CreatePlayFilter;
import com.yy.hiyo.wallet.floatplay.handler.FloatPlayLayer;
import com.yy.hiyo.wallet.floatplay.handler.GameFilter;
import com.yy.hiyo.wallet.floatplay.handler.HandlerManager;
import com.yy.hiyo.wallet.floatplay.handler.IGameFilterCallback;
import com.yy.hiyo.wallet.floatplay.handler.IPlayHandler;
import com.yy.hiyo.wallet.floatplay.handler.IPlayHandlerCallback;
import com.yy.hiyo.wallet.floatplay.handler.PlayHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u0003:\u00018B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\"J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0016H\u0016J\u000e\u0010+\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010.\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u000100J\u001c\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u000e\u00107\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/yy/hiyo/wallet/floatplay/handler/HandlerManager;", "Lcom/yy/hiyo/wallet/floatplay/handler/IPlayHandlerCallback;", "Lcom/yy/hiyo/wallet/floatplay/handler/IGameFilterCallback;", "Lcom/yy/framework/core/INotify;", "controllerCallback", "Lcom/yy/hiyo/wallet/floatplay/IControllerCallback;", "(Lcom/yy/hiyo/wallet/floatplay/IControllerCallback;)V", "createPlayFilter", "Lcom/yy/hiyo/wallet/floatplay/handler/CreatePlayFilter;", "getCreatePlayFilter", "()Lcom/yy/hiyo/wallet/floatplay/handler/CreatePlayFilter;", "createPlayFilter$delegate", "Lkotlin/Lazy;", "gameFilter", "Lcom/yy/hiyo/wallet/floatplay/handler/GameFilter;", "getGameFilter", "()Lcom/yy/hiyo/wallet/floatplay/handler/GameFilter;", "gameFilter$delegate", "listenerList", "", "Lcom/yy/hiyo/wallet/base/floatplay/IFloatGameLifecycle;", "playList", "Lcom/yy/hiyo/wallet/floatplay/handler/IPlayHandler;", "addFloatGameLifeCycle", "", "listener", "findHandlerById", "playId", "", "getContainer", "Landroid/view/ViewGroup;", "getPlayState", "Lcom/yy/hiyo/wallet/base/floatplay/PlayState;", "hadGamePlay", "", "handleBackKeyEvent", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onBlankClick", "handler", "onCloseAllGame", "onFinish", "pausePlay", "removeFloatGameLifeCycle", "resumePlay", "setRoomGameBridge", "bridge", "Lcom/yy/hiyo/game/service/callback/IRoomGameBridge;", "startPlay", "param", "Lcom/yy/hiyo/wallet/base/floatplay/CreatePlayHandlerParam;", "callback", "Lcom/yy/appbase/common/Callback;", "Lcom/yy/hiyo/wallet/base/floatplay/StartPlayResult;", "stopPlay", "Companion", "wallet_billDebug"})
public final class HandlerManager
implements IPlayHandlerCallback,
IGameFilterCallback,
INotify {
    private final List<IPlayHandler> playList;
    private final List<IFloatGameLifecycle> listenerList;
    private final Lazy createPlayFilter$delegate;
    private final Lazy gameFilter$delegate;
    private final IControllerCallback controllerCallback;
    @NotNull
    public static final String TAG = "FloatPlayHandlerManager";
    public static final Companion Companion = new Companion(null);

    private final CreatePlayFilter getCreatePlayFilter() {
        Lazy lazy = this.createPlayFilter$delegate;
        HandlerManager handlerManager2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CreatePlayFilter)lazy.getValue();
    }

    private final GameFilter getGameFilter() {
        Lazy lazy = this.gameFilter$delegate;
        HandlerManager handlerManager2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GameFilter)lazy.getValue();
    }

    public void notify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            Iterable $this$forEach$iv = this.playList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPlayHandler it = (IPlayHandler)element$iv;
                boolean bl = false;
                it.stopPlay();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void startPlay(@NotNull CreatePlayHandlerParam param, @NotNull Callback<StartPlayResult> callback2) {
        void handler;
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        MLog.info((Object)TAG, (String)"startPlay playId: %s", (Object[])new Object[]{param.getPlayId()});
        boolean bl = false;
        boolean bl2 = false;
        Callback<StartPlayResult> $this$with = callback2;
        boolean bl3 = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.findHandlerById(param.getPlayId());
        if ((IPlayHandler)handler.element != null) {
            String msg = "had started play: " + (IPlayHandler)handler.element;
            if (((IPlayHandler)handler.element).getPlayState() == PlayState.START) {
                $this$with.onResponse((Object)new StartPlayResult(StartPlayResultCode.DO_NOTHING, msg));
                return;
            }
            if (((IPlayHandler)handler.element).getPlayState() == PlayState.PAUSE) {
                ((IPlayHandler)handler.element).resumePlay();
                $this$with.onResponse((Object)new StartPlayResult(StartPlayResultCode.RESUME, msg));
                return;
            }
            if (RuntimeContext.sIsDebuggable) {
                throw (Throwable)new IllegalStateException(msg);
            }
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            $this$with.onResponse((Object)new StartPlayResult(StartPlayResultCode.ERROR, msg));
            return;
        }
        this.getCreatePlayFilter().filter(this.playList, param, this.controllerCallback.getContext(), new CreatePlayFilter.IPlayFilerCallback<StartPlayResult>($this$with, (Ref.ObjectRef)handler, this, param){
            final /* synthetic */ Callback $this_with;
            final /* synthetic */ Ref.ObjectRef $handler;
            final /* synthetic */ HandlerManager this$0;
            final /* synthetic */ CreatePlayHandlerParam $param$inlined;
            {
                this.$this_with = $receiver;
                this.$handler = $captured_local_variable$2;
                this.this$0 = handlerManager2;
                this.$param$inlined = createPlayHandlerParam;
            }

            public void onFilter(@NotNull StartPlayResult data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_with.onResponse((Object)data);
            }

            public void onNext() {
                this.$handler.element = PlayHandlerFactory.Companion.newHandler(HandlerManager.access$getContainer(this.this$0), this.$param$inlined, this.this$0);
                List list = HandlerManager.access$getPlayList$p(this.this$0);
                IPlayHandler iPlayHandler = (IPlayHandler)this.$handler.element;
                if (iPlayHandler == null) {
                    Intrinsics.throwNpe();
                }
                list.add(iPlayHandler);
                HandlerManager.access$getGameFilter$p(this.this$0).addGameFilter();
                this.$this_with.onResponse((Object)new StartPlayResult(StartPlayResultCode.SUCCESS, "success"));
            }
        });
    }

    @Override
    public void onFinish(@NotNull IPlayHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        MLog.info((Object)TAG, (String)"onFinish handler: %s", (Object[])new Object[]{handler});
        this.getGameFilter().removeGameFilter();
        handler.destroy();
        this.playList.remove(handler);
        if (this.playList.isEmpty()) {
            MLog.info((Object)TAG, (String)"onFinish playList is empty", (Object[])new Object[0]);
        }
        Iterable $this$forEach$iv = this.listenerList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IFloatGameLifecycle it = (IFloatGameLifecycle)element$iv;
            boolean bl = false;
            it.destroy(handler.getPlayId(), handler.getFromSource());
        }
    }

    @Override
    public void onBlankClick(@NotNull IPlayHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        handler.pausePlay();
    }

    public final boolean handleBackKeyEvent() {
        Iterable $this$forEach$iv = this.playList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayHandler it = (IPlayHandler)element$iv;
            boolean bl = false;
            if (!it.interceptBack()) continue;
            return true;
        }
        return false;
    }

    public final void stopPlay(@NotNull String playId) {
        Intrinsics.checkParameterIsNotNull((Object)playId, (String)"playId");
        MLog.info((Object)TAG, (String)"stopPlay playId: %s", (Object[])new Object[]{playId});
        IPlayHandler handler = this.findHandlerById(playId);
        if (handler != null) {
            handler.stopPlay();
        } else {
            MLog.info((Object)TAG, (String)"stopPlay handler is null playId: %s", (Object[])new Object[]{playId});
        }
        Iterable $this$forEach$iv = this.listenerList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IFloatGameLifecycle it = (IFloatGameLifecycle)element$iv;
            boolean bl = false;
            IPlayHandler iPlayHandler = handler;
            it.stopPlay(playId, (FromSource)(iPlayHandler != null ? iPlayHandler.getFromSource() : null));
        }
    }

    public final void pausePlay(@NotNull String playId) {
        Intrinsics.checkParameterIsNotNull((Object)playId, (String)"playId");
        MLog.info((Object)TAG, (String)"pausePlay playId: %s", (Object[])new Object[]{playId});
        IPlayHandler handler = this.findHandlerById(playId);
        if (handler != null) {
            handler.pausePlay();
        } else {
            MLog.info((Object)TAG, (String)"pausePlay handler is null playId: %s", (Object[])new Object[]{playId});
        }
        Iterable $this$forEach$iv = this.listenerList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IFloatGameLifecycle it = (IFloatGameLifecycle)element$iv;
            boolean bl = false;
            IPlayHandler iPlayHandler = handler;
            it.pausePlay(playId, (FromSource)(iPlayHandler != null ? iPlayHandler.getFromSource() : null));
        }
    }

    public final void resumePlay(@NotNull String playId) {
        Intrinsics.checkParameterIsNotNull((Object)playId, (String)"playId");
        MLog.info((Object)TAG, (String)"resumePlay playId: %s", (Object[])new Object[]{playId});
        IPlayHandler handler = this.findHandlerById(playId);
        if (handler != null) {
            handler.resumePlay();
        } else {
            MLog.info((Object)TAG, (String)"resumePlay handler is null playId: %s", (Object[])new Object[]{playId});
        }
        Iterable $this$forEach$iv = this.listenerList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IFloatGameLifecycle it = (IFloatGameLifecycle)element$iv;
            boolean bl = false;
            IPlayHandler iPlayHandler = handler;
            it.resumePlay(playId, (FromSource)(iPlayHandler != null ? iPlayHandler.getFromSource() : null));
        }
    }

    public final void addFloatGameLifeCycle(@NotNull IFloatGameLifecycle listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerList.add(listener);
    }

    public final void removeFloatGameLifeCycle(@NotNull IFloatGameLifecycle listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerList.remove(listener);
    }

    public final void setRoomGameBridge(@Nullable IRoomGameBridge bridge) {
        MLog.info((Object)TAG, (String)"setRoomGameBridge bridge == null: %b", (Object[])new Object[]{bridge == null});
        Iterable $this$forEach$iv = this.playList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayHandler it = (IPlayHandler)element$iv;
            boolean bl = false;
            if (!(it instanceof GamePlayHandler)) continue;
            ((GamePlayHandler)it).setRoomGameBridge(bridge);
        }
    }

    @NotNull
    public final PlayState getPlayState(@NotNull String playId) {
        Intrinsics.checkParameterIsNotNull((Object)playId, (String)"playId");
        IPlayHandler handler = this.findHandlerById(playId);
        if (handler != null) {
            return handler.getPlayState();
        }
        MLog.info((Object)TAG, (String)"getPlayState handler is null playId: %s", (Object[])new Object[]{playId});
        return PlayState.NONE;
    }

    @Override
    public void onCloseAllGame() {
        MLog.info((Object)TAG, (String)"onCloseAllGame", (Object[])new Object[0]);
        Iterable $this$forEach$iv = this.playList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayHandler it = (IPlayHandler)element$iv;
            boolean bl = false;
            it.stopPlay();
        }
    }

    @Override
    public boolean hadGamePlay() {
        Collection collection = this.playList;
        boolean bl = false;
        return !collection.isEmpty();
    }

    private final IPlayHandler findHandlerById(String playId) {
        Object v0;
        block1: {
            Iterable iterable = this.playList;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                IPlayHandler it = (IPlayHandler)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getPlayId(), (Object)playId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ViewGroup getContainer() {
        FloatPlayLayer container = new FloatPlayLayer(this.controllerCallback.getContext(), null, 0, 6, null);
        this.controllerCallback.addView((View)container);
        return (ViewGroup)container;
    }

    public HandlerManager(@NotNull IControllerCallback controllerCallback) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)controllerCallback, (String)"controllerCallback");
        this.controllerCallback = controllerCallback;
        HandlerManager handlerManager2 = this;
        boolean bl = false;
        handlerManager2.playList = list = (List)new ArrayList();
        handlerManager2 = this;
        bl = false;
        handlerManager2.listenerList = list = (List)new ArrayList();
        this.createPlayFilter$delegate = LazyKt.lazy((Function0)createPlayFilter.2.INSTANCE);
        this.gameFilter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GameFilter>(this){
            final /* synthetic */ HandlerManager this$0;

            @NotNull
            public final GameFilter invoke() {
                return new GameFilter(this.this$0);
            }
            {
                this.this$0 = handlerManager2;
                super(0);
            }
        }));
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
    }

    public static final /* synthetic */ ViewGroup access$getContainer(HandlerManager $this) {
        return $this.getContainer();
    }

    public static final /* synthetic */ List access$getPlayList$p(HandlerManager $this) {
        return $this.playList;
    }

    public static final /* synthetic */ GameFilter access$getGameFilter$p(HandlerManager $this) {
        return $this.getGameFilter();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/wallet/floatplay/handler/HandlerManager$Companion;", "", "()V", "TAG", "", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

