/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui.tab;

import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.R;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.coupon.ui.tab.BaseCouponViewHolder;
import com.yy.hiyo.wallet.coupon.ui.tab.ICouponListItemListener;
import org.json.JSONException;
import org.json.JSONObject;

public class CouponTabViewHolder
extends BaseCouponViewHolder {
    private static final String TAG = "CouponTabViewHolder";
    private View mItemView;
    private CheckBox mCouponCb;
    private TextView mTVCouponName;
    private TextView mTVCouponExpire;
    private TextView mTVCouponRange;
    private TextView mTvVaildEndTimeInTest;
    private boolean mIsAvailable;

    public CouponTabViewHolder(View itemView, boolean isAvailable, final ICouponListItemListener listener) {
        super(itemView);
        this.mIsAvailable = isAvailable;
        this.mItemView = itemView;
        this.mCouponCb = (CheckBox)itemView.findViewById(R.id.coupon_cb);
        this.mTVCouponName = (TextView)itemView.findViewById(R.id.tv_coupon_name);
        this.mTVCouponExpire = (TextView)itemView.findViewById(R.id.tv_coupon_expire);
        this.mTVCouponRange = (TextView)itemView.findViewById(R.id.tv_coupon_range);
        this.mTvVaildEndTimeInTest = (TextView)itemView.findViewById(R.id.tv_end_time_test);
        if (isAvailable) {
            this.mCouponCb.setVisibility(0);
            this.mTVCouponName.setTextColor(Color.parseColor((String)"#0b0505"));
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CouponTabViewHolder.this.mCouponCb.setChecked(!CouponTabViewHolder.this.mCouponCb.isChecked());
                    if (listener != null) {
                        listener.onItemClick(CouponTabViewHolder.this.mCouponCb.isChecked(), (Integer)v.getTag());
                    }
                }
            });
        } else {
            this.mCouponCb.setVisibility(8);
            this.mTVCouponName.setTextColor(Color.parseColor((String)"#999999"));
        }
    }

    @Override
    public void updateItem(CouponBean couponBean, int position) {
        if (couponBean == null) {
            return;
        }
        this.mCouponCb.setChecked(couponBean.isCheck);
        this.mItemView.setTag((Object)position);
        this.mTVCouponName.setText((CharSequence)couponBean.couponName);
        this.mTVCouponRange.setText((CharSequence)this.getCouponRangeTip(couponBean));
        if (this.mIsAvailable) {
            long diffTime = couponBean.validEndTime - couponBean.serverCurrentTime - (System.currentTimeMillis() - couponBean.localCurrentTime);
            long oneHour = 3600000L;
            long oneDayTime = oneHour * 24L;
            long day = diffTime / oneDayTime;
            long diffHour = diffTime / oneHour;
            int hourOf24HClock = TimeUtils.getHourOf24HClock((long)couponBean.validEndTime);
            if (diffHour <= (long)hourOf24HClock) {
                this.mTVCouponExpire.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_coupon_expire_today));
            } else {
                this.mTVCouponExpire.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_theme_expire, (Object[])new Object[]{day + ""}));
            }
        } else {
            this.mTVCouponExpire.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_used));
        }
        this.mTvVaildEndTimeInTest.setVisibility(8);
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        if (type == EnvSettingType.Test) {
            this.mTvVaildEndTimeInTest.setText((CharSequence)("Test:" + TimeUtils.getTimeStringFromMillis((long)couponBean.validEndTime)));
            this.mTvVaildEndTimeInTest.setVisibility(0);
        }
    }

    public String getCouponRangeTip(CouponBean bean) {
        String tip = "";
        if (TextUtils.isEmpty((CharSequence)bean.couponUseWayInfo) || bean == null) {
            return tip;
        }
        if (!TextUtils.isEmpty((CharSequence)bean.couponRangeTip)) {
            return bean.couponRangeTip;
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)bean.couponUseWayInfo);
            int subType = jsonObject.getInt("subType");
            if (subType == 0) {
                tip = ResourceUtils.getString((int)R.string.tips_all_recharges);
            } else {
                JSONObject countryToAmount = jsonObject.getJSONObject("countryToAmount");
                String price = countryToAmount.getString("US");
                if (countryToAmount.has(SystemUtils.getHagoCountry())) {
                    price = countryToAmount.getString(SystemUtils.getHagoCountry());
                }
                if (!TextUtils.isEmpty((CharSequence)price)) {
                    if (subType == 1) {
                        tip = ResourceUtils.getString((int)R.string.tips_only_recharges, (Object[])new Object[]{price});
                    } else if (subType == 2) {
                        tip = ResourceUtils.getString((int)R.string.tips_after_reaching, (Object[])new Object[]{price});
                    }
                }
            }
        }
        catch (JSONException e) {
            FeatureLog.i((String)"FTPayCoupon", (String)"\u4f18\u60e0\u5238\u4f7f\u7528\u8303\u56f4\u89e3\u6790\u5f02\u5e38\uff1a%s", (Object[])new Object[]{e.toString()});
        }
        bean.couponRangeTip = tip;
        return tip;
    }
}

