/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad.config;

import androidx.annotation.NonNull;
import com.yy.base.utils.StringUtils;
import com.yy.socialplatformbase.data.AdPlatform;
import com.yy.socialplatformbase.data.AdvertiseType;

public class AdvertiseDetail {
    private String adId;
    private AdvertiseType adType;
    private AdPlatform origin;

    static AdvertiseDetail create(net.ihago.money.api.appconfigcenter.AdvertiseDetail pad) {
        AdvertiseDetail detail = new AdvertiseDetail();
        detail.adId = pad.ad_id;
        detail.adType = AdvertiseType.type((int)pad.show_type);
        detail.origin = AdPlatform.platform((int)pad.origin);
        return detail;
    }

    public String getAdId() {
        return this.adId;
    }

    @NonNull
    public AdvertiseType getAdType() {
        if (this.adType == null) {
            this.adType = AdvertiseType.none;
        }
        return this.adType;
    }

    @NonNull
    public AdPlatform getPlatform() {
        if (this.origin == null) {
            this.origin = AdPlatform.unknown;
        }
        return this.origin;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public void setAdType(AdvertiseType adType) {
        this.adType = adType;
    }

    public void setOrigin(AdPlatform origin) {
        this.origin = origin;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdvertiseDetail)) {
            return false;
        }
        AdvertiseDetail detail = (AdvertiseDetail)obj;
        if (StringUtils.isEmpty((String)detail.adId) || StringUtils.isEmpty((String)this.adId)) {
            return false;
        }
        return detail.adId.equals(this.adId);
    }

    public String toString() {
        return "AdvertiseDetail:adId=" + this.adId + ",adType=" + this.adType.name() + ",AdPlatform=" + this.origin.name();
    }
}

