/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad.config;

import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.wallet.ad.config.AdSdkConfig;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.hiyo.wallet.ad.config.OnAdConfigChangedListener;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.money.api.appconfigcenter.AdvertiseRetCode;
import net.ihago.money.api.appconfigcenter.CommonAdvertiseInfo;
import net.ihago.money.api.appconfigcenter.GetAdvertiseConfigReq;
import net.ihago.money.api.appconfigcenter.GetAdvertiseConfigRsp;

public class AdConfigModel
implements INotify {
    private static final String TAG = "AdConfigModel";
    private static final long GET_CONFIG_TIME_OUT_LENGTH = 15000L;
    private IQueueTaskExecutor mQueueExecutor;
    private final Map<Integer, AdvertiseConfigInfo> mAdConfigs;
    private final List<OnAdConfigChangedListener> mChangeListener = new CopyOnWriteArrayList<OnAdConfigChangedListener>();
    private int mConfigVersion = 0;
    private int mConditionId = 0;
    private AdSdkConfig mAdSdkConfig;
    private volatile boolean hadRequestSuccess;
    private volatile int mRetryCount;
    private Runnable mRequestRetry = new Runnable(){

        @Override
        public void run() {
            if (!AdConfigModel.this.hadRequestSuccess && AdConfigModel.this.mRetryCount < 3) {
                AdConfigModel.this.mRetryCount++;
                AdConfigModel.this.requestConfig();
            }
        }
    };

    private AdConfigModel() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        this.mQueueExecutor = YYTaskExecutor.createAQueueExcuter();
        this.mAdConfigs = new ConcurrentHashMap<Integer, AdvertiseConfigInfo>();
    }

    public void init() {
        this.parseCacheConfig();
    }

    public static AdConfigModel getInstance() {
        return Instance.instance;
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            MLog.debug((Object)TAG, (String)("request config " + this.hadRequestSuccess), (Object[])new Object[0]);
            if (!this.hadRequestSuccess) {
                this.requestConfig();
            }
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            if (!this.hadRequestSuccess) {
                this.mQueueExecutor.execute(this.mRequestRetry, 1000L);
            }
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.clearConfig();
        }
    }

    public void requestConfig() {
        if (AccountUtil.getUid() <= 0L) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigModel requestConfig, but not login", (Object[])new Object[0]);
            return;
        }
        this.hadRequestSuccess = true;
        if (!this.hadRequestSuccess) {
            this.mQueueExecutor.removeTask(this.mRequestRetry);
            this.mQueueExecutor.execute(this.mRequestRetry, 5000L);
            FeatureLog.i((String)"FTAdv", (String)"AdConfigModel requestConfig version: %d, mAdConfigs.size: %d, hadRequestSuccess: %b\uff0c mRetryCount: %d", (Object[])new Object[]{this.mConfigVersion, FP.size(this.mAdConfigs), this.hadRequestSuccess, this.mRetryCount});
            GetAdvertiseConfigReq req = new GetAdvertiseConfigReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).version(Long.valueOf(this.mConfigVersion)).build();
            ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetAdvertiseConfigRsp>(){

                public long getTimeoutTimeLength() {
                    return 15000L;
                }

                public void onResponse(@Nullable GetAdvertiseConfigRsp response) {
                    if (response == null) {
                        FeatureLog.e((String)"FTAdv", (String)"AdConfigModel onResponse error while response is null", (Object[])new Object[0]);
                        return;
                    }
                    FeatureLog.i((String)"FTAdv", (String)"AdConfigModel onResponse result: %d, prompt: %s", (Object[])new Object[]{response.getResultValue(), response.prompt});
                    if (RuntimeContext.sIsDebuggable) {
                        FeatureLog.i((String)"FTAdv", (String)"AdConfigModel onResponse response: %s", (Object[])new Object[]{response});
                    }
                    AdConfigModel.this.mQueueExecutor.removeTask(AdConfigModel.this.mRequestRetry);
                    AdvertiseRetCode code = response.result;
                    if (code == AdvertiseRetCode.kRetCodeOK || code == AdvertiseRetCode.kRetCodeSameVersion) {
                        AdConfigModel.this.hadRequestSuccess = true;
                    } else {
                        AdConfigModel.this.mQueueExecutor.execute(AdConfigModel.this.mRequestRetry, 5000L);
                    }
                    if (response.result == AdvertiseRetCode.kRetCodeOK) {
                        AdConfigModel.this.handleResponse(response, false);
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    FeatureLog.e((String)"FTAdv", (String)"retryWhenTimeout canRetry: %s", (Object[])new Object[]{canRetry});
                    AdConfigModel.this.mQueueExecutor.removeTask(AdConfigModel.this.mRequestRetry);
                    AdConfigModel.this.mQueueExecutor.execute(AdConfigModel.this.mRequestRetry, 5000L);
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    FeatureLog.e((String)"FTAdv", (String)"AdConfigModel retryWhenError code: %d, reason: %s", (Object[])new Object[]{code, reason});
                    AdConfigModel.this.mQueueExecutor.removeTask(AdConfigModel.this.mRequestRetry);
                    AdConfigModel.this.mQueueExecutor.execute(AdConfigModel.this.mRequestRetry, 5000L);
                    return false;
                }
            });
        }
    }

    @Nullable
    public AdvertiseConfigInfo getAdConfig(int localAdId) {
        if (localAdId == 0) {
            return null;
        }
        return this.mAdConfigs.get(localAdId);
    }

    public int getConditionId() {
        return this.mConditionId;
    }

    public Map<Integer, AdvertiseConfigInfo> getAdConfigs() {
        return this.mAdConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangedListener(final OnAdConfigChangedListener listener, boolean notifyWhenAdd) {
        if (notifyWhenAdd) {
            if (YYTaskExecutor.isMainThread()) {
                listener.onAdConfigChanged(new HashMap<Integer, AdvertiseConfigInfo>(this.mAdConfigs));
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onAdConfigChanged(new HashMap<Integer, AdvertiseConfigInfo>(AdConfigModel.this.mAdConfigs));
                    }
                });
            }
        }
        List<OnAdConfigChangedListener> list = this.mChangeListener;
        synchronized (list) {
            if (!this.mChangeListener.contains(listener)) {
                this.mChangeListener.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangedListener(OnAdConfigChangedListener listener) {
        if (listener == null) {
            return;
        }
        List<OnAdConfigChangedListener> list = this.mChangeListener;
        synchronized (list) {
            this.mChangeListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangedListener(OnAdConfigChangedListener listener) {
        if (listener == null) {
            return;
        }
        List<OnAdConfigChangedListener> list = this.mChangeListener;
        synchronized (list) {
            if (!this.mChangeListener.contains(listener)) {
                this.mChangeListener.add(listener);
            }
        }
    }

    @MainThread
    private void handleResponse(GetAdvertiseConfigRsp response, boolean isCache) {
        if (response == null) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigModel handleResponse response == null", (Object[])new Object[0]);
            return;
        }
        FeatureLog.i((String)"FTAdv", (String)"AdConfigModel handleResponse isCache: %b, version: %d, result: %d, size: %d", (Object[])new Object[]{isCache, response.version, response.getResultValue(), FP.size((Map)response.ads)});
        this.mAdConfigs.clear();
        this.mConfigVersion = FP.orInt((Long)response.version);
        this.mConditionId = response.condition_id;
        HiidoStatis.putAbTestFlag((String)"ad_realize_group", (String)String.valueOf(this.mConditionId));
        this.mAdSdkConfig = AdSdkConfig.create(response.sdk_config);
        FeatureLog.i((String)"FTAdv", (String)"AdConfigModel handleResponse mAdSdkConfig: %s", (Object[])new Object[]{this.mAdSdkConfig});
        Map ids = response.ads;
        if (!FP.empty((Map)ids)) {
            for (CommonAdvertiseInfo config : ids.values()) {
                if (config == null) continue;
                AdvertiseConfigInfo bc = AdvertiseConfigInfo.create(config);
                if (RuntimeContext.sIsDebuggable) {
                    FeatureLog.i((String)"FTAdv", (String)"AdConfigModel handleResponse bc: %s", (Object[])new Object[]{bc});
                }
                this.mAdConfigs.put(bc.getLocalAdId(), bc);
            }
        }
        if (!isCache) {
            this.saveConfig(response);
        } else if (RuntimeContext.sIsAppStartFinished && !this.hadRequestSuccess) {
            this.requestConfig();
        }
        this.notifyChanged();
    }

    @MainThread
    private void notifyChanged() {
        if (FP.empty(this.mChangeListener)) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.notifyOnUi();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    AdConfigModel.this.notifyOnUi();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnUi() {
        List<OnAdConfigChangedListener> list = this.mChangeListener;
        synchronized (list) {
            for (OnAdConfigChangedListener listener : this.mChangeListener) {
                if (listener == null) continue;
                listener.onAdConfigChanged(new HashMap<Integer, AdvertiseConfigInfo>(this.mAdConfigs));
            }
        }
    }

    private void parseCacheConfig() {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigModel parseCacheConfig mAdConfigs.size: %d, mConfigVersion: %d", (Object[])new Object[]{FP.size(this.mAdConfigs), this.mConfigVersion});
        this.mQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                byte[] bs = AdConfigModel.this.readConfig();
                if (bs == null) {
                    FeatureLog.i((String)"FTAdv", (String)"AdConfigModel parseCacheConfig read file failed, maybe not exist", (Object[])new Object[0]);
                    AdConfigModel.this.requestConfig();
                    return;
                }
                try {
                    final GetAdvertiseConfigRsp rsp = (GetAdvertiseConfigRsp)GetAdvertiseConfigRsp.ADAPTER.decode(bs);
                    if (rsp != null) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AdConfigModel.this.handleResponse(rsp, true);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    FeatureLog.e((String)"FTAdv", (String)"AdConfigModel parse proto error", (Object[])new Object[0]);
                    AdConfigModel.this.requestConfig();
                }
            }
        }, 0L);
    }

    private void clearConfig() {
        FeatureLog.i((String)"FTAdv", (String)"clearConfig", (Object[])new Object[0]);
        this.hadRequestSuccess = false;
        this.mConfigVersion = 0;
        this.mRetryCount = 0;
        this.mAdConfigs.clear();
        this.saveConfig(null);
        this.notifyChanged();
    }

    private void saveConfig(final GetAdvertiseConfigRsp response) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigModel saveConfig response == null: %b", (Object[])new Object[]{response == null});
        if (response == null) {
            this.mQueueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    YYFileUtils.delete((File)new File(AdConfigModel.this.getCachePath()));
                }
            }, 0L);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.mQueueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    byte[] bs = response.encode();
                    YYFileUtils.writeBytes((File)new File(AdConfigModel.this.getCachePath()), (byte[])bs, (int)0, (int)bs.length);
                }
            }, 0L);
        } else {
            byte[] bs = response.encode();
            YYFileUtils.writeBytes((File)new File(this.getCachePath()), (byte[])bs, (int)0, (int)bs.length);
        }
    }

    @Nullable
    private byte[] readConfig() {
        byte[] bs = YYFileUtils.readBytes((File)new File(this.getCachePath()));
        FeatureLog.i((String)"FTAdv", (String)"AdConfigModel readConfig bs == null: %b", (Object[])new Object[]{bs == null});
        return bs;
    }

    public AdSdkConfig getAdSdkConfig() {
        return this.mAdSdkConfig;
    }

    private String getCachePath() {
        String name = "ababbababbaamammama.ad";
        if (RuntimeContext.sIsDebuggable) {
            name = "ad_config.txt";
        }
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + name;
    }

    private static class Instance {
        static AdConfigModel instance = new AdConfigModel();

        private Instance() {
        }
    }
}

