/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AdConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.ad.AdConfigAllModel;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.AdModel;
import com.yy.hiyo.wallet.ad.AdStatisHelper;
import com.yy.hiyo.wallet.ad.AdViewProvider;
import com.yy.hiyo.wallet.ad.config.AdConfigModel;
import com.yy.hiyo.wallet.ad.config.AdSdkConfig;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.hiyo.wallet.ad.config.OnAdConfigChangedListener;
import com.yy.socialplatformbase.callback.IAdCacheCallBack;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import com.yy.socialplatformbase.data.AdPlatform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public enum AdManager implements OnAdConfigChangedListener
{
    INSTANCE;

    private static final String TAG = "AdManager";
    private AdModel mAdModel;
    private AdViewProvider mAdViewProvider;
    private Map<Integer, AdEntity> mAdCacheMap = new HashMap<Integer, AdEntity>();
    private Map<Integer, Long> mCacheingMap = new HashMap<Integer, Long>();

    public void init(Context context) {
        this.mAdModel = new AdModel();
        this.mAdViewProvider = new AdViewProvider(context);
        AdConfigModel.getInstance().addChangedListener(this);
        AdConfigModel.getInstance().init();
    }

    public void cacheAd(int localAdId, IAdCallback callback2) {
        this.cacheAd(localAdId, -1, true, callback2);
    }

    public void cacheAd(int localAdId, boolean isRefreshConfig, IAdCallback callback2) {
        this.cacheAd(localAdId, -1, isRefreshConfig, callback2);
    }

    public void cacheAd(int localAdId, int adType, IAdCallback callback2) {
        this.cacheAd(localAdId, adType, true, callback2);
    }

    public void cacheAd(int localAdId, int adType, boolean isRefreshConfig, IAdCallback callback2) {
        FeatureLog.i((String)"FTAdv", (String)"AdManager cacheAd localAdId=%d, isRefreshConfig=%s", (Object[])new Object[]{localAdId, isRefreshConfig});
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"Network unavailable", (int)0);
            }
            if (callback2 != null) {
                callback2.onError(100000013, "no network");
            }
            FeatureLog.i((String)"FTAdv", (String)"AdManager no network localAdId=%d", (Object[])new Object[]{localAdId});
            return;
        }
        if (!this.judgeAdConfig(localAdId, adType, callback2)) {
            return;
        }
        final int newLocalAdId = AdConfigureManager.INSTANCE.dealWithGoogleRewardVideoAd(localAdId);
        if (!AdConfigureManager.INSTANCE.canAdvertiseTypeCache(newLocalAdId)) {
            if (callback2 != null) {
                callback2.onError(99999995, "error_type_banner_no_need_cache");
            }
            FeatureLog.i((String)"FTAdv", (String)"AdManager no banner cacheAd localAdId=%d", (Object[])new Object[]{newLocalAdId});
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            if (!AdConfigureManager.INSTANCE.canRequestAd(newLocalAdId) && AdConfigureManager.INSTANCE.canShowToast(newLocalAdId)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u65f6\u95f4\u95f4\u9694\u592a\u77ed\u4e0d\u80fd\u518d\u8bf7\u6c42\u7f13\u5b58\u5e7f\u544a\uff0clocalAdId=" + newLocalAdId), (int)0);
            }
            if (!AdConfigureManager.INSTANCE.isAdCacheExpired(newLocalAdId) && AdConfigureManager.INSTANCE.canShowToast(newLocalAdId)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u7f13\u5b58\u672a\u8fc7\u671f\u4e0d\u80fd\u8bf7\u6c42\u7f13\u5b58\u5e7f\u544a\uff0clocalAdId=" + newLocalAdId), (int)0);
            }
        }
        if (!this.canRequestAdInInterval(newLocalAdId)) {
            if (callback2 != null) {
                callback2.onError(99999998, "error_type_request_interval_short");
            }
            return;
        }
        if (!AdConfigureManager.INSTANCE.canRequestAd(newLocalAdId)) {
            if (callback2 != null) {
                callback2.onError(100000006, "error_type_request_interval_limited");
            }
            return;
        }
        if (!AdConfigureManager.INSTANCE.isAdCacheExpired(newLocalAdId)) {
            if (callback2 != null) {
                callback2.onError(100000007, "error_type_cache_not_expired");
            }
            return;
        }
        if (AdConfigureManager.INSTANCE.canRequestAd(newLocalAdId) && AdConfigureManager.INSTANCE.isAdCacheExpired(newLocalAdId)) {
            if (RuntimeContext.sIsDebuggable && AdConfigureManager.INSTANCE.canShowToast(newLocalAdId)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u5f00\u59cb\u8bf7\u6c42\u7f13\u5b58\u5e7f\u544a\uff0clocalAdId=" + newLocalAdId), (int)0);
            }
            if (isRefreshConfig) {
                AdConfigureManager.INSTANCE.refreshAdConfig(localAdId);
            }
            final IAdCallback proxyCallback = AdStatisHelper.proxyCacheAd(newLocalAdId, callback2);
            this.mCacheingMap.put(newLocalAdId, SystemClock.elapsedRealtime());
            this.mAdModel.cacheAd(newLocalAdId, new IAdCacheCallBack(){

                public void onAdLoadSuccess(AdEntity adEntity) {
                    FeatureLog.i((String)"FTAdv", (String)"AdManager cacheAd onAdLoadSuccess localAdId=%d", (Object[])new Object[]{newLocalAdId});
                    if (RuntimeContext.sIsDebuggable && AdConfigureManager.INSTANCE.canShowToast(newLocalAdId)) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u7f13\u5b58\u5e7f\u544a\u6210\u529f\uff0clocalAdId=" + newLocalAdId), (int)0);
                    }
                    if (adEntity != null) {
                        AdManager.this.setAdCache(newLocalAdId, adEntity);
                    }
                    AdManager.this.mCacheingMap.remove(newLocalAdId);
                    if (proxyCallback != null) {
                        proxyCallback.onAdLoadSuccess(adEntity);
                    }
                }

                public void onError(int code, String error) {
                    FeatureLog.e((String)"FTAdv", (String)"AdManager cacheAd onError localAdId=%d, error=%s", (Object[])new Object[]{newLocalAdId, error});
                    if (RuntimeContext.sIsDebuggable) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u53ea\u5728Debug\u4e0b\u663e\u793a\uff1a\u83b7\u53d6\u5e7f\u544a\u5931\u8d25:" + error), (int)0);
                    }
                    AdManager.this.mCacheingMap.remove(newLocalAdId);
                    if (AdConfigureManager.INSTANCE.updateAdIdConfig(newLocalAdId, code)) {
                        AdManager.this.cacheAd(newLocalAdId, false, proxyCallback);
                    } else if (proxyCallback != null) {
                        proxyCallback.onError(code, error);
                    }
                }
            });
        }
    }

    public void loadAd(int localAdId, ViewGroup adContainer, IAdCallback callback2, boolean needCacheFirst) {
        this.loadAd(localAdId, adContainer, -1, callback2, needCacheFirst, false);
    }

    public void loadAd(int localAdId, ViewGroup adContainer, int adType, IAdCallback callback2, boolean needCacheFirst, boolean isRefreshConfig) {
        int newLocalAdId;
        FeatureLog.i((String)"FTAdv", (String)"AdManager loadAd localAdId=%d", (Object[])new Object[]{localAdId});
        if (!this.judgeAdConfig(localAdId, adType, callback2)) {
            return;
        }
        if (isRefreshConfig) {
            AdConfigureManager.INSTANCE.refreshAdConfig(localAdId);
        }
        if (this.mAdCacheMap.containsKey(newLocalAdId = AdConfigureManager.INSTANCE.dealWithGoogleRewardVideoAd(localAdId))) {
            if (!AdConfigureManager.INSTANCE.isAdCacheExpired(newLocalAdId)) {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadAd isAdCacheExpired=no, localAdId=%d", (Object[])new Object[]{newLocalAdId});
                AdEntity adEntity = this.mAdCacheMap.get(newLocalAdId);
                if (adEntity != null) {
                    this.loadPlatformAd(newLocalAdId, adContainer, adEntity, callback2);
                    this.mAdCacheMap.remove(newLocalAdId);
                    long cacheTimestamp = AdConfigureManager.INSTANCE.removeCacheTimestamp(newLocalAdId);
                    AdStatisHelper.monitorLoadCacheAd(newLocalAdId, cacheTimestamp);
                } else if (callback2 != null) {
                    callback2.onError(99999991, "");
                }
            } else {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadAd isAdCacheExpired=yes, localAdId=%s", (Object[])new Object[]{newLocalAdId});
                this.mAdCacheMap.remove(newLocalAdId);
                long cacheTimestamp = AdConfigureManager.INSTANCE.removeCacheTimestamp(newLocalAdId);
                AdStatisHelper.monitorCacheAdExpired(newLocalAdId, cacheTimestamp);
                this.cacheAd(newLocalAdId, null);
                if (callback2 != null) {
                    callback2.onError(99999991, "");
                }
            }
        } else if (needCacheFirst) {
            this.cacheAd(newLocalAdId, null);
            if (callback2 != null) {
                callback2.onError(99999991, "");
            }
        } else {
            this.loadPlatformAd(newLocalAdId, adContainer, null, callback2);
        }
    }

    private void loadPlatformAd(final int localAdId, final ViewGroup adContainer, final AdEntity adEntity, final IAdCallback callback2) {
        if (adEntity == null && !AdConfigureManager.INSTANCE.isUnityRewardVideoAd(localAdId) && !AdConfigureManager.INSTANCE.canRequestAd(localAdId)) {
            if (callback2 != null) {
                callback2.onError(99999991, "Invalid Ad id");
            }
            return;
        }
        final IAdCallback proxyCallback = AdStatisHelper.proxyLoadAd(localAdId, adEntity, callback2);
        this.mAdModel.loadPlatformAd(localAdId, adContainer, adEntity, new IAdCallback(){

            public void onAdLoadSuccess(AdEntity adEntity2) {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onAdLoadSuccess localAdId=%s", (Object[])new Object[]{localAdId});
                if (proxyCallback != null) {
                    proxyCallback.onAdLoadSuccess(adEntity2);
                }
                if (AdConfigureManager.INSTANCE.canNativeInflate(localAdId)) {
                    AdManager.this.mAdViewProvider.inflateNativeView(localAdId, AdConfigureManager.INSTANCE.getAdUiType(localAdId), adEntity2, adContainer, AdConfigureManager.INSTANCE.canAdClose(localAdId), proxyCallback, new View.OnClickListener(){

                        public void onClick(View v) {
                            if (adContainer != null) {
                                adContainer.setVisibility(8);
                            }
                            if (proxyCallback != null) {
                                proxyCallback.onAdClickClose();
                            }
                        }
                    });
                }
                AdConfigureManager.INSTANCE.setRequestTimestamp(localAdId, System.currentTimeMillis());
            }

            public void onError(int code, String error) {
                FeatureLog.e((String)"FTAdv", (String)"AdManager loadPlatformAd onError localAdId=%s, code=%d, error=%s", (Object[])new Object[]{localAdId, code, error});
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25,localAdId=" + localAdId + ",error=" + error), (int)0);
                }
                if (code == 100000004) {
                    FeatureLog.e((String)"FTAdv", (String)"AdManager loadPlatformAd onError localAdId=%s, ERROR_TYPE_CACHE_NOT_UPDATE", (Object[])new Object[]{localAdId});
                    AdManager.this.mAdCacheMap.remove(localAdId);
                    AdConfigureManager.INSTANCE.removeCacheTimestamp(localAdId);
                }
                if (adEntity == null && AdConfigureManager.INSTANCE.updateAdIdConfig(localAdId, code)) {
                    AdManager.this.loadAd(localAdId, adContainer, callback2, false);
                } else if (proxyCallback != null) {
                    proxyCallback.onError(code, error);
                }
            }

            public void onAdClicked() {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onAdClicked localAdId=%s", (Object[])new Object[]{localAdId});
                super.onAdClicked();
                if (adContainer != null) {
                    adContainer.setVisibility(8);
                }
                if (proxyCallback != null) {
                    proxyCallback.onAdClickClose();
                    proxyCallback.onAdClicked();
                }
            }

            public void onLoggingImpression() {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onLoggingImpression localAdId=%s", (Object[])new Object[]{localAdId});
                super.onLoggingImpression();
                if (proxyCallback != null) {
                    proxyCallback.onLoggingImpression();
                }
            }

            public void onRewardedVideoCompleted() {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onRewardedVideoCompleted localAdId=%s", (Object[])new Object[]{localAdId});
                super.onRewardedVideoCompleted();
                if (proxyCallback != null) {
                    proxyCallback.onRewardedVideoCompleted();
                }
            }

            public void onRewardedVideoClosed() {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onRewardedVideoClosed localAdId=%s", (Object[])new Object[]{localAdId});
                super.onRewardedVideoClosed();
                if (proxyCallback != null) {
                    proxyCallback.onRewardedVideoClosed();
                }
                if (AdConfigureManager.INSTANCE.needCacheAfterShowAd(localAdId)) {
                    AdManager.this.cacheAd(localAdId, null);
                }
            }

            public void onInterstitialDismissed() {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onInterstitialDismissed localAdId=%s", (Object[])new Object[]{localAdId});
                super.onInterstitialDismissed();
                if (proxyCallback != null) {
                    proxyCallback.onInterstitialDismissed();
                }
                if (localAdId == 101) {
                    AdConfigureManager.INSTANCE.setInterstitialAdDismissTimeStamp(SystemClock.elapsedRealtime());
                }
            }

            public void onInterstitialDisplayed() {
                FeatureLog.i((String)"FTAdv", (String)"AdManager loadPlatformAd onInterstitialDisplayed localAdId=%s", (Object[])new Object[]{localAdId});
                super.onInterstitialDisplayed();
                if (proxyCallback != null) {
                    proxyCallback.onInterstitialDisplayed();
                }
            }
        });
    }

    public void setAdCache(int localAdId, AdEntity adEntity) {
        if (this.mAdCacheMap.containsKey(localAdId)) {
            long timestamp = AdConfigureManager.INSTANCE.getAdCacheTimestamp(localAdId);
            AdStatisHelper.monitorCacheAdExpired(localAdId, timestamp);
        }
        this.mAdCacheMap.put(localAdId, adEntity);
        FeatureLog.i((String)"FTAdv", (String)"AdManager setAdCache localAdId=%d, getPlacementId=%s", (Object[])new Object[]{localAdId, adEntity.getPlacementId()});
        AdConfigureManager.INSTANCE.setAdCacheTimestamp(localAdId, SystemClock.elapsedRealtime());
        AdConfigureManager.INSTANCE.setRequestTimestamp(localAdId, System.currentTimeMillis());
    }

    @Override
    public void onAdConfigChanged(@NonNull Map<Integer, AdvertiseConfigInfo> configs) {
        if (configs != null) {
            FeatureLog.i((String)"FTAdv", (String)"AdManager onAdConfigChanged %d", (Object[])new Object[]{configs.size()});
        }
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
        this.initAdSdkConfig();
        AdConfigureManager.INSTANCE.updateConfigBean();
        Set<AdPlatform> initAdPlatformList = AdConfigureManager.INSTANCE.getInitAdPlatformList();
        if (initAdPlatformList != null && initAdPlatformList.size() > 0) {
            for (AdPlatform adPlatform : initAdPlatformList) {
                if (!AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().contains(adPlatform)) continue;
                this.mAdModel.initAdSdk(AdConfigureManager.INSTANCE.getConstDefPlatformId(adPlatform));
            }
        }
    }

    private synchronized void initAdSdkConfig() {
        AdSdkConfig adSdkConfig = AdConfigModel.getInstance().getAdSdkConfig();
        if (adSdkConfig != null && adSdkConfig.isEnableFilterLowMachine() && RuntimeContext.getPhoneType() == 1) {
            AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
            AdConfigureManager.INSTANCE.setAllowedAdPlatformConfigList(adSdkConfig.getInitOrigin());
            return;
        }
        this.setAllAdPlatform();
    }

    private void setAllAdPlatform() {
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.facebook);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.google);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.vungle);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.unity);
        AdConfig config = (AdConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.AD_CONFIG);
        if (config != null && config.getAdConfigData() != null && config.getAdConfigData().getBidPlatform() != null) {
            Iterator iterator = config.getAdConfigData().getBidPlatform().iterator();
            while (iterator.hasNext()) {
                int platform = (Integer)iterator.next();
                AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().remove(AdPlatform.platform((int)platform));
            }
        }
    }

    public int getAdLineNumber(int localAdId) {
        return AdConfigureManager.INSTANCE.getAdLineNumber(localAdId);
    }

    private boolean canRequestAdInInterval(int localAdId) {
        if (this.mCacheingMap.containsKey(localAdId)) {
            long timestamp = this.mCacheingMap.get(localAdId);
            if (SystemClock.elapsedRealtime() - timestamp > 4000L) {
                FeatureLog.i((String)"FTAdv", (String)"AdManager canRequestAdInInterval=%s", (Object[])new Object[]{localAdId});
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasAdCache(int localAdId) {
        int newLocalAdId = AdConfigureManager.INSTANCE.dealWithGoogleRewardVideoAd(localAdId);
        if (AdConfigureManager.INSTANCE.isVungleRewardVideoAd(localAdId)) {
            return this.mAdModel.isRewardVideoAdLoaded(newLocalAdId, null);
        }
        if (this.mAdCacheMap.containsKey(newLocalAdId)) {
            if (AdConfigureManager.INSTANCE.isGoogleRewardVideoAd(newLocalAdId)) {
                AdEntity adEntity = this.mAdCacheMap.get(newLocalAdId);
                if (adEntity != null && this.mAdModel.isRewardVideoAdLoaded(newLocalAdId, adEntity)) {
                    FeatureLog.i((String)"FTAdv", (String)"AdManager hasAdCache=true isGoogleRewardVideoAd localAdId=%d", (Object[])new Object[]{newLocalAdId});
                    return true;
                }
                this.mAdCacheMap.remove(newLocalAdId);
                AdConfigureManager.INSTANCE.removeCacheTimestamp(newLocalAdId);
                return false;
            }
            return true;
        }
        if (AdConfigureManager.INSTANCE.isUnityRewardVideoAd(localAdId)) {
            return this.mAdModel.isRewardVideoAdLoaded(newLocalAdId, null);
        }
        return false;
    }

    public void clearAdCache() {
        this.mAdCacheMap.clear();
        AdConfigureManager.INSTANCE.clearAdCacheTimestampMap();
    }

    public void pauseAdView(int localAdId) {
        this.mAdModel.pauseAdView(localAdId);
    }

    public void resumeAdView(int localAdId) {
        this.mAdModel.resumeAdView(localAdId);
    }

    public void destroyAdView(int localAdId) {
        this.mAdModel.destroyAdView(localAdId);
    }

    private boolean judgeAdConfig(int localAdId, int adType, IAdCallback callback2) {
        if (!AdConfigAllModel.getInstance().isUsingLocalAdConfig(localAdId)) {
            if (adType <= 0) {
                if (AdConfigModel.getInstance().getAdConfigs().isEmpty() || !AdConfigModel.getInstance().getAdConfigs().containsKey(localAdId)) {
                    if (callback2 != null) {
                        callback2.onError(100000008, "not_contain_config_it");
                    }
                    MLog.error((Object)"FTAdv", (String)"loadAd localAdId=%s not_contain_config_it", (Object[])new Object[]{localAdId});
                    if (RuntimeContext.sIsDebuggable && localAdId > 300) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u6ca1\u6709\u914d\u7f6e\u8be5\u5e7f\u544a " + localAdId), (int)1);
                    }
                    return false;
                }
            } else if (AdConfigAllModel.getInstance().needAddLocalAdConfig(localAdId)) {
                AdConfigAllModel.getInstance().addLocalAdConfig(localAdId, adType);
            }
        }
        if (AdConfigAllModel.getInstance().getAdConfigs().isEmpty() || !AdConfigAllModel.getInstance().getAdConfigs().containsKey(localAdId)) {
            if (callback2 != null) {
                callback2.onError(100000009, "not_contain_local_config_it");
            }
            MLog.error((Object)"FTAdv", (String)"loadAd localAdId=%s not_contain_local_config_it", (Object[])new Object[]{localAdId});
            return false;
        }
        return true;
    }
}

