/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.activity.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.service.web.IWebPageCallback;
import com.yy.appbase.ui.webview.WebViewPage;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.action.ActionManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;

public class ActivityIconView
extends YYFrameLayout
implements ICustomView {
    private static final String TAG = "ActivityImageView";
    private static final int DEFAULT_RADIUS = ResolutionUtils.dip2Px((float)3.0f);
    private ActivityAction mAction;
    protected RoundImageView mIcon;
    protected SVGAImageView mSVGAImageView;
    @Nullable
    protected WebViewPage mWebView;
    protected YYTextView mTitleText;
    private OnActionClickListener mOnActionClickListener;
    private boolean autoOpenCharge = true;
    private float mIconRadius;
    private boolean needAniAfterAttach;
    private String aniIconUrl;
    private YYPlaceHolderView mWebHolder;

    public ActivityIconView(Context context) {
        super(context);
        this.createView(null);
    }

    public ActivityIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public ActivityIconView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        ActivityIconView.inflate((Context)this.getContext(), (int)this.getLayoutId(), (ViewGroup)this);
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ActivityIconView, 0, 0);
        try {
            this.mIconRadius = typedArray.getDimension(R.styleable.ActivityIconView_iconRadius, (float)DEFAULT_RADIUS);
        }
        finally {
            typedArray.recycle();
        }
        this.mIcon = (RoundImageView)this.findViewById(R.id.action_icon);
        this.mSVGAImageView = (SVGAImageView)this.findViewById(R.id.action_svga);
        this.mTitleText = (YYTextView)this.findViewById(R.id.action_text);
        this.mWebHolder = (YYPlaceHolderView)this.findViewById(R.id.action_h5_holder);
        this.setAutoOpenCharge(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.needAniAfterAttach && StringUtils.isNotEmpty((String)this.aniIconUrl) && this.mSVGAImageView.getVisibility() == 0) {
            this.needAniAfterAttach = false;
            this.startSVGAAnimation();
        }
    }

    private void startSVGAAnimation() {
        SvgaLoader.load((SVGAImageView)this.mSVGAImageView, (String)this.aniIconUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (ActivityIconView.this.isAttachToWindow() && ActivityIconView.this.mSVGAImageView != null) {
                    ActivityIconView.this.mSVGAImageView.startAnimation();
                } else {
                    ActivityIconView.this.needAniAfterAttach = true;
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mSVGAImageView.stopAnimation(true);
        ViewCompat.setBackground((View)this.mSVGAImageView, null);
    }

    protected int getLayoutId() {
        return R.layout.wallet_activity_image_view;
    }

    public void setData(ActivityAction data) {
        if (data != null) {
            this.mAction = data;
            this.setVisibility(0);
            this.mIcon.setVisibility(8);
            this.mIcon.setImageDrawable(null);
            this.mIcon.setBackground(null);
            this.mSVGAImageView.setVisibility(8);
            this.mSVGAImageView.setImageDrawable(null);
            this.mSVGAImageView.setBackground(null);
            this.mTitleText.setVisibility(8);
            this.mTitleText.setText((CharSequence)"");
            if (data.pictureType == ActivityAction.PictureType.SVGA) {
                this.mSVGAImageView.setVisibility(0);
                if (this.isAttachToWindow()) {
                    this.aniIconUrl = data.iconUrl;
                    this.startSVGAAnimation();
                } else {
                    this.aniIconUrl = data.iconUrl;
                    this.needAniAfterAttach = true;
                }
            } else if (data.pictureType == ActivityAction.PictureType.IMAGE) {
                this.mIcon.setVisibility(0);
                this.mIcon.setBorderRadius(ResolutionUtils.dip2Px((float)this.mIconRadius));
                ImageLoader.loadImage((ImageView)this.mIcon, (String)data.iconUrl, (int)0, (int)R.drawable.yylite_launcher);
            } else if (data.pictureType == ActivityAction.PictureType.H5) {
                this.initWebView(data);
            }
            if (data.actExtraInfos != null && data.actExtraInfos.containsKey("isShowIcon")) {
                String isShowIcon = (String)data.actExtraInfos.get("isShowIcon");
                MLog.info((Object)TAG, (String)"isShowIcon=%s", (Object[])new Object[]{isShowIcon});
                if ("false".equals(isShowIcon)) {
                    this.mIcon.setVisibility(8);
                    this.mSVGAImageView.setVisibility(8);
                    this.mTitleText.setVisibility(0);
                } else {
                    if (data.pictureType == ActivityAction.PictureType.SVGA) {
                        this.mSVGAImageView.setVisibility(0);
                    } else if (data.pictureType == ActivityAction.PictureType.IMAGE) {
                        this.mIcon.setVisibility(0);
                    }
                    this.mTitleText.setVisibility(8);
                }
            }
        } else {
            this.setVisibility(8);
        }
    }

    private void initWebView(ActivityAction data) {
        MLog.info((Object)TAG, (String)"initWebView linkUrl %s", (Object[])new Object[]{data.linkUrl});
        this.mIcon.setVisibility(8);
        this.mSVGAImageView.setVisibility(8);
        if (this.mWebView == null) {
            this.mWebView = new WebViewPage(this.getContext());
        }
        this.mWebHolder.inflate((View)this.mWebView);
        this.mWebView.setData("", data.linkUrl);
        this.mWebView.setWebPageCallback(new IWebPageCallback(){

            public void exitWebView() {
                super.exitWebView();
                ActivityIconView.this.mWebView.setVisibility(8);
                ActivityIconView.this.removeView((View)ActivityIconView.this.mWebView);
                ActivityIconView.this.mWebView.destroy();
            }
        });
    }

    public ActivityAction getData() {
        return this.mAction;
    }

    private void openRecharge(ActivityAction action) {
        MLog.info((Object)TAG, (String)"openRecharge %s", (Object[])new Object[]{action});
        ActionManager.obtain().onAction(action);
    }

    public void setAutoOpenCharge(boolean autoOpenCharge) {
        this.autoOpenCharge = autoOpenCharge;
        if (autoOpenCharge) {
            this.setOnClickListener(view -> {
                if (this.mOnActionClickListener != null) {
                    this.mOnActionClickListener.onActionClick(this, this.mAction);
                }
                this.openRecharge(this.mAction);
            });
        } else {
            this.setClickable(false);
        }
    }

    public void setOnActionClickListener(OnActionClickListener onActionClickListener) {
        this.mOnActionClickListener = onActionClickListener;
    }

    public static interface OnActionClickListener {
        public void onActionClick(ActivityIconView var1, ActivityAction var2);
    }
}

