/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.send;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ConfirmDialog;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketBehavior;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ISendPacketListener;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ui.QuestDialog;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.ui.SendPacketPanel;
import java.util.Collection;
import java.util.List;
import net.ihago.money.api.redpacket.Code;
import net.ihago.money.api.redpacket.GetSendConfigReq;
import net.ihago.money.api.redpacket.GetSendConfigRes;
import net.ihago.money.api.redpacket.SendGear;
import net.ihago.money.api.redpacket.SendPacketReq;
import net.ihago.money.api.redpacket.SendPacketRes;

public class SendPacketPresenter
implements IPacketPresenter,
ISendPacketListener {
    private static final String TAG = "FTRedPacketSendPresenter";
    private RedPacketParam mPacketParam;
    private SendPacketPanel mSendPanel;
    private SendGear mSelectedGear;
    private DialogLinkManager mDialogLinkManager;
    private Context mContext;

    @Override
    public void onCreate(RedPacketParam createParam) {
        this.mPacketParam = createParam;
    }

    @Override
    public void onStart(ViewGroup parent) {
        this.mContext = parent.getContext();
    }

    public void showSendPacket() {
        this.reqPacketGear();
    }

    @Override
    public void onDestroy() {
        if (this.mSendPanel != null && this.mPacketParam.getBehavior().getPanelLayer() != null) {
            this.mPacketParam.getBehavior().getPanelLayer().hidePanel((BasePanel)this.mSendPanel, false);
        }
        if (this.mDialogLinkManager != null && this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    @Override
    public void onSelectedGear(SendGear gear) {
        MLog.info((Object)TAG, (String)"onSelectedGear diamond: %d", (Object[])new Object[]{gear == null ? -1 : gear.diamonds});
        this.mSelectedGear = gear;
    }

    @Override
    public void onQuestClick() {
        this.showQuestDialog();
    }

    @Override
    public void onClick() {
        MLog.info((Object)TAG, (String)"send red packet", (Object[])new Object[0]);
        this.mSendPanel = null;
        if (this.mSelectedGear != null) {
            this.reqSendPacket(this.mSelectedGear.diamonds);
        }
    }

    @Override
    public void onClose() {
        MLog.info((Object)TAG, (String)"onClose", (Object[])new Object[0]);
        this.mSendPanel = null;
    }

    private void reqPacketGear() {
        if (this.mPacketParam == null) {
            MLog.error((Object)TAG, (String)"reqPacketGear null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"reqPacketGear", (Object[])new Object[0]);
        if (this.mPacketParam == null) {
            return;
        }
        GetSendConfigReq req = new GetSendConfigReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).build();
        ProtoManager.getInstance().sendRpc(this.mPacketParam.getRoomId(), (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetSendConfigRes>(){

            public void onResponse(@NonNull GetSendConfigRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)SendPacketPresenter.TAG, (String)"reqPacketGear code: %d, reason: %s, gear size: %d", (Object[])new Object[]{code, msg, FP.size((Collection)message.gears)});
                if (ProtoManager.isSuccessCode((long)code) && !FP.empty((Collection)message.gears)) {
                    SendPacketPresenter.this.showSendPanel(message.gears);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_gift_service_error), (int)0);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)SendPacketPresenter.TAG, (String)"reqPacketGear code: %d, reason: %s", (Object[])new Object[]{code, reason});
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_gift_service_error), (int)0);
            }
        });
    }

    private void showSendPanel(List<SendGear> list) {
        MLog.info((Object)TAG, (String)"showSendPanel list.size: %d", (Object[])new Object[]{FP.size(list)});
        if (this.mPacketParam == null) {
            return;
        }
        PanelLayer panelLayer = this.mPacketParam.getBehavior().getPanelLayer();
        this.mSendPanel = new SendPacketPanel(panelLayer.getContext(), this);
        this.mSendPanel.showBalckMask(true);
        this.mSendPanel.setGearList(list);
        panelLayer.showPanel((BasePanel)this.mSendPanel, false);
        GiftHiidoReport.sendPacketShow(this.mPacketParam.getRoomId());
    }

    private void showQuestDialog() {
        if (this.mPacketParam != null) {
            GiftHiidoReport.showQuestionDialog(this.mPacketParam.getRoomId());
        }
        QuestDialog dialog2 = new QuestDialog();
        this.getDialogManager().showDialog((BaseDialog)dialog2);
    }

    private void reqSendPacket(int diamond) {
        long sequence = System.currentTimeMillis();
        IRedPacketBehavior behavior = this.mPacketParam.getBehavior();
        UserInfoKS user = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        SendPacketReq req = new SendPacketReq.Builder().sequence(Long.valueOf(sequence)).diamonds(Integer.valueOf(diamond)).sender_nick(user.nick).sender_avatar(user.avatar).owner_uid(Long.valueOf(behavior.roomOwnUid())).room_nick(behavior.roomName()).room_locked(Boolean.valueOf(behavior.isRoomLock())).build();
        ProtoManager.getInstance().sendRpc(this.mPacketParam.getRoomId(), (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SendPacketRes>(){

            public void onResponse(@NonNull SendPacketRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)SendPacketPresenter.TAG, (String)"reqPacketGear code: %d, reason: %s", (Object[])new Object[]{code, msg});
                if (!ProtoManager.isSuccessCode((long)code)) {
                    SendPacketPresenter.this.handlerSendPacketCode(message, code);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)SendPacketPresenter.TAG, (String)"reqSendPacket code: %d, reason: %s", (Object[])new Object[]{code, reason});
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_gift_service_error), (int)0);
            }
        });
        GiftHiidoReport.packetSendClick(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId(), diamond);
    }

    private void handlerSendPacketCode(SendPacketRes message, long code) {
        if (code == (long)Code.CodeNotEnoughDiamonds.getValue()) {
            this.showConfirmDialog(R.string.short_summary_send_packet_no_balance, R.string.btn_send_packet_no_balance_buy, this::toRecharge);
            GiftHiidoReport.redPacketNoEnoughDialogShow(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
        } else if (code == (long)Code.CodeInQueue.getValue()) {
            this.showConfirmDialog(R.string.short_summary_send_packet_queue, R.string.dialog_ok, null);
            GiftHiidoReport.redPacketQueueDialogShow(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
        } else if (code == (long)Code.CodeRoomLocked.getValue()) {
            this.showConfirmDialog(R.string.short_summary_send_packet_lock_tips, R.string.dialog_ok, null);
        } else if (code == (long)Code.CodeIsPrivate.getValue()) {
            this.showConfirmDialog(R.string.tips_send_packet_private_channel, R.string.dialog_ok, null);
        } else if (code == (long)Code.CodeAccountIsFreezed.getValue()) {
            this.showConfirmDialog(R.string.tips_send_packet_fronze, R.string.dialog_ok, null);
        } else if (code == (long)Code.CodeDailyLimit.getValue()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.short_tips_packet_diamond_limit, (Object[])new Object[]{message.daily_limit_diamonds}), (int)0);
        } else if (code == (long)Code.CodeQueueLimit.getValue()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.short_tips_too_many_wait), (int)0);
            GiftHiidoReport.redPacketQueueDialogFail(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
        } else if (code == (long)Code.CodeBlackUser.getValue()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_red_pack_risk), (int)0);
        } else if (code == (long)Code.CodeTourist.getValue()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_red_pack__guest), (int)0);
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_gift_service_error), (int)0);
        }
    }

    private void showConfirmDialog(int res, int btn, OkDialogListener listener) {
        ConfirmDialog dialog2 = ConfirmDialog.newBuilder().canceledOnClickOutside(false).withCloseBtn(true).confirmLabel((CharSequence)ResourceUtils.getString((int)btn)).message((CharSequence)ResourceUtils.getString((int)res)).confirmListener(listener).build();
        this.getDialogManager().showDialog((BaseDialog)dialog2);
    }

    private DialogLinkManager getDialogManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.mContext);
        }
        return this.mDialogLinkManager;
    }

    private void toRecharge() {
        Message msg = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putString("gid", this.mPacketParam.getBehavior().gameId());
        bundle.putString("roomId", this.mPacketParam.getRoomId());
        bundle.putInt("fromType", 6);
        bundle.putInt("recharge_dialog_act_type", 1);
        msg.setData(bundle);
        msg.what = AppbaseMsgDef.SHOW_RECHARGE_DIALOG;
        MsgDispatcher.getInstance().sendMessage(msg);
        GiftHiidoReport.redPacketNoEnoughDialogClick(this.mPacketParam == null ? "" : this.mPacketParam.getRoomId());
    }
}

