/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.grab;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.PacketResult;
import com.yy.hiyo.wallet.redpacket.room.presenter.grab.GrabPacketState;
import java.util.HashMap;
import java.util.Map;
import net.ihago.money.api.redpacket.Code;
import net.ihago.money.api.redpacket.GetPacketInfoReq;
import net.ihago.money.api.redpacket.GetPacketInfoRes;
import net.ihago.money.api.redpacket.GrabOrigin;
import net.ihago.money.api.redpacket.GrabPacketReq;
import net.ihago.money.api.redpacket.GrabPacketRes;
import net.ihago.money.api.redpacket.PacketInfo;

public class GrabPacketPresenter
implements IPacketPresenter {
    private static final String TAG = "FTRedPacketGrabPresenter";
    public static final int GRAB_PACKET_MISS = -10001;
    private RedPacketParam mPacketParam;
    private final Map<String, GrabPacketState> mGrabPacketState = new HashMap<String, GrabPacketState>();

    @Override
    public void onCreate(RedPacketParam createParam) {
        this.mPacketParam = createParam;
    }

    @Override
    public void onDestroy() {
        this.mGrabPacketState.clear();
    }

    public void grabPacket(String packetId, GrabOrigin origin, ICommonCallback<PacketResult> callback2) {
        boolean hadGrab = this.hadGrabPacketSuccess(packetId);
        MLog.info((Object)TAG, (String)"grabPacket packetId: %s, origin: %s, hadGrab: %b", (Object[])new Object[]{packetId, origin, hadGrab});
        if (hadGrab) {
            this.reqPacketResult(packetId, callback2);
        } else {
            this.reqGrabPacket(packetId, origin, callback2);
        }
    }

    public void queryPacketResult(String packetId, ICommonCallback<PacketResult> callback2) {
        MLog.info((Object)TAG, (String)"grabPacket packetId: %s", (Object[])new Object[]{packetId});
        this.reqPacketResult(packetId, callback2);
    }

    private void reqGrabPacket(String packetId, final GrabOrigin origin, final ICommonCallback<PacketResult> callback2) {
        UserInfoKS user = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        GrabPacketReq req = new GrabPacketReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).packet_id(packetId).origin(origin).nick(user.nick).avatar(user.avatar).build();
        ProtoManager.getInstance().sendRpc(this.mPacketParam.getRoomId(), (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GrabPacketRes>(){

            public void onResponse(@NonNull GrabPacketRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)GrabPacketPresenter.TAG, (String)"reqGrabPacket onResponse code: %d, msg: %s, packet: %s, getCurGot: %b, getLastGot: %b", (Object[])new Object[]{code, msg, message.packet_info.id, message.cur_got, message.last_got});
                if (ProtoManager.isSuccessCode((long)code) || code == (long)Code.CodePacketIsExpired.getValue() || code == (long)Code.CodePacketNoRemain.getValue()) {
                    GrabPacketPresenter.this.updateGrabState(message);
                    if (callback2 != null) {
                        if (message.cur_got.booleanValue() || origin == GrabOrigin.RoomMsg || code == (long)Code.CodePacketNoRemain.getValue()) {
                            PacketResult result = new PacketResult(message.packet_info, message.winners, message.share_info, message.cur_got);
                            result.setPacketFinish(code == (long)Code.CodePacketNoRemain.getValue());
                            callback2.onSuccess((Object)result, new Object[0]);
                        } else {
                            callback2.onFail(-10001, msg, new Object[0]);
                        }
                    }
                } else if (callback2 != null) {
                    callback2.onFail(-10001, msg, new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)GrabPacketPresenter.TAG, (String)"reqGrabPacket onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
                if (callback2 != null) {
                    callback2.onFail(-10001, reason, new Object[0]);
                }
            }
        });
    }

    private void reqPacketResult(String packetId, final ICommonCallback<PacketResult> callback2) {
        if (this.mPacketParam == null) {
            MLog.error((Object)TAG, (String)"reqPacketResult mPacketParam is null", (Object[])new Object[0]);
            return;
        }
        GetPacketInfoReq req = new GetPacketInfoReq.Builder().packet_id(packetId).sequence(Long.valueOf(System.currentTimeMillis())).build();
        ProtoManager.getInstance().sendRpc(this.mPacketParam.getRoomId(), (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetPacketInfoRes>(){

            public void onResponse(@NonNull GetPacketInfoRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)GrabPacketPresenter.TAG, (String)"reqPacketResult onResponse code: %d, msg: %s, packetId: %s", (Object[])new Object[]{code, msg, message.packet_info.id});
                if (ProtoManager.isSuccessCode((long)code) || code == (long)Code.CodePacketIsExpired.getValue() || code == (long)Code.CodePacketNoRemain.getValue()) {
                    GrabPacketPresenter.this.updateGrabState(message.packet_info);
                    if (callback2 != null) {
                        PacketResult result = new PacketResult(message.packet_info, message.winners, message.share_info, false);
                        callback2.onSuccess((Object)result, new Object[0]);
                    }
                } else if (callback2 != null) {
                    callback2.onFail((int)code, msg, new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)GrabPacketPresenter.TAG, (String)"reqPacketResult onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
                if (callback2 != null) {
                    callback2.onFail(code, reason, new Object[0]);
                }
            }
        });
    }

    private void updateGrabState(GrabPacketRes message) {
        PacketInfo info = message.packet_info;
        String packetId = info.id;
        GrabPacketState state = this.getGrabPacketState(packetId);
        if (message.cur_got.booleanValue() || message.last_got.booleanValue()) {
            state.updateGrabState(GrabPacketState.GrabState.success);
        } else {
            state.updateGrabState(GrabPacketState.GrabState.miss);
        }
        this.updateGrabState(message.packet_info);
    }

    private void updateGrabState(PacketInfo info) {
        String packetId = info.id;
        GrabPacketState state = this.getGrabPacketState(packetId);
        if (info.remain_seconds <= 0) {
            state.updatePacketState(GrabPacketState.PacketSate.over);
        } else if (info.current >= info.total) {
            state.updatePacketState(GrabPacketState.PacketSate.finish);
        } else {
            state.updatePacketState(GrabPacketState.PacketSate.remain);
        }
    }

    @NonNull
    public GrabPacketState getGrabPacketState(String packetId) {
        if (TextUtils.isEmpty((CharSequence)packetId)) {
            return new GrabPacketState(packetId);
        }
        if (this.mGrabPacketState.containsKey(packetId)) {
            return this.mGrabPacketState.get(packetId);
        }
        GrabPacketState state = new GrabPacketState(packetId);
        this.mGrabPacketState.put(packetId, state);
        return state;
    }

    private boolean hadGrabPacketSuccess(String packetId) {
        GrabPacketState state = this.getGrabPacketState(packetId);
        return state.getGrabState() == GrabPacketState.GrabState.success;
    }
}

