/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.request;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import java.util.Map;

public class PayRequestUtils {
    private static final String TAG = "PayRequestUtils";

    public static String getExpand(int quantity, double unitPrice, String productId, String hdid, String srcCurrencySymbol, Map<String, Object> ext) {
        JsonStringBuilder expand = JsonStringBuilder.newBuilder();
        expand.put("quantity", (Object)String.valueOf(quantity));
        expand.put("unitPrice", (Object)unitPrice);
        expand.put("product_id", (Object)productId);
        expand.put("hdid", (Object)hdid);
        expand.put("srcCurrencySymbol", (Object)srcCurrencySymbol);
        if (!FP.empty(ext)) {
            expand.putAll(ext);
        }
        return expand.buildJson();
    }

    @WorkerThread
    @Nullable
    public static <T> T parseResponse(RevenueProtoRes response, Class<T> cls) {
        if (response == null || TextUtils.isEmpty((CharSequence)response.jsonMsg)) {
            return null;
        }
        return PayRequestUtils.parseJsonMsg(response.jsonMsg, cls);
    }

    @WorkerThread
    @Nullable
    public static <T> T parseJsonMsg(String jsonMsg, Class<T> cls) {
        Object res;
        block3: {
            if (TextUtils.isEmpty((CharSequence)jsonMsg)) {
                return null;
            }
            res = null;
            try {
                res = JsonParser.parseJsonObject((String)jsonMsg, cls);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parseResponse", (Throwable)e, (Object[])new Object[0]);
                if (!RuntimeContext.sIsDebuggable) break block3;
                throw e;
            }
        }
        return (T)res;
    }
}

