/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.question.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.pay.question.adapter.ItemClickCallBack;
import com.yy.hiyo.wallet.pay.question.bean.QuestionInfo;
import java.util.List;

public class QuestionAdapter
extends RecyclerView.Adapter<QuestionViewHolder> {
    private List<QuestionInfo> questionInfoList;
    private Context mContext;
    private ItemClickCallBack mUiCallBack;

    public QuestionAdapter(Context mContext) {
        this.mContext = mContext;
    }

    @NonNull
    public QuestionViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = View.inflate((Context)this.mContext, (int)R.layout.layout_question_item, null);
        QuestionViewHolder questionViewHolder = new QuestionViewHolder(view);
        return questionViewHolder;
    }

    public void onBindViewHolder(@NonNull QuestionViewHolder holder, int position) {
        if (this.questionInfoList != null) {
            final QuestionInfo questionInfo = this.questionInfoList.get(position);
            if (questionInfo != null) {
                holder.questionTv.setText((CharSequence)this.getContent(questionInfo));
            }
            holder.questionTv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    QuestionAdapter.this.mUiCallBack.itemClick(questionInfo);
                }
            });
        }
    }

    private String getContent(QuestionInfo questionInfo) {
        if (questionInfo.getType() == 0) {
            return ResourceUtils.getString((int)R.string.short_tips_sim_card);
        }
        if (questionInfo.getType() == 3) {
            return ResourceUtils.getString((int)R.string.short_tips_look);
        }
        if (questionInfo.getType() == 2) {
            return ResourceUtils.getString((int)R.string.short_tips_other_problems);
        }
        if (questionInfo.getType() == 5) {
            return ResourceUtils.getString((int)R.string.short_tips_credit);
        }
        if (questionInfo.getType() == 1) {
            return ResourceUtils.getString((int)R.string.short_tip_no_payment_method);
        }
        return "";
    }

    public int getItemCount() {
        if (this.questionInfoList != null) {
            return this.questionInfoList.size();
        }
        return 0;
    }

    public void setDate(List<QuestionInfo> questionInfoList) {
        this.questionInfoList = questionInfoList;
        this.notifyDataSetChanged();
    }

    public void setOnClickListener(ItemClickCallBack itemClickCallBack) {
        this.mUiCallBack = itemClickCallBack;
    }

    public class QuestionViewHolder
    extends RecyclerView.ViewHolder {
        YYTextView questionTv;

        public QuestionViewHolder(View itemView) {
            super(itemView);
            this.questionTv = (YYTextView)itemView.findViewById(R.id.question_tv);
        }
    }
}

