/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.ui.holder;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IRedPacketService;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketHandler;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelContract;
import com.yy.hiyo.wallet.gift.ui.pannel.act.GiftItemActExpandInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.GiftItemAdapter;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.IGiftItemAdapter;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.GiftPanelItemInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.holder.BaseGiftVH;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import net.ihago.money.api.giftpanel.GiftInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class MyViewHolder
extends BaseGiftVH {
    public static String TAG = "MyViewHolder";
    public static long FIVE_DAY = 432000L;
    public RecycleImageView mRivGiftImg;
    public SVGAImageView mRivGiftSvga;
    public RecycleImageView mRivCornerIcon;
    public YYTextView mTvGiftName;
    public YYTextView mTvPrice;
    public YYTextView mTvX;
    public YYTextView mTvCount;
    public YYTextView mTvSingleName;
    public YYLinearLayout mExpireLayout;
    public YYTextView mTvExpireCount;
    public YYTextView mTvExpireTime;
    public YYImageView mIvDiamond;
    private YYTextView mTvGoldCountAreGiven;
    public SVGAImageView mSVGAImageView;
    private GiftPanelItemInfo giftInfo;
    private boolean isPlayGiftSvga = false;

    @KvoMethodAnnotation(name="giftInfo", sourceClass=GiftItemActExpandInfo.class, thread=1)
    public void onGiftExpandChange(KvoEventIntent eventIntent) {
        GiftInfo newValue = (GiftInfo)eventIntent.newValue();
        this.updateLabel(newValue);
    }

    public MyViewHolder(View view) {
        super(view);
        this.mTvX = (YYTextView)view.findViewById(R.id.tv_x);
        this.mTvPrice = (YYTextView)view.findViewById(R.id.tv_price);
        this.mTvCount = (YYTextView)view.findViewById(R.id.tv_pack_count);
        this.mRivGiftImg = (RecycleImageView)view.findViewById(R.id.riv_gift_img);
        this.mRivGiftSvga = (SVGAImageView)view.findViewById(R.id.riv_gift_svga);
        this.mTvGiftName = (YYTextView)view.findViewById(R.id.tv_gift_name);
        this.mRivCornerIcon = (RecycleImageView)view.findViewById(R.id.riv_icon_new);
        this.mTvSingleName = (YYTextView)view.findViewById(R.id.tv_single_name);
        this.mIvDiamond = (YYImageView)view.findViewById(R.id.iv_diamond);
        this.mSVGAImageView = (SVGAImageView)view.findViewById(R.id.svgaHalo);
        this.mExpireLayout = (YYLinearLayout)view.findViewById(R.id.ll_expire);
        this.mTvExpireCount = (YYTextView)view.findViewById(R.id.tv_expire_pack_count);
        this.mTvExpireTime = (YYTextView)view.findViewById(R.id.tv_expire_time);
        this.mTvGoldCountAreGiven = (YYTextView)view.findViewById(R.id.tv_gold_count_are_given);
        this.mTvPrice.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mTvCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mTvX.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        if (this.mExpireLayout != null) {
            this.mTvExpireCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
            this.mTvExpireTime.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        }
    }

    public void bindView(GiftItemActExpandInfo actGiftItemActExpandinfo, GiftPanelItemInfo giftInfo) {
        this.giftInfo = giftInfo;
        if (actGiftItemActExpandinfo != null) {
            Kvo.removeKvoBinding((KvoSource)actGiftItemActExpandinfo, (Object)((Object)this), (String)"onGiftExpandChange");
            Kvo.addKvoBinding((KvoSource)actGiftItemActExpandinfo, (Object)((Object)this), (String)"onGiftExpandChange");
            this.updateLabel(actGiftItemActExpandinfo.getGiftInfo());
        } else {
            this.updateLabel(null);
        }
    }

    private void updateLabel(GiftInfo info) {
        if (info != null && info.enabled.booleanValue() && this.giftInfo != null && !TextUtils.isEmpty((CharSequence)info.corner_icon) && info.gift_id == (long)this.giftInfo.getPropsId()) {
            this.setViewVisibility((View)this.mRivCornerIcon, 0);
            ImageLoader.loadImage((ImageView)this.mRivCornerIcon, (String)(info.corner_icon + YYImageUtils.getThumbnailPostfix((int)75)));
        } else if (this.giftInfo != null && StringUtils.isNotEmpty((String)this.giftInfo.getLeftCornerMark())) {
            String leftUrl = this.giftInfo.getLeftCornerMark();
            this.setViewVisibility((View)this.mRivCornerIcon, 0);
            ImageLoader.loadImage((ImageView)this.mRivCornerIcon, (String)(leftUrl + YYImageUtils.getThumbnailPostfix((int)75)));
        } else {
            this.setViewVisibility((View)this.mRivCornerIcon, 8);
        }
    }

    @Override
    public void bindView(final GiftPanelItemInfo giftInfo, String tabType, final GiftItemAdapter.OnGiftItemCallback mGiftItemCallback, final GiftPanelContract.View view, final BubblePopupWindow mCoinGiftGuide, final String mRoomId, IGiftItemAdapter callback2, int position, int mSelectedIndex, boolean checkGift) {
        if (giftInfo != null) {
            int unitAward;
            block24: {
                if (giftInfo.getCount() > 0 && tabType.equals("packet")) {
                    this.mTvX.setVisibility(0);
                    this.mTvCount.setVisibility(0);
                    this.mTvCount.setText((CharSequence)String.valueOf(giftInfo.getCount()));
                } else {
                    this.mTvX.setVisibility(8);
                    this.mTvCount.setVisibility(8);
                }
                this.itemView.setBackgroundResource(R.drawable.selector_item_gift_bg);
                if (giftInfo.getType() == 1000) {
                    this.setViewVisibility((View)this.mTvSingleName, 0);
                    this.setViewVisibility((View)this.mTvGiftName, 8);
                    this.setViewVisibility((View)this.mIvDiamond, 8);
                    this.setViewVisibility((View)this.mTvPrice, 8);
                    if (this.mTvSingleName != null) {
                        this.mTvSingleName.setText((CharSequence)giftInfo.getName());
                    }
                    try {
                        JSONObject expand = giftInfo.expand();
                        if (expand == null || !(expand.get("background_res_id") instanceof Integer)) break block24;
                        int bgId = (Integer)expand.get("background_res_id");
                        if (this.itemView != null) {
                            this.itemView.setBackgroundResource(bgId);
                        }
                    }
                    catch (JSONException e) {
                        MLog.error((Object)TAG, (Throwable)e);
                        e.printStackTrace();
                    }
                } else {
                    this.setViewVisibility((View)this.mTvSingleName, 8);
                    this.setViewVisibility((View)this.mTvGiftName, 0);
                    this.setViewVisibility((View)this.mIvDiamond, 0);
                    this.setViewVisibility((View)this.mTvPrice, 0);
                }
            }
            String giftUrl = giftInfo.getStaticIcon();
            String giftName = giftInfo.getName();
            String giftLevelUrl = giftInfo.getGradeIcon(String.valueOf(giftInfo.getGiftLevel()));
            if (!TextUtils.isEmpty((CharSequence)giftLevelUrl)) {
                giftUrl = giftLevelUrl;
                giftName = ResourceUtils.getString((int)R.string.tips_gift_level, (Object[])new Object[]{giftInfo.getGiftLevel(), giftInfo.getName()});
            }
            this.mRivGiftImg.setVisibility(0);
            giftUrl = this.getResizeUrl(giftUrl, 50);
            ImageLoader.loadImage((ImageView)this.mRivGiftImg, (String)(giftUrl + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_gift_default);
            if (this.mTvGiftName != null) {
                this.mTvGiftName.setText((CharSequence)giftName);
            }
            if (GiftUtils.giftPrice((GiftItemInfo)giftInfo.getGiftInfo()) == 0L) {
                if (this.mTvPrice != null) {
                    this.mTvPrice.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_free));
                }
            } else if (this.mTvPrice != null) {
                this.mTvPrice.setText((CharSequence)String.valueOf(GiftUtils.giftPrice((GiftItemInfo)giftInfo.getGiftInfo())));
            }
            if (this.mExpireLayout != null) {
                long expireTime = giftInfo.getGiftInfo().getExpireDate();
                if (giftInfo.getGiftInfo().getExpireCount() > 0 && expireTime > 0L && expireTime < this.getExpireShowMinTime()) {
                    this.mExpireLayout.setVisibility(0);
                    this.mTvExpireCount.setText((CharSequence)("X" + giftInfo.getGiftInfo().getExpireCount()));
                    this.mTvExpireTime.setText((CharSequence)this.getTime(expireTime));
                } else {
                    this.mExpireLayout.setVisibility(8);
                }
            }
            GiftItemActExpandInfo actGiftItemActExpandinfo = mGiftItemCallback == null ? null : mGiftItemCallback.getActGiftInfo(giftInfo);
            this.bindView(actGiftItemActExpandinfo, giftInfo);
            this.setViewVisibility((View)this.mTvGoldCountAreGiven, 8);
            if (giftInfo.getType() == 14 && (unitAward = giftInfo.getUnitAward()) > 0) {
                String count = StringUtils.getFormatedNumber((long)unitAward, (int)1);
                if (this.mTvGoldCountAreGiven != null) {
                    this.mTvGoldCountAreGiven.setVisibility(0);
                    this.mTvGoldCountAreGiven.setText((CharSequence)"+".concat(count));
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MyViewHolder.this.showCoinsGiftGuide(MyViewHolder.this, view, mCoinGiftGuide, mRoomId);
                    }
                });
            }
            if (giftInfo.getType() == 1000) {
                callback2.setRedPocketGuide(this, position);
            }
            this.mRivGiftSvga.setTag(R.id.gift_item_data, (Object)giftInfo);
            if (giftInfo.isSelected()) {
                this.selectGift(mGiftItemCallback, giftInfo);
                this.prepareForAppearAnim(this, view, giftInfo.getGiftInfo().getPropsId(), callback2);
            } else {
                this.clearSelectedAnimator();
                this.unSelect();
            }
        } else {
            this.setViewVisibility(this.itemView, 8);
        }
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (giftInfo != null && giftInfo.getType() == 1000) {
                    if (GuestLoginUtils.checkAndShowGuide((int)16)) {
                        return;
                    }
                    GiftHiidoReport.redPacketClick(mRoomId);
                    IRedPacketHandler handler = ((IRedPacketService)ServiceManagerProxy.getServiceManager().getService(IRedPacketService.class)).getHandler(mRoomId);
                    if (handler != null) {
                        handler.showRedPacket();
                    }
                    if (mGiftItemCallback != null) {
                        mGiftItemCallback.onClickGift(giftInfo);
                    }
                } else if (mGiftItemCallback != null) {
                    mGiftItemCallback.onClickGift(giftInfo);
                    MyViewHolder.this.selectGift(mGiftItemCallback, giftInfo);
                }
            }
        });
    }

    private void selectGift(GiftItemAdapter.OnGiftItemCallback mGiftItemCallback, GiftPanelItemInfo giftInfo) {
        if (mGiftItemCallback != null) {
            mGiftItemCallback.updateSelectHolder(this);
        }
        this.itemView.setSelected(true);
        if (giftInfo != null) {
            this.startClickAnimatioin(giftInfo, this, this.itemView.getContext());
            giftInfo.setSelected(true);
        }
    }

    private void showCoinsGiftGuide(MyViewHolder holder, GiftPanelContract.View mView, BubblePopupWindow mCoinGiftGuide, String mRoomId) {
        if (holder == null) {
            return;
        }
        int[] location = new int[2];
        this.itemView.getLocationInWindow(location);
        if (location[0] > 0 || location[1] > 0) {
            boolean canShow = SettingFlags.getBoolean((String)"key_show_coin_gift_guide", (boolean)true);
            if (mView != null && !mView.isShowWithoutAnim()) {
                return;
            }
            if (canShow) {
                int margin = ResolutionUtils.dip2Px((float)7.0f);
                mCoinGiftGuide.showArrowTo(this.itemView, BubbleStyle.ArrowDirection.Down, margin);
                SettingFlags.setBoolean((String)"key_show_coin_gift_guide", (boolean)false);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033117").put("function_id", "ruby_gift_tips_show").put("room_id", mRoomId));
            }
        }
    }

    private void startClickAnimatioin(GiftPanelItemInfo giftItemInfo, final MyViewHolder holder, Context context) {
        String previewSvgaUrl = giftItemInfo.getPreviewSvga();
        if (!TextUtils.isEmpty((CharSequence)previewSvgaUrl)) {
            this.isPlayGiftSvga = true;
            SvgaLoader.load((SVGAImageView)holder.mRivGiftSvga, (String)previewSvgaUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (svgaVideoEntity != null && MyViewHolder.this.isPlayGiftSvga) {
                        SVGADrawable drawable2 = new SVGADrawable(svgaVideoEntity);
                        holder.mRivGiftSvga.setVisibility(0);
                        holder.mRivGiftSvga.setImageDrawable((Drawable)drawable2);
                        holder.mRivGiftSvga.startAnimation();
                        holder.mRivGiftImg.setImageDrawableToNull();
                    }
                }

                public void onFailed(Exception e) {
                    holder.mRivGiftSvga.stopAnimation();
                    holder.mRivGiftSvga.setVisibility(4);
                    holder.mRivGiftImg.setVisibility(0);
                }
            });
        } else {
            holder.mRivGiftImg.setVisibility(0);
            holder.mRivGiftSvga.setVisibility(4);
            if (NAB.B.equals((Object)NewABDefine.GIFT_INFINITE_ANIM.getTest())) {
                if (holder.itemView.isSelected()) {
                    this.playScaleAnimation(holder);
                }
            } else {
                Animation animation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.anim_scale_out_in);
                holder.mRivGiftImg.startAnimation(animation);
            }
        }
    }

    private void playScaleAnimation(MyViewHolder holder) {
        this.endScaleAnim();
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe kf1 = Keyframe.ofFloat((float)0.5f, (float)1.1f);
        Keyframe kf3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{kf0, kf1, kf3});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{kf0, kf1, kf3});
        ObjectAnimator scaleAnim = ObjectAnimator.ofPropertyValuesHolder((Object)holder.mRivGiftImg, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY}).setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        holder.mRivGiftImg.setTag(R.id.gift_item_animator, (Object)scaleAnim);
        scaleAnim.start();
    }

    private void endScaleAnim() {
        ObjectAnimator animator = (ObjectAnimator)this.mRivGiftImg.getTag(R.id.gift_item_animator);
        if (animator != null && animator.getRepeatCount() == -1 && animator.isRunning()) {
            this.mRivGiftImg.clearAnimation();
            animator.end();
            animator.cancel();
        }
    }

    public void unSelect() {
        this.itemView.setSelected(false);
        this.giftInfo.setSelected(false);
    }

    public void clearSelectedAnimator() {
        GiftPanelItemInfo giftItemInfo;
        this.mRivGiftImg.setVisibility(0);
        this.endScaleAnim();
        if (this.mRivGiftSvga.isAnimating() && (giftItemInfo = (GiftPanelItemInfo)this.mRivGiftSvga.getTag(R.id.gift_item_data)) != null) {
            String giftUrl = giftItemInfo.getStaticIcon();
            String giftLevelUrl = giftItemInfo.getGradeIcon(String.valueOf(giftItemInfo.getGiftLevel()));
            if (!TextUtils.isEmpty((CharSequence)giftLevelUrl)) {
                giftUrl = giftLevelUrl;
            }
            giftUrl = this.getResizeUrl(giftUrl, 50);
            ImageLoader.loadImage((ImageView)this.mRivGiftImg, (String)giftUrl, (int)R.drawable.icon_gift_default);
            this.mRivGiftSvga.stopAnimation();
            this.mRivGiftSvga.setVisibility(4);
        }
        this.isPlayGiftSvga = false;
    }

    private void prepareForAppearAnim(MyViewHolder holder, GiftPanelContract.View mView, int giftId, IGiftItemAdapter callback2) {
        if (mView.getFrom() == 13) {
            this.setViewVisibility(this.itemView, 4);
            callback2.updateAppearView(holder, giftId);
        }
    }

    private void setViewVisibility(View view, int visibility) {
        if (view != null) {
            view.setVisibility(visibility);
        }
    }

    private String getResizeUrl(String originUrl, int dp) {
        originUrl = originUrl + YYImageUtils.getThumbnailPostfix((int)dp);
        return originUrl;
    }

    private long getExpireShowMinTime() {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig) {
            return ((CommonConfig)config).getData().giftExpireMinTime;
        }
        return FIVE_DAY;
    }

    private String getTime(double time) {
        if (time >= 86400.0) {
            int day = (int)Math.ceil(time / 86400.0);
            return day + "d";
        }
        int hour = (int)Math.ceil(time / 3600.0);
        if (hour > 0) {
            return hour + "h";
        }
        return "1h";
    }
}

