/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.adapter;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import java.util.ArrayList;
import java.util.List;
import net.ihago.uinfo.api.uinfo.ESexType;

public class GiftReceiversAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private List<GiftUserInfo> mUserInfoList;
    private CircleImageView mLastClickAvatar;
    private OnReceiverItemClickListener mListener;
    private int headerSelectedSourceId = 0;
    private long mDefaultUid;
    private int mSelectedPosition;

    public GiftReceiversAdapter(int iconGiftHeaderSelected) {
        this.headerSelectedSourceId = iconGiftHeaderSelected;
        this.mUserInfoList = new ArrayList<GiftUserInfo>();
    }

    public void setData(List<GiftUserInfo> list) {
        this.mUserInfoList.clear();
        if (!FP.empty(list)) {
            try {
                for (GiftUserInfo userInfo : list) {
                    this.mUserInfoList.add((GiftUserInfo)userInfo.clone());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public List<GiftUserInfo> getData() {
        return this.mUserInfoList;
    }

    public int getItemCount() {
        if (FP.empty(this.mUserInfoList)) {
            return 0;
        }
        return this.mUserInfoList.size();
    }

    public void setOnClickListener(OnReceiverItemClickListener listener) {
        this.mListener = listener;
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_gift_receiver_header, parent, false);
        return new MyViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        final GiftUserInfo userInfoKS = this.mUserInfoList.get(position);
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)holder.itemView.getLayoutParams();
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(this.getItemSpace());
        } else {
            layoutParams.leftMargin = this.getItemSpace();
        }
        holder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (userInfoKS != null && userInfoKS.getUserInfo() != null && GiftReceiversAdapter.this.mListener != null) {
                    GiftReceiversAdapter.this.mListener.onReceiverItemClick(userInfoKS);
                }
            }
        });
        if (userInfoKS != null) {
            if (userInfoKS.isCpUser()) {
                holder.cpImg.setVisibility(0);
            } else {
                holder.cpImg.setVisibility(8);
            }
            if (userInfoKS.isSelected()) {
                holder.mAvatar.setAlpha(1.0f);
                holder.borderImg.setVisibility(0);
            } else {
                holder.mAvatar.setAlpha(0.7f);
                holder.borderImg.setVisibility(4);
            }
            int defaultAvatar = userInfoKS.getUserInfo().sex == 0 ? R.drawable.icon_avatar_default_female : R.drawable.icon_avatar_default_male;
            ImageLoader.loadImage((ImageView)holder.mAvatar, (String)(userInfoKS.getUserInfo().avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)defaultAvatar);
            if (userInfoKS.getUserType() == 1) {
                holder.mNumber.setText((CharSequence)"");
                holder.mNumber.setBackgroundResource(R.drawable.icon_host);
            } else {
                holder.mNumber.setText((CharSequence)(this.mListener.getRealSeatNumber(userInfoKS) + ""));
                holder.mNumber.setBackgroundResource(R.drawable.level_list_index_bg);
                holder.mNumber.getBackground().setLevel(userInfoKS.getUserInfo().sex == ESexType.ESTFemale.getValue() ? 0 : 1);
            }
        }
    }

    private int getItemSpace() {
        if (!FP.empty(this.mUserInfoList)) {
            int space = ResolutionUtils.dip2Px((float)6.0f);
            if (this.mUserInfoList.size() < 8) {
                return space;
            }
            int itemSpace = (ScreenUtils.getInstance().getWidthPixels() - 8 * ResolutionUtils.dip2Px((float)38.0f)) / 9;
            if (itemSpace < space) {
                return space;
            }
            return itemSpace;
        }
        return 0;
    }

    public static interface OnReceiverItemClickListener {
        public void onReceiverItemClick(GiftUserInfo var1);

        public int getRealSeatNumber(GiftUserInfo var1);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public CircleImageView mAvatar;
        public YYTextView mNumber;
        private YYImageView borderImg;
        public RecycleImageView cpImg;

        public MyViewHolder(View itemView) {
            super(itemView);
            this.mAvatar = (CircleImageView)itemView.findViewById(R.id.riv_avatar);
            this.mNumber = (YYTextView)itemView.findViewById(R.id.tv_number);
            this.borderImg = (YYImageView)itemView.findViewById(R.id.avatar_border_img);
            this.cpImg = (RecycleImageView)itemView.findViewById(R.id.cp_img);
            this.borderImg.setBackgroundResource(GiftReceiversAdapter.this.headerSelectedSourceId);
        }
    }
}

