/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.flymic;

import android.content.Context;
import android.graphics.Point;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.collection.ArraySet;
import androidx.core.view.ViewCompat;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.common.FacePoint;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftBehavior;
import com.yy.hiyo.wallet.gift.effect.IFlyMicEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.flymic.FlyMicInfo;
import com.yy.hiyo.wallet.gift.ui.flymic.FlyMicView;
import com.yy.hiyo.wallet.gift.ui.flymic.GiftFlyMicCallBack;
import com.yy.hiyo.wallet.gift.utils.GiftComboUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class GiftFlyMicPresent
implements GiftFlyMicCallBack<FlyMicView>,
IFlyMicEffectPresenter {
    private static String TAG = "GiftFlyMicPresent";
    private static final int RESOLUTION_45_DP = ResolutionUtils.dip2Px((float)45.0f);
    private static int defaultSendX = 0;
    private static int defaultSendY = 100;
    private ViewGroup mRootView;
    private IGiftBehavior mGiftBehavior;
    private String mRoomId = "";
    private IGiftHandler iGiftHandler;
    private ViewGroup mLuckyGiftLayer;
    private int screenWidth;
    private FacePoint sendPoint;
    private Set<Long> uids = new ArraySet(8);
    private Map<Long, FacePoint> recvSeats;
    private Map<Long, FacePoint> sendSeats;
    private List<FacePoint> recvLocation = new ArrayList<FacePoint>();
    private ISceneOptLimiter<FlyMicInfo> mSceneOptLimiter;

    @NotNull
    private ISceneOptLimiter<FlyMicInfo> getLimiter() {
        if (this.mSceneOptLimiter != null) {
            return this.mSceneOptLimiter;
        }
        this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("gift_mic_fly", (ISceneOptLimiterCallback)new SimpleSceneOptLimiterCallback<FlyMicInfo>(){

            @NotNull
            public DiscardResult onDiscard(FlyMicInfo item, float discardRatio, int discardMinRemain, int maxRemain) {
                return DiscardResult.NONE;
            }

            @Nullable
            public List<FlyMicInfo> needDiscardWhenOnDiscard(@NotNull List<? extends FlyMicInfo> items, float discardRatio, int discardMinRemain, int maxRemain) {
                return GiftUtils.discardStrategy(items, (float)discardRatio, (int)discardMinRemain, (int)maxRemain);
            }

            public boolean isDisCardOldDataFrequency() {
                return false;
            }

            public boolean needSkip(FlyMicInfo item) {
                return item.getResult().isMySendOrReceive() || item.getAnimType() == 1 || item.getAnimType() == 2;
            }

            public void onAppendItem(FlyMicInfo item) {
                GiftFlyMicPresent.this.showFlyMic(item);
            }
        });
        return this.mSceneOptLimiter;
    }

    public GiftFlyMicPresent(ViewGroup giftLayer, ViewGroup luckyGiftLayer, IGiftBehavior behavior, String roomId, IGiftHandler iGiftHandler) {
        this.mRootView = this.createRootView(giftLayer);
        this.mLuckyGiftLayer = this.createRootView(luckyGiftLayer);
        this.mGiftBehavior = behavior;
        this.iGiftHandler = iGiftHandler;
        this.screenWidth = ResolutionUtils.getScreenWidth((Context)this.mRootView.getContext());
        defaultSendX = this.screenWidth / 2;
        defaultSendY = ResolutionUtils.dip2Px((float)40.0f);
        this.mRoomId = roomId;
    }

    private ViewGroup createRootView(ViewGroup giftLayer) {
        YYFrameLayout viewGroup = new YYFrameLayout(giftLayer.getContext());
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        giftLayer.addView((View)viewGroup, lp);
        return viewGroup;
    }

    @Override
    public void addFlyMicView(GiftBroResult giftBroResult, int marginTop) {
        MLog.info((Object)TAG, (String)"addFlyMicView result: %s", (Object[])new Object[]{giftBroResult});
        int animType = 2;
        if (giftBroResult != null && giftBroResult.getGiftBroInfo().getRevUserInfos() != null && giftBroResult.getGiftBroInfo().getRevUserInfos().size() > 1) {
            animType = 1;
        }
        this.addGiftEffect(giftBroResult, animType, marginTop);
    }

    @Override
    public void addGiftEffect(@NonNull GiftBroResult giftBroResult) {
        int animType = 0;
        this.addGiftEffect(giftBroResult, animType, 0);
    }

    private void addGiftEffect(GiftBroResult result, int animType, int marginTop) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"addGiftEffect result: %s", (Object[])new Object[]{result});
        }
        if (this.canShow(result) && result.getGiftInfo() != null) {
            FlyMicInfo flyMicInfo = new FlyMicInfo(result, animType, marginTop);
            this.getLimiter().addItem((Object)flyMicInfo, 0);
        }
    }

    private void showFlyMic(FlyMicInfo flyMicInfo) {
        GiftBroResult result = flyMicInfo.getResult();
        int animType = flyMicInfo.getAnimType();
        int marginTop = flyMicInfo.getMarginTop();
        GiftBroadcastInfo bro = result.getGiftBroInfo();
        this.setUserLocation(result, animType, marginTop);
        String giftLevelUrl = "";
        if (result.getExpand() != null) {
            giftLevelUrl = result.getGiftInfo().getGradeIcon(String.valueOf(result.getExpand().giftLevel));
        }
        int comboCount = bro.getPropsCount();
        for (Point point : this.recvLocation) {
            if (!TextUtils.isEmpty((CharSequence)giftLevelUrl)) {
                this.startFlyMicAnim(giftLevelUrl, result.getGiftInfo().getType(), comboCount, animType, point);
                continue;
            }
            this.startFlyMicAnim(result.getGiftInfo().getStaticIcon(), result.getGiftInfo().getType(), comboCount, animType, point);
        }
    }

    private boolean canShow(@NonNull GiftBroResult result) {
        return !result.isFinish();
    }

    private void setUserLocation(GiftBroResult info, int animType, int marginTop) {
        this.uids.clear();
        this.recvLocation.clear();
        for (GiftBroUserInfo userInfo : info.getGiftBroInfo().getRevUserInfos()) {
            if (userInfo.getUid() <= 0L) continue;
            this.uids.add(userInfo.getUid());
        }
        if (this.iGiftHandler != null) {
            long sendUid = info.getGiftBroInfo().getUid();
            this.sendSeats = this.mGiftBehavior.locateSeat(this.iGiftHandler, Collections.singleton(sendUid));
            if (this.sendSeats != null) {
                if (animType == 0 || animType == 3) {
                    FacePoint point;
                    this.sendPoint = new FacePoint();
                    this.sendPoint.x = defaultSendX;
                    this.sendPoint.y = defaultSendY;
                    if (this.mGiftBehavior.isUserOnMicSeat(this.iGiftHandler, info.getGiftBroInfo().getUid()) && (point = this.sendSeats.get(sendUid)) != null) {
                        if (LanguageUtils.isRtl()) {
                            this.sendPoint.x = -point.x;
                            this.sendPoint.y = point.y;
                        } else {
                            this.sendPoint = point;
                        }
                    }
                } else {
                    this.sendPoint = new FacePoint();
                    this.sendPoint.x = DpToPxDef.RESOLUTION_160_DP + RESOLUTION_45_DP * this.getVipCardCount(info);
                    this.sendPoint.y = marginTop + DpToPxDef.RESOLUTION_80_DP;
                }
            }
            this.recvSeats = this.mGiftBehavior.locateSeat(this.iGiftHandler, this.uids);
            if (this.recvSeats != null) {
                for (Map.Entry<Long, FacePoint> entry : this.recvSeats.entrySet()) {
                    if (entry == null) continue;
                    FacePoint location = new FacePoint();
                    location.x = this.mGiftBehavior.defaultLocation().x;
                    location.y = this.mGiftBehavior.defaultLocation().y;
                    long uid = entry.getKey();
                    FacePoint point = entry.getValue();
                    if (this.mGiftBehavior.isUserOnMicSeat(this.iGiftHandler, uid) && point != null) {
                        if (LanguageUtils.isRtl()) {
                            location.x = -point.x;
                            location.y = point.y;
                        } else {
                            location = point;
                        }
                    }
                    this.recvLocation.add(location);
                }
            }
        }
    }

    private int getVipCardCount(GiftBroResult info) {
        if (!FP.empty((CharSequence)info.getSenderVipInfo())) {
            try {
                JSONObject vipInfo = new JSONObject(info.getSenderVipInfo());
                JSONArray cards = vipInfo.optJSONArray("cards");
                if (cards != null) {
                    return cards.length();
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"getVipCardCount %s", (Throwable)e, (Object[])new Object[]{info.getSenderVipInfo()});
                return 0;
            }
        }
        return 0;
    }

    public void startFlyMicAnim(String giftIcon, int giftType, int comboCount, int animType, Point recvPoint) {
        if (this.mRootView == null || this.mLuckyGiftLayer == null) {
            MLog.info((Object)TAG, (String)"error! flyMicAniming is true or mRootView is null", (Object[])new Object[0]);
            return;
        }
        if (this.sendPoint == null || recvPoint == null || this.sendPoint.x < 0 || this.sendPoint.y < 0 || recvPoint.x < 0 || recvPoint.y < 0) {
            MLog.info((Object)TAG, (String)"error! fly location is illegality ", (Object[])new Object[0]);
            return;
        }
        FlyMicView giftBigImg = new FlyMicView(this.mRootView.getContext(), this, (Point)this.sendPoint, recvPoint, animType);
        if (comboCount > 1) {
            if (animType == 0) {
                giftBigImg.setComboNum(GiftComboUtils.INSTANCE.getGiftNumSpannable(String.valueOf(comboCount), 2));
            } else {
                giftBigImg.setComboNum(GiftComboUtils.INSTANCE.getGiftNumSpannable(String.valueOf(comboCount), 2, 24, 32));
            }
        }
        giftBigImg.setGiftType(giftType);
        giftBigImg.loadImg(giftIcon);
        if (animType == 0) {
            this.mRootView.addView((View)giftBigImg);
        } else {
            this.mLuckyGiftLayer.addView((View)giftBigImg);
        }
        giftBigImg.enterAnim();
    }

    @Override
    public void destroy() {
        View view;
        int i;
        int size;
        if (this.mRootView != null && this.mRootView.getChildCount() > 0) {
            size = this.mRootView.getChildCount();
            for (i = 0; i < size; ++i) {
                view = this.mRootView.getChildAt(i);
                ViewCompat.animate((View)view).cancel();
            }
            this.mRootView.removeAllViews();
        }
        this.mRootView = null;
        if (this.mLuckyGiftLayer != null && this.mLuckyGiftLayer.getChildCount() > 0) {
            size = this.mLuckyGiftLayer.getChildCount();
            for (i = 0; i < size; ++i) {
                view = this.mLuckyGiftLayer.getChildAt(i);
                ViewCompat.animate((View)view).cancel();
            }
            this.mLuckyGiftLayer.removeAllViews();
        }
        this.mLuckyGiftLayer = null;
        if (this.mSceneOptLimiter != null) {
            this.mSceneOptLimiter.destroy();
        }
    }

    @Override
    public void removeFlyMicAnim(FlyMicView giftBigImg) {
        MLog.info((Object)TAG, (String)"removeFlyMicAnim", (Object[])new Object[0]);
        if (giftBigImg != null) {
            if (giftBigImg.getAnimType() == 0) {
                if (this.mRootView != null) {
                    this.mRootView.removeView((View)giftBigImg);
                }
            } else if (this.mLuckyGiftLayer != null) {
                this.mLuckyGiftLayer.removeView((View)giftBigImg);
            }
        }
    }
}

