/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.statis;

import android.os.SystemClock;
import android.text.TextUtils;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GiftMonitor {
    private static final Map<String, ReqGiftList> mGiftList = new ConcurrentHashMap<String, ReqGiftList>();

    public static void reqGiftList(String seq, int cmd, int channelId, long anchorUid) {
        if (TextUtils.isEmpty((CharSequence)seq)) {
            return;
        }
        ReqGiftList giftList = new ReqGiftList(seq, cmd, channelId, anchorUid);
        mGiftList.put(seq, giftList);
    }

    public static void resGiftList(String seq, int code, String reason) {
        if (TextUtils.isEmpty((CharSequence)seq)) {
            return;
        }
        ReqGiftList giftList = mGiftList.remove(seq);
        if (giftList != null) {
            giftList.reason = reason;
            GiftMonitor.reportReqResultMetri(giftList.cmd, giftList.duration(), code);
            GiftMonitor.reportGiftList(giftList);
        }
    }

    public static void reportMetr(String seq, String code) {
        if (TextUtils.isEmpty((CharSequence)seq)) {
            return;
        }
        ReqGiftList giftList = mGiftList.get(seq);
        if (giftList != null) {
            StringBuilder builder = new StringBuilder("revenue/cmd/");
            if (PayUtils.isHuaweiPayChannel()) {
                builder.append("huawei/");
            }
            builder.append(giftList.cmd);
            HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)StringUtils.parseLong((String)giftList.interval()), (String)code);
        }
    }

    public static void giftListSdkMetric(boolean success, int code, String reason, long duration) {
        code = success ? 0 : code;
        HiidoStatis.reportAppMonitorReturnCode((String)"giftlist/sdk/", (long)duration, (String)(code + ""));
    }

    private static void reportReqResultMetri(int cmd, long duration, int code) {
        if (code == 1) {
            code = 0;
        }
        StringBuilder builder = new StringBuilder("revenue/result/cmd/");
        if (PayUtils.isHuaweiPayChannel()) {
            builder.append("huawei/");
        }
        builder.append(cmd);
        HiidoStatis.reportAppMonitorReturnCode((String)builder.toString(), (long)duration, (String)("" + code));
    }

    private static void reportGiftList(ReqGiftList giftList) {
        if (giftList == null) {
            return;
        }
        giftList.release();
        String duration = giftList.interval();
        StatisContent content = GiftMonitor.createContent();
        content.put("ifield", giftList.cmd);
        content.put("ifieldtwo", giftList.channelId);
        content.put("sfield", String.valueOf(giftList.anchorUid));
        content.put("sfieldtwo", duration);
        content.put("sfieldthree", giftList.reason);
        HiidoStatis.reportContent((StatisContent)content);
    }

    private static StatisContent createContent() {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "gift");
        return statContent;
    }

    private static class ReqGiftList {
        String seq;
        int cmd;
        int channelId;
        long anchorUid;
        String reason;
        long start;
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                reason = "timeout with 30s";
                mGiftList.remove(seq);
                GiftMonitor.reportGiftList(this);
            }
        };

        public ReqGiftList(String seq, int cmd, int channelId, long anchorUid) {
            this.seq = seq;
            this.cmd = cmd;
            this.channelId = channelId;
            this.anchorUid = anchorUid;
            this.start = SystemClock.uptimeMillis();
            YYTaskExecutor.execute((Runnable)this.timeoutTask, (long)30000L);
        }

        void release() {
            YYTaskExecutor.removeTask((Runnable)this.timeoutTask);
        }

        String interval() {
            long interval = SystemClock.uptimeMillis() - this.start;
            return String.valueOf(interval);
        }

        long duration() {
            return SystemClock.uptimeMillis() - this.start;
        }
    }
}

