/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui.tab;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.coupon.ui.ICouponListUiCallBack;
import com.yy.hiyo.wallet.coupon.ui.tab.CouponListItenDecoration;
import com.yy.hiyo.wallet.coupon.ui.tab.CouponTabAdapter;
import java.util.List;

public class CouponTabPage
extends YYFrameLayout {
    private Context mContext;
    private CommonStatusLayout mStatusLayout;
    private RecyclerView mCouponRV;
    private CouponTabAdapter mCouponAdapter;
    private boolean mIsAvailable;
    private ICouponListUiCallBack mCallBack;

    public CouponTabPage(Context context, boolean isAvailable, ICouponListUiCallBack callBack) {
        super(context);
        this.mIsAvailable = isAvailable;
        this.mCallBack = callBack;
        this.createView();
    }

    private void createView() {
        this.mContext = this.getContext();
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_coupon_tab_page, (ViewGroup)this);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mCouponRV = (RecyclerView)this.findViewById(R.id.coupon_rv);
        this.initRV();
    }

    private void initRV() {
        this.mCouponAdapter = new CouponTabAdapter(this.mIsAvailable);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.mContext);
        linearLayoutManager.setOrientation(1);
        this.mCouponRV.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mCouponRV.addItemDecoration((RecyclerView.ItemDecoration)new CouponListItenDecoration(Color.parseColor((String)"#f3f3f3")));
        this.mCouponRV.setAdapter((RecyclerView.Adapter)this.mCouponAdapter);
        this.mCouponAdapter.setICouponListItemClickListener(couponBean -> {
            MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.UPDATE_COUPON_DISCOUNT, (Object)couponBean);
            if (this.mCallBack != null) {
                this.mCallBack.onBackClick();
            }
        });
    }

    public CommonStatusLayout getStatusLayout() {
        return this.mStatusLayout;
    }

    public void setListData(List<CouponBean> list, long couponId) {
        this.mCouponAdapter.setDatas(list, couponId);
        this.mCouponRV.scrollToPosition(this.mCouponAdapter.getCheckPosition());
        this.mStatusLayout.hideLoading();
        if (this.mCouponAdapter.isDataEmpty()) {
            this.mStatusLayout.showNoData(R.drawable.default_no_data, (Spanned)new SpannableString((CharSequence)(this.mIsAvailable ? ResourceUtils.getString((int)R.string.tips_available_coupons_empty) : ResourceUtils.getString((int)R.string.tips_used_coupons_empty))));
        }
    }
}

