/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui.tab;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.NoCouponBean;
import com.yy.hiyo.wallet.coupon.ui.tab.BaseCouponViewHolder;
import com.yy.hiyo.wallet.coupon.ui.tab.CouponTabViewHolder;
import com.yy.hiyo.wallet.coupon.ui.tab.ICouponListItemClickListener;
import com.yy.hiyo.wallet.coupon.ui.tab.NoCouponViewHolder;
import java.util.ArrayList;
import java.util.List;

public class CouponTabAdapter
extends RecyclerView.Adapter<BaseCouponViewHolder> {
    private static final int COUPON_TYPE = 0;
    private static final int NO_COUPON_TYPE = 1;
    private boolean mIsAvailable;
    private Context mContext;
    private List<CouponBean> mDatas;
    private ICouponListItemClickListener mCouponListItemListener;

    public CouponTabAdapter(boolean isAvailable) {
        this.mIsAvailable = isAvailable;
        this.mDatas = new ArrayList<CouponBean>();
    }

    @NonNull
    public BaseCouponViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.mContext = parent.getContext();
        if (viewType == 0) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_coupon_tab_item, parent, false);
            CouponTabViewHolder viewHolder = new CouponTabViewHolder(view, this.mIsAvailable, (isCheck, position) -> {
                if (!this.mDatas.get(position).isCouponVaild(this.mContext, true)) {
                    this.notifyDataSetChanged();
                    return;
                }
                for (int i = 0; i < this.mDatas.size(); ++i) {
                    CouponBean bean = this.mDatas.get(i);
                    bean.isCheck = i == position;
                }
                if (this.mCouponListItemListener != null) {
                    this.mCouponListItemListener.onItemClick(this.mDatas.get(position));
                }
                this.notifyDataSetChanged();
            });
            return viewHolder;
        }
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_no_coupon_item, parent, false);
        NoCouponViewHolder viewHolder = new NoCouponViewHolder(view, (isCheck, position) -> {
            for (int i = 0; i < this.mDatas.size(); ++i) {
                CouponBean bean = this.mDatas.get(i);
                bean.isCheck = i == position;
            }
            if (this.mCouponListItemListener != null) {
                this.mCouponListItemListener.onItemClick(this.mDatas.get(position));
            }
            this.notifyDataSetChanged();
        });
        return viewHolder;
    }

    public int getItemViewType(int position) {
        if (this.mDatas != null && this.mDatas.get(position) instanceof NoCouponBean) {
            return 1;
        }
        return 0;
    }

    public void onBindViewHolder(@NonNull BaseCouponViewHolder holder, int position) {
        holder.updateItem(this.mDatas.get(position), position);
    }

    public int getItemCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }

    public void setDatas(List<CouponBean> datas, long couponId) {
        this.mDatas = datas;
        if (!FP.empty(this.mDatas) && this.mIsAvailable) {
            for (CouponBean data : datas) {
                if (data.id != couponId) continue;
                data.isCheck = true;
            }
        }
        this.notifyDataSetChanged();
    }

    public boolean isDataEmpty() {
        boolean isEmpty = false;
        if (this.mDatas == null || this.mDatas.isEmpty()) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public CouponBean getCheckItem() {
        if (!FP.empty(this.mDatas)) {
            for (CouponBean mData : this.mDatas) {
                if (!mData.isCheck) continue;
                return mData;
            }
        }
        return null;
    }

    public int getCheckPosition() {
        if (!FP.empty(this.mDatas)) {
            for (int i = 0; i < this.mDatas.size(); ++i) {
                if (!this.mDatas.get((int)i).isCheck) continue;
                return i;
            }
        }
        return 0;
    }

    public void setICouponListItemClickListener(ICouponListItemClickListener listener) {
        this.mCouponListItemListener = listener;
    }
}

