/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui.popupwindow;

import android.content.Context;
import android.os.Message;
import android.view.View;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.R;
import com.yy.framework.core.Environment;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.coupon.ui.popupwindow.CouponListPopupWindow;
import java.util.List;

public class CouponListPopupWindowController
extends DefaultController {
    private CouponListPopupWindow mPopWindow;
    private long mCheckCouponId;

    public CouponListPopupWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.SHOW_COUPON_LIST_POPUPWINDOW && msg.obj instanceof View) {
            if (this.mPopWindow == null) {
                this.mPopWindow = new CouponListPopupWindow(this.mContext);
            }
            View anchorView = (View)msg.obj;
            this.mCheckCouponId = (Long)anchorView.getTag();
            this.mPopWindow.showCouponListPop(anchorView);
            this.queryCouponListAsync();
        }
        if (msg.what == AppbaseMsgDef.CLOSE_COUPON_LIST_POPUPWINDOW) {
            this.mPopWindow = null;
        }
    }

    private void queryCouponListAsync() {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        if (this.mPopWindow != null) {
            this.mPopWindow.showLoading();
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryCouponListAsync(false, (IPayCallback)new IPayCallback<List<CouponBean>>(){

            public void onSucceed(@Nullable List<CouponBean> data) {
                if (CouponListPopupWindowController.this.mPopWindow != null) {
                    CouponListPopupWindowController.this.mPopWindow.setListData(data, CouponListPopupWindowController.this.mCheckCouponId);
                }
            }

            public void onFailed(int code, String msg) {
                if (CouponListPopupWindowController.this.mPopWindow != null) {
                    CouponListPopupWindowController.this.mPopWindow.processFailed();
                }
            }
        });
    }
}

