/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.Context;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.wallet.ad.AdConfigAllModel;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.config.AdConfigModel;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.hiyo.wallet.ad.config.AdvertiseDetail;
import com.yy.hiyo.wallet.ad.data.AdConfigBean;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AdStatisHelper {
    private static final String TAG = "AdStatisHelper";
    private static final long LOAD_TIMEOUT = 60000L;

    static IAdCallback proxyCacheAd(int localAdId, IAdCallback originalCallback) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            MLog.error((Object)TAG, (String)"proxyCacheAd can not found ad config, localAdId: %s", (Object[])new Object[]{localAdId});
            return originalCallback;
        }
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean == null) {
            MLog.error((Object)TAG, (String)"proxyCacheAd can not found adConfigBean, localAdId: %s", (Object[])new Object[]{localAdId});
            return originalCallback;
        }
        ProxyAdCallback callbackProxy = new ProxyAdCallback(0, originalCallback, localAdId, info, adConfigBean, null);
        return callbackProxy;
    }

    static IAdCallback proxyLoadAd(int localAdId, AdEntity adEntity, IAdCallback originalCallback) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            MLog.error((Object)TAG, (String)"proxyLoadAd can not found ad config, localAdId: %s", (Object[])new Object[]{localAdId});
            return originalCallback;
        }
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean == null) {
            MLog.error((Object)TAG, (String)"proxyCacheAd can not found adConfigBean, localAdId: %s", (Object[])new Object[]{localAdId});
            return originalCallback;
        }
        ProxyAdCallback callbackProxy = new ProxyAdCallback(1, originalCallback, localAdId, info, adConfigBean, adEntity);
        return callbackProxy;
    }

    private static void reportHiido(int localAdId, AdvertiseConfigInfo info, AdConfigBean adConfigBean, String functionID, String errorCode, long startTime, long endTime) {
        AdStatisHelper.reportHiido(localAdId, info, adConfigBean, functionID, errorCode, startTime, endTime, -1);
    }

    private static void reportHiido(int localAdId, AdvertiseConfigInfo info, AdConfigBean adConfigBean, String functionID, String errorCode, long startTime, long endTime, int biddingType) {
        if (info == null || adConfigBean == null) {
            return;
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20028437").put("ad_id", adConfigBean.getPlacementId()).put("ad_type", String.valueOf(adConfigBean.getAdContentType())).put("conf_id", String.valueOf(info.getConfId())).put("ad_type_id", String.valueOf(localAdId)).put("ad_group_id", String.valueOf(info.getAdGroupId())).put("function_id", functionID).put("condition_id", String.valueOf(AdConfigModel.getInstance().getConditionId())).put("mediation_source", String.valueOf(AdConfigModel.getInstance().getConditionId())).put("ad_source_type", String.valueOf(adConfigBean.getAdPlatform().value()));
        if ("fill_up_success".equals(functionID)) {
            event.put("net_type", String.valueOf(AdStatisHelper.getNetWorkType()));
            event.put("start_time", String.valueOf(startTime));
            event.put("end_time", String.valueOf(endTime));
            event.put("mediation_source", String.valueOf(biddingType));
        }
        if (!TextUtils.isEmpty((CharSequence)errorCode)) {
            event.put("fail_result", errorCode);
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public static void monitorChangedId(int localAdId, AdConfigBean oldConfig, AdvertiseDetail newConfig, int errorCode) {
        if (oldConfig == null || newConfig == null) {
            return;
        }
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "advertising");
        statContent.put("sfield", "change_id_when_error");
        statContent.put("sfieldtwo", oldConfig.getPlacementId() + "--" + newConfig.getAdId());
        statContent.put("sfieldthree", oldConfig.getAdContentType() + "--" + newConfig.getAdType().getValue());
        statContent.put("sfieldfour", oldConfig.getAdPlatform().value() + "--" + newConfig.getPlatform().value());
        statContent.put("ifield", localAdId);
        statContent.put("ifieldtwo", errorCode);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public static void monitorLoadCacheAd(int localAdId, long cacheTimestamp) {
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean == null) {
            MLog.error((Object)TAG, (String)"monitorLoadCacheAd can not found adConfigBean, localAdId: %s", (Object[])new Object[]{localAdId});
            return;
        }
        AdStatisHelper.reportMetric(adConfigBean.getPlacementId(), localAdId, adConfigBean.getAdContentType(), "show_cache", adConfigBean.getAdPlatformId(), System.currentTimeMillis() - cacheTimestamp);
    }

    public static void monitorCacheAdExpired(int localAdId, long cacheTimestamp) {
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean == null) {
            MLog.error((Object)TAG, (String)"monitorCacheAdExpired can not found adConfigBean, localAdId: %s", (Object[])new Object[]{localAdId});
            return;
        }
        AdStatisHelper.reportMetric(adConfigBean.getPlacementId(), localAdId, adConfigBean.getAdContentType(), "cache_expired", adConfigBean.getAdPlatformId(), System.currentTimeMillis() - cacheTimestamp);
    }

    private static void reportErrorMetric(String placementId, int localAdId, int type, String event, int platform, long duration, int errorCode) {
        StatisContent statContent = AdStatisHelper.getCommonContent(placementId, localAdId, type, event, platform, duration);
        statContent.put("ifieldfour", errorCode);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static void reportMetric(String placementId, int localAdId, int type, String event, int platform, long duration) {
        StatisContent statContent = AdStatisHelper.getCommonContent(placementId, localAdId, type, event, platform, duration);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static StatisContent getCommonContent(String placementId, int localAdId, int type, String event, int platform, long duration) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "advertising");
        statContent.put("sfield", event);
        statContent.put("sfieldtwo", placementId);
        statContent.put("sfieldthree", duration);
        statContent.put("ifield", localAdId);
        statContent.put("ifieldtwo", type);
        statContent.put("ifieldthree", platform);
        return statContent;
    }

    private static int getNetWorkType() {
        int type = NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext);
        if (type == 1) {
            return 1;
        }
        if (type == 3) {
            return 2;
        }
        if (type == 4) {
            return 3;
        }
        return 4;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetWorkType {
        public static final int NET_TYPE_WIFI = 1;
        public static final int NET_TYPE_3G = 2;
        public static final int NET_TYPE_4G = 3;
        public static final int NET_TYPE_OTHER = 4;
    }

    private static class ProxyAdCallback
    extends IAdCallback {
        private IAdCallback originalCallback;
        private String business = "";
        private int localAdId;
        private AdConfigBean adConfigBean;
        private AdvertiseConfigInfo adConfigInfo;
        private AdEntity adEntity;
        private String placementId;
        private int adType;
        private long loadTime;
        private long showTime;
        private int callbackType;
        private boolean isShow = false;
        private Runnable loadTimeout = new Runnable(){

            @Override
            public void run() {
                if (adConfigBean != null) {
                    AdStatisHelper.reportMetric(placementId, localAdId, adType, "load_timeout", adConfigBean.getAdPlatformId(), System.currentTimeMillis() - loadTime);
                }
            }
        };

        ProxyAdCallback(int callbackType, IAdCallback originalCallback, int localAdId, AdvertiseConfigInfo info, AdConfigBean adConfigBean, AdEntity adEntity) {
            this.callbackType = callbackType;
            this.originalCallback = originalCallback;
            this.localAdId = localAdId;
            this.adConfigInfo = info;
            this.adConfigBean = adConfigBean;
            this.adEntity = adEntity;
            this.placementId = adConfigBean.getPlacementId();
            this.adType = adConfigBean.getAdContentType();
            if (this.adEntity == null) {
                AdStatisHelper.reportHiido(localAdId, info, adConfigBean, "ad_request", "", 0L, 0L);
                this.loadTime = System.currentTimeMillis();
                YYTaskExecutor.execute((Runnable)this.loadTimeout, (long)60000L);
            }
        }

        public void onAdLoadSuccess(AdEntity adEntity) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onAdLoadSuccess localAdId: %s, adEntity == null: %b, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, adEntity == null, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onAdLoadSuccess(adEntity);
            }
            if (this.adEntity == null) {
                int biddingType = -1;
                if (adEntity != null) {
                    biddingType = adEntity.biddingType;
                }
                AdStatisHelper.reportHiido(this.localAdId, this.adConfigInfo, this.adConfigBean, "fill_up_success", "", this.loadTime, System.currentTimeMillis(), biddingType);
                YYTaskExecutor.removeTask((Runnable)this.loadTimeout);
                if (this.adConfigBean != null) {
                    AdStatisHelper.reportMetric(this.placementId, this.localAdId, this.adType, "load_success", this.adConfigBean.getAdPlatformId(), System.currentTimeMillis() - this.loadTime);
                }
            }
        }

        public void onError(int code, String error) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onError localAdId: %s, code: %s, error: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, code, error, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onError(code, error);
            }
            if (this.callbackType == 0) {
                AdStatisHelper.reportHiido(this.localAdId, this.adConfigInfo, this.adConfigBean, "fill_up_fail", String.valueOf(code), 0L, 0L);
                YYTaskExecutor.removeTask((Runnable)this.loadTimeout);
                if (this.adConfigBean != null) {
                    AdStatisHelper.reportErrorMetric(this.placementId, this.localAdId, this.adType, "load_fail", this.adConfigBean.getAdPlatformId(), System.currentTimeMillis() - this.showTime, code);
                }
            } else if (this.callbackType == 1 && this.isShow) {
                AdStatisHelper.reportHiido(this.localAdId, this.adConfigInfo, this.adConfigBean, "ad_play_result_fail", String.valueOf(code), 0L, 0L);
            }
        }

        public void onAdClicked() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onAdClicked localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onAdClicked();
            }
            AdStatisHelper.reportHiido(this.localAdId, this.adConfigInfo, this.adConfigBean, "ad_click", "", 0L, 0L);
            if (this.adConfigBean != null) {
                AdStatisHelper.reportMetric(this.placementId, this.localAdId, this.adType, "ad_click", this.adConfigBean.getAdPlatformId(), System.currentTimeMillis() - this.showTime);
            }
        }

        public void onLoggingImpression() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onLoggingImpression localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onLoggingImpression();
            }
            AdStatisHelper.reportHiido(this.localAdId, this.adConfigInfo, this.adConfigBean, "ad_show", "", 0L, 0L);
            this.isShow = true;
            this.showTime = System.currentTimeMillis();
            if (this.adConfigBean != null) {
                AdStatisHelper.reportMetric(this.placementId, this.localAdId, this.adType, "ad_show", this.adConfigBean.getAdPlatformId(), 0L);
            }
        }

        public void onRewardedVideoCompleted() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onRewardedVideoCompleted localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onRewardedVideoCompleted();
            }
        }

        public void onRewardedVideoClosed() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onRewardedVideoClosed localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onRewardedVideoClosed();
            }
            this.isShow = false;
            AdStatisHelper.reportHiido(this.localAdId, this.adConfigInfo, this.adConfigBean, "ad_play_result_success", "", 0L, 0L);
        }

        public void onMediaDownloaded() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onMediaDownloaded localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onMediaDownloaded();
            }
        }

        public void onInterstitialDisplayed() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onInterstitialDisplayed localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onInterstitialDismissed();
            }
        }

        public void onInterstitialDismissed() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onInterstitialDismissed localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onInterstitialDismissed();
            }
        }

        public void onAdClickClose() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)AdStatisHelper.TAG, (String)"%s onAdClickClose localAdId: %s, placementId: %s, adType: %d", (Object[])new Object[]{this.business, this.localAdId, this.placementId, this.adType});
            }
            if (this.originalCallback != null) {
                this.originalCallback.onAdClickClose();
            }
            if (this.adConfigBean != null) {
                AdStatisHelper.reportMetric(this.placementId, this.localAdId, this.adType, "ad_close", this.adConfigBean.getAdPlatformId(), System.currentTimeMillis() - this.showTime);
            }
        }
    }
}

