/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.accumulate;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.wallet.accumulate.AccumulateRewardBean;
import com.yy.webservice.WebEnvSettings;
import java.util.Collection;
import net.ihago.money.api.accumulate.AccRechargeNotify;
import net.ihago.money.api.accumulate.NewRewardNotify;
import net.ihago.money.api.accumulate.Uri;

public enum AccumulateManager {
    INSTANCE;

    private static final String TAG = "AccumulateManager";
    private IProtoNotify mAccRechargeNotify = new IProtoNotify<AccRechargeNotify>(){

        public String serviceName() {
            return "net.ihago.money.api.accumulate";
        }

        public void onNotify(@NonNull AccRechargeNotify notify) {
            if (notify != null && notify.getUriValue() == Uri.UriNewReward.getValue()) {
                MLog.info((Object)AccumulateManager.TAG, (String)"AccRechargeNotify", (Object[])new Object[0]);
                NewRewardNotify newRewardNotify = notify.new_notify;
                if (newRewardNotify != null) {
                    if (!FP.empty((Collection)newRewardNotify.excluded_channels) && newRewardNotify.excluded_channels.contains(AppMetaDataUtil.getChannelID((Context)RuntimeContext.sApplicationContext))) {
                        return;
                    }
                    AccumulateRewardBean bean = AccumulateRewardBean.from(newRewardNotify);
                    MLog.info((Object)AccumulateManager.TAG, (String)"AccRechargeNotify AccumulateRewardBean=%s", (Object[])new Object[]{bean});
                    AccumulateManager.this.openUrl(bean);
                }
            }
        }
    };

    public void registerAccRechargeListener() {
        ProtoManager.getInstance().registerNotify(this.mAccRechargeNotify);
    }

    public void openUrl(AccumulateRewardBean bean) {
        if (bean != null && !StringUtils.isEmpty((String)bean.url) && ServiceManagerProxy.getServiceManager() != null) {
            WebEnvSettings settings = new WebEnvSettings();
            settings.url = bean.url;
            settings.isShowBackBtn = true;
            settings.isFullScreen = true;
            settings.disablePullRefresh = true;
            settings.usePageTitle = false;
            settings.webViewBackgroundColor = 0x4C000000;
            settings.webWindowAnimator = false;
            settings.hideLastWindow = false;
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
        }
    }
}

