/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.Context;
import android.os.SystemClock;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.AdStatisHelper;
import com.yy.hiyo.wallet.ad.config.AdPlatform;
import com.yy.hiyo.wallet.ad.config.a;
import com.yy.hiyo.wallet.ad.config.l;
import com.yy.hiyo.wallet.ad.config.m;
import com.yy.hiyo.wallet.ad.config.p;
import com.yy.hiyo.wallet.ad.i;
import com.yy.hiyo.wallet.ad.j;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum AdManager implements p
{
    INSTANCE;

    private static final String TAG = "AdManager";
    private com.yy.hiyo.wallet.ad.l mAdModel;
    private com.yy.hiyo.wallet.ad.p mAdViewProvider;
    private Map<Integer, AdEntity> mAdCacheMap = new HashMap<Integer, AdEntity>();
    private Map<Integer, Long> mCacheingMap = new HashMap<Integer, Long>();

    public void init(Context context) {
        this.mAdModel = new com.yy.hiyo.wallet.ad.l();
        this.mAdViewProvider = new com.yy.hiyo.wallet.ad.p(context);
        a.b().a(this);
        a.b().a();
    }

    public void cacheAd(int n2, IAdCallback iAdCallback) {
        this.cacheAd(n2, -1, true, iAdCallback);
    }

    public void cacheAd(int n2, boolean bl, IAdCallback iAdCallback) {
        this.cacheAd(n2, -1, bl, iAdCallback);
    }

    public void cacheAd(int n2, int n3, IAdCallback iAdCallback) {
        this.cacheAd(n2, n3, true, iAdCallback);
    }

    public void cacheAd(int n2, int n3, boolean bl, IAdCallback iAdCallback) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdManager cacheAd localAdId=%d, isRefreshConfig=%s", (Object[])new Object[]{n2, bl});
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"Network unavailable", (int)0);
            }
            if (iAdCallback != null) {
                iAdCallback.onError(100000013, "no network");
            }
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdManager no network localAdId=%d", (Object[])new Object[]{n2});
            }
            return;
        }
        if (!this.judgeAdConfig(n2, n3, iAdCallback)) {
            return;
        }
        int n4 = AdConfigureManager.INSTANCE.dealWithGoogleRewardVideoAd(n2);
        if (!AdConfigureManager.INSTANCE.canAdvertiseTypeCache(n4)) {
            if (iAdCallback != null) {
                iAdCallback.onError(99999995, "error_type_banner_no_need_cache");
            }
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdManager no banner cacheAd localAdId=%d", (Object[])new Object[]{n4});
            }
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            if (!AdConfigureManager.INSTANCE.canRequestAd(n4) && AdConfigureManager.INSTANCE.canShowToast(n4)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u65f6\u95f4\u95f4\u9694\u592a\u77ed\u4e0d\u80fd\u518d\u8bf7\u6c42\u7f13\u5b58\u5e7f\u544a\uff0clocalAdId=" + n4), (int)0);
            }
            if (!AdConfigureManager.INSTANCE.isAdCacheExpired(n4) && AdConfigureManager.INSTANCE.canShowToast(n4)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u7f13\u5b58\u672a\u8fc7\u671f\u4e0d\u80fd\u8bf7\u6c42\u7f13\u5b58\u5e7f\u544a\uff0clocalAdId=" + n4), (int)0);
            }
        }
        if (!this.canRequestAdInInterval(n4)) {
            if (iAdCallback != null) {
                iAdCallback.onError(99999998, "error_type_request_interval_short");
            }
            return;
        }
        if (!AdConfigureManager.INSTANCE.canRequestAd(n4)) {
            if (iAdCallback != null) {
                iAdCallback.onError(100000006, "error_type_request_interval_limited");
            }
            return;
        }
        if (!AdConfigureManager.INSTANCE.isAdCacheExpired(n4)) {
            if (iAdCallback != null) {
                iAdCallback.onError(100000007, "error_type_cache_not_expired");
            }
            return;
        }
        if (AdConfigureManager.INSTANCE.canRequestAd(n4) && AdConfigureManager.INSTANCE.isAdCacheExpired(n4)) {
            if (RuntimeContext.sIsDebuggable && AdConfigureManager.INSTANCE.canShowToast(n4)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u5f00\u59cb\u8bf7\u6c42\u7f13\u5b58\u5e7f\u544a\uff0clocalAdId=" + n4), (int)0);
            }
            if (bl) {
                AdConfigureManager.INSTANCE.refreshAdConfig(n2);
            }
            IAdCallback iAdCallback2 = AdStatisHelper.a(n4, iAdCallback);
            this.mCacheingMap.put(n4, SystemClock.elapsedRealtime());
            this.mAdModel.a(n4, new i(this, n4, iAdCallback2));
        }
    }

    public void loadAd(int n2, ViewGroup viewGroup, IAdCallback iAdCallback, boolean bl) {
        this.loadAd(n2, viewGroup, -1, iAdCallback, bl);
    }

    public void loadAd(int n2, ViewGroup viewGroup, int n3, IAdCallback iAdCallback, boolean bl) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdManager loadAd localAdId=%d", (Object[])new Object[]{n2});
        }
        if (!this.judgeAdConfig(n2, n3, iAdCallback)) {
            return;
        }
        int n4 = AdConfigureManager.INSTANCE.dealWithGoogleRewardVideoAd(n2);
        if (this.mAdCacheMap.containsKey(n4)) {
            if (!AdConfigureManager.INSTANCE.isAdCacheExpired(n4)) {
                AdEntity adEntity;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTAdv", (String)"AdManager loadAd isAdCacheExpired=no, localAdId=%d", (Object[])new Object[]{n4});
                }
                if ((adEntity = this.mAdCacheMap.get(n4)) != null) {
                    this.loadPlatformAd(n4, viewGroup, adEntity, iAdCallback);
                    this.mAdCacheMap.remove(n4);
                    long l2 = AdConfigureManager.INSTANCE.removeCacheTimestamp(n4);
                    AdStatisHelper.a(n4, l2);
                } else if (iAdCallback != null) {
                    iAdCallback.onError(99999991, "");
                }
            } else {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTAdv", (String)"AdManager loadAd isAdCacheExpired=yes, localAdId=%s", (Object[])new Object[]{n4});
                }
                this.mAdCacheMap.remove(n4);
                long l3 = AdConfigureManager.INSTANCE.removeCacheTimestamp(n4);
                AdStatisHelper.b(n4, l3);
                this.cacheAd(n4, null);
                if (iAdCallback != null) {
                    iAdCallback.onError(99999991, "");
                }
            }
        } else if (bl) {
            this.cacheAd(n4, null);
            if (iAdCallback != null) {
                iAdCallback.onError(99999991, "");
            }
        } else {
            this.loadPlatformAd(n4, viewGroup, null, iAdCallback);
        }
    }

    private void loadPlatformAd(int n2, ViewGroup viewGroup, AdEntity adEntity, IAdCallback iAdCallback) {
        if (adEntity == null && !AdConfigureManager.INSTANCE.isUnityRewardVideoAd(n2) && !AdConfigureManager.INSTANCE.canRequestAd(n2)) {
            if (iAdCallback != null) {
                iAdCallback.onError(99999991, "Invalid Ad id");
            }
            return;
        }
        IAdCallback iAdCallback2 = AdStatisHelper.a(n2, adEntity, iAdCallback);
        this.mAdModel.a(n2, viewGroup, adEntity, new j(this, n2, iAdCallback2, viewGroup, adEntity, iAdCallback));
    }

    public void setAdCache(int n2, AdEntity adEntity) {
        if (this.mAdCacheMap.containsKey(n2)) {
            long l2 = AdConfigureManager.INSTANCE.getAdCacheTimestamp(n2);
            AdStatisHelper.b(n2, l2);
        }
        this.mAdCacheMap.put(n2, adEntity);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdManager setAdCache localAdId=%d, getPlacementId=%s", (Object[])new Object[]{n2, adEntity.getPlacementId()});
        }
        AdConfigureManager.INSTANCE.setAdCacheTimestamp(n2, SystemClock.elapsedRealtime());
        AdConfigureManager.INSTANCE.setRequestTimestamp(n2, System.currentTimeMillis());
    }

    @Override
    public void onAdConfigChanged(@NonNull Map<Integer, m> map) {
        if (map != null && FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdManager onAdConfigChanged %d", (Object[])new Object[]{map.size()});
        }
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
        this.initAdSdkConfig();
        AdConfigureManager.INSTANCE.updateConfigBean();
        Set<AdPlatform> set = AdConfigureManager.INSTANCE.getInitAdPlatformList();
        if (set != null && set.size() > 0) {
            for (AdPlatform adPlatform : set) {
                if (!AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().contains((Object)adPlatform)) continue;
                this.mAdModel.d(AdConfigureManager.INSTANCE.getConstDefPlatformId(adPlatform));
            }
        }
    }

    private synchronized void initAdSdkConfig() {
        l l2 = a.b().f();
        if (l2 != null && l2.a() && RuntimeContext.getPhoneType() == 1) {
            AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
            AdConfigureManager.INSTANCE.setAllowedAdPlatformConfigList(l2.b());
            return;
        }
        this.setAllAdPlatform();
    }

    private void setAllAdPlatform() {
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().clear();
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.facebook);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.google);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.vungle);
        AdConfigureManager.INSTANCE.getAllowedAdPlatformConfigList().add(AdPlatform.unity);
    }

    public int getAdLineNumber(int n2) {
        return AdConfigureManager.INSTANCE.getAdLineNumber(n2);
    }

    private boolean canRequestAdInInterval(int n2) {
        if (this.mCacheingMap.containsKey(n2)) {
            long l2 = this.mCacheingMap.get(n2);
            if (SystemClock.elapsedRealtime() - l2 > 4000L) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTAdv", (String)"AdManager canRequestAdInInterval=%s", (Object[])new Object[]{n2});
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasAdCache(int n2) {
        int n3 = AdConfigureManager.INSTANCE.dealWithGoogleRewardVideoAd(n2);
        if (AdConfigureManager.INSTANCE.isVungleRewardVideoAd(n2)) {
            return this.mAdModel.a(n3, (AdEntity)null);
        }
        if (this.mAdCacheMap.containsKey(n3)) {
            if (AdConfigureManager.INSTANCE.isGoogleRewardVideoAd(n3)) {
                AdEntity adEntity = this.mAdCacheMap.get(n3);
                if (adEntity != null && this.mAdModel.a(n3, adEntity)) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTAdv", (String)"AdManager hasAdCache=true isGoogleRewardVideoAd localAdId=%d", (Object[])new Object[]{n3});
                    }
                    return true;
                }
                this.mAdCacheMap.remove(n3);
                AdConfigureManager.INSTANCE.removeCacheTimestamp(n3);
                return false;
            }
            return true;
        }
        if (AdConfigureManager.INSTANCE.isUnityRewardVideoAd(n2)) {
            return this.mAdModel.a(n3, (AdEntity)null);
        }
        return false;
    }

    public void clearAdCache() {
        this.mAdCacheMap.clear();
        AdConfigureManager.INSTANCE.clearAdCacheTimestampMap();
    }

    public void pauseAdView(int n2) {
        this.mAdModel.a(n2);
    }

    public void resumeAdView(int n2) {
        this.mAdModel.b(n2);
    }

    public void destroyAdView(int n2) {
        this.mAdModel.c(n2);
    }

    private boolean judgeAdConfig(int n2, int n3, IAdCallback iAdCallback) {
        if (!com.yy.hiyo.wallet.ad.a.a().c(n2)) {
            if (n3 <= 0) {
                if (a.b().e().isEmpty() || !a.b().e().containsKey(n2)) {
                    if (iAdCallback != null) {
                        iAdCallback.onError(100000008, "not_contain_config_it");
                    }
                    MLog.error((Object)"FTAdv", (String)"loadAd localAdId=%s not_contain_config_it", (Object[])new Object[]{n2});
                    if (RuntimeContext.sIsDebuggable && n2 > 300) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u6ca1\u6709\u914d\u7f6e\u8be5\u5e7f\u544a " + n2), (int)1);
                    }
                    return false;
                }
            } else if (com.yy.hiyo.wallet.ad.a.a().b(n2)) {
                com.yy.hiyo.wallet.ad.a.a().a(n2, n3);
            }
        }
        if (com.yy.hiyo.wallet.ad.a.a().b().isEmpty() || !com.yy.hiyo.wallet.ad.a.a().b().containsKey(n2)) {
            if (iAdCallback != null) {
                iAdCallback.onError(100000009, "not_contain_local_config_it");
            }
            MLog.error((Object)"FTAdv", (String)"loadAd localAdId=%s not_contain_local_config_it", (Object[])new Object[]{n2});
            return false;
        }
        return true;
    }

    static /* synthetic */ Map access$000(AdManager adManager) {
        return adManager.mCacheingMap;
    }

    static /* synthetic */ com.yy.hiyo.wallet.ad.p access$100(AdManager adManager) {
        return adManager.mAdViewProvider;
    }

    static /* synthetic */ Map access$200(AdManager adManager) {
        return adManager.mAdCacheMap;
    }
}

