/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.platform.gp.billing;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.billing.base.ISkuDetailsCallback;
import com.yy.billing.base.PurchaseInfo;
import com.yy.billing.base.SkuDetailsInfo;
import com.yy.hiyo.billingclient.api.BillingClient;
import com.yy.hiyo.billingclient.api.BillingClientStateListener;
import com.yy.hiyo.billingclient.api.BillingFlowParams;
import com.yy.hiyo.billingclient.api.ConsumeResponseListener;
import com.yy.hiyo.billingclient.api.Purchase;
import com.yy.hiyo.billingclient.api.PurchasesUpdatedListener;
import com.yy.hiyo.billingclient.api.SkuDetails;
import com.yy.hiyo.billingclient.api.SkuDetailsParams;
import com.yy.hiyo.billingclient.api.SkuDetailsResponseListener;
import com.yy.hiyo.wallet.pay.platform.gp.billing.b;
import com.yy.hiyo.wallet.pay.platform.gp.billing.c;
import com.yy.hiyo.wallet.pay.platform.gp.billing.d;
import com.yy.hiyo.wallet.pay.platform.gp.billing.e;
import com.yy.hiyo.wallet.pay.platform.gp.billing.f;
import com.yy.hiyo.wallet.pay.platform.gp.billing.g;
import com.yy.hiyo.wallet.pay.platform.gp.billing.h;
import com.yy.hiyo.wallet.pay.platform.gp.billing.j;
import com.yy.socialplatformbase.platform.google.billing.IConsumeCallback;
import com.yy.socialplatformbase.platform.google.billing.IGooglePay;
import com.yy.socialplatformbase.platform.google.billing.IPayConnectCallback;
import com.yy.socialplatformbase.platform.google.billing.IPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.IQueryPurchaseCallback;
import com.yy.socialplatformbase.platform.google.billing.PurchaseParams;
import com.yy.socialplatformbase.platform.google.billing.QueryDetailsParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class a
implements IGooglePay {
    private BillingClient a;
    private Map<PurchaseParams, IPurchaseCallback> b;

    public a() {
        b b2 = new b(this);
        this.a = BillingClient.newBuilder((Context)RuntimeContext.sApplicationContext).setListener((PurchasesUpdatedListener)b2).build();
    }

    public void startConnect(IPayConnectCallback iPayConnectCallback) {
        boolean bl = this.isReady();
        MLog.info((Object)"FTPayGoogleSdkBillingWrapper", (String)"startConnect ready: %b", (Object[])new Object[]{bl});
        if (bl) {
            if (iPayConnectCallback != null) {
                iPayConnectCallback.onPaySetupFinished(0);
            }
            return;
        }
        this.a.startConnection((BillingClientStateListener)new c(this, iPayConnectCallback));
    }

    public void endConnect() {
        MLog.info((Object)"FTPayGoogleSdkBillingWrapper", (String)"endConnect mBillingClient == null : %b", (Object[])new Object[]{this.a == null});
        if (this.a != null) {
            this.a.endConnection();
        }
        this.a = null;
    }

    public void purchase(@NonNull Activity activity, @NonNull PurchaseParams purchaseParams, IPurchaseCallback iPurchaseCallback) {
        MLog.info((Object)"FTPayGoogleSdkBillingWrapper", (String)"purchase param: %s", (Object[])new Object[]{purchaseParams});
        if (this.b(purchaseParams.getProductId(), iPurchaseCallback) && this.a(purchaseParams.getType(), iPurchaseCallback)) {
            int n2;
            if (!this.a()) {
                if (iPurchaseCallback != null) {
                    iPurchaseCallback.onPurchasesUpdated(1002, null);
                }
                return;
            }
            BillingFlowParams.Builder builder = BillingFlowParams.newBuilder().setType(purchaseParams.getType()).setSku(purchaseParams.getProductId()).setOldSkus(null);
            if (!TextUtils.isEmpty((CharSequence)purchaseParams.getAccountId())) {
                builder.setAccountId(purchaseParams.getAccountId());
            }
            if ((n2 = this.a.launchBillingFlow(activity, builder.build(), purchaseParams.getPayload())) != 0) {
                if (iPurchaseCallback != null) {
                    iPurchaseCallback.onPurchasesUpdated(n2, null);
                }
            } else {
                this.a(purchaseParams, iPurchaseCallback);
            }
        }
    }

    public void consume(String string2, IConsumeCallback iConsumeCallback) {
        MLog.info((Object)"FTPayGoogleSdkBillingWrapper", (String)"consume purchaseToken: %s", (Object[])new Object[]{string2});
        if (this.a(string2, iConsumeCallback)) {
            if (!this.a()) {
                if (iConsumeCallback != null) {
                    iConsumeCallback.onConsumeResponse(1002, null);
                }
                return;
            }
            this.a.consumeAsync(string2, (ConsumeResponseListener)new d(this, iConsumeCallback));
        }
    }

    public void acknowledgePurchase(String string2, IConsumeCallback iConsumeCallback) {
        if (iConsumeCallback != null) {
            iConsumeCallback.onConsumeResponse(0, string2);
        }
    }

    public void queryPurchase(String string2, IQueryPurchaseCallback iQueryPurchaseCallback) {
        if (iQueryPurchaseCallback == null) {
            return;
        }
        if (!this.a()) {
            iQueryPurchaseCallback.onPurchaseHistory(1002, null);
            return;
        }
        YYTaskExecutor.execute((Runnable)new e(this, string2, iQueryPurchaseCallback));
    }

    private void a(String string2, IQueryPurchaseCallback iQueryPurchaseCallback) {
        Purchase.PurchasesResult purchasesResult = this.a.queryPurchases(string2);
        if (purchasesResult == null) {
            YYTaskExecutor.postToMainThread((Runnable)new f(this, iQueryPurchaseCallback));
        }
        List list = purchasesResult.getPurchasesList();
        int n2 = purchasesResult.getResponseCode();
        YYTaskExecutor.postToMainThread((Runnable)new g(this, list, n2, iQueryPurchaseCallback));
    }

    public void querySkuDetails(QueryDetailsParam queryDetailsParam, ISkuDetailsCallback iSkuDetailsCallback) {
        if (iSkuDetailsCallback == null) {
            return;
        }
        if (!this.a()) {
            iSkuDetailsCallback.onResponse(1002, null);
            return;
        }
        SkuDetailsParams skuDetailsParams = SkuDetailsParams.newBuilder().setType(queryDetailsParam.getSkuType()).setSkusList(queryDetailsParam.getSkuList()).build();
        this.a.querySkuDetailsAsync(skuDetailsParams, (SkuDetailsResponseListener)new h(this, iSkuDetailsCallback));
    }

    private void a(int n2, List<SkuDetails> list, ISkuDetailsCallback iSkuDetailsCallback) {
        ArrayList<SkuDetailsInfo> arrayList = null;
        if (list != null && !list.isEmpty()) {
            arrayList = new ArrayList<SkuDetailsInfo>(list.size());
            for (SkuDetails skuDetails : list) {
                arrayList.add(com.yy.hiyo.wallet.pay.platform.gp.billing.a.a(skuDetails));
            }
        }
        ArrayList<SkuDetailsInfo> arrayList2 = arrayList;
        YYTaskExecutor.postToMainThread((Runnable)new j(this, iSkuDetailsCallback, n2, arrayList2));
    }

    private static SkuDetailsInfo a(SkuDetails skuDetails) {
        return new SkuDetailsInfo.Builder().productId(skuDetails.getSku()).type(skuDetails.getType()).price(skuDetails.getPrice()).priceAmountMicros(Long.valueOf(skuDetails.getPriceAmountMicros())).priceCurrencyCode(skuDetails.getPriceCurrencyCode()).title(skuDetails.getTitle()).description(skuDetails.getDescription()).subscriptionPeriod(skuDetails.getSubscriptionPeriod()).freeTrialPeriod(skuDetails.getFreeTrialPeriod()).introductoryPrice(skuDetails.getIntroductoryPrice()).introductoryPriceAmountMicros(Long.valueOf(StringUtils.safeParseLong((String)skuDetails.getIntroductoryPriceAmountMicros()))).introductoryPricePeriod(skuDetails.getIntroductoryPricePeriod()).introductoryPriceCycles(Integer.valueOf(StringUtils.safeParseInt((String)skuDetails.getIntroductoryPriceCycles()))).originalJson(skuDetails.getOriginalJson()).build();
    }

    private void a(List<Purchase> list, int n2, IQueryPurchaseCallback iQueryPurchaseCallback) {
        if (list == null) {
            iQueryPurchaseCallback.onPurchaseHistory(n2, null);
        } else {
            ArrayList<PurchaseInfo> arrayList = new ArrayList<PurchaseInfo>(list.size());
            for (Purchase purchase : list) {
                if (purchase == null) continue;
                PurchaseInfo purchaseInfo = PurchaseInfo.newBuilder((String)purchase.getSignature(), (String)purchase.getOriginalJson()).orderId(purchase.getOrderId()).purchaseTime(purchase.getPurchaseTime()).purchaseToken(purchase.getPurchaseToken()).productId(purchase.getSku()).payload(purchase.getPayload()).build();
                arrayList.add(purchaseInfo);
            }
            iQueryPurchaseCallback.onPurchaseHistory(n2, arrayList);
        }
    }

    public boolean isReady() {
        if (this.a != null) {
            return this.a.isReady();
        }
        return false;
    }

    private synchronized void a(int n2, @Nullable List<Purchase> list, String string2) {
        if (this.b == null || this.b.isEmpty()) {
            MLog.error((Object)"FTPayGoogleSdkBillingWrapper", (String)"handlePurchaseResponse mPurchaseCallbackMap is empty, responseCode: %d, customPayload: %s", (Object[])new Object[]{n2, string2});
            return;
        }
        if (list == null || list.isEmpty()) {
            MLog.error((Object)"FTPayGoogleSdkBillingWrapper", (String)"handlePurchaseResponse purchases is empty, responseCode: %d, customPayload: %s", (Object[])new Object[]{n2, string2});
            if (this.b != null && !TextUtils.isEmpty((CharSequence)string2)) {
                PurchaseParams purchaseParams = null;
                IPurchaseCallback iPurchaseCallback = this.b.keySet().iterator();
                while (iPurchaseCallback.hasNext()) {
                    PurchaseParams purchaseParams2 = iPurchaseCallback.next();
                    if (purchaseParams2 == null || !string2.equals(purchaseParams2.getPayload())) continue;
                    purchaseParams = purchaseParams2;
                    break;
                }
                if (purchaseParams != null && (iPurchaseCallback = this.b.remove(purchaseParams)) != null) {
                    iPurchaseCallback.onPurchasesUpdated(n2, null);
                }
            }
            return;
        }
        MLog.info((Object)"FTPayGoogleSdkBillingWrapper", (String)"handlePurchaseResponse responseCode: %d, purchases.size: %d, mPurchaseCallbackMap.size: %d, customPayload: %s", (Object[])new Object[]{n2, list.size(), this.b.size(), string2});
        for (Purchase purchase : list) {
            if (purchase == null) continue;
            PurchaseParams purchaseParams = new PurchaseParams("", purchase.getSku(), purchase.getPayload());
            IPurchaseCallback iPurchaseCallback = this.b.remove(purchaseParams);
            if (iPurchaseCallback != null) {
                PurchaseInfo purchaseInfo = PurchaseInfo.newBuilder((String)purchase.getSignature(), (String)purchase.getOriginalJson()).orderId(purchase.getOrderId()).purchaseTime(purchase.getPurchaseTime()).purchaseToken(purchase.getPurchaseToken()).productId(purchaseParams.getProductId()).payload(purchaseParams.getPayload()).build();
                iPurchaseCallback.onPurchasesUpdated(n2, purchaseInfo);
                continue;
            }
            MLog.info((Object)"FTPayGoogleSdkBillingWrapper", (String)"handlePurchaseResponse can not found callback, consume it", (Object[])new Object[0]);
        }
    }

    private synchronized void a(@NonNull PurchaseParams purchaseParams, IPurchaseCallback iPurchaseCallback) {
        if (iPurchaseCallback != null) {
            if (this.b == null) {
                this.b = new HashMap<PurchaseParams, IPurchaseCallback>();
            }
            this.b.put(purchaseParams, iPurchaseCallback);
        }
    }

    private boolean a(String string2, IPurchaseCallback iPurchaseCallback) {
        if ("inapp".equals(string2) || "subs".equals(string2)) {
            return true;
        }
        String string3 = "purchase type must be 'inapp' or 'subs'";
        if (RuntimeContext.sIsDebuggable) {
            throw new IllegalArgumentException(string3);
        }
        MLog.error((Object)"FTPayGoogleSdkBillingWrapper", (String)string3, (Object[])new Object[0]);
        if (iPurchaseCallback != null) {
            iPurchaseCallback.onPurchasesUpdated(1001, null);
        }
        return false;
    }

    private boolean b(String string2, IPurchaseCallback iPurchaseCallback) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = "purchase productId can not be empty, it may be sku that create in google play console";
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(string3);
            }
            MLog.error((Object)"FTPayGoogleSdkBillingWrapper", (String)string3, (Object[])new Object[0]);
            if (iPurchaseCallback != null) {
                iPurchaseCallback.onPurchasesUpdated(1001, null);
            }
            return false;
        }
        return true;
    }

    private boolean a(String string2, IConsumeCallback iConsumeCallback) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = "consume purchaseToken can not be empty";
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(string3);
            }
            MLog.error((Object)"FTPayGoogleSdkBillingWrapper", (String)string3, (Object[])new Object[0]);
            if (iConsumeCallback != null) {
                iConsumeCallback.onConsumeResponse(1001, string2);
            }
            return false;
        }
        return true;
    }

    private boolean a() {
        if (this.a == null && !this.isReady()) {
            String string2 = "billing service is not ready, you must call startConnect before";
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException(string2);
            }
            MLog.error((Object)"FTPayGoogleSdkBillingWrapper", (String)string2, (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    static /* synthetic */ void a(a a2, int n2, List list, String string2) {
        a2.a(n2, list, string2);
    }

    static /* synthetic */ void a(a a2, String string2, IQueryPurchaseCallback iQueryPurchaseCallback) {
        a2.a(string2, iQueryPurchaseCallback);
    }

    static /* synthetic */ void a(a a2, List list, int n2, IQueryPurchaseCallback iQueryPurchaseCallback) {
        a2.a(list, n2, iQueryPurchaseCallback);
    }

    static /* synthetic */ void a(a a2, int n2, List list, ISkuDetailsCallback iSkuDetailsCallback) {
        a2.a(n2, list, iSkuDetailsCallback);
    }
}

