/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.statis;

import android.os.SystemClock;
import android.text.TextUtils;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.wallet.pay.o;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GiftMonitor {
    private static final Map<String, ReqGiftList> mGiftList = new ConcurrentHashMap<String, ReqGiftList>();

    public static void reqGiftList(String string2, int n2, int n3, long l2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ReqGiftList reqGiftList = new ReqGiftList(string2, n2, n3, l2);
        mGiftList.put(string2, reqGiftList);
    }

    public static void resGiftList(String string2, int n2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ReqGiftList reqGiftList = mGiftList.remove(string2);
        if (reqGiftList != null) {
            reqGiftList.reason = string3;
            GiftMonitor.reportReqResultMetri(reqGiftList.cmd, reqGiftList.duration(), n2);
            GiftMonitor.reportGiftList(reqGiftList);
        }
    }

    public static void reportMetr(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ReqGiftList reqGiftList = mGiftList.get(string2);
        if (reqGiftList != null) {
            StringBuilder stringBuilder = new StringBuilder("revenue/cmd/");
            if (o.f()) {
                stringBuilder.append("huawei/");
            }
            stringBuilder.append(reqGiftList.cmd);
            HiidoStatis.reportAppMonitorReturnCode((String)stringBuilder.toString(), (long)StringUtils.parseLong((String)reqGiftList.interval()), (String)string3);
        }
    }

    public static void giftListSdkMetric(boolean bl, int n2, String string2, long l2) {
        n2 = bl ? 0 : n2;
        HiidoStatis.reportAppMonitorReturnCode((String)"giftlist/sdk/", (long)l2, (String)(n2 + ""));
    }

    private static void reportReqResultMetri(int n2, long l2, int n3) {
        if (n3 == 1) {
            n3 = 0;
        }
        StringBuilder stringBuilder = new StringBuilder("revenue/result/cmd/");
        if (o.f()) {
            stringBuilder.append("huawei/");
        }
        stringBuilder.append(n2);
        HiidoStatis.reportAppMonitorReturnCode((String)stringBuilder.toString(), (long)l2, (String)("" + n3));
    }

    private static void reportGiftList(ReqGiftList reqGiftList) {
        if (reqGiftList == null) {
            return;
        }
        reqGiftList.release();
        String string2 = reqGiftList.interval();
        StatisContent statisContent = GiftMonitor.createContent();
        statisContent.put("ifield", reqGiftList.cmd);
        statisContent.put("ifieldtwo", reqGiftList.channelId);
        statisContent.put("sfield", String.valueOf(reqGiftList.anchorUid));
        statisContent.put("sfieldtwo", string2);
        statisContent.put("sfieldthree", reqGiftList.reason);
        HiidoStatis.reportContent((StatisContent)statisContent);
    }

    private static StatisContent createContent() {
        StatisContent statisContent = new StatisContent();
        statisContent.put("act", "hagoperf");
        statisContent.put("perftype", "gift");
        return statisContent;
    }

    private static class ReqGiftList {
        String seq;
        int cmd;
        int channelId;
        long anchorUid;
        String reason;
        long start;
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                reason = "timeout with 30s";
                mGiftList.remove(seq);
                GiftMonitor.reportGiftList(this);
            }
        };

        public ReqGiftList(String string2, int n2, int n3, long l2) {
            this.seq = string2;
            this.cmd = n2;
            this.channelId = n3;
            this.anchorUid = l2;
            this.start = SystemClock.uptimeMillis();
            YYTaskExecutor.execute((Runnable)this.timeoutTask, (long)30000L);
        }

        void release() {
            YYTaskExecutor.removeTask((Runnable)this.timeoutTask);
        }

        String interval() {
            long l2 = SystemClock.uptimeMillis() - this.start;
            return String.valueOf(l2);
        }

        long duration() {
            return SystemClock.uptimeMillis() - this.start;
        }
    }
}

